(*****************************************************************************)
(*                                                                           *)
(*                       ROS - Remote Operating System                       *)
(*                                                                           *)
(*                           Copyright (c) 1985 by                           *)
(*                                                                           *)
(*                                Steven Fox                                 *)
(*                                                                           *)
(*                    All commercial rights are reserved.                    *)
(*                                                                           *)
(*  Non-commercial, public distribution and use of this system is permitted. *)
(*                                                                           *)
(*****************************************************************************)

program ros;
{$C-}

{$I ROSDEF.INC}                             { Definitions }

{$I ACCESS.BOX}                             { Turbo Toolbox files }
{$I GETKEY.BOX}
{$I ADDKEY.BOX}
{$I DELKEY.BOX}

var
  DatF: DataFile;
  IdxF: IndexFile;

{$I ROSMAC.INC}                             { Machine dependent routines }
{$I ROSKER.INC}                             { Kernel - not overlayed }
{$I ROSOV0.INC}                             { Kernel - overlay .000 }
  type dummy = char;                        { Force overlay .001 }
{$I ROSINI.INC}                             { System initialization }
{$I ROSOPS.INC}                             { Operating routines }
{$I ROSMSG.INC}                             { Message sub-system }
{$I ROSFIL.INC}                             { File sub-system }
{$I ROSUTL.INC}                             { Utility sub-system }
{$I ROSSYS.INC}                             { Sysop sub-system }
{$I ROSXFR.INC}                             { File transfer routines }

begin { ROS }
  cold_start;
  setup;
  wait_for_user;
  while not fini do
    begin
      login;
      mesg_area_change('GENERAL');
      section('LOGIN');
      new_dir := FALSE;
      list('B');
      while online and in_use do
        begin
          if new_dir
            then directory;
          writeln(USR);
          ch := select(pr_msg[mode] + ' function (? for MENU):', rep_msg[mode]);
          case mode of
            message_mode:
              case ch of
                'C': mesg_area_change('');
                'E': mesg_enter(FALSE);
                'F': mode := files_mode;
                'G': in_use := FALSE;
                'K': mesg_kill;
                'Q': mesg_quick_scan;
                'R': mesg_read;
                'S': mesg_summary;
                'U': mode := utility_mode;
                'X': if user_rec.access = 255
                       then mode := sysop_mode;
                'A'..'Z', '1'..'9': list(ch);
                '?': list('M')
              end;
            files_mode:
              case ch of
                'C': begin
                       if in_library
                         then library;
                       section('')
                     end;
                'D': directory;
                'F': toggle_st_switch;
                'G': in_use := FALSE;
                'R', 'S', 'T': transfer(ch);
                'L': library;
                'M': mode := message_mode;
                'U': mode := utility_mode;
                'X': if user_rec.access = 255
                       then mode := sysop_mode;
                '?': list('F')
              end;
            utility_mode:
              case ch of
                'A': get_nulls_and_case;
                'C': if chat
                       then mesg_enter(TRUE);
                'F': mode := files_mode;
                'G': in_use := FALSE;
                'M': mode := message_mode;
                'P': noisy := not noisy;
                'T': display_time;
                'U': display_users;
                'X': if user_rec.access = 255
                       then mode := sysop_mode;
                '?': list('U')
              end;
            sysop_mode:
              case ch of
                'A': area_assign := not area_assign;
                'D': delete_user;
                'E': edit_user;
                'F': mode := files_mode;
                'G': in_use := FALSE;
                'I': rebuild_index;
                'K': begin
                       krunch_messages;
                       mesg_area_change(AreaReq)
                     end;
                'L': print_log;
                'M': mode := message_mode;
                'P': purge_user;
                'R': print_messages;
                'T': toggle_printer;
                'U': mode := utility_mode;
                '?': list('S')
              end
          end
        end;
      if in_library
        then library;
      if ask('Do you have a message for the sysop')
        then mesg_enter(TRUE);
      wrapup;
      setup;                                { Re-init system }
      wait_for_user
    end
end.
