{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }
{ Modified for Televideo  802,  and clock          31 May 85 }
{ Only have to change DataPort, StatusPort and RatePort for }
{ 806 and 816}
{ Clock will work for both 802 + 806 + 816 as is}


procedure system_init;
{System particular for start up}
 begin
 end;

procedure putstat(st: StrStd);
{Put 'st' on status line and return to normal display }
 const
   status_line    =  1;                    {Line used for system status}
   last_line      = 25;                    {Last line on screen}
 begin
   GotoXY(1, status_line);
   ClrEol;
   LowVideo;
   write(st);
   HighVideo;
   GotoXY(1, last_line)
 end;

const
{ Machine specific constants }

  DataPort   = $20;          { Data port }
  StatusPort = $22;          { Status port }
  RatePort   = $08;          { Data rate (bps) port }

{ StatusPort commands }

  RESCHN     = $18;          { reset channel }
  RESSTA     = $10;          { reset ext/status }
  WRREG1     = $00;          { value to write to register 1 }
  WRREG3     = $C1;          { 8 bits/char, rx enable }
  WRREG4     = $44;          { 16x, 1 stop bit, no parity }
  DTROFF     = $00;          { dtr off, rts off }
  DTRON      = $EA;          { dtr on, 8 bits/char, tx enable, rts on }
  ONINS      = $30;          { error reset }

{ StatusPort status masks }

  DAV        = $01;          { data available }
  TRDY       = $04;          { transmit buffer empty }
  DCD        = $08;          { data carrier detect }
  PE         = $10;          { parity error }
  OE         = $20;          { overrun error }
  FE         = $40;          { framing error }
  ERR        = $70;          { parity, overrun and framing error }

{ Smartmodem result codes }

  OKAY        = '0';         { Command executed with no errors }
  CONNECT300  = '1';         { Carrier detect at 300 bps }
  RING        = '2';         { Ring signal detected }
  NOCARRIER   = '3';         { Carrier lost or never heard }
  ERROR       = '4';         { Error in command execution }
  CONNECT1200 = '5';         { Carrier detect at 1200 bps }

{ Rate setting commands }

  BDSET      = $47;          {First Byte of CTC Command}
  BD300      = 128;          { 300 bps }
  BD1200     =  32;          { 1200 bps }

function mdcarck: boolean;
{ Check to see if carrier is present }
begin
  port[StatusPort] := RESSTA;
  mdcarck := ((DCD and port[StatusPort]) <> 0)
end;

function mdinprdy: boolean;
{ Check for ready to input from modem }
var
  bt: byte;
begin
  if (DAV and port[StatusPort]) <> 0
    then
      begin
        port[StatusPort] := 1;
        if (ERR and port[StatusPort]) <> 0
          then
            begin
              port[StatusPort] := ONINS;
              bt := port[DataPort];
              mdinprdy := FALSE
            end
          else mdinprdy := TRUE
      end
    else mdinprdy := FALSE
end;

function mdinp: byte;
{ Input a byte from modem - no wait - assumed ready }
begin
  mdinp := port[DataPort]
end;

procedure mdout(b: byte);
{ Output a byte to modem - wait until ready }
begin
  repeat
  until (TRDY and port[StatusPort]) <> 0;
  port[DataPort] := b
end;

procedure mdinit;
{ Initialize the sio channel and the Hayes Smartmodem 1200 }
const
  sio_init: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3, 5, DTROFF);
var
  i: integer;
  mdm_attn : string[2];
  mdm_init : string[41];
  bt       : byte;
begin
  for i := 1 to 9 do
    port[StatusPort] := sio_init[i];        { initialize the SIO channel }
  port[StatusPort] := 5;                    { pull DTR high }
  port[StatusPort] := DTRON;
  mdm_attn := 'AT';
  mdm_init := 'ATE0Q0V0M0X1 S0=1 S2=3 S4=255 S5=255';
  port[RatePort] := BDSET;
  port[RatePort] := BD1200;                 {set the 8116 to 1200 baud}
  delay (500);                              {let the modem settle for a bit}
  for i := 1 to 2 do
    begin
      bt := ord(mdm_attn[i]);               {force the modem to 1200 baud}
      mdout(bt)
    end;
  bt := ord(

CR);
  mdout(bt);
  delay (2000);                             {wait a sec...}
  for i := 1 to 41 do
    begin
      bt := ord(mdm_init[i]);               {initialize the modem}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  bt := mdinp;                              { clear any previous rings }
  bt := mdinp
end;

function mdring: boolean;
{ Determine if the phone is ringing }
begin
  if mdinprdy
    then mdring := (RING = chr(mdinp))
    else mdring := FALSE
end;

procedure mdhangup;
{ Hangup modem }
var
  i        : integer;
  mdm_hang : string[4];
  bt       : byte;
begin
  repeat
    port[StatusPort] := 5;             { setup to write register 5 }
    port[StatusPort] := DTROFF;        { clear DTR, causing hangup }
    delay(2000);
    port[StatusPort] := 5;
    port[StatusPort] := DTRON;
    if mdcarck
      then
        begin
          mdm_hang := 'ATH0';
          for i := 1 to 3 do
            begin
              bt := ord(ETX);
              mdout(bt)
            end;
          delay(1500);
          for i := 1 to 4 do
            begin
              bt := ord(mdm_hang[i]);
              mdout(bt)
            end;
          bt := ord(CR);
          mdout(bt)
        end;
  until not(mdcarck)
end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
var
  mdm_answ : string[3];
  code     : char;
  i        : integer;
  bt       : byte;
begin
  repeat
  until mdinprdy;
  bt := mdinp;
  mdm_answ := 'ATA';
  for i := 1 to 3 do
    begin
      bt := ord(mdm_answ[i]);
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  repeat
  until mdinprdy;
  code := chr(mdinp);
  if code = CONNECT1200
    then
      begin
        port[RatePort] := BDSET;
        port[RatePort] := BD1200;
        rate := 0.02075;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = CONNECT300
    then
      begin
        port[RatePort] := BDSET;
        port[RatePort] := BD300;
        rate := 0.083;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = NOCARRIER
    then mdhangup
end;

procedure mdbusy;
{Take modem off hook to present a busy signal to incoming callers}
 begin
   mdhangup
 end;

procedure GetTAD(var t: tad_array);
{ Return a 6 element byte array of the current system time in
  seconds, minutes, hours, day, month, and year. }
var
    aaa: array[0..21] of byte absolute $FF7C;
    result,temp1,temp2,temp3,temp4,temp5,temp6 : integer;
begin
  INLINE($2A/$1B/$00);
  INLINE($01/$13/$00);
  INLINE($09);
  INLINE($11/$7C/$FF);
  INLINE($0E/$00);
  INLINE($CD/*+5);
  INLINE($C3/*+3);
  INLINE($E9);
  val(chr(aaa[17])+chr(aaa[18]),temp1,result);
  val(chr(aaa[14])+chr(aaa[15]),temp2,result);
  val(chr(aaa[11])+chr(aaa[12]),temp3,result);
  val(chr(aaa[3])+chr(aaa[4]),temp4,result);
  val(chr(aaa[0])+chr(aaa[1]),temp5,result);
  val(chr(aaa[8])+chr(aaa[9]),temp6,result);
  t[0] :=temp1;
  t[1] :=temp2;
  t[2] :=temp3;
  t[3] :=temp4;
  t[4] :=temp5;
  t[5] :=temp6;
end;

procedure SetTAD(var t: tad_array);
{ Set the system time using  a 6 element byte array }

var
     aaa: array[0..21] of char absolute $FF7C;
     bbb: STRING[1];
     ccc,ddd,eee: integer;
begin
  ccc :=t[0] div 10;
  str(ccc,bbb);
  aaa[17] :=bbb;
  ddd :=ccc * 10;
  ccc :=t[0] - ddd;
  str(ccc,bbb);
  aaa[18] :=bbb;
  ccc :=t[1] div 10;
  str(ccc,bbb);
  aaa[14] :=bbb;
  ddd :=ccc * 10;
  ccc :=t[1] - ddd;
  str(ccc,bbb);
  aaa[15] :=bbb;
  ccc :=t[2] div 10;
  str(ccc,bbb);
  aaa[11] :=bbb;
  ddd :=ccc * 10;
  ccc :=t[2] - ddd;
  str(ccc,bbb);
  aaa[12] :=bbb;
  ccc :=t[3] div 10;
  str(ccc,bbb);
  aaa[3] :=bbb;
  ddd :=ccc * 10;
  ccc :=t[3] - ddd;
  str(ccc,bbb);
  aaa[4] :=bbb;
  ccc :=t[4] div 10;
  str(ccc,bbb);
  aaa[0] :=bbb;
  ddd :=ccc*10;
  ccc :=t[4] - ddd;
  str(ccc,bbb);
  aaa[1] :=bbb;
  ccc :=t[5] div 10;
  str(ccc,bbb);
  aaa[8] :=bbb;
  ddd :=ccc * 10;
  ccc :=t[5] - ddd;
  str(ccc,bbb);
  aaa[9] :=bbb;
  INLINE($2A/$1B/$00);
  INLINE($01/$13/$00);
  INLINE($09);
  INLINE($11/$7C/$FF);
  INLINE($0E/$01);
  INLINE($CD/*+5);
  INLINE($C3/*+3);
  INLINE($E9);
end;
