{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }
{ This insert should be useable on any computer with a Z80 SIO or }
{ DART and a CTC. I used Steve Foxs' BB2 overlay and added the    }
{ Hayes Smartmodem codes and re-wrote the MDBUSY procedure using  }
{ the code from Steve Davis' overlay.                             }
{ Chris Heuser sysop BBS Directory 305-231-6435/7pm - 9am/24hrs wk}


procedure system_init;
{ System particular initialization to be done once (when ROS first starts) }
  begin
  end;

procedure putstat (st: StrStd);
{ Put 'st' on status line and return normal display }
  const
    status_line    = 1;                   { Line used for system status }
    last_line      = 24;                  { Last line on screen }
  begin
    GotoXY(1, status_line);
    ClrEol;
    write(st);
    GotoXY(1, last_line)
  end;

     {** Modem dependent routines **}

const

{ Port locations }

  DataPort   = $88;          { Data port }
  StatusPort = $8A;          { Status port }
  RatePort   = $85;          { Data rate (bps) port }

{ StatusPort commands }

  RESCHN     = $18;          { reset channel }
  RESSTA     = $10;          { reset ext/status }
  WRREG1     = $00;          { value to write to register 1 }
  WRREG3     = $C1;          { 8 bits/char, rx enable }
  WRREG4     = $44;          { 16x, 1 stop bit, no parity }
  DTROFF     = $00;          { dtr off, rts off }
  DTRON      = $EA;          { dtr on, 8 bits/char, tx enable, rts on }
  ONINS      = $30;          { error reset }

{ StatusPort status masks }

  DAV        = $01;          { data available }
  TRDY       = $04;          { transmit buffer empty }
  DCD        = $08;          { data carrier detect }
  PE         = $10;          { parity error }
  OE         = $20;          { overrun error }
  FE         = $40;          { framing error }
  ERR        = $70;          { parity, overrun and framing error }

{ Smartmodem result codes }

  OKAY        = '0';         { Command executed with no errors }
  CONNECT300  = '1';         { Carrier detect at 300 bps }
  RING        = '2';         { Ring signal detected }
  NOCARRIER   = '3';         { Carrier lost or never heard }
  ERROR       = '4';         { Error in command execution }
  CONNECT1200 = '5';         { Carrier detect at 1200 bps }

{ Rate setting commands }

  BDSET      = $47;          { First Byte of CTC Command }
  BD300      = 128;          { 300 bps }
  BD1200     =  32;          { 1200 bps }

function mdcarck: boolean;
{ Check to see if carrier is present }
begin
  port[StatusPort] := RESSTA;
  mdcarck := ((DCD and port[StatusPort]) <> 0)
end;

function mdinprdy: boolean;
{ Check for ready to input from modem }
var
  bt: byte;
begin
  if (DAV and port[StatusPort]) <> 0
    then
      begin
        port[StatusPort] := 1;
        if (ERR and port[StatusPort]) <> 0
          then
            begin
              port[StatusPort] := ONINS;
              bt := port[DataPort];
              mdinprdy := FALSE
            end
          else mdinprdy := TRUE
      end
    else mdinprdy := FALSE
end;

function mdinp: byte;
{ Input a byte from modem - no wait - assumed ready }
begin
  mdinp := port[DataPort]
end;

procedure mdout(b: byte);
{ Output a byte to modem - wait until ready }
begin
  repeat
  until ((TRDY and port[StatusPort]) <> 0);
  port[DataPort] := b
end;

procedure mdinit;
{ Initialize modem }
const
  mdinit: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3,
                                 5, DTROFF);
var
  i: integer;
  mdm_attn : string[2];
  mdm_init : string[36];
  bt       : byte;
begin
  for i := 1 to 9 do
    port[StatusPort] := mdinit[i];        { initialize the SIO channel }
  port[StatusPort] := 5;                    { pull DTR high }
  port[StatusPort] := DTRON;
  mdm_attn := 'AT';
  mdm_init := 'ATE0Q0V0M0X1 S0=0 S2=3 S4=255 S5=255';
  port[RatePort] := BDSET;                  {first byte of CTC command}
  port[RatePort] := BD1200;                 {set the CTC to 1200 baud}
  for i := 1 to 2 do
    begin
      bt := ord(mdm_attn[i]);               {force the modem to 1200 baud}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  delay (2000);                             {wait a sec...}
  for i := 1 to 36 do
    begin
      bt := ord(mdm_init[i]);               {initialize the modem}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  bt := mdinp;                              { clear any previous rings }
  bt := mdinp
end;

function mdring: boolean;
{ Determine if the phone is ringing }
begin
  if mdinprdy
    then mdring := (RING = chr(mdinp))
    else mdring := FALSE
end;

procedure mdhangup;
{ Hangup modem }
var
  i        : integer;
  mdm_hang : string[4];
  bt       : byte;
begin
  repeat
    port[StatusPort] := 5;             { setup to write register 5 }
    port[StatusPort] := DTROFF;        { clear DTR, causing hangup }
    port[StatusPort] := 5;
    port[StatusPort] := DTRON;
    if mdcarck
      then
        begin
          mdm_hang := 'ATH0';
          for i := 1 to 3 do
            begin
              bt := ord(ETX);
              mdout(bt)
            end;
          delay(1500);
          for i := 1 to 4 do
            begin
              bt := ord(mdm_hang[i]);
              mdout(bt)
            end;
          bt := ord(CR);
          mdout(bt)
        end;
  until not(mdcarck)
end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
var
  mdm_answ : string[3];
  code     : char;
  i        : integer;
  bt       : byte;
begin
  repeat
  until mdinprdy;
  bt := mdinp;
  mdm_answ := 'ATA';
  for i := 1 to 3 do
    begin
      bt := ord(mdm_answ[i]);
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  repeat
  until mdinprdy;
  code := chr(mdinp);
  if code = CONNECT1200
    then
      begin
        port[RatePort] := BDSET;
        port[RatePort] := BD1200;
        rate := 0.02075;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = CONNECT300
    then
      begin
      port[RatePort] := BDSET;  
      port[RatePort] := BD300;
        rate := 0.083;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = NOCARRIER
    then mdhangup
end;

procedure mdsend(mstr: StrStd;lstr: Integer);
var
  i               : integer;
  bt              : byte;
begin
  for i := 1 to lstr do
  begin
    bt := ord(mstr[i]);
    mdout(bt)
  end;
  bt := ord(CR);
  mdout(bt);
  delay(2000);
end;

procedure mdbusy;
{ Take modem off hook to present a busy signal to incoming callers }
var
  mdmstr : String[6];
  begin
    mdmstr := 'ATM0H1'; { Take modem off hook }
    mdsend(mdmstr,6);    
  end;

     {** Time and date routines }

procedure GetTAD(var t: tad_array);
{ Return a 6 element integer array of the current system time in
  seconds, minutes, hours, day, month, and year. }
begin
  move(global_date, t, 6)
end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element integer array which contains
  seconds, minutes, hours, day, month, and year. }
begin
  move(t, global_date, 6)
end;
