{
  If your machine does not have a real time clock (RTC), you can still
  install ROS by using the following procedures for time keeping.  The
  time and date are maintained in 'global_date' which  MUST be defined
  in ROSDEF.INC as follows:

        <-- near the end of the file -->

  global_date,                              { ADD THIS LINE }
  login_t        : tad_array;               { Login time }

        <-- etc. -->

  When you first  bring up ROS,  and once per day,  login as sysop and
  use the  'T'ime operation in the  'U'tility menu to set the time and
  date.  While the time may be set to any value, I recommend 00:00:00.
}

procedure GetTAD(var t: tad_array);
{ Return a 6 element integer array of the current system time in
  seconds, minutes, hours, day, month, and year. }
  begin
    move(global_date, t, 6)
  end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element integer array which contains
  seconds, minutes, hours, day, month, and year. }
  begin
    move(t, global_date, 6)
  end;
