{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }

     {** System routines **}

procedure system_init;
{ System particular initialization to be done once (when ROS first starts) }
  begin
  end;

procedure putstat(st: StrStd);
{ Put 'st' on status line and return to normal display }
  const
    status_line    =  1;                    { Line used for system status }
    last_line      = 25;                    { Last line on screen }
  begin
    GotoXY(1, status_line);
    ClrEol;
    LowVideo;
    write(st);
    HighVideo;
    GotoXY(1, last_line)
  end;

     {** Time and date routines - BigBoard II code by Steve Fox }

procedure GetTAD(var t: tad_array);
{ Return a 6 element byte array of the current system time in
    seconds, minutes, hours, day, month, and year. }
  begin
    move(mem[$FF7C], t[0], 6);
    t[3] := succ(t[3]);
    t[4] := succ(t[4])
  end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element byte array which contains
    seconds, minutes, hours, day, month, and year. }
  begin
    t[3] := pred(t[3]);
    t[4] := pred(t[4]);
    move(t[0], mem[$FF7C], 6)
  end;

     {** Modem dependent routines **}

const

{ Port locations }

  DataPort   = $80;          { Data port }
  StatusPort = $81;          { Status port }
  RatePort   = $89;          { Data rate (bps) port }

{ StatusPort commands }

  RESCHN     = $18;          { reset channel }
  RESSTA     = $10;          { reset ext/status }
  WRREG1     = $00;          { value to write to register 1 }
  WRREG3     = $C1;          { 8 bits/char, rx enable }
  WRREG4     = $44;          { 16x, 1 stop bit, no parity }
  DTROFF     = $00;          { dtr off, rts off }
  DTRON      = $EA;          { dtr on, 8 bits/char, tx enable, rts on }
  ONINS      = $30;          { error reset }

{ StatusPort status masks }

  DAV        = $01;          { data available }
  TRDY       = $04;          { transmit buffer empty }
  DCD        = $08;          { data carrier detect }
  PE         = $10;          { parity error }
  OE         = $20;          { overrun error }
  FE         = $40;          { framing error }
  ERR        = $70;          { parity, overrun and framing error }

{ Rate setting commands }

  BDSET      = $47;          { First Byte of CTC Command }
  BD300      = 128;          { 300 bps }
  BD1200     =  32;          { 1200 bps }

procedure mdinit;
{ Initialize modem }
  const
    mdinit: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3, 5, DTRON);
  var
    i: integer;
  begin
    for i := 1 to 9 do
      port[StatusPort] := mdinit[i]
  end;

function mdring: boolean;
{ Determine if the phone is ringing }
  begin
    port[StatusPort] := RESSTA;
    mdring := ((DCD and port[StatusPort]) <> 0)
    { mdring := (($04 and port[$D9]) <> 0) }
  end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
  begin
    port[RatePort] := BDSET;
    if ($40 and port[$D9]) = 0
      then
        begin
          port[RatePort] := BD1200;
          rate := 0.02075
        end
      else
        begin
          port[RatePort] := BD300;
          rate := 0.083
        end
  end;

procedure mdhangup;
{ Hangup modem }
  begin
    port[StatusPort] := RESCHN;
    port[StatusPort] := 5;                  { setup to write register 5 }
    port[StatusPort] := DTROFF              { clear DTR, causing hangup }
  end;

function mdcarck: boolean;
{ Check to see if carrier is present }
  begin
    port[StatusPort] := RESSTA;
    mdcarck := ((DCD and port[StatusPort]) <> 0)
  end;

function mdinprdy: boolean;
{ Check for ready to input from modem }
  begin
    mdinprdy := ((DAV and port[StatusPort]) <> 0)
  end;

function mdinp: byte;
{ Input a byte from modem - no wait - assumed ready }
  begin
    mdinp := port[DataPort]
  end;

procedure mdout(b: byte);
{ Output a byte to modem - wait until ready }
  begin
    repeat
    until ((TRDY and port[StatusPort]) <> 0);
    port[DataPort] := b
  end;

procedure mdbusy;
{ Take modem off hook to present a busy signal to incoming callers }
  begin
    mdhangup
  end;

