{ 05/30/85 ROS820-1.TAD Time and Date routine for the Xerox 820-I.            }
{ If you are using the software clock from the Xerox 820-1 Programmers        }
{ Guide, then you must modify the routine to allow re-setting of the          }
{ clock with-out doing a system reset. I recommend obtaining a new set of     }
{ ROMS from Optronics Technology, Pennfield, NY (free plug, Jim) and using    }
{ the burned-in clock, as well as dumb terminal, and -II attributes.          }
{ This TAD modification adapted from Steve Fox's BB2 routine, and includes    }
{ the proper putstat routine. Modified by Richard L. Transue, Sr. If you make }
{ improvements, please upload a properly notated release to the Pleasant      }
{ Grove RCP/M....Dallas, Tx  214-286-2673. Had it not been for JACQUES        }
{ DUROSIER, I would have never figured this out! Thank You, Jacques.          }

{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }

     {** System routines **}

procedure system_init;
{ System particular initialization to be done once (when ROS first starts) }
  begin
  end;

procedure putstat(st: StrStd);
{ Put 'st' on status line and return to normal display }
  const
    status_line    =  1;                    { Line used for system status }
    last_line      = 24;                    { Last line on screen }
  begin
    GotoXY(1, status_line);
    ClrEol;
    write(st);
    GotoXY(1, last_line)
 end;
     {** Time and date routines - BigBoard II code by Steve Fox }

procedure GetTAD(var t: tad_array);
{ Return a 6 element byte array of the current system time in
    seconds, minutes, hours, day, month, and year. }
  begin
    move(mem[$FF59], t[3], 3);
    move(mem[$FF5E], t[0], 1);
    move(mem[$FF5D], t[1], 1);
    move(mem[$FF5C], t[2], 1)
  end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element byte array which contains
    seconds, minutes, hours, day, month, and year. }
  begin
    move(t[3], mem[$FF59], 3);
    move(t[0], mem[$FF5E], 1);
    move(t[1], mem[$FF5D], 1);
    move(t[2], mem[$FF5C], 1)
  end;

