;******************************************************************************
;
;	NBYEUSER.INC		Gary Case
;	12 August 1984		585 Big Sky Court
;				Colorado Springs, CO
;					       80919
;				(303) 599-0744
;
;
; Implementation-specific code for NBYE10.MAC.  This insert is written for my
; NZCPR-2 BIOS.  The only special function it performs is to initialize the
; multiple-command buffer.
;
;
;******************************************************************************
;
;
;
USRWBOOT:	;This routine is jumped to by NBYE to complete a warm boot.
		;When entered, the original BIOS warm boot entry is in HL.
		;Normally, this routine consists of a single 'PCHL' to vector
		;to the BIOS warm boot point.  The entry is provided for
		;special systems which require other processing.
		;
;
	PCHL			;WARM BOOT ENTIRELY THROUGH THE BIOS
;
;
;
USRINIT:	;This routine is called by NBYE after it has initialized the
		;MODEM and is preparing to wait for a call.  If no special
		;processing is required, just 'RET'.
		;
		;	May destroy all registers.
		;
;
	CALL	CHKZPR		;SEE IF WE'RE RUNNING THE EXPECTED NZCPR SYSTEM
	RNZ			;AND DO NOTHING IF NOT
	LHLD	BASE+1		;ELSE COMPUTE MULTIPLE COMMAND BUFFER ADDRESS
	LXI	D,033H+4
	DAD	D
	MOV	D,H
	MOV	E,L
	MVI	M,0		;CLEAR THE FIRST BYTE
	DCX	H		;AND STORE POINTER TO BEGINNING FOR NZCPR2
	DCX	H
	DCX	H
	MOV	M,D
	DCX	H
	MOV	M,E
	RET
;
;
;
USRFINI:	;This routine is called when the SYSOP has exited NBYE to CP/M.
		;
		;	May destroy all registers.
		;
;
	RET			;NO SPECIAL PROCESSING NEEDED
;
;
;
USRLOGD:	;This routine is called when NBYE has answered the phone,
		;received a carrier tone, and successfully logged in a new
		;user.
		;
		;	May destroy all registers.
		;
;
	RET			;NO SPECIAL PROCESSING NEEDED
;
;
;
USRFUNC:	;This routine is called when the SYSOP has pressed Control-U
		;while function keys are enabled.
		;
		;	May destroy all registers.
		;
		;	Must Return Acc=0
		;
;
	XRA	A		;NO SPECIAL USER FUNCTION IMPLEMENTED
	RET			;JUST RETURN WITH ACC=0 PER SPECIFICATION
;
;
