;******************************************************************************
;
;	NBYECLK.INC		Gary Case
;	12 August 1984		585 Big Sky Court
;				Colorado Springs, CO
;					       80919
;				(303) 599-0744
;
;
; Clock Insert for NBYE.MAC.  This insert is designed for a North Star
; Horizon with my NZCPR2 clock routines.
;
;
;******************************************************************************
;
;
;
TIME:		;Routine to get the current time and update the binary time
		;values at CHOUR and CMIN.
		;
		;Exit Status:	 C ==> Time was NOT available.  CHOUR and
		;		       CMIN have not been changed.
		;		NC ==> CHOUR and CMIN have been updated.
		;
;
	CALL	CHKZPR		;CONFIRM WE'RE USING THE EXPECTED ZCPR SYSTEM
	STC			;(IN CASE NOT)
	RNZ			;IF NOT, TIME IS NOT AVAILABLE
	PUSH	D		;ELSE SAVE REGISTERS AND GET THE TIME
	PUSH	H
	LHLD	BASE+1		;POINT TO MINUTES IN THE TIME STRING
	LXI	D,5*1024-3-7
	DAD	D
	DI			;MOVE TIME IN PLACE WITH NO INTERRUPTS
	MOV	A,M
	STA	CMIN
	INX	H
	MOV	A,M
	EI			;(IRUPTS OKAY NOW)
	STA	CHOUR
	POP	H		;RESTORE REGISTERS AND EXIT WITH CARRY CLEAR
	POP	D
	ORA	A
	RET
;
;
;
CHKZPR:		;Routine to verify we are running with a ZCPR2 system using
		;Gary Case's BIOS with the ZCPR flag.
		;
		;Return Status:	 Z ==> ZCPR flag found
		;		NZ ==> ZCPR flag not found
		;
;
	PUSH	B		;SAVE REGISTERS
	PUSH	D
	PUSH	H
	LHLD	1		;GET POINTER TO BIOS (+3)
	LXI	D,256-3-1	;ADD OFFSET TO 'ZPCR' ID STRING
	DAD	D
	LXI	D,IDSTRNG+3	;POINT TO STRING TO CHECK
	MVI	B,4		;SET LENGTH
CHKSTR:	LDAX	D		;COMPARE A BYTE
	CMP	M
	JNZ	CZPRXT		;IF NOT A MATCH RETURN WITH STATUS
	DCX	D		;ELSE CONTINUE UNTIL ENTIRE STRING CHECKED
	DCX	H
	DCR	B
	JNZ	CHKSTR
CZPRXT:	POP	H		;RESTORE REGISTERS AND EXIT WITH STATUS
	POP	D
	POP	B
	RET
;
IDSTRNG: DB	'ZCPR'
;
;
