;******************************************************************************
;
;	NBNSRS.INC		Gary Case
;	19 August 1984		585 Big Sky Court
;				Colorado Springs, CO
;					       80919
;				(303) 599-0744
;
;
; North Star Horizon Right Serial Port insert for NBYE.MAC
; Companion insert to NBHAYES.INC.
;
; *** Must be renamed as NBYEIO.INC before assembly.
;
;
;   ***  Be sure to set the following:
;
;
NSBASE	EQU	0	;BASE PORT OF THE NORTH STAR HORIZON MOTHERBOARD
			;(NORMALLY 0)
;
;******************************************************************************
;
;  Special Cabling Note:  Because of the unusual connections at the DB-25
;			  connector on the back of the North Star if the
;			  "standard" header is used for the right serial
;			  port (at location 4D on the Horizon motherboard),
;			  the following must be considered when making up
;			  the connecting cable.  The Horizon looks like a
;			  DCE device, but has USART DTR on pin 5 instead of
;			  pin 6, and USART DSR on pin 4 instead of pin 20.
;			  The best solution is to redo the header on the
;			  motherboard, but if you don't want to fool with it,
;			  be sure to consider the above when making a cable.
;
;******************************************************************************
;
;
;
NSDATA	EQU	NSBASE+4	;NORTH STAR RIGHT SERIAL PORT VALUES
NSSTAT	EQU	NSBASE+5
NSCMND	EQU	NSBASE+5
;
;
;
MDMISTAT:	;Routine to return current modem port input status.
		;
		;	??? ==> Acc ==>    0 if no input ready
		;			0FFH if a character is ready
		;
		;Exit Status:	Z ==> No char available
		;	       NZ ==> Character ready
		;
;
MISCYL	EQU	28		;NBR OF MACHINE CYCLES EXECUTED BY THIS ROUTINE
				;WHEN NO CHARACTER IS READY
;
	IN	NSSTAT		;GET STATUS
	ANI	00000010B	;MASK RECEIVE READY BIT
	RZ			;STATUS OKAY IF NO INPUT READY
	MVI	A,0FFH		;ELSE NEED 0FFH TO MEET SPECIFICATIONS
	RET
;
;
;
MDMOSTAT:	;Routine to return current modem port output status.
		;
		;Exit Status:	Z ==> Port not ready for output
		;	       NZ ==> Port is ready for a character
		;
;
	IN	NSSTAT		;GET STATUS
	ANI	00000001B	;MASK TRANSMIT READY BIT
	RET			;AND RETURN WITH STATUS
;
;
;
MDMINP:		;Routine to input a byte from the modem data port.  Clears any
		;errors (framing, overrun, and parity), and substitutes a null
		;for any input with errors.
		;
		;	??? ==> Acc ==> Data from the input port
		;
;
	CALL	MDMISTAT	;WAIT UNTIL CHARACTER IS READY
	JZ	MDMINP
	IN	NSSTAT		;CHECK FOR ERRORS (PARITY OR FRAMING)
	ANI	00101000B
	IN	NSDATA		;GET THE DATA REGARDLESS
	RZ			;DONE IF NO ERRORS
	JMP	MDMDTRON	;ELSE RESET COMMAND REGISTER AND RETURN A NULL
;
;
;
MDMOUT:		;Routine to send a byte to the modem data port.
		;
		;	Byte to send ==> Acc ==> Unchanged
		;
;
	PUSH	PSW		;SAVE BYTE TO SEND
W4MDMO:	CALL	MDMOSTAT	;WAIT UNTIL READY FOR OUTPUT
	JZ	W4MDMO
	POP	PSW		;RESTORE THE DATA, SEND IT, AND EXIT
	OUT	NSDATA
	RET
;
;
;
MDM300:		;Routine to initialize the modem port to 300 baud.
		;
;
	MVI	A,01001111B	;SET VALUE FOR 300 BAUD INITIALIZATION
				;1 STOP, NO PARITY, 8 BITS, 64x CLOCK
	JMP	MDMBD		;GO INIT THE PORT
;
;
;
MDM1200:	;Routine to initialize the modem port to 1200 baud.
		;
;
	MVI	A,01001110B	;SET VALUE FOR 1200 BAUD INITIALIZATION
				;1 STOP, NO PARITY, 8 BITS, 16x CLOCK
MDMBD:	PUSH	PSW		;SAVE SETUP BYTE
	MVI	A,01000000B	;RESET RIGHT SERIAL PORT USART
	OUT	NSCMND
	XTHL			;A BIT OF DELAY
	XTHL
	POP	PSW		;NOW SEND SETUP BYTE
	OUT	NSCMND
	CALL	MDMDTRON	;AND FOLLOW WITH COMMAND BYTE
	XTHL			;A BIT OF DELAY
	XTHL
	IN	NSDATA		;CLEAR ANY PENDING INPUTS
	IN	NSDATA
	XRA	A		;RETURN WITH GOOD STATUS
	RET
;
;
;
MDMDTRON:	;Routine to turn modem port DTR on.
		;
;
	MVI	A,00110111B	;COMMAND NORMAL OPERATION, RTS HIGH, RESET ANY
	OUT	NSCMND		;ERRORS, NO BREAK, RCVR ON, DTR HIGH, XMITR ON
	XRA	A		;EXIT WITH NULL FOR 'MDMINP'
	RET
;
;
;
MDMDTROFF:	;Routine to turn modem port DTR off.
		;
;
	MVI	A,00110101B	;COMMAND NORMAL OPERATION, RTS HIGH, RESET ANY
	OUT	NSCMND		;ERRORS, NO BREAK, RCVR ON, DTR LOW, XMITR ON
	RET
;
;
;
MDMDSR:		;Routine to return status of the DSR input on the modem port.
		;
;
	IN	NSSTAT		;GET STATUS
	ANI	10000000B	;MASK DSR STATUS BIT
	RET			;AND RETURN WITH STATUS
;
;
;		***  End of North Star Right Serial Port Insert ***
;
;******************************************************************************
