;  NBYEMDM.DOC  --  Specifications for the NBYEMDM.INC file for NBYE.MAC
;
;			Gary Case
;			585 Big Sky Court
;			Colorado Springs, CO
;				       80919
;			(303) 599-0744
;
;
;******************************************************************************
;
;   NBYE.MAC requires that all modem interface code be located in a file
;   named NBYEMDM.INC.  The required routines in this module are documented
;   below.  The following conventions are used in this documentation:
;
;	Inputs/Outputs:	Any required input is shown as an input to the
;			required register, with the expected register result
;			shown exiting the register.  For example, the modem
;			output routine requires the character to send in Acc,
;			and must not destroy the character.  The routine
;			documentation shows this as:
;
;				Char to Send ==> Acc ==> Unchanged
;
;		Status:	Any required status flags will be explicitly listed
;			after the register input/output conventions.  The
;			zero flag is represented by Z (set) or NZ (not set),
;			and carry is represented by C (set) or NC (not set).
;
;     Use of Registers: All Registers except the Acc must be preserved unless
;			the register input/output section explicitly shows
;			that a particular register is changed.  If a routine
;			may change a register, the exit condition is shown as
;			three question marks.  For example, if the character
;			output routine was allowed to destroy the character,
;			the documentation would show this as:
;
;				Char to Send ==> Acc ==> ???
;
;
;
;	NOTE:	To separate physical port I/O from the modem management
;		code, a separate NBYEIO.INC file is included when assembling
;		NBYE except in the S100 modem card cases.  Any NBYEMDM.INC
;		files you write should follow this convention.  Please
;		document the requirements for the associated NBYEIO.INC file
;		at the top of your NBYEMDM.INC file, so someone with the same
;		modem but a different I/O card (or computer) can easily adapt
;		the insert for his system.
;
;
;******************************************************************************
;
MDMUSER	EQU	7	;RELATIVE USER NUMBER OF MODEM PORT ON INTERFACER 3
;
I3BASE	EQU	10H	;BASE PORT OF THE INTERFACER 3
;
;
I3DATA	EQU	I3BASE		;INTERFACER 3 PORT VALUES
I3STAT	EQU	I3BASE+1
I3MODE	EQU	I3BASE+2
I3CMND	EQU	I3BASE+3
I3USER	EQU	I3BASE+7
;
;
;
MISTAT:		;Routine to return current modem port input status.
		;
		;	??? ==> Acc ==>    0 if no input ready
		;			0FFH if a character is ready
		;
		;Exit Status:	Z ==> No char available
		;	       NZ ==> Character ready
		;
;
MISCYL	EQU	44		;NBR OF MACHINE CYCLES EXECUTED BY THIS ROUTINE
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	IN	I3STAT		;GET STATUS
	ANI	00000010B	;MASK RECEIVE READY BIT
	RZ			;STATUS OKAY IF NO INPUT READY
	MVI	A,0FFH		;ELSE NEED 0FFH TO MEET SPECIFICATIONS
	RET
;
;
;
MOSTAT:		;Routine to return current modem port output status.
		;
		;Exit Status:	Z ==> Port not ready for output
		;	       NZ ==> Port is ready for a character
		;
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	IN	I3STAT		;GET STATUS
	ANI	00000001B	;MASK TRANSMIT READY BIT
	RET			;AND RETURN WITH STATUS
;
;
;
MINP:		;Routine to input a byte from the modem data port.  Does not
		;check the data available status -- just gets what's there,
		;but does check for errors (framing, overrun, parity) and
		;clears any which are indicated.
		;
		;	??? ==> Acc ==> Data from the input port
		;
;
	CALL	MISTAT		;WAIT UNTIL CHARACTER IS READY
	JZ	MINP
	IN	I3DATA		;GET WHATEVER'S THERE AND EXIT
	RET
;
;
;
MOUT:		;Routine to send a byte to the modem data port.  Does not
		;check the ready status -- just sends the data out the port.
		;
		;	Byte to send ==> Acc ==> Unchanged
		;
;
	PUSH	PSW		;SAVE BYTE TO SEND
W4MDMO:	CALL	MOSTAT		;WAIT UNTIL READY FOR OUTPUT
	JZ	W4MDMO
	POP	PSW		;RESTORE THE DATA, SEND IT, AND EXIT
	OUT	I3DATA
	RET
;
;
;
MINIT:		;Modem initialization routine.  This routine must:
		;
		;	1)  Ensure the modem is on hook.
		;	2)  Initialize the modem port baud rate as appropriate.
		;	3)  Set up the modem to desired default parameters.
		;	    (See comments for MRING below)
		;
		;This is always the first routine NBYE calls in the
		;NBYEMDM.INC insert.  It is also called after each telephone
		;call to reinitialize the modem.
		;
		;Exit Status:	None
		;
	MVI	A,0111B		;SET VALUE FOR 1200 BAUD INITIALIZATION
MDMBAUD	EQU	$
	ORI	01110000B	;COMPLETE MODE REGISTER 2 VALUE FOR DESIRED
	PUSH	PSW		;BAUD RATE WITH INTERNAL CLOCKS AND SAVE IT
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	MVI	A,01001110B	;INIT TO 1 STOP, ODD PARITY DISABLED,
	OUT	I3MODE		;8 DATA BITS, AND 16X CLOCK
	POP	PSW		;SET INTERNAL CLOCKS AT DESIRED BAUD RATE
	OUT	I3MODE
MDMDTR:	MVI	A,00110111B	;COMMAND NORMAL OPERATION, RTS HIGH, RESET ANY
	OUT	I3CMND		;ERRORS, NO BREAK, RCVR ON, DTR HIGH, XMITR ON
	XRA	A		;RETURN ZERO STATUS
	RET
;
;
;
MEXIT:		;Modem exit routine.  This routine is called when the SYSOP
		;has elected to exit NBYE.  It should 'shut down' the modem,
		;returning it to the desired default state.  This is always
		;the last routine called by NBYE in the NBYEMDM.INC insert.
		;
		;Exit Status:	None
		;
	RET
;
;
;
MRING:		;Modem Ring Check routine.  This routine returns the current
		;ringing status of the telephone line.  If your modem can't
		;detect the ring status, then the initialization routine
		;should set the auto-answer mode for the modem and, when the
		;modem has answered the phone, MRING should return a Connect
		;status.
		;
		;Exit Status:	 Z and NC ==> Telephone Not Ringing
		;		NZ and NC ==> Telephone Is Ringing
		;			C ==> Already Connected
		;
	MVI	A,0FFH
	ORA	A
	RET
;
;
;
MANSWER:	;Modem Answer Routine.  This routine must answer the telephone
		;and wait for the carrier.  The wait time can be whatever you
		;want, but 30 seconds is suggested as reasonable.  This routine
		;is not called if MRING returns a connect status; however, it
		;will be called if NBYE is invoked with a /A or /C option.
		;
		;Exit Status:	 Z ==> Didn't get a carrier
		;		NZ ==> Connected with a carrier
		;
	MVI	A,0FFH
	ORA	A
	RET
;
;
;
MBAUD:		;Routine to return the connection baud rate.  If the modem
		;supports more than one baud rate, this routine should
		;determine the current baud rate (by waiting for a carriage
		;return, line feed, ctrl-c, etc.) and return the baud rate
		;indicator as shown.  If the modem always operates at the
		;same baud rate, the routine can immediately return with the
		;appropriate indicator.  If an input is necessary to determine
		;the baud rate, this routine should wait a limited time
		;(suggested 5 seconds) and return undetermined status if
		;no input is received.
		;
		;	??? ==> Acc ==> Baud Rate Indicator
		;
		;			    0 ==>   110
		;			    1 ==>   300
		;			    2 ==>   450
		;			    3 ==>   600
		;			    4 ==>   710
		;			    5 ==>  1200
		;			    6 ==>  2400
		;			    7 ==>  9600
		;			    8 ==> 19200
		;
		;Exit Status:	 C ==> Couldn't Determine the Baud Rate
		;		NC ==> Baud Rate Indicator is Set
		;
	MVI	A,5
	ORA	A
	RET
;
;
;
MCARRIER:	;Carrier Check Routine.  Returns current carrier status.
		;
		;Exit Status:	 Z ==> No Carrier
		;		NZ ==> Carrier Active
		;
	MVI	A,0FFH
	ORA	A
	RET
;
;
;
DELAY:		;Routine to delay 1/10 second.  This routine is placed here
		;because:
		;	     1) It may use some of the modem hardware (PMMI)
		;
		;	     2) Some modems (e.g. Hayes Smartmodems) provide
		;		status information via response strings that
		;		might be missed if we didn't keep polling
		;		the modem port during delays.  In these
		;		cases the delay routine can include a poll
		;		to the modem port and can factor in the poll
		;		time in the delay loop.
		;
		;Exit Status:	None
		;
	PUSH	B
	LXI	B,4167*MHZ
DELAY1:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY1
	POP	B
	RET
;
;
;
KDELAY:		;Routine to delay 1 millisecond.  This routine is place in
		;this insert for the reasons stated at DELAY.
		;
		;Exit Status:	None
		;
	PUSH	B
	LXI	B,42*MHZ
	JMP	DELAY1
;
;
;	***  End of Required Modem Routines  ***
;
;******************************************************************************
