;******************************************************************************
;
;	NBCPRO.INC		Gary Case
;	19 August 1984		585 Big Sky Court
;				Colorado Springs, CO
;					       80919
;				(303) 599-0744
;
;
; Compupro Interfacer 3 (or 4) insert for NBYE.MAC
; Companion insert to NBHAYES.INC.
;
; *** Must be renamed as NBYEIO.INC before assembly.
;
;
;   ***  Be sure to set the following:
;
;
MDMUSER	EQU	6	;RELATIVE USER NUMBER OF MODEM PORT ON INTERFACER 3
;
I3BASE	EQU	10H	;BASE PORT OF THE INTERFACER 3
;
;******************************************************************************
;
;
;
I3DATA	EQU	I3BASE		;INTERFACER 3 PORT VALUES
I3STAT	EQU	I3BASE+1
I3MODE	EQU	I3BASE+2
I3CMND	EQU	I3BASE+3
I3USER	EQU	I3BASE+7
;
;
;
MDMISTAT:	;Routine to return current modem port input status.
		;
		;	??? ==> Acc ==>    0 if no input ready
		;			0FFH if a character is ready
		;
		;Exit Status:	Z ==> No char available
		;	       NZ ==> Character ready
		;
;
MISCYL	EQU	45		;NBR OF MACHINE CYCLES EXECUTED BY THIS ROUTINE
				;WHEN NO CHARACTER IS READY
				;(FOR PURISTS IT'S 45 FOR 8080'S, 46 FOR Z80'S)
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	IN	I3STAT		;GET STATUS
	ANI	00000010B	;MASK RECEIVE READY BIT
	RZ			;STATUS OKAY IF NO INPUT READY
	MVI	A,0FFH		;ELSE NEED 0FFH TO MEET SPECIFICATIONS
	RET
;
;
;
MDMOSTAT:	;Routine to return current modem port output status.
		;
		;Exit Status:	Z ==> Port not ready for output
		;	       NZ ==> Port is ready for a character
		;
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	IN	I3STAT		;GET STATUS
	ANI	00000001B	;MASK TRANSMIT READY BIT
	RET			;AND RETURN WITH STATUS
;
;
;
MDMINP:		;Routine to input a byte from the modem data port.  Clears any
		;errors (framing, overrun, and parity), and substitutes a null
		;for any input with errors.
		;
		;	??? ==> Acc ==> Data from the input port
		;
;
	CALL	MDMISTAT	;WAIT UNTIL CHARACTER IS READY
	JZ	MDMINP
	IN	I3STAT		;CHECK FOR ERRORS
	ANI	00111000B
	IN	I3DATA		;GET THE DATA REGARDLESS
	RZ			;DONE IF NO ERRORS
	JMP	MDMDTRON	;ELSE RESET COMMAND REGISTER AND RETURN A NULL
;
;
;
MDMOUT:		;Routine to send a byte to the modem data port.
		;
		;	Byte to send ==> Acc ==> Unchanged
		;
;
	PUSH	PSW		;SAVE BYTE TO SEND
W4MDMO:	CALL	MDMOSTAT	;WAIT UNTIL READY FOR OUTPUT
	JZ	W4MDMO
	POP	PSW		;RESTORE THE DATA, SEND IT, AND EXIT
	OUT	I3DATA
	RET
;
;
;
MDM110:		;Routine to initialize the modem port to 110 baud.
		;
;
	MVI	A,0010B		;SET VALUE FOR 110 BAUD INITIALIZATION
	JMP	MDMBAUD		;GO INIT THE PORT
;
;
;
MDM300:		;Routine to initialize the modem port to 300 baud.
		;
;
	MVI	A,0101B		;SET VALUE FOR 300 BAUD INITIALIZATION
	JMP	MDMBAUD		;GO INIT THE PORT
;
;
;
MDM1200:	;Routine to initialize the modem port to 1200 baud.
		;
;
	MVI	A,0111B		;SET VALUE FOR 1200 BAUD INITIALIZATION
MDMBAUD	EQU	$
	ORI	01110000B	;COMPLETE MODE REGISTER 2 VALUE FOR DESIRED
	PUSH	PSW		;BAUD RATE WITH INTERNAL CLOCKS AND SAVE IT
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	MVI	A,01001110B	;INIT TO 1 STOP, ODD PARITY (DISABLED),
	OUT	I3MODE		;8 DATA BITS, AND 16X CLOCK
	POP	PSW		;SET INTERNAL CLOCKS AT DESIRED BAUD RATE
	OUT	I3MODE
	CALL	MDMDTRON	;FOLLOW WITH COMMAND WORD
	XTHL			;A BIT OF DELAY
	XTHL
	IN	I3DATA		;CLEAR ANY PENDING DATA
	IN	I3DATA
	XRA	A		;RETURN GOOD STATUS
	RET
;
;
;
MDMDTRON:	;Routine to turn modem port DTR on.
		;
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	MVI	A,00110111B	;COMMAND NORMAL OPERATION, RTS HIGH, RESET ANY
	OUT	I3CMND		;ERRORS, NO BREAK, RCVR ON, DTR HIGH, XMITR ON
	XRA	A		;EXIT WITH NULL FOR 'MDMINP'
	RET
;
;
;
MDMDTROFF:	;Routine to turn modem port DTR off.
		;
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	MVI	A,00110101B	;COMMAND NORMAL OPERATION, RTS HIGH, RESET ANY
	OUT	I3CMND		;ERRORS, NO BREAK, RCVR ON, DTR LOW, XMITR ON
	RET
;
;
;
MDMDSR:		;Routine to return status of the DSR input on the modem port.
		;
;
	MVI	A,MDMUSER	;SET RELATIVE USER NUMBER
	OUT	I3USER		;SELECT THE PORT
	IN	I3STAT		;GET STATUS
	ANI	10000000B	;MASK DSR STATUS BIT
	RET			;AND RETURN WITH STATUS
;
;
;		***  End of Compupro Interfacer 3/4 Insert ***
;
;******************************************************************************
