DEBUG:		;Debugger In-Line Print Routine.  Prints the 0FFH-terminated
		;message immediately following the call to this routine on
		;the local console, saving all registers and status.
		;
		;	e.g.	CALL	DEBUG
		;		DB	'HERE I AM',0FFH
		;
		;Exit Status:	None
		;
;
	XTHL			;SAVE HL, GET MESSAGE ADDRESS
	PUSH	D		;SAVE EVERYTHING ELSE
	PUSH	B
	PUSH	PSW
DBGCHR:	MOV	A,M		;GET NEXT MESSAGE CHARACTER
	INX	H		;KEEP POINTER CURRENT
	CPI	0FFH		;DONE?
	JZ	DBGFIN		;...YES
	CALL	MYCONS		;...NO, SEND TO MY CONSOLE
	JMP	DBGCHR		;	AND CONTINUE
;
DBGFIN:	POP	PSW		;RESTORE EVERYTHING EXCEPT HL
	POP	B
	POP	D
	XTHL			;RESTORE HL, TRUE RETURN ADRS TO STACK
	RET			;DONE
;
;
;
MYCONS:	PUSH	PSW		;SAVE CHARACTER TO OUTPUT
W4MYCO:	IN	3		;GET CHARACTER OUTPUT STATUS
	ANI	00000001B	;READY?
	JZ	W4MYCO		;...NO
	POP	PSW		;...YES, SEND THE CHARACTER AND EXIT
	OUT	2
	RET
;
;
;
