; UNARCOVL.ASM
;
; Overlay File for UNARC
; CP/M Archive File Extractor
; Version 1.4  21 Nov 86
;
; Copyright (C) 1986 by Robert A. Freed
; All Rights Reserved
;
; This file may be used to customize the UNARC utility for specific
; non-universal requirements.  It is intended primarily for RCP/M
; system operators or technically-oriented users with specialized
; system requirements.	Use only with the UNARC program version
; indicated above.
;
; NOTE:  This file is intended for individual, private use only!
; Please DO NOT re-distribute versions of the UNARC.COM (Z80) or
; UNARCA.COM (8080/8085) program files which have been modified by use
; of this overlay.  The distributed program files are suitable for the
; majority of users with standard CP/M 2.2 or CP/M 3.0 (CP/M Plus)
; operating environments.
;
;=======================================================================
;
; To use, simply follow these three steps:
;
; 1) Edit this UNARCOVL.ASM file for desired options.
; 2) Assemble to create an UNARCOVL.HEX file.
; 3) Merge with the distributed UNARC.COM or UNARCA.COM program files.
;
; The ASM.COM assembler supplied with CP/M 2.2 may be used for assembly.
; DDT.COM or SID.COM may be used for the final step (if you save the
; correct number of memory pages), but the publicly-distributed program
; MLOAD.COM (by Ron Fowler, Nightowl Software, Inc.) is recommended:
;
;	A>MLOAD UNARC.COM,UNARCOVL	(for the Z80-only version)
;	A>MLOAD UNARCA.COM,UNARCOVL	(for the 8080/8085 version)
;
;=======================================================================
;
NO	EQU	0
YES	EQU	NOT NO
;
; Most UNARC program options are specified by EQUate statements below.
; Each option is followed by a detailed description of its function.
; Most of these options are provided for RCP/M systems, and those most
; commonly changed are marked with an asterisk '*' in the comment field.
; (The other option defaults are suitable for the majority of systems.)
;
RCPM	EQU	YES		;*YES if remote CP/M system
;
; Define RCPM = YES to generate a restricted version of UNARC for secure
; use by callers of an RCP/M remote access system.  "Restricted" implies
; that no disk file extraction can be performed.  In addition, file
; typeout may be disallowed (see TYFLG) or limited to a maximum no. of
; lines (see TYLIM), and the default interpretation of certain other
; parameters is modified (see TYPGS and BLKSZ).
;
; The following two definitions apply only if RCPM = YES:
;
USEWHL	EQU	YES		; YES if RCP/M uses a wheel byte
WHEEL	EQU	003EH		;*Wheel byte address if USEWHL is YES
;
; Most RCP/M systems utilize a "wheel" byte in memory, to restrict
; access to privileged functions by remote callers and to provide
; greater flexibility for the sysop.  If such a byte is implemented
; (USEWHL = YES), a single version of UNARC may be utilized both for
; restricted use by remote callers (wheel byte zero) and unrestricted
; local use by the sysop (wheel byte non-zero).  Define WHEEL with the
; address of the wheel byte location in external memory.  (ZCPR3 users
; should specify the address of their Z3WHL byte, as determined by
; runing SHOW.COM).  Note that all subsequent references to the
; "restricted" version of UNARC apply only when the wheel byte is zero;
; when the wheel byte is set, operation of UNARC is identical to that
; obtained by defining RCPM = NO.  For those few RCP/M systems which do
; not implement a wheel byte (USEWHL = NO), it will be necessary to
; maintain separate versions of UNARC for remote callers (RCPM = YES)
; and local sysop use (RCPM = NO).
;
; The following two definitions apply only in restricted versions:
;
TYFLG	EQU	YES		; NO to disallow RCP/M file typeout
TYLIM	EQU	72		 ;*Non-zero typeout line limit (1-255)
;
; Define TYFLG = NO to disallow file typeout operations on RCP/M
; systems.  In this case, UNARC may be used only to obtain directory
; listings of archive files.  (In which case, it may be more appropriate
; to rename the program 'ADIR' - see program name patch at end of this
; file.)  If TYFLG = YES (the normal case), TYLIM may be defined as the
; non-zero limit (255 maximum) of the number of file lines which may be
; displayed.  This may be desired by some RCP/M sysops to discourage
; excess on-line "browsing" in favor of downloading of long files by
; callers.  If TYLIM = 0, unlimited file typeout is permitted as in
; unrestricted versions.
;
CCPSV	EQU	8		; No. high memory pages to save (8 = 2K)
;
; UNARC uses all available TPA space for buffering output files, which
; provides better performance in systems with larger memories.	However,
; by default the program preserves the CCP area at the top of the TPA,
; and it returns directly to the CCP instead of forcing a warm boot
; after execution.  CCPSV specifies the amount of memory (in 256-byte
; pages) to reserve for this purpose.  The default value (CCPSV = 8) is
; appropriate for the CCP size in standard CP/M 2.2 systems.  Setting
; CCPSV = 0 will yield an additional 2K bytes of buffer space, but it
; forces a warm boot return after each program execution.  This need be
; used only with very small CP/M 2.2 systems (but may be desirable with
; CP/M 3.0 or any non-standard system with a permanently-resident CCP).
; Certain non-standard CP/M implementations (TRS-80?) may require the
; definition CCPSV = 9.
;
; Note that the CCPSV definition may be overridden by the following:
;
USELUX	EQU	YES		;*YES if UNARC will be used by LUX
LUXSIZ	EQU	27		; Size of LUX resident code
;
; The associated file UNARCLUX.FIX describes a problem of interaction
; between UNARC and the LUX utility program (version 8.0).  Define
; USELUX = YES to avoid this problem (or until it is corrected by a
; later version of LUX).  LUXSIZ specifies the size (in 256-byte pages)
; of the resident code which LUX relocates to high memory before calling
; UNARC.  The supplied value (LUXSIZ = 27) is appropriate for LUX 8.0
; and should not be modified unless requirements change in a later
; version of LUX.
;
TYPGS	EQU	0		; No. buffer pages for typeout (0=max)
;
; This value specifies the number of (256-byte) pages to buffer an
; extracted file during typeout operations.  The default definition
; (TYPGS = 0) provides the maximum possible buffering (the entire TPA
; space), but may cause a long delay at the start (and in the middle)
; of typeout of large files.  Defining TYPGS = 1 will minimize viewing
; waits, but may cause excessive start/stop of floppy disk drive motors
; on some systems (e.g. Kaypro).  Since this is not a consideration for
; systems with hard disks, users of such systems may prefer TYPGS = 1.
; For restricted RCP/M versions, TYPGS = 1 is assumed if the default
; (TYPGS = 0) is not changed (to minimize delays for remote users).
;
BLKSZ	EQU	0		; Default disk allocation block size (K)
;
; This value provides the default disk allocation block size (as a
; multiple of 1K bytes) to use in calculating disk space requirements
; for the "Disk" column of archive directory listings (except during
; file extraction to disk, in which case the output drive's block size
; applies.)  The default definition (BLKSZ = 0) indicates that the
; block size of the default (CCP) drive is to be used for this purpose.
; However, for restricted RCP/M versions, BLKSZ = 1 is assumed if the
; default is not changed.  (Since 1K is the minimum disk block size in
; any CP/M system, this provides the widest applicability for all remote
; callers, independent of the RCP/M system's actual disk block size.)
;
CPM68K	EQU	NO		; YES if BDOS function 31 unsupported
;
; UNARC uses BDOS function 31 (Get Address of Disk Parameter Block) to
; determine disk allocation block size (i.e. of the output drive when
; extracting files to disk, or of the default CCP drive at other times
; if BLKSZ = 0).  However, this function is rarely used by application
; programs and is not supported by some non-standard implementations of
; CP/M (in particular, the 8080 CP/M 2.2 emulator for CP/M-68K).  For
; such systems, define CPM68K = YES to inhibit use of BDOS function 31.
; In this case, the BLKSZ value will be assumed (1K, if BLKSZ = 0).
;
HIDRV	EQU	16		; Highest input file drive (A=1,B=2,...)
;
; Specifies the highest allowable drive no. for archive files, where
; drive A is 1, drive B is 2, etc.  The default definition (HIDRV = 16)
; is the maximum supported by CP/M.  Most RCP/M systems need not alter
; this definition, since invalid drive accesses are normally intercepted
; elsewhere.  If this is not the case, this value should be set to the
; number of available drives (assuming all sequential drives available,
; starting with drive A).  Setting HIDRV = 0 restricts input to the
; default drive (i.e. disallows specification of a drive name for the
; archive file).
;
HODRV	EQU	16		; Highest output file drive no.
;
; Specifies the highest allowable output drive no. for file extraction
; operations (specified as for HIDRV above).  Setting HODRV = 0 will
; disallow any file extraction to disk (which is the obvious setting of
; importance for RCP/M systems).  However, this is assumed in restricted
; versions, so this value need not be modified (except for local sysop
; use) if RCPM = YES.
;
TYLPS	EQU	23		; No. typeout lines per screen (1-255)
;
; Specifies the number of lines between automatic pauses in console
; typeout.  Should be set to one less than the number of display screen
; lines, to allow for the '[more]' message line.  Setting TYLPS = 0 will
; inhibit all pauses (e.g. for hard-copy terminals), although this can
; also be specified by a trailing 'N' on the UNARC command line.
;
BELLS	EQU	YES		; NO to inhibit error message bells
;
; By default (BELLS = YES), the terminal 'bell' (i.e. beeper on most
; modern terminals) is sounded in all warning and fatal error messages,
; to bring operator attention to unusual conditions.  Define BELLS = NO
; if you prefer solitude.
;
;		     (End of user-definable EQUates)
;=======================================================================
;		       (Start of program patches)
;
; Do not make any changes to this section.  Additional user-definable
; options continue below the next double separator line.
;
	ORG	103H
;
	 IF NOT	USELUX
	DB	CCPSV		; 103H
	 ENDIF
	 IF USELUX
	DB	LUXSIZ		; 103H
	 ENDIF
;
	DB	BLKSZ		; 104H
	DB	HIDRV		; 105H
;
	 IF USEWHL OR NOT RCPM
PSWHL:	DB	HODRV		; 106H	Pseudo wheel byte if not RCP/M
	 ENDIF
	 IF RCPM AND NOT USEWHL
PSWHL:	DB	0		; 106H	Pseudo wheel byte if weird RCP/M
	 ENDIF
;
	DB	TYFLG AND 0FFH	; 107H
	DB	TYPGS		; 108H
	DB	TYLIM		; 109H
;
	 IF RCPM AND USEWHL
	DW	WHEEL		; 10AH
	 ENDIF
	 IF NOT	RCPM OR	NOT USEWHL
	DW	PSWHL		; 10AH
	 ENDIF
;
	DB	TYLPS		; 10CH
;
	 IF NOT	CPM68K
	DB	0		; 10DH
	 ENDIF
	 IF CPM68K AND BLKSZ
	DB	BLKSZ		; 10DH
	 ENDIF
	 IF CPM68K AND NOT BLKSZ
	DB	1		; 10DH
	 ENDIF
;
	DB	BELLS AND 0FFH	; 10EH
;
;=======================================================================
;	   (Additional user-definable patches continue here)
;
; The following is a table of filetypes (3-byte ASCII strings) which are
; assumed to contain binary data and are not allowed for file typeout.
; Question marks may be used as wildcards (will match any character).
; The table must terminate with a zero byte (room for 20 entries total).
;
	DB	'COM'		; CP/M-80 or MS-DOS binary object
	DB	'CM','D'+80H	; CP/M-86 binary object (or dBASE file)
	DB	'EXE'		; MS-DOS executable
	DB	'OBJ'		; Renamed COM
	DB	'OV?'		; Binary overlay
	DB	'REL'		; Relocatable object
	DB	'?RL'		; Other relocatables (PRL, CRL, etc.)
	DB	'INT'		; Intermediate compiler code
	DB	'SYS'		; System file
	DB	'BAD'		; Bad disk block
	DB	'LBR'		; Library
	DB	'ARC'		; Archive (unlikely in an ARC)
	DB	'ARK'		; Alternate archive (ditto)
	DB	'?Q?'		; Any SQueezed file (ditto)
	DB	'?Z?'		; Any CRUNCHed (or ZOO'd) file (ditto)
;
; Additional filetypes may be added below.  To remove one of the above
; filetypes without replacing it, simply set the msb in any byte (as
; above for .CMD, since that can be a readable dBASE command file).
;
	DB	0,0,0
	DB	0,0,0
	DB	0,0,0
	DB	0,0,0
	DB	0,0,0
	DB	0		; 14BH	End of table (do not change)
;
;-----------------------------------------------------------------------
;
; The following 6 bytes specify the program name for self-referential
; use in the help display and abort message.  If less than 6 name
; characters are desired, the remaining bytes must be padded with
; blanks.  (A maximum of 5 characters is recommended for proper tabular
; alignment of the help display examples.)
;
	DB	'UNARC '	; 14CH	Author's preference, of course
;;;	DB	'ADIR  '	; 14CH	(But some sysops prefer this)
;
; Note:  If you prefer to call this program 'ADIR' (Archive Directory),
; move the ';;;' up one line above.  (We won't object too much, since
; we plan to release a program of that name in the near future.)
;
;=======================================================================
;
LAST	EQU	$-1		; 151H	Last patch address
;
; Confirm that the symbol LAST has the value 151H, which is the highest
; program location which may be modified in UNARC.COM or UNARCA.COM!
;
	END
