; TIMEUP for QBBS systems - Lawrence Davis - 05/19/86
; Version 1.0
;
; -------------------------------------------------------------------
; TIMEUP allows special access users (those tagged with 'S' flag) to
; gain additional time on the system.  Set the value at TIMEUP to the
; number of minutes that will added each time TIMEUP is run.  Be sure
; to set TUPASC the same.  Set the INCNUM equate to the number of
; increments that TIMEUP will allow.
; -------------------------------------------------------------------
;
; ** OPTION AREA **
;
TIMEUP	EQU	15	; Number of minutes to add
TUPASC	EQU	'15'	; Enter same number as TIMEUP between quotes
INCNUM	EQU	2	; Number of times to increment
;
; ** END OF OPTION AREA **
;
SBYTE	EQU	10H	; QBBS special status byte address
CBYTE	EQU	11H	; Counter address
BDOS	EQU	5
CR	EQU	13
LF	EQU	10
;
ORG	100H
;
CSTAT:	LDA	SBYTE		; Get special status byte
	CPI	255		; Is it set?
	JZ	CTNUM		; Yes, check counter
	LXI	D,EXMSG		; No, print exit msg
	CALL	PRINT
	JMP 	EXIT		; exit program
;
CTNUM:	LDA	CBYTE		; Get counter byte
	CPI	INCNUM		; Has it 'maxed out'?
	JNZ	UCOUNT		; No, go increment it
      	LXI	D,MAXMSG	; Yes, print 'maxed out' msg
	CALL 	PRINT
	JMP	EXIT
;
UCOUNT:	ADI	1		; Add one to counter
	STA	CBYTE		; Poke back to memory
       	MVI	C,81		; Extended BYE/BDOS call to get maxtime
	MVI	E,255
	CALL	BDOS		; Get maxtime allowed
	ADI	TIMEUP		; Add TIMEUP value
        MVI	C,81	
	MOV	E,A
	CALL 	BDOS		; Poke new maxtime
	LXI	D,TUPMSG	; Tell user
	CALL	PRINT
	JMP 	EXIT
;
PRINT:	MVI	C,9
	CALL	BDOS
	RET
MAXMSG:	
	DB	CR,LF
	DB	'Maximum time increment reached.'
	DB	CR,LF,'$'
TUPMSG:
	DB	CR,LF
	DB	'Time on system increased by '
	DW	TUPASC
	DB	' minutes.'
	DB	CR,LF,'$'
EXMSG:
	DB	CR,LF
	DB	'Special Access Required.'
	DB	CR,LF,'$'
EXIT:
	RET
