{ 8/8/86 Pascal Integrated Communications System }
{Installation and editor for File Sections, Message Areas and Articles.}

Program Install_sections;

const
   fname='SECTION.BB#';
   version='1.0';
   ver_date='8/8/86';

type
   str10=string[10];
   strpr=string[50];
   str12=string[12];

   Section_rec=
     record
       drive:char;
       user:integer;
       accs:integer;
       confnum:integer;
       name:str12;
       desc:strpr;
       mode:char;
     end;

var
   sect_file,temp_file: file of Section_rec;
   sec_rec,temp_rec:Section_rec;
   rec,i,n,x,num,err,ednum,msg_area,hi_num,lo_num:integer;
   OK,edit,add,delete,found:boolean;
   cur_mode,ch,dr:char;
   reply:str10;
   work:strpr;
   new_name:str12;
   line:string[80];

procedure Display;
  begin
    found:=false;
    with sec_rec do
      begin
        rec:=0; hi_num:=0; lo_num:=1000;
        seek(sect_file,rec);
        if (cur_mode<>'Q') then
          begin
            writeln;  writeln;
            write('                             ');
            case cur_mode of
              'M' : writeln('MESSAGE AREAS');
              'F' : writeln('FILE AREAS');
              'A' : writeln('ARTICLES');
            end;
            writeln(line);
            write(' #     ');
            if (cur_mode<>'M') then write('D/U   ');
            write('accs    ');
            if (cur_mode='A') then writeln('  Filename      Title')
            else writeln('   Name   Cn      Description');
            writeln(line);
          end;
        while (not eof(sect_file)) and (cur_mode<>'Q') do
          begin
            read(sect_file,sec_rec);
            if mode=cur_mode then
              begin
                found:=true;
                write(rec:3,'    ');
                if cur_mode<>'M' then
                  begin
                    write(drive,':');
                    write(user:2,'  ');
                  end;
                write(accs:3,'  ',name:12);
                if confnum>0 then write(confnum:2)
                else write(' ');
                writeln('   ',desc);
                if lo_num>rec then lo_num:=rec;
                if hi_num<rec then hi_num:=rec;
              end;
            if (mode='M') and (user>msg_area) then
              msg_area:=user;
            rec:=succ(rec);
          end;
        if (not found) and (cur_mode<>'Q') then writeln('No Entries Found');
      end;
  end;

Procedure get_reply;
  begin
    if OK then
      begin
        reply:='';
        write(' > ');
        readln(reply);
        val(reply,num,err);
        if (length(reply)>=1) and (err<>0) then ch:=upcase(reply[1])
        else ch:=' ';
        if (ch=' ') and (err<>0) and (cur_mode<>'X') then OK:=false;
        if (cur_mode<>'X') then writeln;
      end;
  end;

begin  {install}
  clrscr;
  writeln;
  writeln('Pascal Integrated Communications System');
  writeln('    Version ',version,'  ',ver_date);
  writeln;
  line:='------------------------------------------------------------------------------';
  Assign(sect_file,fname);
  {$I-}  Reset(sect_file); {$I+}
  OK:=(IOresult=0);
  If OK then
    begin  {file exists}
      repeat
        OK:=true;  msg_area:=0;
        add:=false; edit:=false; delete:=false;
        writeln;
        writeln('  EDITING PICS SYSTEM SETUP FILE ');
        writeln; writeln;
        writeln('     <M>.....Message Areas.');
        writeln('     <F>.....File Sections.');
        writeln('     <A>.....Articles.');
        writeln('     <CR>....Finished.');
        writeln;
        write('           Enter letter');
        get_reply;
        if ( ch in ['A','F','M']) and (reply<>'') then cur_mode:=ch
        else cur_mode:='Q';
      display;
      If (cur_mode<>'Q') and OK then
        begin
          if found then
            begin
              writeln;
              write('     <A>dd,  <D>elete,  <E>dit,  <CR> to exit');
              get_reply;
            end
          else ch:='A';
          if (ch in ['A','D','E']) and (reply<>'') then
            begin
              add:=false; edit:=false; delete:=false;
              case ch of
                'A' : add:=true;
                'D' : delete:=true;
                'E' : edit:=true;
              end;
            end
          else OK:=false;
        end;
      if OK and (cur_mode<>'Q') then
        begin
         repeat
          writeln;
          if add and OK then
            begin
              sec_rec.mode:=cur_mode;
              writeln; writeln;
              write('ADDING ');
              case cur_mode of
                'M' : write('MESSAGE');
                'F' : write('FILE');
                'A' : write('ARTICLE');
              end;
              writeln(' ENTRY.  <Return> to exit.');
              writeln;
            end
          else
          If delete and OK then
            begin
              if found then
                begin
                  repeat
                    writeln;
                    write('Number to Delete  <CR> to exit');
                    get_reply;
                  until (not OK) or (reply='') or ((num>=lo_num) and (num<=hi_num));
                  if reply='' then ok:=false;
                end
              else OK:=false;
              if OK then
                begin
                  writeln;
                  writeln('Please wait...Deleting entry.');
                  writeln;
                  assign(temp_file,'SECTION.$$$');
                  rewrite(temp_file);
                  for x:=0 to num-1 do
                    begin
                      seek(sect_file,x);
                      read(sect_file,sec_rec);
                      write(temp_file,sec_rec);
                    end;
                  for x:=num+1 to filesize(sect_file)-1 do
                    begin
                      seek(sect_file,x);
                      read(sect_file,sec_rec);
                      write(temp_file,sec_rec);
                    end;
                  close(temp_file); close(sect_file);
                  erase(sect_file);
                  rename(temp_file,fname);
                  reset(sect_file);
                  display;
                end;
            end
          else
          if (edit) and OK then
            begin
              repeat
                writeln;
                write('Number to Edit,  <CR> to exit');
                get_reply;
              until (reply='') or ((num>=lo_num) and (num<=hi_num)) or (not OK);
              if ok and (reply<>'') then
                begin
                  ednum:=num;
                  writeln;writeln;
                  write('EDITING ');
                  case cur_mode of
                    'M' : write('MESSAGE');
                    'F' : write('FILE');
                    'A' : write('ARTICLE');
                  end;
                  writeln(' ENTRY,   <CR> if OK'); writeln;
                  seek(sect_file,ednum);
                  read(sect_file,sec_rec);
                end
              else OK:=false;
            end
          else OK:=false;           {fall through}
          if (not delete) and OK then
            begin
              if OK  then
                begin
                  if cur_mode<>'A' then write('Name')
                  else write('Filename');
                  if edit then write(' [',sec_rec.name,'] > ')
                  else write(' > ');
                  write('|------------|');
                  for i:=1 to 13 do write(chr(8));
                  readln(new_name);
                  if new_name<>'' then
                    begin
                      for n:=1 to length(new_name) do
                        new_name[n]:=upcase(new_name[n]);
                      sec_rec.name:=new_name;
                    end
                  else if add then OK:=false;
                  writeln;
                end;
              if OK then
                begin
                  if edit then
                    begin
                      if cur_mode<>'A' then write('Description   ')
                      else write('Article Title ');
                      writeln(' [',sec_rec.desc,']')
                    end;
                  write('Description > |--------------------------------------------------|');
                  for i:=1 to 51 do write(chr(8));
                  readln(work);
                  if work<>'' then sec_rec.desc:=work
                  else if add then OK:=false;
                end;
              if OK and (cur_mode<>'M') then
                begin
                  writeln;
                  write('Drive letter (A-P)');
                  if edit then write('  [',sec_rec.drive,']');
                  get_reply;
                  if OK and (ch in ['A'..'P']) and (reply<>'') then
                     sec_rec.drive:=ch
                  else if add then OK:=false;
                end
                else sec_rec.drive:=' ';
              if OK and (cur_mode<>'M') then
                begin
                  write('User Area (0-15)');
                  if edit then write('  [',sec_rec.user,']');
                  get_reply;
                  if OK and (reply<>'') then sec_rec.user:=num
                  else if add then OK:=false;
                end
                else if add then sec_rec.user:=msg_area+1;
              if OK then
                 begin
                  write('Access level required (0-255)');
                  if edit then write('  [',sec_rec.accs,']');
                  get_reply;
                  if OK and (reply<>'') then sec_rec.accs:=num
                  else if add then OK:=false;
                end;
              if Ok then
                begin
                  if cur_mode<>'A' then
                    begin
                      write('Will it be a conference (Y/N)');
                      if edit then
                        begin
                          if sec_rec.confnum>0 then write('  [Y]')
                          else write('  [N]');
                        end;
                      get_reply;
                      if edit and (reply='') then
                         if sec_rec.confnum>0 then ch:='Y'
                         else ch:='N';
                      if OK and (ch='Y') then
                        begin
                          write('Enter conference number (1-7)');
                          if edit and (sec_rec.confnum>0) then
                            write(' [',sec_rec.confnum,']');
                          get_reply;
                          if ok and (reply<>'') then sec_rec.confnum:=num
                          else if add then OK:=false;
                        end
                        else sec_rec.confnum:=0;
                    end;
                end;
              if OK then
                begin
                  if add then seek(sect_file,filesize(sect_file))
                  else seek(sect_file,ednum);
                  write(sect_file,sec_rec);
                  if edit or add then display;
                end;
            end;      {not delete}
         until (not OK);
        end;          {OK to edit or add}
      until cur_mode='Q';
      close(sect_file);
    end
  else     {file doesn't exist}
    begin
      OK:=true;
      cur_mode:='X';
      Writeln(' PICS  Sections file not found -- Creating new file.');
      writeln;
      Rewrite(sect_file);
      writeln('The following Message Areas and File Sections are required.');
      writeln('All newly created entries may be edited later by re-running');
      writeln('the program on the new file.');
      writeln;
      writeln('Two Message Area entries will be generated without asking questions.');
      writeln('Then there will be three File Section entries where you will be ');
      writeln('asked for Drive and User information for your system.');
      writeln;
      write('Press Return to continue...');
      readln(reply);
      writeln;
      writeln('Creating Message Area: SYSTEM');
      Writeln('         Description : System global message area.');
      Writeln('         Access Level: 250');
      writeln;
      with sec_rec do
        begin
          drive:=' ';
          user:=0;
          accs:=250;
          confnum:=0;
          name:='SYSTEM';
          Desc:='System Message Area';
          mode:='M';
        end;
      write(sect_file,sec_rec);
      writeln;
      Writeln('Creating Message Area: POST');
      writeln('         Description : Initial area for entering messages.');
      writeln('         Access Level: 0');
      writeln;
      with sec_rec do
        begin
          drive:=' ';
          user:=1;
          accs:=0;
          confnum:=0;
          name:='POST';
          Desc:='Initial Area for entering messages';
          mode:='M';
        end;
      write(sect_file,sec_rec);
      writeln;
      writeln('Creating File Section: SYSTEM');
      writeln('         Description : System Command and data files.');
      writeln('         Access Level: 250');
      writeln;
      with sec_rec do
        begin
          repeat
            write('          Drive where System files will reside [A-J]');
            get_reply;
          until (ch in ['A'..'J']);
          drive:=ch;
          repeat
            write('          User area where System files will reside [0-15]');
            get_reply;
          until (num in [0..15]);
          user:=num;
          accs:=250;
          confnum:=0;      {no conference}
          name:='SYSTEM';
          Desc:='System Command and Data Files';
          mode:='F';
        end;
      write(sect_file,sec_rec);
      writeln;
      writeln('Creating File Section: LOGIN');
      writeln('         Description : Initial Section for file access.');
      writeln('         Access Level: 0');
      writeln;
      with sec_rec do
        begin
          repeat
            write('          Drive where you want this Section [A-J]');
            get_reply;
          until (ch in ['A'..'J']);
          drive:=ch;
          repeat
            write('          User Area where you want this Section [0-15]');
            get_reply;
          until (num in [0..15]);
          user:=num;
          accs:=0;
          confnum:=0;
          name:='LOGIN';
          Desc:='Initial Section for file access';
          mode:='F';
        end;
        write(sect_file,sec_rec);
        writeln;
        writeln('Creating File Section: NEWIN');
        writeln('         Description : Section for new uploaded files.');
        writeln('         Access Level: 20');
        writeln;
        with sec_rec do
          begin
            repeat
              write('          Drive where you want this Section [A-J]');
              get_reply;
            until (ch in ['A'..'J']);
            drive:=ch;
            repeat
              write('          User Area where you want this Section [0-15]');
              get_reply;
            until (num in [0..15]);
            user:=num;
            accs:=20;
            confnum:=0;
            name:='NEWIN';
            Desc:='New Uploaded Files Section';
            mode:='F';
          end;
        write(sect_file,sec_rec);
        writeln;
        close(sect_file);
        writeln('New file ',fname,' Created');
    end;
end.

