{PICSVAR.INC  Pascal Integrated Communications System }
{ 5/25/87  vers 1.6  Copyright 1987 by Les Archambault }

var

  debug:boolean;

{ System message global }

  SysmBase       : SysmPtr;                 { Start of linked list }
  Cmd_Queue      : StrStd;                  { for multiple commands}
  Mult_cmds      : boolean;                 { true when mult cmds exist}

{ Section globals }

  SectBase       : SectPtr;                 { Start of linked list }
  SectReq        : filename;                { Section name }

{ Articles globals }

  Artbase        : ArtPtr;                  { start of linked list}

{ Message area globals }

  AreaBase       : AreaPtr;                 { Start of linked list }
  AreaReq        : filename;                { Message area name }
  AreaSet        : integer;                 { Current message area }

{ Directory globals }

  DirBase        : FilePtr;                 { Start of linked list }
  DirEntries,                               { Count of directory entries }
  DirSpace       : integer;                 { Disk space used }

{ Library globals }

  LibBase        : FilePtr;                 { Start of linked list }
  LibEntries,                               { Count of library entries }
  LibSpace       : integer;                 { Space used }
  LibReq         : FileName;                { Library name }

{ Arc globals}
  ArcBase        : FilePtr;
  ArcEntries,
  ArcSpace       : integer;
  ArcReq         : FileName;
  Hdr            : Heads;
  ArcPtr         : integer;
  ArcBuf         : Record_Array;
  HdrVer         : Byte;
  Endfile        : boolean;

{ Message system globals }

  MesgBase, MesgLast, MesgCurr: MesgPtr;    { Pointers }
  temp_hi_lmr,                              { Storage for lmr}
  msg_all,                                  { Public message count }
  msg_ind,                                  { Private message count }
  msg_aut,                                  { Authored message count }
  msg_sys,                                  { Sysop viewable message count }
  msg_hi,msg_lo         : integer;          { High-low message numbers }
  nonstop               : boolean;          { continuous reading flag}

{ System globals }

  abort,                                    { used to set brk from pause}
  audit_on,                                 { Audit file enabled }
  case_lock,                                { Convert output to upper case }
  clock,                                    { tells whether clock present}
  cold,                                     { Cold start }
  connected,                                { Connection established }
  delay_down,                               { Shutdown between users }
  fini,                                     { Finished with PICS }
  in_library,                               { Library/section switch }
  in_arc,                                   { Arc/switch}
  in_use,                                   { Successful login }
  local_copy,                               { Console display }
  local_online,                             { Local use allowed }
  new_dir,                                  { New section or library selected }
  noisy,                                    { Prompt bell enable }
  chat_ok,                                  { allow chat function}
  op_chat,                                  { Operator requested chat }
  printer_copy,                             { Printer display }
  remote_copy,                              { Remote display }
  remote_online,                            { Remote use allowed }
  st_switch,                                { Size/time switch }
  up_down_display,                          { Up/download display }
  restrict300,                              { on/off flag}
  auto_macro,                               { on/off flag}
  macro_in_progress,                        { set while macro running}
  macro_file_exists,                        { alt. macro in text file}
  limit_lines,                              { on/off flag}
  restrict_public,                          { public msgs have to by approved}
  extra_time_sw,                            { extra time on sys on/off}
  valid_pw       : boolean;                 { Correct password flag }

  ch             : char;                    { Input character }
  HomDrv, HomUsr,                           { Default drive/user }
  RcvDrv, RcvUsr,                           { Upload drive/user }
  SetDrv, SetUsr,                           { User selected drive/user }
  AudDrv, Audusr,                           { Audit file drive/user}
  user_loc,                                 { Location in data file of user record }
  time_on, time_left, extra_time,           { Timers }
  timeout,sleepy_time,
  mode,                                     { Current mode of operation }
  free_space,                               { Space remaining on current drive }
  start_restrict300,                        { hour to start restrictions}
  end_restrict300,                          { hour to end restrictions}
  auto_macro_start,                         { hour to start auto macro process}
  macro_done,                               { last day macro operated}
  max_msg_lines,                            { max. number of lines allowed}
  up_down_ratio,                            { numerator of ratio ie. 20:1}
  val_acc,                                  { validated user access level}
  uval_acc,                                 { unvalidated}
  uval_time,                                { same for unvalidated users}
  val_time,                                 { time on sys limit - validated}
  chatstart,                                { hour sysop available}
  chatend,                                  { end of chat available}
  unv_days,                                 { retention of user listing}
  val_days,                                 { retention of val users}
  unr_days,                                 { message retention}
  rea_days,                                 { same for after read}
  max_tries,                                { counter}
  maxfree_uplds,maxfree_logs,               { variables to shut off or limit}
  maxfree_mslimit,maxfree_lines,            {   functions when too little disk}
  maxfree_abs,                              {   space is left}
  extra_time_val,extra_time_start,          { for extra time on system}
  extra_time_stop,
  rate           : integer;                 { Current bps rate }
  lps,                                      { loops per second for timers}
  hour_count,                               { counts hours for no clock people}
  time_adjust,                              { no clock routines}
  input_time     : real;                    { for input timout routine}
  st             : StrPr;
  macro,                                    { Automatic 'keyboard' input }
  next_inpstr    : StrStd;                  { Input string - used for word wrap }

  global_date,                              { For systems without real time clock }
  login_t        : tad_array;               { Login time }

{ Files }

  user_rec       :         user_list;
  sysm_rec       :         sysm_list;
  sysm_file      : file of sysm_list;
  summ_rec       :         summ_list;
  summ_file      : file of summ_list;
  mesg_rec       :         mesg_list;
  mesg_file      : file of mesg_list;
  logr_rec       :         logr_list;
  logr_file      : file of logr_list;
  stat_rec       :         stat_list;
  stat_file      : file of stat_list;
  nwin_rec       :         nwin_list;
  nwin_file      : file of nwin_list;
  libr_file      : file;
  Arc_File       : file;
  AuditFile      : text;
  Config_file    : text;
  Macro_File     : text;

{end of PICSvar.inc }
