{ PICSTYPE.INC  Pascal Integrated Communications System}
{ 5/25/87 Ver 1.6 Copyright 1987 by Les Archambault}

type
  record_status  = (deleted, read, private, public,restricted);

  Str3           = string[3];
  Str10          = string[10];
  FileName       = string[12];
  Str14          = string[14];
  StrTAD         = string[27];
  StrPr          = string[50];
  StrStd         = string[80];
  StrName        = string[len_name];
  firstname      = string[len_fn];
  lastname       = string[len_ln];
  address        = string[len_ad];
  city           = string[len_cy];
  state          = string[len_st];
  phone          = string[len_ph];
  password       = string[len_pw];
  subject        = string[len_subj];
  message        = string[len_msg];

  tad_array      = array[0..5] of byte;
  name_array     = array[1..11] of byte;
  hour_array     = array[0..23] of integer;
  day_array      = array[0..6] of integer;
  Fname_array    = array[1..20] of filename;
  Record_Array   = array[1..128] of byte;

  buf_ptr        = ^mem_buf;
  mem_buf        = array[1..1024] of byte;

  SysmPtr        = ^SysmRecord;
  SysmRecord     =
    record
      key        : char;                    { Key value }
      loc        : integer;                 { Location of record in file }
      next       : SysmPtr                  { Pointer to next element on list }
    end;

  MesgPtr        = ^MesgRecord;
  MesgRecord     =
    record
      MesgNo,                               { Message number }
      SummLoc    : integer;                 { Summary index }
      TypMsg     : byte;                    { Message type }
      next       : MesgPtr                  { Pointer to next element on list }
    end;

  FilePtr        = ^FileRecord;
  FileRecord     =
    record
      fname      : FileName;                { Name of a matching file }
      index,                                { Libraries only: location of file }
      fsize      : integer;                 { Size of file }
      attrib     : byte;
      next       : FilePtr                  { Pointer to next element on list }
    end;

  SectPtr        = ^SectRecord;
  SectRecord     =
    record
      SectDrive,                            { Drive }
      SectUser,                             { User area }
      SectConf,                             { Conference number 1-7}
      SectAccs   : integer;                 { Access level required }
      SectName   : filename;                { Section name }
      sectrec    : integer;                 { section record number}
      next       : SectPtr                  { Pointer to next element on list }
    end;

  AreaPtr        = ^AreaRecord;
  AreaRecord     =
    record
      Area,                                 { Area number }
      AreaConf,                             { Conference number 1-7}
      AreaAccs   : integer;                 { Access level required }
      AreaName   : filename;                { Message area name }
      AreaRec    : integer;                 { record number for description}
      next       : AreaPtr                  { Pointer to next element on list }
    end;

  ArtPtr         =^ArtRecord;
  ArtRecord      =
    record
      Artdrive,
      ArtUser,
      ArtAccs,
      Artnum     : integer;
      ArtName    : filename;
      ArtRec     : integer;
      Next       : ArtPtr;
    end;

 {Arc File types}

  long    = record           { used to simulate long (4 byte) integers }
                 l, h : integer
               end;
  fntype  = array [0..12] of char;
  heads   = record
                 name   : fntype;
                 size   : long;
                 date   : integer;
                 time   : integer;
                 crc    : integer;
                 length : long
            end;

  FileBlock      =
    record
      drive      : byte;                    { Byte code }
      fname      : name_array;              { File name }
      extent,                               { Current extent }
      s1, s2, reccount: byte;               { Used to compute file size }
      map        : array[16..31] of byte    { Data map }
    end;

  EntryBlock =
    record
      status     : byte;
      fname      : name_array;
      index,
      fsize,
      CRC,
      CreationDate,
      LastChangeDate,
      CreationTime,
      LastChangeTime: integer;
      PadCount   : byte;
      filler     : array[27..31] of byte
    end;

  user_list      =
    record
      used       : integer;                 {  2 }
{ Personal information }
      fn         : firstname;               { 11 }
      ln         : lastname;                { 16 }
      ad         : address;                 { 21 }
      cy         : city;                    { 21 }
      st         : state;                   {  3 }
      ph         : phone;                   { 13 }
      flags      : byte;                    {  1 }
      pw         : password;                { 11 }
{ User access }
      access     : byte;                    {  1 }
      limit      : byte;                    {  1 }
{ User configuration }
      nulls      : byte;                    {  1 }
      shift_lock : boolean;                 {  1 }
      noisy      : boolean;                 {  1 }
      conf_flags : byte;                    {  1 }
      columns    : byte;                    {  1 }
      lines      : byte;                    {  1 }
{ User stats }
      laston     : tad_array;               {  6 }
      time_today : integer;                 {  2 }
      time_total : integer;                 {  2 }
      lasthi     : integer;                 {  2 }
      upload     : integer;                 {  2 }
      download   : integer                  {  2 }
    end;                             { Total 123 }

  logr_list      =
    record
      date       : tad_array;               {  6 }
      action     : byte;                    {  1 }
      user       : integer;                 {  2 }
      text       : FileName                 { 13 }
    end;                             { Total  22 }

  summ_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      area       : byte;                    {  1 }
      num,                                  {  2 }
      num_prev,                             {  2 }
      num_next,                             {  2 }
      user_from,                            {  2 }
      user_to    : integer;                 {  2 }
      subject    : subject;                 { 56 }
      st_rec,                               {  2 }
      size       : integer                  {  2 }
    end;                             { Total  80 }

  stat_list      =
    record
      date       : tad_array;               {  6 }
      busy_per_hour : hour_array;           { 48 }
      busy_per_day  : day_array;            { 14 }
    end;                             { Total  68 }

  nwin_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      name       : FileName;                { 13 }
      user       : integer;                 {  2 }
      sectn      : filename;                { 13 }
      descr      : Strstd;                  { 81 }
      dnloads    : integer;                 {  2 }
      last_dnload: tad_array;               {  6 }
    end;                            { Total  123 }

  sysm_list      = StrStd;           { Total  81 }
  mesg_list      = message;          { Total  73 }

  untype_file    = file;

{End of PICSTYPE.INC }
