{ PICSDEF.INC - Pascal Integrated Communications System defaults}
{ 5/25/87  Ver. 1.4 -1.6 Copyright 1987 by Les Archambault}

const
  num_drives    = 3;       {set to number of ( drives -1 ) i.e. 3=4 drives }
  Mhz           = 4.0;     { machine speed [.0 is important]}
  def_maxfree_uplds   =50; { #K disk space left when uplds will be disabled}
  def_maxfree_logs    =25; { #K  "     "     "   " logins will be disabled}
  def_maxfree_mslimit =20; { #K left when msgs will be limited to maxfree_lines}
  def_maxfree_lines   =10; { # lines allowed when msgs are limited by disk space}
  def_maxfree_abs     =5;  { when this amount of space remains, all mesg entering restricted}
  def_uval_acc   = 10;     { Default access level }
  def_uval_time  = 20;     { Default time limit }
  def_chars      = 80;     { Default characters per line }
  def_lines      = 23;     { Default lines per page }
  def_val_acc    = 20;     { Access level for validated users }
  def_val_time   = 45;     { Time limit for validated users }
  def_chat_ok    = true;   { allow chat function}
  Def_ChatStart  = 19;     { Chat hours }
  Def_ChatEnd    = 22;
  fence          = '|';    { Character between directory columns }
  def_unv_days   = 14;     { Days to retain unvalidated user }
  def_val_days   = 180;    { Days to retain validated user }
  def_unr_days   = 90;     { Days to retain unread, undeleted messages }
  def_rea_days   = 14;     { Days to retain read, undeleted messages }
  def_Max_Tries  =  3;     { Max number of tries for password }
  Deflt_macro    = 'S;N;G';   { DEFAULT MACRO STRING ^M=CR }
  def_auto_macro_start = 4;   { auto macro start time}
  def_restrict300 = false;    {restrict 300 baud callers}
  def_start_restrict300 = 19;
  def_end_restrict300 = 23;
  def_auto_macro = false;      {no auto macro processing}
  def_max_msg_lines = 100;
  def_restrict_public = false;
  def_limit_lines = false;
  def_up_down_ratio = 20;      { downloads per upload, 0=no restriction}
  def_sleepy_time = 300;       {input timeout in seconds}
  def_extra_time_val = 20;     {extra minutes on sys allowed at certain ties}
  def_extra_time_start=1;      {hour tostart extra time on system}
  def_extra_time_stop=7;       {hour extra time stops}
  def_extra_time=true;         {extra time enabled}
  def_time_adjust=1.15;        {for no clock routines}

{ File names }

  user_data      = 'USERDAT';               { User data }
  user_indx      = 'USERIDX';               { Index to user data }
  logr_name      = 'LOG';                   { Log file }
  mesg_name      = 'MESSAGE';               { Messages }
  summ_name      = 'SUMMARY';               { Summaries }
  sysm_name      = 'SYSMSG';                { System messages }
  sect_name      = 'SECTION';               { Section names }
  stat_name      = 'STATS';                 { Statistics }
  nwin_name      = 'NEWIN';                 { New uploads list }

  ext            = '.BB#';                  { File type }

{ ASCII constants }

  NUL            = #$00;
  SOH            = #$01;
  STX            = #$02;
  ETX            = #$03;
  EOT            = #$04;
  ACK            = #$06;
  BEL            = #$07;
  BS             = #$08;
  TAB            = #$09;
  LF             = #$0A;
  FF             = #$0C;
  CR             = #$0D;
  DC1            = #$11;                    { XON }
  DC3            = #$13;                    { XOFF }
  NAK            = #$15;
  CAN            = #$18;
  ESC            = #$1B;
  RUB            = #$7F;

{ Turbo Toolbox constants }

  MaxDataRecSize = 123;                     { max record size }
  MaxKeyLen      = 26;                      { max key size }
  PageSize       = 16;                      { page size }
  Order          = 8;                       { half page size }
  PageStackSize  = 5;                       { page buffer size }
  MaxHeight      = 5;                       { max B-tree height }

{ CP/M-80 constants }

  seldrive       = 14;                      { BDOS drive select }
  findfirst      = 17;                      { BDOS search for first file }
  findnext       = 18;                      { BDOS search for next file }
  getdrive       = 25;                      { BDOS get default drive }
  setdma         = 26;                      { BDOS set DMA buffer address }
  getallocvec    = 27;                      { BDOS get allocation vector }
  getdiskparm    = 31;                      { BDOS get disk parameters }
  getseluser     = 32;                      { BDOS get/select user area }

  fcb            = $80;                     { Default DMA buffer address }

{ PICS constants }

  len_fn         = 10;                      { length of firstname }
  len_ln         = 15;                      { length of lastname }
  len_name       = 25;                      {   sum of above }
  len_ad         = 20;                      { length of address }
  len_cy         = 20;                      { length of city }
  len_st         =  2;                      { length of state abbreviation }
  len_ph         = 12;                      { length of phone number }
  len_pw         = 10;                      { length of password }
  len_subj       = 56;                      { length of subject }
  len_msg        = 72;                      { length of message }

  message_mode   = 1;
  files_mode     = 2;
  utility_mode   = 3;
  sysop_mode     = 4;
  pr_msg    : array[1..4] of string[7] =
    ('Message',
     'Files',
     'Utility',
     'Sysop');


{end of PICSDEF.INC }
