{ PICS3A.INC  Pascal Integrated Communications System commands processor }
{ 6/8/87 vers 1.6 Copyright 1987 by Les Archambault.}

Overlay Procedure Set_Initial_areas;
   var drive,user:integer;
  begin
    if (not macro_in_progress) and online then
      begin
        pause;
        list('B');
        pause;
        repeat until (not BRK) or (not online);
      end;
    if user_rec.access >= 250 then
      begin
        FindSect('NEWIN',Drive,User,OK);
        SectReq:='NEWIN';
        SetDrv:=Drive;
        SetUsr:=User;
        mesg_area_change('SYSTEM');
      end
    else
      begin
        FindSect('LOGIN',Drive,User,OK);
        SectReq:='LOGIN';
        SetDrv:=Drive;
        SetUsr:=User;
        mesg_area_change('POST');
      end;
  end;

Overlay Procedure Check_time;
{checks time on system and time left}

begin
  timer(time_on, time_left);
  if time_left <= 0 then
    begin
      writeln(USR, 'Access time expired.  Please call back tomorrow.', BEL, BEL, BEL);
      remote_online := FALSE
    end
  else if time_left <= 5 then
  writeln(USR, 'Less than 5 minutes of access time left.  Please finish up.', BEL);
end;

Overlay Procedure Make_Prompt;

begin
  st := intstr(time_left, 1) + '-' + pr_msg[mode];
  case mode of
    message_mode: st := st + ' ' + AreaReq;
    files_mode  : begin
                    st := st + ' ' + SectReq;
                    if in_library then st := st + ' [' + LibReq + ']';
                    if in_arc then st:=st+' ['+ArcReq+']';
                    if new_dir then directory;
                    if up_down_display then
                       begin
                         Repeat until (not BRK) or (not online);
                         ReadDir(direntries,dirspace,dirbase);
                         directory;
                         writeln(usr);
                         writeln(USR, user_rec.upload, ' uploads, ',
                         user_rec.download, ' downloads to date.');
                         up_down_display := FALSE;
                       end;
                  end;
  end;
  if (user_rec.access>=250) and Audit_on then st:=st+' (Audit ON) ';
end;

Overlay Procedure Write_status_line;
  begin
    putstat(user_rec.fn + ' ' + user_rec.ln + '  ' + user_rec.cy + ', ' +
     user_rec.st + '  Access: ' + intstr(user_rec.access, 1) + '  On: ' +
     intstr((time_on+user_rec.time_today), 1) + '  Heap: '
     + intstr(MaxAvail, 1));
  end;

overlay procedure Process_messages;
  begin
    case ch of
         'A': Articles;
         'C': mesg_area_change('');
         'E': begin
                mesg_enter(' ');
                mesg_build_index(AreaSet);
              end;
         'F': begin
                clear_heaps;
                if in_library then LibReadDir(LibEntries,LibSpace,LibBase)
                else
                if in_arc then ArcReadDir(ArcEntries,ArcSpace,ArcBase)
                else
                ReadDir(direntries,dirspace,dirbase);
                new_dir:=false;
                mode := files_mode;
              end;
         'G': in_use := FALSE;
         'Q': mesg_quick_scan;
         'R': mesg_read;
         'S': mesg_summary;
         'U': begin
                clear_heaps;
                mode := utility_mode;
              end;
         'X': if (user_rec.access >= 250) or (not remote_copy) then
              begin
                clear_heaps;
                mode := sysop_mode;
              end;
         'B', 'I': list(ch);
         'O': List_file('OTHERSYS.LST',homdrv,homusr)
    else
      begin
        list('M');
        if (not macro_in_progress) then
          begin
            mult_cmds:=false;
            cmd_queue:='';
          end;
      end;
    end;
  end;

Overlay procedure Process_files;
  begin
    if (st[1]='S') and (user_rec.access<val_acc) then list('S')
    else
    if st='REN' then rename_file
    else
    if st='DEL' then delete_file
    else
    if st='COPY' then copy_file
    else
    if st='STAT' then file_status
    else
    if st='SK' then SendXmodem('K')
    else
    If st='SB' then SendXmodem('B')
    else
    if st='TYPE' then SendText
    else
    If st='RB' then RecvXmodem('B')
    else
    case ch of
        'A': begin
               if in_library then library;
               arc;
             end;
        'C': begin
               if in_library then library;
               if in_arc then arc;
               file_area_change('')
             end;
        'D': directory;
        'F': find_files;
        'G': in_use := FALSE;
        'L': begin
               if in_arc then arc;
               library;
             end;
        'M': begin
               clear_heaps;
               mesg_build_index(areaset);
               mode := message_mode;
             end;
        'N': newin_list;
        'R': RecvXmodem(' ');
        'S': SendXmodem('X');                  { 128 byte protocol}
        'T': SendText;
        'U': begin
               if in_library then library;
               if in_arc then arc;
               clear_heaps;
               mode := utility_mode;
             end;
        'X': if (user_rec.access >= 250) or (not remote_copy) then
               begin
                 if in_library then library;
                 if in_arc then arc;
                 clear_heaps;
                 mode := sysop_mode;
               end;
        'Z': toggle_st_switch
    else
      begin
        list('F');
        if user_rec.access>=250 then list('Z');
        if (not macro_in_progress) then
          begin
            mult_cmds:=false;
            cmd_queue:='';
          end;
      end;
    end;
  end;


Overlay procedure process_utility;
  Begin
    case ch of
         'A': alter_user_params;
         'C': if chat then mesg_enter('S');
         'F': begin
                clear_heaps;
                if in_library then LibReadDir(Libentries,Libspace,Libbase)
                else
                if in_arc then ArcReadDir(ArcEntries,ArcSpace,ArcBase)
                else
                ReadDir(direntries,dirspace,dirbase);
                new_dir:=false;
                mode := files_mode;
              end;
         'G': in_use := FALSE;
         'M': begin
               clear_heaps;
               mesg_build_index(areaset);
               mode := message_mode;
             end;
         'S': display_stats;
         'T': display_time;
         'U': display_users;
         'Y': show_user_stats;
         'X': begin
               if (user_rec.access >= 250) or (not remote_copy)
                then mode := sysop_mode;
              end
    else
      begin
        list('U');
        if (not macro_in_progress) then
          begin
            mult_cmds:=false;
            cmd_queue:='';
          end;
      end;
    end;
  end;

Overlay procedure process_sysop;
  Begin
    case ch of
         'A': toggle_audit;
         'B': Make_message;
         'C': config_sys;
         'D': delete_user;
         'E': edit_user('','');
         'F': begin
                clear_heaps;
                mode:=files_mode;
                if in_library then LibReadDir(Libentries,Libspace,Libbase)
                else
                if in_arc then ArcReadDir(ArcEntries,ArcSpace,ArcBase)
                else
                ReadDir(direntries,dirspace,dirbase);
                new_dir:=false;
              end;
         'G': in_use := FALSE;
         'I': rebuild_index;
         'L': print_log;
         'M': begin
               clear_heaps;
               mesg_build_index(areaset);
               mode := message_mode;
             end;
         'N': process_newin;
         'O': process_macro;
         'P': purge_files;
         'R': print_messages;
         'S': sys_dir;
         'T': toggle_printer;
         'U': mode := utility_mode;
         'V': validate_user
    else
      begin
        list('X');
        if (not macro_in_progress) then
          begin
            mult_cmds:=false;
            cmd_queue:='';
          end;
      end;
    end;
  end;

Overlay Procedure Exit_system;
  begin
    if in_library then library;
    if in_arc then arc;
    if audit_on then toggle_audit;
    if (user_rec.fn <> 'SYSOP') and online
       then if not valid_pw
         then mesg_enter('S')
       else if ask('Do you have a message for the sysop')
              then mesg_enter('S');
    wrapup;
    setup;
  end;

overlay procedure check_300_restrict;
 var t:tad_array;
  begin
    gettad(t);
    if (rate=300) and (restrict300)
    and (t[2]>start_restrict300) and (t[2]<end_restrict300) then
    begin
      writeln(usr);
      writeln(usr,'300 Baud Callers are restricted from ',
      start_restrict300,':00 - ',end_restrict300,':00 hours.');
      writeln(usr,'Please call back outside of these times.');
      remote_online:=false;
      mdhangup;
    end;
  end;

{end of PICS3A.inc }
