{PICS2H.INC  Pascal Integrated Communications System Overlays}
{ 6/11/87  Ver 1.6 Copyright 1987 by Les Archambault}

overlay procedure print_log;
{ Print the log file }
  const
    txt_act: array[0..14] of FileName =
      ('PICS up  ', 'PICS down', 'Login    ', 'Logout   ', 'Recv-Xmdm',
       'Send-Xmdm', 'Type-file', 'Complete ', 'Failed   ', 'New User ',
       'Error    ', 'Purge    ', 'Car. Lost', 'Inp Timeout', 'Canceled');
  var
    t: tad_array;
    str: StrTAD;
    line_count,rec:integer;
    cur_date: real;
    temp_user_rec: user_list;
  begin
    writeln(usr,'Log File reverse listing. <CR> for current date.');
    str := prompt('Date to stop listing [mm/dd/yy]', 8, 'E');
    if str=' ' then str:='';
    GetTAD(t);
    if length(str) >= 2
      then t[4] := strint(copy(str, 1, 2));
    if length(str) >= 5
      then t[3] := strint(copy(str, 4, 2));
    if length(str) >= 8
      then t[5] := strint(copy(str, 7, 2));
    cur_date := greg_to_jul(t[3], t[4], t[5]);
    GetTAD(t);
    str := FormTAD(t);
    writeln(USR, FF, 'Log file as of: ', str);
    writeln(USR);
    line_count:=2;
    if audit_on
      then
        begin
          setsect(AudDrv,AudUsr);
          writeln(AuditFile, FF, 'Log file as of: ', str);
          writeln(AuditFile);
          setsect(homdrv,homusr);
        end;
    rec:=pred(filesize(logr_file));
    if rec>1
      then with logr_rec do
             begin
               seek(logr_file,rec);
               while (not brk) and online and (rec>0) do
                 begin
                   read(logr_file,logr_rec);
                   if (greg_to_jul(date[3], date[4], date[5]) >= cur_date) then
                   begin
                     if (action > 1) and (logr_rec.user>0)
                      and (logr_rec.user<=(FileLen(DatF))) then
                        begin
                          GetRec(DatF, logr_rec.user, temp_user_rec);
                          if temp_user_rec.used<>0 then
                            begin
                              temp_user_rec.fn:='Deleted';
                              temp_user_rec.ln:='User';
                            end;
                        end
                       else
                         begin
                           if action>1 then temp_user_rec.fn := 'Unknown'
                           else temp_user_rec.fn:='No';
                           temp_user_rec.ln := 'User';
                         end;
                     if (action>14) or (action<0) then action:=10; {error}
                     str := FormTAD(date);
                     writeln(USR, pad(str, 28), txt_act[action], ' ',
                       pad(temp_user_rec.fn + ' ' + temp_user_rec.ln, succ(len_name)), text);
                     if (user_rec.lines <> 99) and (not printer_copy)
                     and (not audit_on) then
                       begin
                         line_count := succ(line_count);
                         if line_count >= user_rec.lines then
                           begin
                             pause;
                             line_count:=1;
                           end;
                      end;
                     if audit_on then
                       begin
                         setsect(AudDrv,Audusr);
                         writeln(AuditFile, pad(str, 28), txt_act[action], ' ',
                           pad(temp_user_rec.fn + ' ' + temp_user_rec.ln, succ(len_name)), text);
                         setsect(HomDrv,Homusr);
                       end;
                     rec:=pred(rec);
                     seek(logr_file,rec);
                   end                 {correct date range}
                   else
                     begin
                       rec:=pred(rec);
                       seek(logr_file,rec);
                     end;
                 end;
             end;
    If (not printer_copy) and (not audit_on) then pause;
  end;

overlay procedure print_messages;
{ Print the message file }
  var
    i, j, first_line, last_line: integer;
    cur_date: real;
    fr_fn:firstname; fr_ln:lastname;
    t: tad_array;
    str: StrTAD;
    err:boolean;
  begin
    str := prompt('Date to start listing [mm/dd/yy]', 8, 'E');
    if ch<>ETX then
      begin
        GetTAD(t);
        if length(str) >= 2 then t[4] := strint(copy(str, 1, 2)); {month}
        if length(str) >= 5 then t[3] := strint(copy(str, 4, 2)); {day}
        if length(str) >= 8 then t[5] := strint(copy(str, 7, 2)); {year}
        cur_date := greg_to_jul(t[3], t[4], t[5]);
        GetTAD(t);
        str := FormTAD(t);
        writeln(USR, 'Message file as of: ', str);
        if audit_on then
          begin
            setsect(AudDrv,AudUsr);
            writeln(AuditFile, FF, 'Message file as of: ', str);
            setsect(HomDrv,HomUsr);
          end;
        i:=1;
        {$I-} seek(summ_file,1); {$I+}
        err:=(ioresult<>0);
        while (not err) and (not brk) and online and (not eof(summ_file)) do
          begin
            {$I-} read(summ_file, summ_rec) {$I+};
            err:=(IOresult<>0);
            if (not err) and (greg_to_jul(summ_rec.date[3],
            summ_rec.date[4], summ_rec.date[5]) >= cur_date) then
              begin
                writeln(USR);
                if audit_on then
                  begin
                    setsect(AudDrv,AudUsr);
                    writeln(AuditFile);
                    setsect(HomDrv,HomUsr);
                  end;
                mesg_header_list(i, first_line, last_line,fr_fn,fr_ln);
                {$I-} seek(mesg_file, first_line);  {$I+}
                err:=(ioresult<>0);
                if (not err) then
                  begin
                    for j := 1 to last_line do
                      begin
                        {$I-} read(mesg_file, mesg_rec); {$I+}
                        err:=(ioresult<>0);
                        if (not err) then writeln(USR, mesg_rec);
                        if audit_on and (not err) then
                          begin
                            setsect(AudDrv,AudUsr);
                            writeln(AuditFile, mesg_rec);
                            setsect(HomDrv,HomUsr);
                          end;
                      end;
                  end;
              end;
            i:=succ(i);
          end;
      end;
  end;

{ End of PICS2H.INC }
