{ PICS2B1.INC  Pascal Integrated Communications System }
{ 5/25/87  vers. 1.6  Copyright 1987 by Les Archambault }

overlay procedure directory;
{ Display file area or library directory }
  const
    col_width = 19;
  var
    i, j, k, entries, rows, mm, ss, size, col_count, col_limit, line_count: integer;
    this: FilePtr;
    nodes: array[1..4] of FilePtr;
    st: Str10;
    fn: FileName;
  begin
    col_limit := max(1, user_rec.columns div col_width);
    writeln(USR);
    new_dir := FALSE;
    if in_library
      then
        begin
          this := LibBase;
          entries := LibEntries;
          if entries = 0
            then writeln(USR, '   Library: ', LibReq, ' is empty.')
            else writeln(USR, '   Library: ', LibReq, '   Files: ', entries,
                 '   Space used: ', LibSpace, 'k')
        end
      else
        if in_arc then
          begin
            this:=ArcBase;
            entries:=ArcEntries;
            if entries=0 then
              writeln(USR, '   Arc File: ', ArcReq, ' is empty.')
            else writeln(USR, '   Arc File: ', ArcReq, '   Files: ', entries,
                 '   Space used: ', ArcSpace, 'k')
          end
      else
        begin
          this := DirBase;
          entries := DirEntries;
          if entries = 0
            then writeln(USR, '   File area: ', SectReq, ' is empty.')
            else write(USR, '   File area: ', SectReq, '   Files: ', entries,
                 '   Space used: ', DirSpace, 'k');
          if user_rec.access >= 250
            then writeln(USR, '   Free: ', free_space, 'k')
            else writeln(USR)
        end;
    line_count := 2;
    if entries > 0
      then
        begin
          rows := entries div col_limit;
          if 0 <> entries mod col_limit
            then rows := succ(rows);
          nodes[1] := this;
          for i := 2 to col_limit do
            begin
              for j := 1 to rows do
                this := this^.next;
              nodes[i] := this
            end;
          i := 1;
          while (not brk) and (i <= rows) do
            begin
              for j := 1 to col_limit do
                begin
                  this := nodes[j];
                  if (i + rows * pred(j)) <= entries
                    then
                      begin
                        if st_switch
                          then
                            begin
                              size := this^.fsize shr 3;
                              if (this^.fsize mod 8) <> 0
                                then size := succ(size);
                              st := intstr(size, 4) + 'k '
                            end
                          else
                            begin
                              send_time(this^.fsize, mm, ss);
                              st := intstr(mm, 3) + ':' + intstr(ss, 2);
                              for k := 3 to length(st) do
                                if st[k] = ' '
                                  then st[k] := '0'
                            end;
                        fn := this^.fname;
                        if ($80 and ord(fn[11])) <> 0
                          then
                            begin
                              fn[9] := '*'; { Indicate $SYS file }
                              fn[11] := chr($7F and ord(fn[11]))
                            end;
                        write(USR, fn, st);
                        if j < col_limit
                          then write(USR, fence, ' ')
                          else writeln(USR)
                      end
                    else writeln(USR);
                  nodes[j] := nodes[j]^.next   { Go to next on list }
                end;
              if user_rec.lines <> 99
                then
                  begin
                    line_count := succ(line_count);
                    if line_count mod user_rec.lines = 0
                      then pause
                  end;
              i := succ(i)
            end
        end;
    if j <> col_limit
      then writeln(USR)
  end;

Overlay Procedure Find_Files;
{ searches all sections for a file and expands wildcards}

var  this:sectptr;
     i,off,tdrv,count,tusr:integer;
     filname,found:filename;
     searchblk:fileblock;
     answerblk: array[0..num_drives] of fileblock;
     abort:boolean;

begin
  writeln(usr); abort:=false;  found:='';
  if (not in_library) and (not in_arc) then
    filname:=prompt('Filename (wildcards ok) ',12,'ES')
  else filname:='';
  if filname<>'' then
    begin
      filname:=expand_filename(filname);
      this:=sectbase; count:=0;
      with searchblk do
        begin
          drive:=0;
          for i:=1 to 8 do fname[i]:=ord(filname[i]);
          for i:=10 to 12 do fname[i-1]:=ord(filname[i]);
          extent:=ord('?');
          s1:=ord('?');
          s2:=ord('?');
          reccount:=0;
          for i:=16 to 31 do map[i]:=0;
        end;
      while (this<>nil) and (not abort) do
        begin
          if (this^.sectaccs<=user_rec.access) or (not remote_copy) then
            begin
              tdrv:=this^.sectdrive;
              tusr:=this^.sectuser;
              setsect(tdrv,tusr);
              filname:='';
              BDOS(setdma,addr(answerblk));
              off:=BDOS(findfirst,addr(searchblk));
              while (off<>255) and (not abort) do
                begin
                  if brk then abort:=true;
                  with answerblk[off] do
                    if ($80 and ord(fname[10])=0) or (not remote_copy) then
                      begin
                        found:='            ';
                        move(fname,found[1],11);
                        insert('.',found,9);
                        if found<>filname then
                          begin
                             writeln(usr,
                                pad(found,15),'Location:  ',this^.sectname);
                             filname:=found;
                          end;
                        if user_rec.lines<>99 then
                          begin
                            count:=succ(count);
                            if count mod user_rec.lines=0 then pause;
                          end;
                      end;
                    off:=BDOS(findnext,addr(searchblk));
                end;
            end;
          this:=this^.next; {point to next section}
        end;  {searching sections}
      if found='' then writeln(usr,'File(s) Not Found.');
      Bdos(setdma,fcb); {restore dma address}
      setsect(homdrv,homusr);
      writeln(usr);
    end  {filename<>''}
  else
    if in_library or in_arc then writeln(usr,'File Search not allowed.')
  end;

{end of PICS2B1.INC }
