{ PICS2B.INC - Pascal Integrated Communications System: File Sub-system }
{ 5/25/87 vers 1.6 Copyright 1987 by les archambault}

overlay procedure toggle_st_switch;
{ Toggle file size display }
  begin
    writeln(USR);
    st_switch := not st_switch;
    write(USR, 'File sizes will be shown in ');
    if st_switch
      then writeln(USR, 'bytes, where "k" is 1024.')
      else writeln(USR, 'minutes and seconds of transfer time.')
  end;

overlay procedure newin_list;
{ List new uploads }
  var
    i, line_count,conf_num: integer;
    str: StrTAD;
    temp_user_rec: user_list;
    this:sectptr;
    pages,none_found:boolean;
    Fname,work:filename;

  begin
    fname:='';  none_found:=true;
    if ask('Search for file(s)') then
      begin
        fname:=prompt('Filename (wildcards ok) ',12,'ES');
        if fname<>' ' then fname:=expand_filename(fname)
        else fname:='';
      end;
    pages:=ask('Do you want page breaks');
    line_count := 0;
    i := pred(FileSize(nwin_file));
    while (not brk) and (i >= 0) do
      begin
        seek(nwin_file, i);
        read(nwin_file, nwin_rec);
        this:=sectbase;
        with nwin_rec do
          begin
            if status = public
              then
                begin
                  while (this<>nil) and (this^.sectname<>sectn) do
                    this:=this^.next;
                  conf_num:=this^.sectconf;
                  if ((user_rec.access>=this^.sectaccs) or (test_bit(user_rec.conf_flags,conf_num))) and
                  ((sectn=sectreq) or (sectreq='NEWIN') or (sectreq='SYSTEM')) then
                    begin
                      work:=expand_filename(name);
                      if (fname='') or (equal_names(fname,work)) then
                        begin
                          none_found:=false;
                          str := intstr(date[4],2)+'/'+intstr(date[3],2)+'/'+intstr(date[5],2);
                          if (user>0) and (user<=FileLen(DatF)) then
                            begin
                              GetRec(DatF, user, temp_user_rec);
                              if temp_user_rec.used<>0 then
                                begin
                                  temp_user_rec.fn:='';
                                  temp_user_rec.ln:='';
                                end;
                            end
                          else
                            begin
                              temp_user_rec.fn:='Unknown';
                              temp_user_rec.ln:='Sender';
                            end;

                          writeln(USR);
                          write(USR, pad(name, 15),sectn,' Section ', str,'  ');
                          writeln(usr,temp_user_rec.fn, ' ', temp_user_rec.ln);
                          str := intstr(last_dnload[4],2)+'/'+intstr(last_dnload[3],2)+'/'+intstr(last_dnload[5],2);
                          writeln(usr,'Downloads ',dnloads,'  Last download ',str);
                          writeln(usr,'    ',descr);
                          if (user_rec.lines <> 99) and pages
                            then
                              begin
                                line_count := succ(line_count);
                                if line_count mod (user_rec.lines div 4) = 0
                                then pause;
                              end;
                        end; {fname='' or equal names}
                    end;   {print out}
                end;
          end;
        i := pred(i);
      end;
    if (none_found) and (filesize(nwin_file)>0) then
      begin
        writeln(usr);
        write(usr,'No File(s) found in Newin list');
        if (sectreq<>'NEWIN') and (sectreq<>'SYSTEM') then
          begin
            writeln(usr,' for this file area.');
            writeln(usr,'NEWIN file area lists ALL available files.');
          end
        else writeln(usr,'.');
        writeln(usr);
      end;
    if filesize(nwin_file)=0 then
      begin
        writeln(usr);
        writeln(usr,'Newin List is empty.');
        writeln(usr);
      end;
  end;

overlay procedure file_area_change(req: filename);
{ View and set up file area for use }
  type
     section_rec=
       record
         sdrive:char;
         suser:integer;
         saccs:integer;
         confnum:integer;
         sname:filename;
         sdesc:strpr;
         mode:char;
       end;
  var
    sect_file:file of section_rec;
    Drive, User,conf_num,line_count: integer;
    sect_rec:section_rec;
    this: SectPtr;
    pr: StrPr;

  begin   {file area change}
    assign(sect_file,sect_name+ext);
    reset(sect_file);
    pr:='File area';
    while (not new_dir) and (req <> Sectreq) and (online) do
      begin
        this := SectBase;
        if req = '' then
          begin
            req := prompt(pr, 12, 'ES?M');
            if req=' ' then req:=SectReq;
          end;
        if req = '?' then
            begin
              writeln(USR, 'Available file areas:');
              writeln(USR);
              line_count:=2;
              while (not brk) and (this <> nil) do
                begin
                  conf_num:=this^.SectConf;
                  if (user_rec.access >= this^.SectAccs)
                  or (test_bit(user_rec.conf_flags,conf_num)) then
                    begin
                      seek(sect_file,this^.sectrec);
                      read(sect_file,sect_rec);
                      writeln(USR, pad(this^.SectName, 14), sect_rec.sdesc);
                      if user_rec.lines <> 99 then
                        begin
                          line_count := succ(line_count);
                          if line_count mod user_rec.lines = 0 then pause;
                        end;
                    end;
                  this := this^.next
                end;
              writeln(USR);
              req := '';
            end
        else if req <> ''
          then
            begin
              FindSect(req, Drive, User, OK);
              if OK
                then
                  begin
                    SectReq := req;
                    SetDrv  := Drive;
                    SetUsr  := User;
                    ReadDir(DirEntries, DirSpace, DirBase);
                  end
                else
                  begin
                    writeln(USR, '"', req, '" not found.');
                    writeln(USR);
                    req:='';
                  end;
            end;
      end;
    close(sect_file);
  end;

overlay procedure library;
{ Open and close a library }
  var
    i: integer;
    this: FilePtr;
  begin { library }
    if in_library
      then
        begin
          SetSect(SetDrv, SetUsr);          { Close file }
          Close(libr_file);
          SetSect(HomDrv, HomUsr);
          while LibBase <> nil do           { Clean out old list }
            begin
              this := LibBase;
              LibBase := LibBase^.Next;     { Go to next on chain }
              dispose(this)                 { Reclaim space }
            end;
          in_library := FALSE;
          writeln(USR, 'Library ', LibReq, ' closed.')
        end
      else
        begin
          LibReq := prompt('Library', 12, 'ES');
          delete(LibReq, 1, pos(':', LibReq));
          if LibReq <> ''
            then
              begin
                if pos('.', LibReq) = 0
                  then LibReq := LibReq + '.LBR';
                if copy(LibReq, succ(pos('.', LibReq)), 3) = 'LBR'
                  then LibReadDir(LibEntries, LibSpace, LibBase);
                if not in_library
                  then writeln(USR, 'Cannot open ', LibReq, '.')
              end
        end
  end;

overlay procedure Arc;
{ Open and close an Arc File }
  var
    i: integer;
    this: FilePtr;
  begin { Arc }
    if in_arc
      then
        begin
          SetSect(SetDrv,SetUsr);          { Close file }
          Close(Arc_file);
          SetSect(HomDrv,HomUsr);
          while ArcBase <> nil do           { Clean out old list }
            begin
              this := ArcBase;
              ArcBase := ArcBase^.Next;     { Go to next on chain }
              dispose(this)                 { Reclaim space }
            end;
          in_arc := FALSE;
          writeln(USR, 'Arc File ', ArcReq, ' closed.')
        end
      else
        begin
          ArcReq := prompt('Arc File', 12, 'ES');
          delete(ArcReq, 1, pos(':', ArcReq));
          if ArcReq <> ''
            then
              begin
                if pos('.', ArcReq) = 0
                  then ArcReq := ArcReq + '.ARC';
                if copy(ArcReq, succ(pos('.', ArcReq)), 3) = 'ARC'
                  then ArcReadDir(ArcEntries, ArcSpace, ArcBase);
                if not in_Arc
                  then writeln(USR, 'Cannot open ', ArcReq, '.')
              end
        end
  end;

{end of PICS2B.INC }
