{ PICS2A.INC - Pascal Integrated Communications System Message Sub-system }
{ 6/17/87 vers 1.6 Copyright 1987 by Les Archambault }

overlay procedure mesg_quick_scan;
{ Print abbreviated summary of messages }
  var
    private: boolean;
    sep: char;
    num, line_count: integer;
  begin
    line_count := 0;
    private := FALSE;
    num := mesg_start('Start');
    MesgCurr := MesgBase;
    while (MesgCurr <> nil) and (MesgCurr^.MesgNo < num) do
      MesgCurr := MesgCurr^.next;
    Writeln(USR);
    while (not brk) and (MesgCurr <> nil) do
      begin
        if (MesgCurr^.TypMsg = 1) or (MesgCurr^.TypMsg = 2)
          then
            begin
              private := TRUE;
              sep := '*'
            end
          else sep := ':';
        seek(summ_file, MesgCurr^.SummLoc);
        read(summ_file, summ_rec);
        Writeln(USR, MesgCurr^.MesgNo, sep, ' ', summ_rec.subject);
        MesgCurr := MesgCurr^.next;
        if user_rec.lines <> 99
          then
            begin
              line_count := succ(line_count);
              if line_count mod user_rec.lines = 0 then pause;
            end;
      end;
    if private
      then
        begin
          Writeln(USR);
          Writeln(USR, '"*" marks messages to or from you.')
        end
  end;

overlay procedure mesg_summary;
{ Message summary }
  var
    num, first_line, last_line, line_count: integer;
    fr_fn:firstname;  fr_ln:lastname;
  begin
    line_count := 0;
    num := mesg_start('Start');
    MesgCurr := MesgBase;
    while (MesgCurr <> nil) and (MesgCurr^.MesgNo < num) do
      MesgCurr := MesgCurr^.next;
    while (not brk) and (MesgCurr <> nil) do
      begin
        mesg_header_list(MesgCurr^.SummLoc, first_line, last_line,Fr_fn,Fr_ln);
        MesgCurr := MesgCurr^.next;
        if user_rec.lines <> 99
          then
            begin
              line_count := succ(line_count);
              if line_count mod (user_rec.lines div 5) = 0 then pause;
            end;
      end;
  end;

overlay procedure mesg_read;
{ Read message }
  var
    This : Mesgptr;
    ch,option: char;
    pr_str:strpr;
    fr_fn:firstname; fr_ln:lastname;
    RefFile,RefSect:Filename;
    update,skip,backup : boolean;
    i,num,first_line,last_line,line_count,strt,RefDrv,RefUsr: integer;
  begin
    OK := TRUE; nonstop:=false; MesgCurr:=MesgBase; num:=0;
    repeat
      Writeln(usr);
      st:=prompt('Read Search Option <A><F><T><N><S><Q> ',80,'ES?M');
      if length(st)=1 then option:=st[1]
      else option:='?';
      if option='?' then
        begin
          Writeln(usr,'<A>ll, <F>rom you, <T>o you <N>umeric, <S>ince your last call, <Q>uit');
          mult_cmds:=false;
          cmd_queue:='';
        end;
    until (not online) or (option in ['A','F','T','N','S','Q']);
      Case Option of
        'A' :  If mesgbase<>nil then num:=mesgbase^.mesgno;
        'N' :  num:=Mesg_start('Start'); {get starting number}
        'F' :  Begin
               If Msg_aut=0 then
                 Begin
                 OK:=false; Writeln(usr,'No Messages From You.');
                 end;
               end;
        'T' :  Begin
               If Msg_ind=0 then
                Begin
                OK:=False; Writeln(usr,'No Messages for you.');
                end;
               end;
        'S' :  num:=succ(user_rec.lasthi);
        'Q' :  ok:=false;
      End;
    If(( num>0) and (ok)) then While (MesgCurr<>Nil)
       and (MesgCurr^.MesgNo<Num) do MesgCurr:=MesgCurr^.Next;

    while (not brk) and (MesgCurr <> nil) and OK and Online do
      begin
        backup:=false; skip:=false; update:=false;
        If option='F' then
          While (MesgCurr<>Nil) and (MesgCurr^.Typmsg<>2) do
          MesgCurr:=MesgCurr^.Next;
        If option='T' then
          While (MesgCurr<>Nil) and (MesgCurr^.Typmsg<>1) do
          MesgCurr:=MesgCurr^.Next;
    If (MesgCurr<>Nil) then
      Begin
        if MesgCurr^.MesgNo > user_rec.lasthi  {update LMR}
          then temp_hi_lmr := MesgCurr^.MesgNo;
        mesg_header_list(MesgCurr^.SummLoc, first_line, last_line,Fr_fn,Fr_ln);
        line_count := 4;
        If (not Nonstop) then
          begin
            Repeat
            Writeln(usr); pr_str:='Read <Y><N><C><Q><P><R>';
            if user_rec.access>=250 then pr_str:=pr_str+'<X><V><S>';
            st:=prompt(pr_str,1,'ESA?M');
            if length(st)=1 then ch:=st[1]
            else ch:='?';
            if (user_rec.access<250) and ((ch='X') or (ch='V') or (ch='S')) then ch:='?';
            If ch='?' then
              begin
                Writeln(usr,'<Y>es, <N>o, <C>ontinuous, <Q>uit, <P>revious, <R>eply');
                if user_rec.access>=250 then
                  Writeln(usr,'<X> Sysop Commands, <V>alidate caller, <S>ave to disk file');
                mult_cmds:=false;
                cmd_queue:='';
              end;
            until (not online) or (ch in ['Y','N','C','Q','P','R','X','V','S']);
              Case Ch of
              'Q' : OK:=false;
              'C' : Nonstop:=true;
              'N' : Skip:=true;
              'P' : backup:=true;
              'R' : begin
                      skip:=true;
                      if user_rec.access>=val_acc then mesg_enter('A')
                      else writeln(usr,'Reply not accepted until validation.');
                    end;
              'S' : if user_rec.access>=250 then
                      begin
                        record_msg;
                        skip:=true;
                      end;
              'X' : if user_rec.access>=250 then
                      begin
                        SysopCmds(update); skip:=true;
                      end
                    else ok:=false;
              'V' : if user_rec.access>=250 then Edit_User(Fr_fn,Fr_Ln)
                    else ok:=false;
              End;
          end;          {not nonstop}
            Writeln(usr);
        If (not Skip) and (OK) and (not Backup) then
          Begin
            i := 1;
            seek(mesg_file, first_line);
            while (not brk) and (i <= last_line) and online do
              begin
                read(mesg_file, mesg_rec);
                strt:=pos('//',mesg_rec);  { format: //section/filename/ }
                if (strt>0) and (summ_rec.num_next>0) then
                  begin
                    RefSect:='';
                    RefFile:='';
                    strt:=strt+2; {offset}
                    while (mesg_rec[strt]<>'/') and (strt<=length(mesg_rec)) do
                      begin
                        RefSect:=RefSect+upcase(Mesg_Rec[strt]);
                        strt:=succ(strt);
                      end;
                    strt:=succ(strt);  {offset again}
                    while (mesg_rec[strt]<>'/') and (strt<=length(mesg_rec)) do
                      begin
                        RefFile:=RefFile+upcase(mesg_rec[strt]);
                        strt:=succ(strt);
                      end;
                    if (RefSect<>'') and (RefFile<>'') then
                      begin
                        FindSect(RefSect,RefDrv,RefUsr,OK);
                        if OK then
                          begin
                            List_File(RefFile,RefDrv,RefUsr);
                            line_count:=1;
                          end
                        else OK:=true; {setup for next msg.}
                      end;
                  end
                else
                Writeln(USR, mesg_rec);     {type message lines}
                i := succ(i);
                if (user_rec.lines <> 99) and (not nonstop)
                  then
                    begin
                      line_count := succ(line_count);
                      if line_count mod user_rec.lines = 0
                        then pause;
                    end;
              end; {print msg text}
            update := (summ_rec.user_to = user_loc) and
                      ((summ_rec.status=private) or (summ_rec.status=public));
            If update then summ_rec.status := read;
            If ((summ_rec.user_from=user_loc) or (summ_rec.user_to=user_loc))
              and (not Nonstop) and (not backup) and (summ_rec.status<>deleted)
               then
                  begin
                    i:=0;
                    Writeln(USR); pr_str:='DELETE this message';
                    If (summ_rec.user_to=user_loc) then
                      If Ask('Reply to Message') then
                        begin
                          i:=mesgcurr^.summloc;
                          Mesg_enter('A');
                          pr_str:='DELETE original message';
                        end;
                    Writeln(USR);
                    if ask(pr_str) then
                        begin
                          if ask('Are you sure') then
                            begin
                              If i>0 then
                                begin
                                  seek(summ_file,i);
                                  read(summ_file,summ_rec);
                                end;
                              summ_rec.status:=deleted;
                              update:=true; MesgCurr:=MesgCurr^.next;
                              writeln(usr,'Message deleted.');
                            end
                          else
                            begin
                              Writeln(usr,'Message retained.');
                              MesgCurr:=MesgCurr^.next;
                            end;
                        end
                     else
                        begin
                          Writeln(USR, 'Message retained.');
                          MesgCurr := MesgCurr^.next
                        end;
                  end
            else
            MesgCurr :=MesgCurr^.next;
          end; {skip, backup & OK}
        If update
            then
              begin
                seek(summ_file, pred(FilePos(summ_file)));
                Write(summ_file, summ_rec)
              end;
        If (skip) and (online) then MesgCurr:=MesgCurr^.next;
        Writeln(USR);
        If (Backup) and (MesgCurr<>Mesgbase) then
          Begin
           This:=MesgCurr;
           MesgCurr:=Mesgbase;         {find previous record}
           While MesgCurr^.next<>This do
             MesgCurr:=MesgCurr^.next;
           end;                        {backup}
      end;                          {if mesgcurr<>nil}
      end;                          {print msg and header}
    if (not ok) then
      begin
        mult_cmds:=false;  cmd_queue:='';
      end;
    nonstop:=false;
  end;  {read messages}

overlay procedure mesg_area_change(req: filename);
{ Change message area }
  type
     section_rec=
       record
         sdrive:char;
         suser:integer;
         saccs:integer;
         confnum:integer;
         sname:filename;
         sdesc:strpr;
         mode:char;
       end;
  var
    sect_file:file of section_rec;
    conf_num,line_count: integer;
    sect_rec:section_rec;
    this: AreaPtr;
    pr: StrPr;

  begin  {mesg_area_change}
    assign(sect_file,sect_name+ext);
    reset(sect_file);
    pr := 'Message area';
    while (req <> AreaReq) and (online) do
      begin
        this := AreaBase;
        if req = '' then
          begin
            req := prompt(pr, 12, 'ES?M');
            if req=' ' then req:=AreaReq;
          end;
        if req = '?'
          then
            begin
              Writeln(USR, 'Available message areas:');
              Writeln(USR);
              line_count:=2;
              while (not brk) and (this <> nil) do
                begin
                  conf_num:=this^.AreaConf;
                  if (user_rec.access >= this^.AreaAccs) or
                     (test_bit(user_rec.conf_flags,conf_num)) then
                       begin
                         seek(sect_file,this^.arearec);
                         read(sect_file,sect_rec);
                         Writeln(USR, pad(this^.AreaName, 14), sect_rec.sdesc);
                         if user_rec.lines <> 99 then
                           begin
                             line_count := succ(line_count);
                             if line_count mod user_rec.lines = 0 then pause;
                           end;
                       end;
                  this := this^.next
                end;
              Writeln(USR);
              req := '';
            end
        else if req <> ''
          then
            begin
              while (req <> this^.AreaName) and (this <> nil) do
                this := this^.next;
              conf_num:=this^.AreaConf;
              if (req = this^.AreaName) and ((user_rec.access>=this^.AreaAccs)
              or (test_bit(user_rec.conf_flags,conf_num)))
                then
                  begin
                    AreaSet := this^.Area;
                    AreaReq := req;
                    mesg_build_index(AreaSet);
                    mesg_directory
                  end
                else
                  begin
                    Writeln(USR, '"', req, '" not found.');
                    Writeln(USR);
                    req:='';
                  end;
            end;  {req<>''}
      end;        {while}
    close(sect_file);
  end;

{ end of PICS2A.inc }
