{ PICS0H.INC - Pascal Integrated Communications System Overlays }
{ 5/25/87  Ver 1.6  Copyright 1987 by Les Archambault}

overlay procedure mesg_enter(to_ctrl: char);
{ Enter a new message }
  type
    TextPtr     = ^TextRecord;
    TextRecord  =
      record
        LineNo  : integer;                  { Line number }
        TextMsg : message;                  { Summary index }
        next    : TextPtr                   { Pointer to next element on list }
      end;
  var
    stop_msg,abort: boolean;
    msg_status: record_status;
    ch: char;
    last_line, to_loc,x,to_area: integer;
    TextBase, TextLast, this: TextPtr;
    to_fn: firstname;
    to_ln: lastname;
    subj: subject;
    key: StrName;
    temp_user_rec: user_list;

  procedure dummy;
    begin
    end;

  Overlay function In_Conference:boolean;

    var
      i:integer;
      this:areaptr;

   begin
     this:=areabase;  i:=0;
     while (this<>nil) and (this^.areaname<>areareq) do this:=this^.next;
     if this^.areaname=areareq then i:=this^.areaconf;
     In_conference:=test_bit(user_rec.conf_flags,i);
   end;

  Overlay procedure mesg_input(var last_line: integer);
  { Input message }
    var
      ch: char;
      this: TextPtr;
      msg: StrStd;
    begin
      Writeln(USR);
      msg := ' ';
      next_inpstr := '';
      while (not brk) and (msg <> '') and (online) do
        begin
          msg := next_inpstr;
          if (last_line+1=max_msg_lines) and (limit_lines) then writeln(usr,'Two Lines Left');
          if (last_line>max_msg_lines) and (limit_lines) then msg:=''
          else
            begin
              Write(USR, last_line:2, '> ');
              GetStr(msg, ch, len_msg, 'AEW');
              Writeln(USR);
            end;
          if msg <> ''
            then if MaxAvail > 256
                 then
                   begin
                     new(this);
                     if TextBase = nil
                       then TextBase := this
                       else TextLast^.next := this;
                     TextLast := this;
                     TextLast^.LineNo := last_line;
                     TextLast^.TextMsg := msg;
                     TextLast^.next := nil;
                     last_line := succ(last_line)
                   end
                 else
                   begin
                     Writeln(USR, 'Memory full.');
                     msg := ''
                   end
        end
    end;

Overlay  procedure mesg_edit(mode:char);
  { Edit selected line from message }
    var
      ch: char;
      i: integer;
      this,prev,new_line: TextPtr;
      msg: StrStd;
    begin
      Writeln(USR);
      case mode of
        'D': write(usr,'Delete message line...');
        'E': write(usr,'Edit message line...');
      end;
      i := strint(prompt('Number', 2, 'E'));
      this := TextBase;
      prev:=TextBase;
      if i>0 then
        begin
          while (i <> this^.LineNo) and (this <> nil) do    {find line}
            begin
              prev:=this;
              this := this^.next;
            end;
          if this <> nil
            then
              begin
                case mode of
                  'E': begin
                        msg := this^.TextMsg;
                        Write(USR, i:2, '> ');
                        GetStr(msg, ch, len_msg, 'EL');
                        Writeln(USR);
                        if msg <> '' then this^.TextMsg := msg;
                       end;
                  'D':  begin
                         if (prev=textbase) and (prev=this) then textbase:=this^.next
                         else prev^.next:=this^.next;
                         dispose(this);
                         if TextLast=this then TextLast:=prev;
                         this:=prev^.next;
                           while this<>nil do
                             begin
                               this^.lineno:=pred(this^.lineno);
                               TextLast:=this;
                               this:=this^.next;
                             end;
                         last_line:=pred(last_line);
                        end;
                end;           {case}
              end
            else Writeln(USR, 'Not found.')
        end; {i>0}
    end;

Overlay  procedure mesg_insert_line;
    var
      ch: char;
      i: integer;
      this,prev,new_line: TextPtr;
      msg: StrStd;
    begin
      Writeln(USR);
      i := strint(prompt('Insert before line...Number', 2, 'E'));
      this := TextBase;
      prev:=TextBase;
      if i>0 then
        begin
          while (i <> this^.LineNo) and (this <> nil) do    {find line}
            begin
              prev:=this;
              this := this^.next;
            end;
          if this <> nil then
              begin
               msg:='';
               write(usr,i:2,'> ');
               GetStr(msg,ch,len_msg,'EL');
               writeln(usr);
               if msg<> '' then
                 begin
                   new(new_line);
                   if (prev=textbase) and (prev=this) then textbase:=new_line
                   else prev^.next:=new_line;
                   new_line^.next:=this;
                   new_line^.lineno:=i;
                   new_line^.textmsg:=msg;
                   while this<>nil do
                     begin
                       this^.lineno:=succ(this^.lineno);
                       TextLast:=this;
                       this:=this^.next;
                     end;
                   last_line:=succ(last_line);
                 end;
              end
            else Writeln(USR, 'Not found.')
        end; {i>0}
    end;

Overlay  procedure mesg_print;
  { Display message currently being edited }
    var
      this: TextPtr;
    begin
      writeln(usr);
      Writeln(USR, 'From: ', user_rec.fn, ' ', user_rec.ln);
      if to_fn = ''
        then Writeln(USR, '  To: ALL')
        else Writeln(USR, '  To: ', to_fn, ' ', to_ln);
      Writeln(USR, '  Re: ', subj);
      Writeln(USR);
      this := TextBase;
      while (not brk) and (this <> nil) do
        begin
          Writeln(USR, this^.LineNo:2, ': ', this^.TextMsg);
          this := this^.next
        end
    end;

{end of Pics0h.inc }
