{ PICS0G.INC  Pascal Integrated Communications System Overlays }
{ 5/25/87 ver 1.6 Copyright 1987 by Les Archambault}

Overlay Procedure Read_Section_File;

type
   Section_rec=
     record
       sdrive:char;
       suser:integer;
       saccs:integer;
       confnum:integer;
       sname:filename;
       sdesc:strpr;
       mode:char;
     end;
var
   Sect_File:file of section_rec;
   sect_rec:section_rec;
   found_file_secs,found_post,found_system:boolean;
   drive,user,i,artcount,rec:integer;
   ets,co,am,ll,r300,rp:char;
   areathis,arealast:areaptr;
   sectthis,sectlast:sectptr;
   artthis,artlast:artptr;

begin
  found_file_secs:=true; found_post:=false; found_system:=false; artcount:=0;
  Assign(Sect_file,Sect_name + Ext);
  {$I-} Reset(sect_file) {$I+};           { Build file and message section lists }
  OK := (IOresult = 0);
  if OK then
    begin
      rec:=0;
      seek(sect_file,0);
      while not EOF(sect_file) do
      with sect_rec do
        begin
          read(sect_file,sect_rec);
          if mode='M' then
            begin               {message areas}
              if trim(SName)='POST' then found_post:=true;
              if trim(SName)='SYSTEM' then found_system:=true;
              new(AreaThis);
              if AreaBase = nil then AreaBase := AreaThis
              else AreaLast^.next := AreaThis;
              AreaLast := AreaThis;
              AreaLast^.Area := SUser;
              if confnum>0 then AreaLast^.AreaConf:=confnum
                else AreaLast^.AreaConf:=0;
              if confnum>0 then
                begin
                  writeln;
                  writeln('Activating Message Conference number ',confnum);
                  delay(500);
                end;
              AreaLast^.AreaAccs := SAccs;
              AreaLast^.AreaName := trim(SName);
              AreaLast^.AreaRec := rec;
              AreaLast^.next := nil
            end
          else if mode='F' then
            begin
              new(SectThis);     {file sections}
              if SectBase = nil then SectBase := SectThis
              else SectLast^.next := SectThis;
              SectLast := SectThis;
              SectLast^.SectDrive := ord(SDrive) - ord('A');
              SectLast^.SectUser := SUser;
              if confnum>0 then SectLast^.SectConf:=confnum
                else SectLast^.SectConf:=0;
              if confnum>0 then
                begin
                  writeln;
                  writeln('Activating Files Conference number ',confnum);
                  delay(500);
                end;
              SectLast^.SectAccs := SAccs;
              SectLast^.SectName := trim(SName);
              SectLast^.SectRec := rec;
              SectLast^.next := nil;
            end
          else if mode='A' then
            begin
              New(Artthis);
              if artbase=nil then artbase:=artthis
              else artlast^.next:=artthis;
              artcount:=succ(artcount);
              artlast:=artthis;
              artlast^.artdrive:=ord(sdrive)-ord('A');
              artlast^.artuser:=suser;
              artlast^.artaccs:=saccs;
              artlast^.artnum:=artcount;
              artlast^.artname:=trim(sname);
              artlast^.artRec:=rec;
              artlast^.next:=nil;
            end;
          rec:=succ(rec);
        end;  {eof reached}
      Close(sect_file);
      Assign(Config_file,'CONFIG.BB#');
      {$I-}  Reset(config_file); {$I+}
      if ioresult=0 then
        begin
          read(config_file,maxfree_uplds,maxfree_logs,maxfree_mslimit,maxfree_lines,
          maxfree_abs,extra_time_start,extra_time_stop,extra_time_val,
          chatstart,chatend,sleepy_time,max_tries,auto_macro_start,
          max_msg_lines,start_restrict300,end_restrict300,
          up_down_ratio,val_time,uval_time,val_acc,uval_acc,
          val_days,unv_days,unr_days,rea_days);
          read(config_file,ets,ets,co,am,ll,r300,rp,macro); {first ets eats space}
          if ets='T' then extra_time_sw:=true else extra_time_sw:=false;
          if co='T' then chat_ok:=true else chat_ok:=false;
          if am='T' then auto_macro:=true else auto_macro:=false;
          if ll='T' then limit_lines:=true else limit_lines:=false;
          if r300='T' then restrict300:=true else restrict300:=false;
          if rp='T' then restrict_public:=true else restrict_public:=false;
          if macro='' then macro:=Deflt_macro;
          close(config_file);
        end;
      FindSect('NEWIN', RcvDrv, RcvUsr, OK);  {sets up area to recv. files}
      if not OK then Writeln(BEL, 'NEWIN file section name not found.');
      if not ok then found_file_secs:=false;
      Findsect('LOGIN',drive,user,ok);
      if not ok then
        begin
          Writeln(bel,'LOGIN file section name not found.');
          found_file_secs:=false;
        end;
      findsect('SYSTEM',drive,user,ok);
      if not ok then
        begin
          Writeln(bel,'SYSTEM file section name not found.');
          found_file_secs:=false;
        end;
      if not found_post then writeln('POST message area name not found.');
      if not found_system then writeln('SYSTEM message area name not found.');
      if (not found_file_secs) or (not found_post) or (not found_system) then
        begin
          writeln;
          writeln(bel, 'Unable to continue. Re-run SETUP.COM');
          halt;
        end;
    end         {was able to read section.bb# file}
      else
        begin
         Writeln(BEL, 'Section file not found. Run SETUP.COM to create.');
         Writeln(Bel, 'Unable to continue.');
         halt;
        end;
end;

overlay procedure change_settings(num:integer);
 var work:strstd;
     t:tad_array;
  begin
       case num of
         1  : begin
               work:=prompt('Min. disk space to allow uploads',4,'EL');
               if work<>'' then maxfree_uplds:=strint(work);
               end;
         2  : begin
               work:=prompt('Min. disk space left (K) to allow New Users',4,'EL');
               if work<>'' then maxfree_logs:=strint(work);
               end;
         3  : begin
               work:=prompt('Min. disk space (k) for unlimited messages',4,'EL');
               if work<>'' then maxfree_mslimit:=strint(work);
               end;
         4  : begin
               work:=prompt('Message lines when disk space limited',3,'EL');
               if work<>'' then maxfree_lines:=strint(work);
               end;
         5  : begin
               work:=prompt('Min. disk space left (K) for complete restrictions',4,'EL');
               if work<>'' then maxfree_abs:=strint(work);
               end;
         6  : extra_time_sw:=not extra_time_sw;
         7  : begin
               work:=prompt('Hour to begin granting extra time',2,'EL');
               if work<>'' then extra_time_start:=strint(work);
               work:=prompt('Hour to end granting extra time',2,'EL');
               if work<>'' then extra_time_stop:=strint(work);
               end;
         8  : begin
               work:=prompt('Number of minutes of extra time granted',3,'EL');
               if work<>'' then extra_time_val:=strint(work);
               end;
         9  : chat_ok:=not chat_ok;
         10 : begin
               work:=prompt('Hour to begin allowing chat',2,'EL');
               if work<>'' then chatstart:=strint(work);
               work:=prompt('Hour to end allowing chat',2,'EL');
               if work<>'' then chatend:=strint(work);
               end;
         11 : begin
               work:=prompt('Seconds to wait for caller keyboard input',4,'EL');
               if work<>'' then
                 begin
                   sleepy_time:=strint(work);
                   timeout:=sleepy_time;
                 end;
              end;
         12 : begin
               work:=prompt('Max. tries allowed for names, password',2,'EL');
               if work<>'' then max_tries:=strint(work);
               end;
         13 : auto_macro:=not auto_macro;
         14 : begin
               work:=prompt('Starting hour for auto macro execution',2,'EL');
               if work<>'' then
                 begin
                   auto_macro_start:=strint(work);
                   gettad(t);
                   if (auto_macro_start>t[2]) and (macro_done=t[3]) then macro_done:=255;
                 end;
               end;
         15 : limit_lines:=not limit_lines;
         16 : begin
               work:=prompt('Max. number of lines allowed in message',3,'EL');
               if work<>'' then max_msg_lines:=strint(work);
               end;
         17 : restrict300:=not restrict300;
         18 : begin
               work:=prompt('Hour to start restricting 300 baud use',2,'E');
               if work<>'' then start_restrict300:=strint(work);
               work:=prompt('Hour to end restricting 300 baud use',2,'EL');
               if work<>'' then end_restrict300:=strint(work);
              end;
         19 : begin
               work:=prompt('Downloads allowed per upload [ 0 = No restriction] ',3,'EL');
               if work<>'' then up_down_ratio:=strint(work);
               end;
         20 : restrict_public:= not restrict_public;
         21 : begin
               work:=prompt('New Caller Number',5,'EL');
               if work<>'' then
                 begin
                   seek(logr_file,0);
                   logr_rec.user:=strint(work);
                   write(logr_file,logr_rec);
                 end;
               end;
       end;
  end;

Overlay Procedure Display_purge_settings;

  var i:integer;

  begin
      writeln(usr);
      writeln(usr,'1...Time allowed on system:            validated     ',val_time);
      writeln(usr,'2....................................  un-validated  ',uval_time);
      writeln(usr,'3...Access level:                      validated     ',val_acc);
      writeln(usr,'4....................................  un-validated  ',uval_acc);
      writeln(usr,'5...Days to retain inactive user:      validated     ',val_days);
      writeln(usr,'6....................................  un-validated  ',unv_days);
      writeln(usr,'7...Days to retain unread messages:                  ',unr_days);
      writeln(usr,'8...Days to retain read messages:                    ',rea_days);
      for i:=9 to 20 do writeln(usr);
  end;

overlay procedure change_Purge_settings(num:integer);
 var work:strstd;
  begin
       case num of
         1  : begin
               work:=prompt('Time (minutes) allowed on system for validated users',3,'EL');
               if work<>'' then val_time:=strint(work);
               end;
         2  : begin
               work:=prompt('Time (minutes) allowed on system for un-validated users',3,'EL');
               if work<>'' then uval_time:=strint(work);
               end;
         3  : begin
               work:=prompt('Access level assigned to validated users',3,'EL');
               if work<>'' then val_acc:=strint(work);
               end;
         4  : begin
               work:=prompt('Access level for un-validated users',3,'EL');
               if work<>'' then uval_acc:=strint(work);
               end;
         5  : begin
               work:=prompt('Days to retain inactive validated user',3,'EL');
               if work<>'' then val_days:=strint(work);
               end;
         6  : begin
               work:=prompt('Days to retain inactive un-validated caller',3,'EL');
               if work<>'' then unv_days:=strint(work);
               end;
         7  : begin
               work:=prompt('Days to retain un-read messages',3,'EL');
               if work<>'' then unr_days:=strint(work);
               end;
         8  : begin
               work:=prompt('Days to retain read messages',3,'EL');
               if work<>'' then rea_days:=strint(work);
               end;
       end;
  end;

Overlay Procedure Record_msg;

   var  Tfile:text;
        i,x,n,first_line,last_line:integer;
        to_fn,fr_fn:firstname;
        to_ln,fr_ln:lastname;
        str:strstd;
        Tname:filename;
        temp_user_rec:user_list;
        this:areaptr;

  begin
   repeat
    writeln(usr); ok:=false;
    Tname:=prompt('Filename to save msg to',12,'ES');
    if Tname<>' ' then
      begin
        Assign(Tfile,Tname);
        {$I-} Reset(Tfile); {$I+}
        if ioresult<>0 then ok:=true;
        if ok then
          begin
            {$I-} Rewrite(Tfile); {$I+}
            ok:=(ioresult=0);
          end
        else
          begin
            writeln(usr);
            if ask('File already exists...use anyway') then
              begin
                {$I-} Rewrite(Tfile); {$I+}
                ok:=(ioresult=0);
              end;
          end;
      end;
   until ok or (not online) or (tname=' ');
   if ok and online then
     begin
       Writeln(usr); write(usr,'Writing file...');
       with summ_rec do
         begin
           if user_to=0 then
             begin
               to_fn:='ALL';
               to_ln:='';
             end
           else if user_to=user_loc then
             begin
               to_fn:=user_rec.fn;
               to_ln:=user_rec.ln;
             end
           else
             begin
               getrec(datf,user_to,temp_user_rec);
               to_fn:=temp_user_rec.fn;
               to_ln:=temp_user_rec.ln;
             end;
           if user_from=user_loc then
             begin
               fr_fn:=user_rec.fn;
               fr_ln:=user_rec.ln;
             end
           else
             begin
               getrec(datf,user_from,temp_user_rec);
               fr_fn:=temp_user_rec.fn;
               fr_ln:=temp_user_rec.ln;
             end;
           str:=formtad(date);
           this:=areabase;
           while (this<>nil) and (this^.area<>area) do this:=this^.next;
           writeln(tfile);
           if num_prev=255 then write(tfile,'<P>');
           case status of
             deleted : Write(tfile,'Deleted');
             read    : Write(tfile,'Read');
             private : Write(tfile,'Private');
             public  : Write(tfile,'Public');
             restricted : Write(tfile,'Restricted');
           end;
           writeln(tfile,' Message # ',num,'  ',this^.areaname,
             ' Area ',' Entered ',str);
           writeln(tfile,'From: ',fr_fn,' ',fr_ln);
           writeln(tfile,'  To: ',to_fn,' ',to_ln);
           writeln(tfile,'  Re: ',subject);
           first_line:=st_rec;
           last_line:=size;
         end;  {with sum_rec}
       i:=1;
       seek(mesg_file,first_line);
       writeln(tfile);
       while (i<=last_line) and online do
         begin
           read(mesg_file,mesg_rec);
           writeln(tfile,mesg_rec);
           i:=succ(i);
         end;
       close(tfile);
       writeln(usr,'Complete');
     end;      {ok and online}
  end;         {procedure}

{End of PICS0G.inc }

