PUSER16.MOD		Adding Printer Initialization/De-initialization

PUSER is Terry Pinto's program to display or print out PBBS user data
for RCP/M systems that use Russ Pencin's PBBS bulletin board program.


This modification adds the capability to initialize and de-initialize
the printer.  It has been tested with PUSER15 and PUSER16.  Specifically,
it will allow PUSER to automatically set up your printer for compressed
print to print out user info, then will return the printer to normal
print mode. 

Also, ^C has been added to ^K, K, and Q as an abort key.

Finally, if you have not yet fixed the Record 0 bug (described in
PUSER16.FIX), you can do it now.  It is covered below as RECORD 0 FIX.
This also applies to PUSER15 and PUSER16.
 
After you make the changes below to PUSER source code, and you have edited
the new SUPTR and EXPTR strings for your particular printer, assemble and
link to a .COM file as described below.  You will need PBBSUBS.REL and
SYSLIB36.REL for linking.  Both are supplied with Terry Pinto's
PUSERxx.LBR archives. 
 
Some information by way of an example is provided, showing how the new
SUPTR and EXPTR strings might appear.  The example is for an Okidata ML92.

 
				22-Aug-87	Jerry Levy
						1129 Dundee Drive
						Dresher, PA 19025
						(215) 657-0898 (voice)


CHANGES TO PERMIT PRINTER INITIALIZATION/DE-INITIALIZATION
----------------------------------------------------------

Step 1
------
Near the beginning of the program, find the following and make
changes as indicated at the <===== markers.

lstout	equ	5		; BDOS list output character
;
	ext	lpstr, lafdc, lhldc, ladc, lhlfdc, la2hc
	ext	phlfdc, pafdc
	ext	lout						<=====
;
	INCLUDE PBBSHDR.MAC
 	INCLUDE	BDOSHDR.MAC

; Printer setup and exit strings.  SUPTR is for initializing 	<=====
; the printer to compressed print mode, and EXPTR is for	<=====
; de-initializing it to return to normal print.			<=====
;								<=====
; These strings can be as long as you need them to be, but make <=====
; certain that that the last byte is a null (0) which is needed <=====
; as the string terminator.					<=====
;								<=====
; You could leave them as all-nulls and set your printer by 	<=====
; means of an external program, if you wish.			<=====
;								<=====
suptr:					; printer initialization<=====
	db	0,0,0,0,0,0,0,0,0,0	; edit for your printer	<=====
					;  for compressed type	<=====
;								<=====
exptr:					; printer de-init.	<=====
	db	0,0,0,0,0,0,0,0,0,0	; ...for normal type	<=====



Step 2
------
Next, find this code and modify as shown

abort:
	push	hl		; save the TBUF address
	push	de
	push	bc
	ld	e,0ffh
	ld	c,6
	call	spbdos		; see if we got a character
	or	a
	jr	z,abort3	; if no key pressed, then continue
	cp	'S'-'@'		; ^S to pause
	jr	z,abrtwt	; wait for next character
	cp	'K'-'@'		; ^K to abort
	jr	z,abort2
	cp	'C'-'@'		; ^C to abort			<=====
	jr	z,abort2					<=====
	call	caps
	cp	'S'		; S to pause
	jr	nz,abort1	; if not, then exit
abrtwt:
	call	getch		; otherwise wait for another character
	cp	'K'-'@'		; does he want to quit?
	jr	z,abort2	; yup...
	cp	'C'-'@'		; ^C to abort			<=====
	jr	z,abort2					<=====
	call	caps		; check a Q too...
abort1:
	cp  	'Q' 		; is it 'Q' to quit?
	jr	z,abort2	 
	cp	'K'		; is it 'K' to quit?
	jr	z,abort2
	jr	abort3
abort2:
	call	print		; if yes, then print abort message
	db	cr,lf,'++ ABORTED ++',cr,lf,0
	ld	hl,exptr	; point to printer exit string	<=====
	ld	a,(lstflg)	; get print enable flag		<=====
	cp	0ffh		; is it set?			<=====
	call	z,setlst	; if so, de-initialize printer	<=====
	pop	bc		; restore all registers
	pop	de
	pop	hl
	xor	a
	ld	a,(wheel)	; get wheel byte
	cp	0ffh		; is it set?
	jp	nz,exit   	; get prompt line
	ld	hl,0      	; set line count to zero
	ld	(lncnt),hl	; store in buffer
	ld	(tusers),hl	; set total users to zero
	jp	pusers		; exit
abort3:



Step 3
------
Towards the end of the program, find this and change as follows

slflg:
	call	getacc		; get access level request
	ld	hl,suptr	; point to setup string		<=====
	call	setlst		; initialize printer		<=====
	ld	hl,0   		; get starting page
	ld	(pg),hl		; save in buffer
 	call	header		; print page header
	ld	a,0ffh    	; set list enable flag
	ld	(lstflg),a	; save in buffer
	jp      puser1		; start print
;
; send string to printer with no interpretation of non-		<=====
; printable characters.  First null is the string terminator	<=====
;								<=====
setlst:				;				<=====
	ld	a,(hl)		; point to first/next byte	<=====
	cp	0		;				<=====
	ret	z		; done if it's a null		<=====
	call	lout		; defined in SYSLIB36		<=====
	inc	hl		; advance pointer		<=====
	jr	setlst		; loop				<=====
rslflg:
	ld	a,0		; set disable list flag
	ld	(lstflg),a	; save in buffer
	ld	hl,foot		; point to ending message
	call	lpstr		; send to printer
	ld	hl,(tusers)	; get total number of users on system
	call	lhlfdc		; send to printer
	ld	hl,lcrlf 	; point to carriage return/line feed
	call	lpstr		; send to printer
	call	fmfd		; send form feed to printer
	ld	hl,exptr	; point to printer exit string	<=====
	call	setlst		; de-initialize the printer	<=====
	ret		




------------
You're Done.
------------


RECORD 0 FIX
------------
PUSER15 and PUSER16 start reading User Record 1 instead of Record 0.
To correct, make these changes.

Not far from the beginning of the program, find this and change as
indicated

puser1:
	ld	hl,0		; starting record
	ld 	(currec),hl	; put starting record in buffer
	call	uopen		; open user file
	ld	hl,(currec) 	; point to record counter	<=====
	jr	user0						<=====
uslp:	
	ld	hl,(currec) 	; point to record counter
	inc	hl		; increment counter to next record
user0:								<=====
	ld	(currec),hl	; put in buffer
	call	get		; get record

--------
All Done
--------

PRINTER INITIALIZATION/DE-INITIALIZATION EXAMPLE
------------------------------------------------
Here is an example for an Okidata ML92.  As long as you leave a 0
as terminator, you can make these strings as long as you wish.

suptr:						; initialization
	db	0dh,1bh,30h,1dh,1bh,36h,0,0,0,0
		 \   \   \   \   \___\___ esc 6 = 6 lines per inch
		  \   \   \   \__________ 17 cpi
		   \   \___\_____________ esc 0 = data processing chars
		    \____________________ print head to extreme left

exptr:						; de-initialization
	db	0dh,1bh,30h,1eh,1bh,36h,0,0,0,0
		 \   \   \   \   \___\___ esc 6 = 6 lines per inch
		  \   \   \   \__________ 10 cpi
		   \   \___\_____________ esc 0 = data processing chars
		    \____________________ print head to extreme left

Why so much, when in most instances just   1dh,0    will work for
setting 17-CPI and   1eh,0  will get you back to 10-CPI?

Well, the Okidata 92 will not allow 17-CPI (compressed print) in its
correspondence mode.  If you happened to be in correspondence mode when
you asked the printer to reset to 17-CPI, it won't make the change.
Therefore, always getting back to data processing mode before changing
settings is good practice.  The other things -- print head positioning
and line spacing -- are just there to be sure all settings are as I want
them.
 


ASSEMBLY AND LINKING
--------------------
You need PBBSUBS.REL and SYSLIB36.REL for the linking step.  They
are contained in Terry Pinto's PUSERxx.LBR archives.


RENAME .PUSERxx.180 TO PUSERxx.MAC or PUSERxx.Z80 depending on what
your assembler prefers.

M80 does not work for PUSER15.MAC, but that has been fixed in
PUSER16.MAC.  For both PUSER15 or PUSER16, the SLR assemblers work
fine.  I use Z80ASM, and Terry Pinto uses SLR180P.

For PUSER15, I needed to use the /U switch for my SLR assembler, Z80ASM,
and as mentioned M80 will not work.

For PUSER16, the /U swich is not needed (no harm if you use it), and
also M80 works.

Use the /S search option for L80, to avoid two unimportant but
disconcerting %Mult. Def. Global errors (I got them with PUSER16
as well as PUSER15), and to make the shortest possible .COM file,
8k vs. 22k.  Thus:


For PUSER15
				Z80ASM PUSER15.@@Z/6U
				(@ = finds PUSER15.Z80 and places
 				 PUSER15.REL on the default drive)


And for PUSER16

 M80 =PUSER16/N		or	Z80ASM PUSER16.@@Z/6


followed in either case by

 L80 PUSERxx,PBBSUBS,SYSLIB36/S,PUSERxx/N/E

						Jerry Levy
