100 REM  *********************************************************************
110 REM  *                                                                   *
120 REM  *                           PBBSULST.BAS                            *
130 REM  *                                                                   *
140 REM  *      Program to produce a list of active PBBS users.  Based       *
150 REM  *           on MBBSULST.BAS by J. Taylor and K. Levitt.             *
160 REM  *                                                                   *
170 REM  *                Written May 12/86 by Ian Cottrell                  *
180 REM  *                                     Sysop, ICBBS                  *
190 REM  *                                     Ottawa, Ontario, Canada       *
200 REM  *                                     613-952-2289                  *
210 REM  *                                                                   *
220 REM  *                Version 2.2 - October 13/87 - IC                   *
230 REM  *                                                                   *
240 REM  *                          For PBBS 4.0                             *
250 REM  *                                                                   *
260 REM  *********************************************************************
270 VER$="2.2" : DAIT$="October 13/87"
280 DIM MON$(12)
290 BEL$=CHR$(7) : LNEQ$=STRING$(128,"=") : LNDSH$=STRING$(128,"-")
300 CLS$=CHR$(26) : REM  Clear screen code
310 FF$=CHR$(12) : REM  Printer form feed
320 USERS=500 : REM  Set to maximum number of users allowed (from PBBSHDR)
330 WIDTH LPRINT 150
340 DEF FN LC$(X$)=CHR$(ASC(X$)-32*(ASC(X$)>64 AND ASC(X$)<91))
350 FOR I=1 TO 12
360	READ MON$(I)
370 NEXT I
380 DATA "Jan ","Feb ","Mar ","Apr ","May ","Jun "
390 DATA "Jul ","Aug ","Sep ","Oct ","Nov ","Dec "
400 OPEN "R",#1,"INDEX.PBS",100
410 GET #1,1 : FIELD #1, 3 AS DATE$,2 AS NREC$,2 AS NNUM$,2 AS MINUM$,

     2 AS NCAL$,2 AS NUSR$,87 AS UNUSED$
420 TUSR=CVI(NUSR$) : CLOSE #1
430 TWIT=0 : PN=0 : TOT=50
440 PRINT CLS$ SPC(20) "---==={ PBBS User List Program }===---"
450 PRINT SPC(30) "(by Ian Cottrell)" : PRINT
460 PRINT TAB((70-LEN(VER$)-LEN(DAIT$))/2) "Version " VER$ " " DAIT$ : PRINT
470 INPUT "Please enter today's date (mm/dd/yy):  ",TDAY$ : PRINT
480 MNTH=VAL(LEFT$(TDAY$,2)) : MNTH$=MON$(MNTH)
490 TDAY$=MNTH$+RIGHT$(TDAY$,5)
500 INPUT "Do you want to list passwords (Y/N)? ",PWD$ : PRINT
510 IF PWD$="Y" OR PWD$="y" THEN PWD$="Y" ELSE PWD$="N"
520 PRINT "Ready printer and hit return when ready >>> ";
530 LINE INPUT D$
540 ON ERROR GOTO 1800
550 OPEN "I",#1,"PBBSULST.DAT"
560 WHILE NOT EOF(1)
570    LINE INPUT #1, A$
580    CP$=CP$+CHR$(VAL(A$))
590 WEND
600 CLOSE #1
610 LPRINT CP$ : REM  Set printer for compressed print
620 OPEN "R",#1,"USERS.PBS",100
630 FIELD #1, 1 AS FRF$,30 AS N$,20 AS L$,10 AS PW$,12 AS PH$,2 AS NOL$,

    3 AS LD$,1 AS LV$,1 AS ML$,1 AS DU$,1 AS NU$,1 AS BR$,2 AS UP$,2 AS DN$,

    2 AS UMP$,2 AS DMP$,1 AS TC$,1 AS LTOS$,2 AS HM$,2 AS MFA$,1 AS TW$,

    2 AS NUS$
640 REM  Key to FIELD statement for USERS.PBS
650 REM  FRF$    = record free flag (0=record not used)
660 REM  N$      = name of user
670 REM  L$      = City, Prov/State of user
680 REM  PW$     = password
690 REM  PH$     = phone number
700 REM  NOL$    = number of logons
710 REM  LD$     = last date on system
720 REM  LV$     = user level (0-9) (NOTE:  Level 0 not listed)
730 REM  ML$     = mail waiting flag (0=no mail)
740 REM  DU$     = initial drive/user
750 REM  NU$     = number of nulls needed
760 REM  BR$     = last baud rate used
770 REM  UP$     = number of uploads
780 REM  DN$     = number of downloads
790 REM  UMAP$   = user area map
800 REM  DMAP$   = drive map
810 REM  TC$     = terminal code
820 REM  LTOS$   = time on system last time
830 REM  HM$     = high messsage read
840 REM  MFA$    = multiple folder access information
850 REM  TW$     = terminal width
860 REM  NUS$    = not used
870 PRINT : PRINT "Counting total users (including Level 1 TWITS)... ";
880 FOR C=1 TO USERS
890	GET #1,C
900	IF ASC(LV$)=1 THEN TWIT=TWIT+1
910 NEXT C
920 PRINT : PRINT
930 PRINT USING "###";TUSR; : PRINT " active users + ";
940 PRINT USING "###";TWIT; : PRINT " TWITS = "; : PRINT USING "###";TUSR+TWIT;
950 PRINT " total users."
960 PTOT=INT((TUSR+49+TWIT)/50)
970 PRINT : PRINT "Printing users file to printer... ";
980 FOR C=1 TO USERS
990	IF INKEY$=CHR$(3) THEN PRINT "<ABORTED>" : STOP
1000	GET #1,C
1010	IF ASC(FRF$)=0 THEN 1490
1020	IF ASC(LV$)=0 THEN 1490
1030  	IF TOT=50 THEN GOSUB 1640 ELSE TOT=TOT+1
1040	FOR X=30 TO 1 STEP -1
1050        IF MID$(N$,X,1)<>CHR$(0) THEN DIV=X : X=1
1060	NEXT X
1070	NME$=LEFT$(N$,DIV)
1080	N1$=NME$
1090	FOR X=2 TO LEN(NME$)
1100	   IF MID$(NME$,X,1)=" " THEN X=X+1 : GOTO 1120
1110	   MID$(NME$,X,1)=FN LC$(MID$(N1$,X,1))
1120	NEXT X
1130	FOR X=20 TO 1 STEP -1
1140	   IF MID$(L$,X,1)<>CHR$(0) THEN DIV=X : X=1
1150	NEXT X
1160	C$=LEFT$(L$,DIV) : C1$="" : C2$="" : DIV=0
1170	FOR X=LEN(C$) TO 1 STEP -1
1180	   IF MID$(C$,X,1)=" " THEN DIV=X-1 : X=1
1190	NEXT X
1200	IF DIV=0 THEN 1300
1210	C1$=LEFT$(C$,DIV) : C2$=RIGHT$(C$,LEN(C$)-DIV-1)
1220	C$=C1$
1230	FOR X=2 TO LEN(C$)
1240	   IF MID$(C$,X,1)=" " THEN X=X+1 : GOTO 1260
1250	   MID$(C$,X,1)=CHR$(ASC(MID$(C1$,X,1)) OR 32)
1260	NEXT X
1270	C$=C$+" "+C2$
1280	DS=INSTR(C$,"  ") : IF DS=0 THEN 1300
1290	C1$=LEFT$(C$,DS-1) : C2$=RIGHT$(C$,LEN(C$)-DS) : C$=C1$+C2$:GOTO 1280
1300	FOR X=10 TO 1 STEP -1
1310	   IF MID$(PW$,X,1)<>CHR$(0) THEN DIV=X : X=1
1320	NEXT X
1330	P$=LEFT$(PW$,DIV)
1340	LEVEL=ASC(LV$)
1350	NOL=CVI(NOL$)
1360	MNTH=ASC(LEFT$(LD$,1)) : DAY=ASC(MID$(LD$,2,1)) : YR=ASC(RIGHT$(LD$,1))
1370	YR$=RIGHT$(STR$(YR),2)
1380	MNTH$=MON$(MNTH)
1390	IF DAY>9 THEN DAY$=RIGHT$(STR$(DAY),2) ELSE

        DAY$="0"+RIGHT$(STR$(DAY),1)
1400	UPLDS=CVI(UP$) : DWNLDS=CVI(DN$)
1410	MFA1=ASC(RIGHT$(MFA$,1)) : MFA2=ASC(LEFT$(MFA$,1)) : ACC$=""
1420	FOR Z=1 TO 8
1430	    X=2^(Z-1)
1440	    K1=MFA1 AND X : K2=MFA2 AND X
1450	    IF K1=X THEN F$="Y" ELSE IF K2=X THEN F$="B" ELSE F$="N"
1460	    ACC$=ACC$+F$ : IF Z=4 THEN ACC$=ACC$+" "
1470	NEXT Z
1480    GOSUB 1520
1490 NEXT C
1500 LPRINT LNEQ$ FF$ : PRINT " >>> Done." : END
1510 REM *** SUBROUTINE: PRINT USER RECORD ON PRINTER ***
1520 LPRINT USING "###    ";C;
1530 LPRINT USING "\                             \";NME$;
1540 LPRINT USING "\                    \";C$;
1550 LPRINT USING "\            \";PH$;
1560 IF PWD$="Y" AND LEVEL<8 THEN LPRINT USING "\        \ ";P$;

    ELSE LPRINT "---------- ";
1570 LPRINT USING "  #  ";LEVEL;
1580 LPRINT USING " #### ";NOL;
1590 LPRINT USING "  \ \ \\/\\ ";MNTH$,DAY$,YR$;
1600 LPRINT USING " \         \";ACC$;
1610 LPRINT USING "###  ";UPLDS,DWNLDS
1620 RETURN
1630 REM *** SUBROUTINE: PRINT PAGE HEADING ***
1640 PN=PN+1 : IF PN<>1 THEN LPRINT CHR$(12);
1650 LPRINT CP$;LNEQ$
1660 LPRINT "PBBS USER FILE LISTING:";TAB(107);"Printed on:  ";TDAY$
1670 LPRINT "Total # of user file records =";TUSR+TWIT;TAB(112);" Page: ";
1680 LPRINT USING "### of ###";PN,PTOT
1690 LPRINT LNDSH$
1700 LPRINT "User" TAB(92) "# of";
1710 LPRINT TAB(100) "Last log   Folders"
1720 LPRINT "Rec #  User Name" TAB(39) "Location (city, prov) ";
1730 LPRINT "  Phone #      Password   Lvl  Logns   on date   ";
1740 LPRINT "2345 6789  ULD  DLD"
1750 LPRINT "-----  ------------------------------ --------------------- ";
1760 LPRINT "------------  ----------  ---  -----  ---------  --------- ";
1770 LPRINT " ---  ---"
1780 TOT=1 : RETURN
1790 END
1800 IF ERR=53 AND ERL=550 THEN CLOSE #1 ELSE 2070
1810 PRINT STRING$(24,10)
1820 PRINT "The  file  'PBBSULST.DAT' is not present of this  disk/user.   We"
1830 PRINT "will now create it."
1840 PRINT
1850 PRINT "Please enter the compressed print sequence for your printer.  The"
1860 PRINT "sequence  must be entered one byte at a time in Decimal  numbers." 
1870 PRINT "All entries must end with a <RETURN>.   After the last number has"
1880 PRINT "been  entered,  enter a blank line (<RETURN> only).   A total  of"
1890 PRINT "nine characters may be entered."
1900 PRINT
1910 FOR I=1 TO 9
1920    PRINT "Compressed Print character #";I;
1930    LINE INPUT R$
1940    IF R$="" AND I>1 THEN 2030
1950    IF R$="" THEN 1920
1960    IF LEN(R$)>3 THEN 1920
1970    FOR J=1 TO LEN(R$)
1980       IF ASC(MID$(R$,J,1))<48 OR ASC(MID$(R$,J,1))>57 THEN PRINT BEL$;

           "Please enter only whole decimal numbers." : GOTO 1920
1990    NEXT J
2000    IF I>1 THEN CP$=CP$+CHR$(13)+CHR$(10)
2010    CP$=CP$+R$
2020 NEXT I
2030 PRINT"Writing PBBSULST.DAT"; : OPEN "O",#1,"PBBSULST.DAT"
2040 PRINT #1,CP$
2050 CLOSE #1 : CP$=""
2060 RESUME 550
2070 ON ERROR GOTO 0
