100 REM === CALLSTAT ===
110 REM Version 5.1 March 23/87
120 REM by Klaus Bartels and Ian Cottrell
130 REM
140 REM This program summarizes user activity on a PBBS system
150 REM   and produces a paginated, sorted summary showing user
160 REM   name, number of logins, total time on system and date
170 REM   of last login.
180 REM
190 REM Format of the CALLERS data file written by PBBS, ver 4.0
200 REM    01-05  Login date
210 REM    07-11  Login time
220 REM    13-17  Logout time
230 REM    21-24  Speed
240 REM    26-44  User name
250 REM    45-61  User location (city and prov/state)
260 REM
270 DIM NME$(500),NOL(500),LDATE$(500),ANME$(500),BNME$(500),REC(500)
280 DIM TOS(500),MON$(12),STACK(20)
290 DEF FN UC$(X$)=CHR$(ASC(X$)+32*(ASC(X$)>96 AND ASC(X$)<123))
300 VER$="5.1":DAIT$="March 23/87"
310 YR$="/87"
320 CLS$=CHR$(24):FF$=CHR$(12):	  REM CLEAR SCREEN AND FORM FEED
330 FOR I=1 TO 12
340	READ MON$(I)
350 NEXT I
360 DATA "Jan ","Feb ","Mar ","Apr ","May ","Jun "
370 DATA "Jul ","Aug ","Sep ","Oct ","Nov ","Dec "
380 PRINT CLS$
390 PRINT SPC(18) "---==={ PBBS Caller Activity Summary }===---"
400 PRINT SPC(24) "by Ian Cottrell and Klaus Bartels":PRINT
410 PRINT TAB((71-LEN(VER$)-LEN(DAIT$))/2);"Version ";VER$;" ";DAIT$
420 PRINT:PRINT
430 INPUT "Please enter name of the input file ";CNME$
440 F$=CNME$:GOSUB 1670:CNME$=F$
450 PRINT
460 PRINT "Please wait, processing file ...":PRINT
470 MRG=8:REM  Number of spaces from margin to start print
480 LEQ$=STRING$(66,"="): LDSH$=STRING$(66,"-")
490 COUNT=0
500 OPEN "I",#1,CNME$
510 LINE INPUT#1,A$
520 DATE$=MID$(A$,1,5)+YR$
530 GOSUB 1360:SDATE$=DATE$
540 CLOSE
550 OPEN "I",#1,CNME$
560 OPEN "R",#2,"CALLERS.TMP",40
570 FIELD#2,24 AS NAM$,3 AS NL$,9 AS LD$,3 AS TIM$,1 AS NU$
580 WHILE NOT EOF(1)
590	LINE INPUT#1,A$
600	DATE$=LEFT$(A$,5)+YR$:GOSUB 1360
610	STRT$=MID$(A$,7,5):FINSH$=MID$(A$,13,5)
620	STIME=VAL(LEFT$(STRT$,2))*60+VAL(RIGHT$(STRT$,2))
630	FTIME=VAL(LEFT$(FINSH$,2))*60+VAL(RIGHT$(FINSH$,2))
640	IF STIME>FTIME THEN FTIME=FTIME+24*60
650	TOS=FTIME-STIME
660	NME$=MID$(A$,26,19)
670	LOCN$=MID$(A$,45,17)
680	FOR K=1 TO COUNT
690	    IF NME$=NME$(K) THEN GOSUB 1630
700	NEXT K
710	IF MAT=1 THEN MAT=0:GOTO 750
720	COUNT=COUNT+1:NOL=1:NME$(COUNT)=NME$:P=COUNT
730	PRINT CHR$(13);
740	PRINT "Number of different users: ";:PRINT USING "####";COUNT;
750	LSET NAM$=NME$:LSET NL$=MKI$(NOL)
760	LSET LD$=DATE$:LSET TIM$=MKI$(TOS):LSET NU$=" "
770	PUT#2,P
780 WEND
790 EDATE$=DATE$
800 PRINT:PRINT:PRINT "Splitting first and last names...":PRINT
810 FOR JJ=1 TO COUNT
820	IF INKEY$=CHR$(3) THEN PRINT "<ABORTED>":STOP
830	GET #2,JJ
840	NME$(JJ)=NAM$
850	REC(JJ)=JJ
860	REM  Split first and last name
870     CKF=0
880     FOR JN=1 TO 30
890	    CHECK$=MID$(NME$(JJ),JN,1)
900	    IF CHECK$=" " THEN CKF=JN-1:JN=30
910     NEXT JN
920     ANME$(JJ)=LEFT$(NME$(JJ),CKF)
930     BNME$(JJ)=RIGHT$(NME$(JJ),LEN(NME$(JJ))-CKF-1)
940	FOR ZZ=LEN(BNME$(JJ)) TO 1 STEP -1
950	    IF MID$(BNME$(JJ),ZZ,1)<>" " THEN CNT=ZZ:ZZ=1
960	NEXT ZZ
970	BNME$(JJ)=LEFT$(BNME$(JJ),CNT)+", "
980 NEXT JJ
990 GOSUB 1400: REM  Sort on last names
1000 PG=1:PG1=(COUNT+49)\50
1010 GOSUB 1280: REM  Print header
1020 CNTR=0
1030 REM  Now print it all
1040 FOR JJ=1 TO COUNT
1050	GET#2,REC(JJ)
1060	NOL(JJ)=CVI(NL$):TOS(JJ)=CVI(TIM$)
1070	LDATE$(JJ)=LD$
1080	LPRINT  SPC(MRG) BNME$(JJ);ANME$(JJ);
1090	LPRINT TAB(38+MRG);:LPRINT USING "####";NOL(JJ);
1100	LPRINT "   ";
1110	LPRINT USING "########";TOS(JJ);
1120	LPRINT "     " LDATE$(JJ)
1130	TOTNOL=TOTNOL+NOL(JJ)
1140	TOTTOS=TOTTOS+TOS(JJ)
1150	CNTR=CNTR+1:IF CNTR=50 THEN CNTR=0:PG=PG+1:LPRINT FF$:GOSUB 1280
1160 NEXT JJ
1170 LPRINT SPC(MRG) LDSH$
1180 LPRINT SPC(MRG) "[Total Users this period: ";
1190 LPRINT USING"####";COUNT;:LPRINT "]";SPC(7):LPRINT USING "####";TOTNOL;
1200 LPRINT SPC(3):LPRINT USING "########";TOTTOS
1210 LPRINT SPC(MRG) LEQ$
1220 LPRINT SPC(MRG) "(Summary derived from file " CNME$;
1230 LPRINT " using CALLSTAT.BAS)"
1240 LPRINT FF$:PRINT "Done.":PRINT
1250 KILL "CALLERS.TMP":CLOSE
1260 END
1270 REM  *****  Print page header on printer  *****
1280 LPRINT SPC(MRG) LEQ$
1290 LPRINT SPC(MRG) SPC(21) "Summary of PBBS Activity"
1300 LPRINT SPC(MRG+15) "From:  " SDATE$ " To:  " EDATE$ "     Page";
1310 LPRINT PG "of" PG1
1320 LPRINT SPC(MRG) LDSH$
1330 LPRINT SPC(MRG) SPC(15) "NAME" SPC(20) "NOL     TOT TOS      LAST"
1340 LPRINT SPC(MRG) LDSH$
1350 RETURN
1360 MON=VAL(LEFT$(DATE$,2))
1370 MONTH$=MON$(MON):DATE$=MONTH$ + RIGHT$(DATE$,5)
1380 RETURN
1390 REM  Sort names using QSORT
1400 PRINT "Sorting user list by last name...":PRINT
1410 S=1:STACK(S)=1:STACK(S+1)=COUNT
1420 WHILE S>0
1430	L=STACK(S):R=STACK(S+1):S=S-2
1440	WHILE L<R
1450	    I=L:J=R:X$=BNME$((L+R)/2)
1460	    WHILE I<=J
1470	        WHILE BNME$(I)<X$
1480	            I=I+1
1490	        WEND
1500	        WHILE X$<BNME$(J)
1510	            J=J-1
1520	        WEND
1530	        IF I<=J THEN GOSUB 1600:I=I+1:J=J-1
1540	    WEND
1550	    IF I<R THEN S=S+2:STACK(S)=I:STACK(S+1)=R
1560	    R=J
1570	WEND
1580 WEND
1590 RETURN
1600 SWAP BNME$(I),BNME$(J):SWAP ANME$(I),ANME$(J)
1610 SWAP REC(I),REC(J)
1620 RETURN
1630 GET#2,K
1640 NOL=CVI(NL$)+1:TOS=TOS+CVI(TIM$)
1650 MAT=1:P=K:K=COUNT
1660 RETURN
1670 REM  Convert lower case string to upper case for filenames
1680 IF F$="" THEN RETURN
1690 F1$=F$
1700 FOR JJ=1 TO LEN(F$)
1710	MID$(F1$,JJ,1)=FN UC$(MID$(F$,JJ,1))
1720 NEXT JJ
1730 F$=F1$:RETURN
EN RETURN
1690 F1$=F$
1700 FOR JJ=1 TO LEN(F$)
1710	MID$(F1$,J