100 REM  *********************************************************************
110 REM  *                                                                   *
120 REM  *                            MSGCONV.BAS                            *
130 REM  *                                                                   *
140 REM  *  Program to convert an MBBS message file to one usable by PBBS.   *
150 REM  *                                                                   *
160 REM  *                Written April 09/86 by Ian Cottrell                *
170 REM  *                                       Sysop, ICBBS                *
180 REM  *                                       Ottawa, Ontario, Canada     *
190 REM  *                                       613-996-9774                *
200 REM  *                                                                   *
210 REM  *    NOTE:  You must boot MBASIC with the following command:        *
220 REM  *                                                                   *
230 REM  *                       MBASIC /F:4                                 *
240 REM  *           or this program will not run.                           *
250 REM  *********************************************************************
260 DIM A$(17),B$(20)
270 OPEN "R",#1,"SUMMARY.BBS",128: REM  open MBBS summary
280 OPEN "I",#2,"MESSAGES.BBS":    REM  and messages files
290 OPEN "R",#3,"MSGINDEX.PBS",100:REM  Now do the same
300 OPEN "R",#4,"MESSAGES.PBS",64: REM  for PBBS
310 REM  Structure of MBBS SUMMARY.BBS file
320 REM
330 REM  NUM$    = message number - 2 characters
340 REM  YY$     = year message was posted - 2 characters
350 REM  MM$     = month message was posted - 2 characters
360 REM  DD$     = day message was posted - 2 characters
370 REM  MIN$    = minute that message was posted - 2 characters
380 REM  HOUR$   = hour that message was posted - 2 characters
390 REM  SND$    = Sender's name - 29 characters
400 REM  RCV$    = Receiver's name - 50 characters
410 REM  SUB$    = subject - 30 characters
420 REM  PRFLG$  = private flag (Y=private, N=public) - 1 character
430 REM  FLG$    = unknown flag - 1 character
440 REM  STFLG$  = status flag (N=normal, Y=deleted, C=comment, *=bulletin)
450 REM            - 1 character
460 REM  DN2$    = unknown variable - 2 characters
470 REM  LNG$    = length of message (in 32 byte units) - 2 characters
480 REM  DN4$    = unknown variable (always seems to be 01) - 2 characters
490 REM
500 REM  For structure of PBBS files, see PBBS.DOC
510 REM
520 FIELD #1,2 AS NUM$,2 AS YY$,2 AS MM$,2 AS DD$,1 AS MIN$,1 AS HOUR$,

     29 AS SND$,50 AS RCV$,30 AS SUB$, 1 AS PRFLG$, 1 AS FLG2$,1 AS STFLG$,

     2 AS DN2$, 2 AS LNG$,2 AS DN4$
530 FIELD #3,30 AS TWO$,2 AS NMB$,3 AS DATE$,1 AS RECS$,2 AS STREC$,

    2 AS MIREC$,26 AS SUBJ$,30 AS FROM$,1 AS PRIV$,3 AS UNUSED$
540 FIELD #4,64 AS LNE$
550 CNT=2
560 REM  Initialize Starting Record Number, Msg Index Record Number and 
570 REM   Record Number
580 SRECNUM=0:MIRECNUM=1:RECNUM=1
590 REM  This loop reads entire summary files and then finds the correct
600 REM   entries in the message file.  It then writes out the MSGINDEX.PBS
610 REM   and MESSAGES.PBS files.
620 WHILE NOT EOF(1)
630	J=1:K=1:TOTAL=0
640	GET #1,CNT: REM  Get record from MBBS summary file
650	LNG=ASC(LNG$)*32: REM  LNG is length of message in characters
660	NUM=CVI(NUM$): REM  Message number
670	IF FLG=0 THEN LINE INPUT#2,A$(J) ELSE A$(J)=Z$:FLG=0
680	IF KEEP<>0 THEN A$(J)=RIGHT$(A$(J),KEEP):KEEP=0
690	TOTAL=TOTAL+LEN(A$(J))+2: REM  Count characters (+ CR,LF)
700	IF LNG<TOTAL THEN KEEP=TOTAL-LNG-2:Z$=A$(J):FLG=1:GOTO 750
710	B$=B$+" "+A$(J)
720	IF LEN(B$)>64 THEN B$(K)=LEFT$(B$,64):B$=RIGHT$(B$,LEN(B$)-64):

         K=K+1:GOTO 720
730	J=J+1
740	GOTO 670
750	B$(K)=B$:B$(K)=LEFT$(B$(K)+CHR$(13)+CHR$(13)+STRING$(64,0),64):B$=""
760	IF STFLG$="Y" THEN PRINT "<DELETED>":GOTO 1300: REM if deleted, skip
770	RECEIVER$=LEFT$(RCV$,30): REM Convert "TO" name
780	FOR Z=30 TO 1 STEP -1
790	    IF MID$(RECEIVER$,Z,1)<>" " THEN BRK=Z:Z=1
800	NEXT Z
810	RECEIVER$=LEFT$(RECEIVER$,BRK)
820	FOR Z=29 TO 1 STEP -1: REM Convert "FROM" name
830	    IF MID$(SND$,Z,1)<>" " THEN BRK=Z:Z=1
840	NEXT Z
850	SENDER$=LEFT$(SND$,BRK)
860	MIN$=HEX$(ASC(MIN$)):HOUR$=HEX$(ASC(HOUR$))
870	TIME$=LEFT$(HOUR$,1)+RIGHT$(HOUR$,1)+":"+LEFT$(MIN$,1)+RIGHT$(MIN$,1)

         +":00"
880	C$="Left  "+TIME$+", "+MM$+"/"+DD$+"/"+YY$+"."+CHR$(13)
890	D$="For   "+RECEIVER$
900	C$=C$+D$+STRING$(64,1)
910	C$=LEFT$(C$,63)+CHR$(13)
920	D$="From  "+SENDER$+CHR$(13)+CHR$(13)+STRING$(64,1)
930	D$=LEFT$(D$,64)
940	LSET LNE$=C$:PUT #4,RECNUM: REM  Time, Date and "FOR"
950	LSET LNE$=D$:PUT #4,RECNUM+1: REM "FROM"
960	RECNUM=RECNUM+2
970	FOR Z=1 TO K
980	    PRINT B$(Z): REM  Print as we go so we can check
990	    LSET LNE$=B$(Z):B$(Z)=""
1000	    PUT #4,RECNUM-1+Z
1010	NEXT Z
1020	PRINT
1030	REM  Now convert data for MSGINDEX.PBS
1040	DAIT$=CHR$(VAL(MM$))+CHR$(VAL(DD$))+CHR$(VAL(YY$))
1050	LINES$=MKI$(K+2)
1060	RECNUM$=MKI$(RECNUM):RECNUM=RECNUM+K
1070	SRECNUM$=MKI$(SRECNUM):SRECNUM=SRECNUM+2+K
1080	MIRECNUM$=MKI$(MIRECNUM):MIRECNUM=MIRECNUM+1
1090	RECEIVER$=LEFT$(RECEIVER$+STRING$(30,0),30)
1100	SENDER$=LEFT$(SENDER$+STRING$(30,0),30)
1110	SUBJECT$=LEFT$(SUB$,26)
1120	FOR Z=26 TO 1 STEP -1
1130	    IF MID$(SUBJECT$,Z,1)<>" " THEN BRK=Z:Z=1
1140	NEXT Z
1150	SUBJECT$=LEFT$(LEFT$(SUBJECT$,BRK)+STRING$(26,0),26)
1160	IF PRFLG$<>"Y" THEN PRFLG=0 ELSE PRFLG=1
1170	PFLAG$=CHR$(PRFLG)
1180	PAD$=STRING$(3,0)
1190	LSET TWO$=RECEIVER$
1200	LSET NMB$=NUM$
1210	LSET DATE$=DAIT$
1220	LSET RECS$=LINES$
1230	LSET STREC$=SRECNUM$
1240	LSET MIREC$=MIRECNUM$
1250	LSET SUBJ$=SUBJECT$
1260	LSET FROM$=SENDER$
1270	LSET PRIV$=PFLAG$
1280	LSET UNUSED$=PAD$
1290	PUT #3,MIRECNUM-1
1300	CNT=CNT+1
1310	INPUT R$
1320 WEND
1330 REM
1340 REM  Now close all files and get ready to write INDEX.PBS
1350 REM
1360 CLOSE
1370 OPEN "R",#1,"INDEX.PBS": REM  Open INDEX.PBS
1380 FIELD #1,3 AS DATE$,2 AS NEXTREC$,2 AS NEXTNUM$,2 AS RECS$,2 AS CALLERS$,

     2 AS USERS$,2 AS USERECS$,1 AS SPARE$,1 AS HARD$,3 AS LDATEU$,3 AS LTIMU$,

     3 AS LDATEM$,3 AS LTIMM$,71 AS UNUSED$
1390 GET #1,1
1400 INPUT "Current Date (MMDDYY - no separators) ";D$
1410 MM$=LEFT$(D$,2):DD$=MID$(D$,3,2):YY$=RIGHT$(D$,2)
1420 DAIT$=CHR$(VAL(MM$))+CHR$(VAL(DD$))+CHR$(VAL(YY$))
1430 SRECNUM=SRECNUM+1:SRECNUM$=MKI$(SRECNUM)
1440 NUM$=MKI$(NUM)
1450 MIREC$=MKI$(MIRECNUM-1)
1460 U$=STRING$(71,0)
1470 X1$=CALLERS$
1480 X2$=USERS$
1490 X3$=USERECS$
1500 X4$=SPARE$
1510 X5$=HARD$
1520 X6$=LDATEU$
1530 X7$=LTIMU$
1540 X8$=LDATEM$
1550 X9$=LTIMM$
1560 LSET DATE$=DAIT$
1570 LSET NEXTREC$=SRECNUM$
1580 LSET NEXTNUM$=NUM$
1590 LSET RECS$=MIREC$
1600 LSET CALLERS$=CALLERS$
1610 LSET USERS$=USERS$
1620 LSET USERECS$=USERECS$
1630 LSET SPARE$=SPARE$
1640 LSET HARD$=HARD$
1650 LSET LDATEU$=LDATEU$
1660 LSET LTIMU$=LTIMU$
1670 LSET LDATEM$=DAIT$
1680 LSET LTIMM$=LTIMM$
1690 LSET UNUSED$=U$
1700 PUT #1,1
1710 CLOSE:END
660 LSET LTIMU$=LTIMU$
1670 LSET LDATEM$