100 REM  *********************************************************************
110 REM  *                                                                   *
120 REM  *                           CONVMBBS.BAS                            *
130 REM  *                                                                   *
140 REM  *      Program to convert an MBBS Users file to one usable by       *
150 REM  *             PBBS.  Based on SRBBS.BAS by Russ Pencin.             *
160 REM  *                                                                   *
170 REM  *                Written April 06/86 by Ian Cottrell                *
180 REM  *                                       Sysop, ICBBS                *
190 REM  *                                       Ottawa, Ontario, Canada     *
200 REM  *                                       613-996-9774                *
210 REM  *                                                                   *
220 REM  *********************************************************************
230 REM  UNAME$ = User's first and last names and city/prov or state - 42 char
240 REM  OT$    = maximum time allowed on system - 1 char
250 REM  PASS$  = password - 6 char
260 REM  YY$	= year of last logon - 2 char
270 REM  MM$    = month of last logon - 2 char
280 REM  DD$    = day of last logon - 2 char
290 REM  MO$    = time on system last time - 2 char
300 REM  LOGS$  = number of logons - 2 char
310 REM  LMESS$ = high message last time - 2 char
320 REM  USER$  = highest user # allowed - 1 char
330 REM  DRV$   = higest drive allowed - 1 char
340 REM  ACC$   = access flags as below
350 REM
360 REM           flag:  prv  uld  dld  cpm  wr  rd  bbs  sys
370 REM            bit:   7    6    5    4   3   2    1    0
380 REM
390 CLR$=CHR$(26):PRINT CLR$:	REM  Clear screen code
400 PRINT TAB(18) "-={ MBBS to PBBS User File Conversion }=-"
410 PRINT TAB(22) "================================="
420 PRINT:PRINT:PRINT "Please ensure that USERS.BBS, SUMMARY.BBS and USERS.PBS"
430 PRINT " (created by PINSTAL.COM) are on the same drive/user as"
440 PRINT " this file.":PRINT
450 PRINT "All files in place (Y/N)? ";
460 R$=INKEY$:IF R$="" THEN 460
470 PRINT R$:IF R$<>"Y" AND R$<>"y" THEN 1640
480 OPEN "R",#1,"SUMMARY.BBS",128:REM  Open summary file to get # of users
490 GET #1,1 : FIELD #1, 10 AS D$, 2 AS UT$
500 UT=CVI(UT$) : CLOSE #1
510 REM
520 REM  Be sure to run PINSTAL.COM to create USERS.PBS before attempting
530 REM   to convert an MBBS file
540 REM
550 OPEN "R",#1,"USERS.BBS",64:REM  Open MBBS users file
560 OPEN "R",#2,"USERS.PBS",100:REM  and PBBS users file
570 REM
580 REM  Do NOT change the following field statements
590 REM
600 FIELD #1, 42 AS UNAME$,1 AS OT$,6 AS PASS$,2 AS YY$,2 AS MM$,2 AS DD$,

    2 AS MO$,2 AS LOGS$,2 AS LMESS$,1 AS USER$,1 AS DRV$,1 AS ACC$
610 FIELD #2,1 AS X1$,30 AS X2$,20 AS X3$,10 AS X4$,12 AS X5$,2 AS X6$,

    3 AS X7$,1 AS X8$,1 AS X9$,1 AS X10$,19 AS X11$
620 PRINT CLR$
630 REM
640 REM  This loop reads each entry from USERS.BBS and converts it to
650 REM   a format acceptable to PBBS, then writes it to USERS.PBS
660 REM
670 FOR C=4 TO UT
680	REM  Enter a CTL-C to abort program
690	IF INKEY$=CHR$(3) THEN PRINT "<ABORTED>":GOTO 1630
700	GET #1,C:REM  Get record from USERS.BBS
710	RUFLAG$=CHR$(1):REM  Set record used flag to 1
720	REM
730	REM  Take MBBS first name, last name and location (42 characters,
740	REM  space  filled) and convert to name (30 characters, 0 filled)
750	REM   and location (20 characters, 0 filled) for PBBS
760	REM
770	X1=INSTR(UNAME$,";")
780	FSTNME$=LEFT$(UNAME$,X1-1)
790	NNAME$=RIGHT$(UNAME$,LEN(UNAME$)-X1)
800	X2=INSTR(NNAME$,";")
810	LNME$=LEFT$(NNAME$,X2-1)
820	NME$=FSTNME$+" "+LNME$+STRING$(30,0)
830	NME$=LEFT$(NME$,30)
840	NNAME$=RIGHT$(NNAME$,LEN(NNAME$)-X2)
850	FOR I=LEN(NNAME$) TO 1 STEP -1
860	     IF MID$(NNAME$,I,1)<>" " THEN CNT=I:I=1
870	NEXT I
880	PLACE$=LEFT$(LEFT$(NNAME$,CNT)+STRING$(20,0),20)
890	REM
900	REM  Phone numbers are not kept by MBBS, so fake one for now
910	REM  Numbers for existing users will have to be entered by hand
920	REM
930	PHN$="613-555-1212"
940	REM
950	REM  Passwords are only 6 characters long under MBBS, space filled,
960	REM   so remove extra spaces and zero fill to 10 places
970	REM
980	FOR I=LEN(PASS$) TO 1 STEP -1
990	     IF MID$(PASS$,I,1)<>" " THEN CNT=I:I=1
1000	NEXT I
1010	PWD$=LEFT$(LEFT$(PASS$,CNT)+STRING$(10,0),10)
1020	REM
1030	REM  Convert number of logons from ASCII to binary for PBBS
1040	REM
1050	LOGS=CVI(LOGS$)
1060	LOGM=INT(LOGS/256)
1070	LOGL=LOGS-LOGM*256
1080	LOGONS$=CHR$(LOGL)+CHR$(LOGM)
1090	REM
1100	REM  Convert date of last logon to binary
1110	REM
1120	LASTON$=CHR$(VAL(MM$))+CHR$(VAL(DD$))+CHR$(VAL(YY$))
1130	REM
1140	REM  The level assigned here is based on the access flags obtained
1150	REM   from MBBS.  This is an arbitrary choice and you may want to
1160	REM   change it to suit your own preferences
1170	REM
1180	ACC=ASC(ACC$)
1190	OT=ASC(OT$)
1200	IF ACC=0 THEN LEVEL=1:REM  Access flag=0 means personna non grata
1210	IF ACC=7 THEN LEVEL=2:REM  Users with read only access
1220	IF ACC=15 THEN LEVEL=4:REM  Users with no CP/M access
1230	IF ACC>15 THEN LEVEL=5:REM  Normal, unvalidated user
1240	IF ACC>15 AND OT=60 THEN LEVEL=6:REM  Normal, validated user
1250	IF ACC>15 AND OT>60 THEN LEVEL=7:REM  Special user
1260	IF ACC=255 THEN LEVEL=8:REM  Super user (co-sysop)
1270	LEVEL$=CHR$(LEVEL)
1280	REM
1290	REM  Since there will be a new message base, set the message
1300	REM   waiting flag to zero for all users
1310	REM
1320	MWFLAG$=CHR$(0)
1330	REM
1340	REM  Set initial drive/user to A0:
1350	REM  Any changes can be made with PBBSMNT
1360	REM
1370	INIDU$=CHR$(0)
1380	REM
1390	REM  Pad the rest of the record (up to 100 characters) with 0
1400	REM
1410	PAD$=STRING$(100,0)
1420	REM
1430	REM Now move all data to random file buffer
1440	REM
1450	LSET X1$=RUFLAG$:	REM  Record used flag
1460	LSET X2$=NME$:		REM  User's first and last names
1470	LSET X3$=PLACE$:	REM  City/province or state
1480	LSET X4$=PWD$:		REM  Password
1490	LSET X5$=PHN$:		REM  Phone number
1500	LSET X6$=LOGONS$:	REM  Number of signons
1510	LSET X7$=LASTON$:	REM  Last date on
1520	LSET X8$=LEVEL$:	REM  Access level
1530	LSET X9$=MWFLAG$:	REM  Mail waiting flag
1540	LSET X10$=INIDU$:	REM  Initial drv/usr specs
1550	LSET X11$=PAD$:		REM  Padded with 0 to end of record
1560	PRINT "Transferring:  #";C;"  ";NME$
1570	PUT #2,C-3:		REM  Now write data to USERS.PBS
1580 NEXT C
1590 CLOSE
1600 PRINT CLR$:PRINT:PRINT
1610 PRINT "Now run PBBSMNT.COM and rehash your new users file."
1620 PRINT:PRINT:PRINT "Done...":PRINT
1630 END
1640 PRINT:PRINT
1650 PRINT "Please mount the required files and run the program again."
1660 PRINT:PRINT
1670 GOTO 1630

164