
; XMK484-1.ASM - XMODEMxx overlay file for Kaypro 4'84 with Internal Modem
;========================================================================
;
;
; This overlay has been tested with MBYE36 and XMDM106.
;
; Set the USECON equate to YES in MBYE3x and leave the CONOUT set to
; 00000h in this overlay for local console display feature.
;
; Set LSPEED equate to YES (in this overlay) if using MBYE3x or BYE3x.
;
; Assemble with ASM or MAC, and then link with your version of XMODEM:
;
;           MLOAD XMDMK484=XMDM106.COM,XMK484-1
;
;=======================================================================
;
; 05/12/85  Initial version  ---- Terry Carroll
;				  The Poor Man's RCP/M
;				  Bedford, Texas
;				  817-283-9167
;				  24 hours, 300/1200 Baud
;
;=======================================================================
; 
; Define True and False
;
YES:	  EQU	0FFH
NO:	  EQU	0
;
;=======================================================================
;
; Modem & Data Equates
;
MODDATP:  EQU	0DH		;data in port for Kaypro 4'84 Internal Modem
MODCTLP:  EQU	MODDATP+2	;control/status port
MODSNDB:  EQU	04H		;bit to test for send
MODSNDR:  EQU	04H		;value when ready
MODRCVB:  EQU	01H		;bit to test for receive
MODRCVR:  EQU	01H		;value when ready
MODDCDB:  EQU	08H		;carrier detect bit
MODDCDA:  EQU	08H		;value when active
MODPARE:  EQU	10H		;value for parity error
MODOVRE:  EQU	20H		;value for overrun error
MODFRME:  EQU	40H		;value for framing error
MODRESI:  EQU   10H		;reset external status/interrupts
MODERES:  EQU   30H		;error reset
;
;
LSPEED:	  EQU	YES		;true if using MBYE3x or any BYE3-xx
				;false if using 'SPEED' manual selection
MSPEED:	  EQU	3CH		;location of baud rate factor (MBYE3x)
;
XSPEED:	  EQU	1		;1 = 300
;
BASE:	  EQU	100H		;start of cp/m normal program area
;
;=======================================================================
;
; Jump table: The jump table must be in exactly the same sequence as the
; one in XMODEM.
;
	  ORG	BASE+3		;start after 'JMP BEGIN'
;
CONOUT:   JMP	00000H		;must be 00000h (leave me alone)
PMINIT:	  JMP	MINIT		;initialization routine (if needed)
PUNINIT:  JMP	UNINIT		;undo whatever 'MINIT' did (or return)
PSENDR:	  JMP	SENDR		;send character (via pop psw)
PCAROK:	  JMP	CAROK		;test for carrier
PMDIN:	  JMP	MDIN		;receive data byte
PGETCHR:  JMP	GETCHR		;get character from modem
PRCVRDY:  JMP	RCVRDY		;check receive ready
PSNDRDY:  JMP	SNDRDY		;check send ready
PSPEED:	  JMP	SPEED		;get speed value for file transfer time
PEXTRA1:  JMP	EXTRA1		;extra for custom routine
PEXTRA2:  JMP	EXTRA2		;extra for custom routine
PEXTRA3:  JMP	EXTRA3		;extra for custom routine
;
;=======================================================================
;
; ---> CAROK - check for presence of carrier.  RET with Z = carrier on
;
CAROK:
	MVI	A,MODRESI	;reset external status/interrupts
	OUT	MODCTLP
	IN	MODCTLP		;get status
	ANI	MODDCDB		;get carrier detect bit
	CPI	MODDCDA		;test bit
	RET
;
;=======================================================================
;
EXTRA1:	RET			;for later use
EXTRA2:	RET			;for later use
EXTRA3:	RET			;for later use
;
;=======================================================================
;
; ---> GETCHR - get a character, same as MDIN
; ---> MDIN - - get a character, same as GETCHR
;
GETCHR:
MDIN:	IN	MODDATP		;get character from data in port
	RET
;
;=======================================================================
;
MINIT:	RET			;no initialization required
;
;=======================================================================
;
; ---> RCVRDY - check receive ready.  RET with Z = character available.
;	        Return with error code in A-reg.
;
RCVRDY:	IN	MODCTLP		;get modem status
	PUSH	B		;save scratch register
	PUSH	PSW
	MVI	A,1+MODRESI	;select read register 1
	OUT	MODCTLP
	IN	MODCTLP		;read the error status
	ANI	MODFRME+MODOVRE+MODPARE
	MOV	B,A		;save it for a moment
	MVI	A,MODERES
	OUT	MODCTLP		;do an error reset command
	POP	PSW		;now get modem status back
	ANI	MODRCVB		;isolate ready bit
	CPI	MODRCVR		;test it
	MOV	A,B		;get the error code char. back
	POP	B
	RET
;
;=======================================================================
;
; ---> SENDR - send character
;
SENDR:	POP	PSW		;get the character back
	OUT	MODDATP		;send it to the modem output
	RET
;
;=======================================================================
;
; ---> SNDRDY - check if ready to send.
;
SNDRDY:	IN	MODCTLP		;get status byte
	ANI	MODSNDB		;isolate ready bit
	CPI	MODSNDR		;ready to send?
	RET
;
;=======================================================================
;
; ---> SPEED - sets the time shown for program transfer.
;
SPEED:	EQU	$
;
	 IF	LSPEED
	LDA	MSPEED		;get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	;get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;=======================================================================
;
UNINIT:	RET			;not initialized, so no 'UN-INITIALIZE'
;
;=======================================================================
;
	END
