;
; ========================================================================
;  KMZRB-1.ASM - MB-KMD patch file for the ZORBA BIOS and HAYES SMARTMODEM
; ========================================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the ZORBA BIOS and a
; HAYES SMARTMODEM or equivalent.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMZRB-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 09/20/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility		- Michael Conley
; 05/27/84 - Updated					- J.E. Crowell
; 04/26/84 - Edited					- Donald G. Krantz
;
;
; ==============
;
NO	EQU	00H
YES	EQU	0FFH
;
MSPORT	EQU	21H		; Status register for rs232
TXRDY	EQU	1		; Bit to test for ready to send
RXRDY	EQU	2		; Bit to test for received data
DPORT	EQU	20H		; Data port
CONOUT	EQU	0E20CH		; Console output jump vector v1.7 +
BASE:	EQU	100H		; Start of TPA
MSPEED:	EQU	03CH 		; Patch location to agree with your version
				; of BYE
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
; Note the ORG of 103H - This jump table has no jump to BEGIN.
;
	 ORG	BASE+3		; Start after JMP BEGIN
;
PCONOUT: JMP	CONOUT		; CRT out vector (MUST BE JMP 0 IF NOT IMPLEM.)
PMINIT:	 JMP	MINIT		; Initialize whatever has to be (or do RET)
PUNINIT: JMP	UNINIT		; Undo whatever MINIT did (or RET)
PSENDR:	 JMP	SENDR		; Send data byte on stack (POP PSW / OUT)
PCAROK:	 JMP	CAROK		; Test for carrier. RET Z=ok, NZ=no carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	MDIN		; IN from modem data only
PRCVRDY: JMP	RCVRDY		; Check receive ready RET Z=ready
PSNDRDY: JMP	SNDRDY		; Check send ready RET Z=ready
PSPEED:	 JMP	SPEED		; Get speed factor in ACC
PSPARE1: JMP	SPARE		; 3 jumps for custom routines
PSPARE2: JMP	SPARE
PSPARE3: JMP	SPARE
;
;
; ==============
;
SPARE:				; For later use
MINIT:				; No initialization required
UNINIT:	
	RET
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
; RET with Z = character available.  Return with error code in A-reg.
;
RCVRDY:
	IN	MSPORT		; Get status
	ANI	RXRDY		; Mask
	SUI	RXRDY		; Z = ready
	RET			; Done
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:
	IN	MSPORT		; Get status
	ANI	TXRDY		; Mask
	SUI	TXRDY		; Z = ready
	RET			; Done
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:
	POP	PSW		; Load up the character from the stack
	OUT	DPORT		; Send char
	RET
;
;
; ==========================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN - get a character, same as GETCHR
; ==========================================
;
GETCHR:
MDIN:
	IN	DPORT		; Get character from data port
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
; Use the first speed if setting up MB-KMD to agree with BYE, else, use the
; second speed (which only displays the time at 300 baud).
;
SPEED:
	LDA	MSPEED		; Get byte stored at MSPEED location
	RET
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
; 
; RET with Z = carrier on
;
CAROK:
	IN	MSPORT
	ANI	80H		; Mask DSR
	XRI	80H
	RET
;
;
	END
