;
; ====================================================================
;  KMSSC-4.ASM - MB-KMD patch file for the APPLE SUPER SERIAL/CCS 7711
; ====================================================================
;
; >>>>>>>IMPORTANT   This overlay will require you to set LARGEIO to YES
;		     in the main MB-KMD program.  The size allowance
;		     needed is 090H bytes.
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the APPLE SUPER SERIAL
; or CCS 7711 card.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMSSC-4
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 09/20/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility 	- Michael Conley
; 11/15/85 - Created to support the Apple Super Serial
;	     or CCS 7711 board.  Included options for
;	     Applicard or Softcard CP/M protocols. Also,
;	     added DCDMOD conditional assembly for those
;	     who want a better way around the lack of a
;	     DCD output on these cards.			- Chris Hays
; 05/01/83 - Updated to XMODEM75			- R L Berg
; 04/04/83 - Updated to XMODEM74			- Irv Hoff
; 03/27/83 - Updated to XMODEM73			- Irv Hoff
; 03/17/83 - Updated to XMODEM72			- Irv Hoff
; 03/15/83 - Updated to XMODEM71			- Irv Hoff
; 03/07/83 - Added instructions on how to adapt this
;	     file to XMODEM70.COM.  Standardized the
;	     format.  Added automatic MSPEED from "BYE"
;	     program. Added CONOUT information. Adapted
;	     from XM70PMMI.				- Irv Hoff
;
;
; ============================================
; Carrier Detection and the APPLE SUPER SERIAL
; ============================================
;
; Apple finally gave us a decent communications interface in the SUPER SERIAL
; CARD.  Unfortunately, no one at Apple computer has ever set up a bbs,
; apparently, so they decided not to give us the DCD line off of the 6551
; ACIA chip.
;
; Up until now, the only way around this was to use the line intended for the
; modem's DSR (data set ready), which Apple did provide on the card.  If you
; choose this route, you must make a wiring change in your modem cable
; connecting pin 8 (DCD) FROM the modem to pin 6 (DSR) going to the Apple. To
; avoid confusion,  you could just reverse the wires on 6 and 8 at one end of
; the cable (only), as pin 8 doesn't go anywhere in the apple.  Note that the
; same holds true for the APPLE II-C, but the pin numbers are different.
; Consult your owners manual for the correct pins.
;
; This method works fine for your bbs software,  but the problem is that if
; you have any commercial telecommunications software (such as ASCII Express),
; it will expect the cable to be wired normally and will malfunction if you
; present it with this new configuration.  After contemplating switches,
; alternate cables and the like,  I came up with a decent solution which I am
; labeling DCDMOD.  Having been an Apple hacker for over five years, I
; remembered a dear old friend, the game I/O connector. DCDMOD involves
; lifting the wire going to pin 8 on the SSC, and connecting it via a suitable
; protective resistor to the BUTTON0 port on the game connector.  The resistor
; should be at least 2000 ohms and probably no greater than 10000 ohms (the
; RS232 output of the modem is +/- 12 volts).  Our bye/xmodem software is then
; set for DCDMOD, which makes it look for the carrier bit on the game button.
; The cable wiring is left normal, and our ASCII express, or whatever, is
; happy.
;
; NOTE:  If you are uncomfortable with wiring and soldering things you should
;	 get the assistance of someone who is competent to do this sort of
;	 thing.  A wiring error could cost you a nasty repair bill. The
;	 author(s) assume no responsibility for ANY consequences of the use
;	 or mis use of this material.
;
;				Chris Hays, La Canada MBBS-RCPM
;  
;  
; ==============
;
YES:	 EQU	0FFH
NO:	 EQU	0
;
APLICAR: EQU	NO		; Yes,  using Applicard/Starcard
				; No, for Softcard compatibility
				; (including Z-Ram in AppleII-C)
;
DCDMOD:	 EQU	NO		; Yes if DCD connected to game I/O 
				; BUTTON0 input.  You must use a 
				; 2000 to 10000 ohm buildout resistor.
				; See discussion above.
;
;	
; ==============
;
	  IF	APLICAR
OFFSET:	 EQU	0		; No hardware offset for applicard
	  ENDIF
;
	  IF	NOT APLICAR
OFFSET:	 EQU	2000H		; Offset for softcard types
	  ENDIF
;
	  IF	DCDMOD
BUT0:	 EQU	0C061H+OFFSET	; For carrier detect
	  ENDIF
;
SLOT:	 EQU	2		; For SSC/CCS
SLOTVAL: EQU	(SLOT*16)+OFFSET; Allows relocating modem slot
MODDATP: EQU	0C088H+slotval	; Data IN port
STATUS:  EQU	0C089H+slotval	; Control/status port
MODSNDB: EQU	10H		; Bit to test for send
MODSNDR: EQU	10H		; Value when ready
MODRCVB: EQU	08H		; Bit to test for receive
MODRCVR: EQU	08H		; Value when ready
;
	  IF	DCDMOD
MODDCDB: EQU	80H		; Carrier detect bit
MODDCDA: EQU	80H		; Value when active
	  ENDIF
;
	  IF	NOT DCDMOD
MODDCDB: EQU	40H		; Carrier detect bit (SSC DSR)
MODDCDA: EQU	00H		; Value when active
	  ENDIF
;
LSPEED:	 EQU	YES		; Yes,  using 'BYE' with speed selection
				; No,  using 'SPEED' manual selection
MSPEED:	 EQU	3CH		; Location of baud rate factor (Set by
				; 'BYE')  Set location in 'BYE' to agree.
				; 3DH and 3EH often used by newer versions
				; of 'ZCPR'.
XSPEED:	 EQU	1		; Speed for file time transfer without
				; auto-set.  Use one of the following:
				; 0=110 1=300 2=450 3=600 4=710 5=1200
BASE:	 EQU	100H		; Start of CP/M normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
; Note the ORG of 103H - This jump table has no jump to 'BEGIN'.
;
	  ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:   JMP	0000H		; Must be at 0000H if not used, see below
PMINIT:	  JMP	MINIT		; Initialization routine (If needed)
PUNINIT:  JMP	UNINIT		; Undo whatever 'MINIT' did (Or return)
PSENDR:	  JMP	SENDR		; Send character (via POP PSW)
PCAROK:	  JMP	CAROK		; Test for carrier
PMDIN:	  JMP	MDIN		; Received data byte
PGETCHR:  JMP	GETCHR		; Get character from modem
PRCVRDY:  JMP	RCVRDY		; Check receive ready
PSNDRDY:  JMP	SNDRDY		; Check send ready
PSPEED:	  JMP	SPEED		; Get speed value for file transfer time
PEXTRA1:  JMP	EXTRA1		; Extra for custom routine
PEXTRA2:  JMP	EXTRA2		; Extra for custom routine
PEXTRA3:  JMP	EXTRA3		; Extra for custom routine
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
; RET with Z = carrier on
;
CAROK:
	PUSH	D
;
	 IF	DCDMOD
	LXI	D,BUT0		; Check for carrier
	 ENDIF
;
	 IF	NOT DCDMOD
	LXI	D,STATUS
	 ENDIF
;
	CALL	PEEK
	POP	D
	ANI	MODDCDB		; Get carrier detect bit
	CPI	MODDCDA		; Test bit
	RET
;
;
; ==============
;
EXTRA1:	RET			; For later use
EXTRA2:	RET			; For later use
EXTRA3:	RET			; For later use
;
;
; ==========================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN - get a character, same as GETCHR
; ==========================================
;
GETCHR:
MDIN:
	PUSH	D
	LXI	D,MODDATP
	CALL	PEEK		; Get the character, if any
	POP	D
	RET
;
;
; ==============
;
MINIT:	RET			; No initialization required
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
; RET with Z = character available.  Return with error code in A-reg.
;
RCVRDY:
	PUSH	D
	LXI	D,STATUS
	CALL	PEEK
	POP	D
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	RET
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:
	POP	PSW		; Get the character back
	PUSH	D
	LXI	D,MODDATP
	CALL	POKE		; Send it to the modem output
	POP	D
	RET
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:
	PUSH	D
	LXI	D,STATUS
	CALL	PEEK
	POP	D
	ANI	MODSNDB		; Isolate ready bit
	CPI	MODSNDR		; Ready to send?
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:
	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
; ==============
;
UNINIT:	RET			; Not initialized, so no 'UN-INITIALIZE'
;
;
; ==============
;
	 IF	NOT APLICAR
PEEK:	XCHG		; DE to HL
	MOV	A,M
	XCHG		; Restore HL/DE
	RET
;
POKE:	XCHG
	MOV	M,A	; Put byte away
	XCHG		; Restore
	RET
	 ENDIF
;
;
	IF	APLICAR	;		==============================
			;		  PEEK/POKE calling routines
			;		==============================
;
RDBYTE	  EQU	0FFE0H	; Read a byte from Apple (A = byte)
WRBYTE	  EQU	0FFE3H	; Write a byte to Apple (C = byte)
RDWORD	  EQU	0FFE6H	; Read 2 bytes from Apple (DE = bytes)
WRWORD	  EQU	0FFE9H	; Write 2 bytes to Apple (DE = bytes)
RDNBYTS	  EQU	0FFECH	; Read N bytes (DE = count, HL = buffer)
WRNBYTS	  EQU	0FFEFH	; Write N bytes (DE = count, HL = buffer)
;
PEEK1BYTE EQU	6	; Command to PEEK 1 byte in the Apple
POKE1BYTE EQU	7	; Command to POKE 1 byte in the Apple
;
;
; ===========================
; PEEK at 1 byte in the Apple
; ===========================
;
; ENTRY: DE = address.  EXIT:	A = data.
;
PEEK:
	PUSH	B
	MVI	C,PEEK1BYTE
	CALL	WRBYTE
	CALL	WRWORD
	CALL	RDBYTE
	POP	B
	RET
;
;
; ==========================
; POKE 1 byte into the Apple
; ==========================
;
; ENTRY: DE = address.  EXIT:	A = data
;
POKE:
	PUSH	B
	MOV	B,A
	MVI	C,POKE1BYTE
	CALL	WRBYTE
	CALL	WRWORD
	MOV	C,B
	CALL	WRBYTE
	POP	B
	RET
	 ENDIF
;
;
	END
