;
; ==================================================================
;  KMSS-1.ASM - MB-KMD patch file for the ADVANCED DIGITAL SUPER SIX
; ==================================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the SUPER SIX Z80
; DART CHANNEL B serial port.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMSS-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 08/21/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility 	- Michael Conley
; 09/11/84 - First Version.  Based on XMLB-1.ASM	- Bob Connolly
;
;
; ==============
; 
YES:	 EQU	0FFH
NO:	 EQU	0
;
MODDATP: EQU	02H		; Data in port
MODDATO: EQU	MODDATP		; Data out port	
MODCTLP: EQU	MODDATP+1	; Control/status port.
MODDCD:	 EQU	00010000B	; Value for RI
MODDAV:	 EQU	00000001B	; Value for data available.
MODBMT:	 EQU	00000100B	; Value for output buffer empty.
;
LSPEED:	 EQU	YES		; Yes,  using 'BYE' with speed selection
				; No,  using 'SPEED' manual selection
MSPEED:	 EQU	3CH		; Location of baud rate factor (set by
				; 'BYE')  set location in 'BYE' to agree.
				; 3DH and 3EH often used by newer versions
				; of 'ZCPR'.
XSPEED:	 EQU	1		; Speed for file time transfer without
				; auto-set.  use one of the following:
				; 0=110 1=300 2=450 3=600 4=710 5=1200
BASE	 EQU	100H		; start of CP/M normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
; Note the ORG of 103H - This jump table has no jump to 'BEGIN'.
;
	 ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:	 JMP	0000H		; Please check using procedure below.
PMINIT:	 JMP	MINIT		; Initialization routine (if needed)
PUNINIT: JMP	UNINIT		; Undo whatever 'MINIT' did (or return)
PSENDR:	 JMP	SENDR		; Send character (via POP PSW)
PCAROK:	 JMP	CAROK		; Test for carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	GETCHR		; Get character from modem
PRCVRDY: JMP	RCVRDY		; Check receive ready
PSNDRDY: JMP	SNDRDY		; Check send ready
PSPEED:	 JMP	SPEED		; Get speed value for file transfer time
PEXTRA1: JMP	EXTRA1		; Extra for custom routine
PEXTRA2: JMP	EXTRA2		; Extra for custom routine
PEXTRA3: JMP	EXTRA3		; Extra for custom routine
;
;
; ================================================================
; To Display the Record Count on the CRT During Program Transfers:
; ================================================================
;	
;    This one addition requires some work on the part of the user.  When
; "BYE" is added,  CP/M is normally moved lower to accomodate the new
; program above CP/M.  Whenever BYE is called to enable the RCPM capability,
; it steals some of the addresses contained in the BIOS jump vector table.
; In order to display on the CRT during program transfers you need to get
; into the BIOS console output routine directly,  else what is being
; displayed also tries to go out the modem.  This is a big NO-NO at that
; time.  (This cannot be done automatically by MB-KMD,  since BYE has
; already taken the address we need to find,  by the time MB-KMD is auto-
; matically activated by the remote station.)
;
;    So,  with the disk containing BYE, but prior to activating BYE, do
; this:
;	1) Cold reboot to move CP/M (and BIOS) to the new area needed
;            when BYE is activated on the same disk.
;	2) Use DDT and dump the area from 0000H to 0002H.  This gives
;	     the warm reboot address in BIOS.
;	3) Add 9 Bytes to that address to get your console output jump
;	     vector.
;	4) Pick off the address contained in the jump vector and install
;	     that in "CONOUT", below.  Example of one system in use:
;
;  FIRST, COLD REBOOT WITH DISK CONTAINING "BYE"
;
;	  0000  C3 03 EE     (location of warm reboot on disk with BYE
;
;  PRIOR TO ACTIVATING BYE BUT ON SAME DISK
;
;	  EE03  C3 AA EF    (BIOS warm reboot jump vector on this disk)
;	  EE06  C3 06 F5    (BIOS get console status routine)
;	  EE09  C3 11 F5    (BIOS console input routine)
;	  EE0C  C3 48 F5    (BIOS console output routine)
;
;		The address we need is thus F548.  Put that below, in
;		our example it would be:    CONOUT   JMP   0F548H
;
;CONOUT:  JMP	0F548H		;If you wish to show the record count
;				; during program transfer, fill in this
;				; address at 'CONOUT' above.
;
;						- Irv Hoff
;
; PLEASE NOTE: These addresses are for example only.  You will have to 
; follow the example above to find the correct address of conout.
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
; RET with Z = carrier on
;
CAROK:	IN	MODCTLP		; Get status
	ANI	MODDCD		; Get RI bit
	CPI	MODDCD		; Test bit
	RET
;
;
; ==============
;
EXTRA1:	RET			; For later use
EXTRA2:	RET			; For later use
EXTRA3:	RET			; For later use
;
;
; ==========================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN - get a character, same as GETCHR
; ==========================================
;
GETCHR:
MDIN:	IN	MODDATP		; Get character from data in port
	RET
;
;
; ==============
;
MINIT:	RET			; No initialization required,
				; BYE has already done it for us.
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
; RET with Z = character available. Return with error code in A-reg.
;
RCVRDY:	IN	MODCTLP		; Get modem status
        ANI     MODDAV
        CPI     MODDAV
        MOV     A,0
	RET
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:	POP	PSW		; Get the character back
	OUT	MODDATO		; Send it to the modem output
	RET
;
; 
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:	IN	MODCTLP		; Get status byte
	ANI	MODBMT		; Isolate ready bit
	CPI	MODBMT		; Ready to send?
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
; ==============
;
UNINIT:	RET			; Not initialized, so no 'UN-INITIALIZE'
;
; ==============
;
;
	END
