;
; =========================================================
;  KMSM-1.ASM - MB-KMD patch file for the SMARTMODEM w/8251
; =========================================================
;
;
;  This is an extremely "generic" overlay and would be well
;  suited as a model if you decide to create a new overlay.
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the HAYES SMARTMODEM
; and 8251 I/O.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMSM-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
;
; 09/20/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility		- Michael Conley
; 11/17/83 - Renamed to XMSM-1.ASM			- Irv Hoff
; 02/11/83 - Edited					- Sigi Kluger
;
;
; ==============
;
MODCTLP: EQU	3		; Base port address
MODSNDB: EQU	1		; Bit to test fot send
MODSNDR: EQU	1		; Value when ready
MODRCVB: EQU	2		; Bit to test for receive
MODRCVR: EQU	2		; Value when ready
MODDCDB: EQU	1		; Carrier detect bit
MODDCDA: EQU	1		; Value when active
MODDATP: EQU	MODCTLP-1	; Data IN port
MODDATO: EQU	MODCTLP-1	; Data OUT port
BAUDRP:	 EQU	5		; Baud rate output/modem status
;
BASE:	 EQU	100H		; Start of TPA
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
; Note the ORG of 103H - This jump table has no jump to BEGIN.
;
	 ORG	BASE+3		;start after JMP BEGIN
;
CONOUT:	 JMP	00000H		; CRT out vector (MUST BE JMP 0 IF NOT IMPLEM.)
PMINIT:	 JMP	MINIT		; Initialize whatever has to be (or do RET)
PUNINIT: JMP	UNINIT		; Undo whatever MINIT did (or RET)
PSENDR:	 JMP	SENDR		; Send data byte on stack (POP PSW / OUT)
PCAROK:	 JMP	CAROK		; Test for carrier. RET Z=ok, NZ=no carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	GETCHR		; IN from modem data only
PRCVRDY: JMP	RCVRDY		; Check receive ready RET Z=ready
PSNDRDY: JMP	SNDRDY		; Check send ready RET Z=ready
PSPEED:	 JMP	SPEED		; Get speed factor in ACC
PSPARE1: JMP	SPARE		; 3 jumps for custom routines
PSPARE2: JMP	SPARE
PSPARE3: JMP	SPARE
;
;
; ==============
;
SPARE:			 	; For later use
MINIT:				; No initialization required
UNINIT:	RET			; Not initialized, so no un-initialize.
;
;
; ===============================
; SNDRDY - check if ready to send
; ===============================
;
SNDRDY:	IN	MODCTLP		; Get status byte
	ANI	MODSNDB		; Mask off bit to be tested
	XRI	MODSNDR		; Set status flag
	RET
;
;
; ======================
; SENDR - send character
; ======================
;
SENDR:	POP	PSW		; Get character from stack
	OUT	MODDATO		; Send character
	RET
;
;
; ============================
; RCVRDY - check receive ready
; ============================
;
; RET with Z = character available.  RET error code in A
;
RCVRDY:	IN	MODCTLP
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	MVI	A,0
	RET
;
;
; ================================================
; MDIN - receive a character (GETCHR is identical)
; ================================================
;
GETCHR:
MDIN:	IN	MODDATP		; Get character
	RET			; Return it
;
;
; ===========================================
; SPEED - This routine returns the speed code
; ===========================================
;
; 0=110, 1=300, 2=450, 3=600, 4=710, 5=1200  Load your speed byte from low
; memory, or simply MVI A,n and RET for default speed only
;
SPEED:	IN	BAUDRP
	ANI	2
	MVI	A,1
	RZ
	MVI	A,5
	RET
;
;
; =====================================
; CAROK - check for presence of carrier
; =====================================
;
; RET with Z = carrier on
;
CAROK:	IN	BAUDRP		; Get status
	ANI	MODDCDB		; Get cd bit
	CPI	MODDCDA		; Test bit
	RET
;
;
	END