;
; ========================================================
;  KMRS4-0.ASM - MB-KMD patch file for the TRS-80 MODEL IV
; ========================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the TRS-80 MODEL IV
; (TR1865 UART and WD1943 BRG) computer.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMRS4-0
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
;
; 09/07/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility		- Michael Conley
; 06/15/85 - First version for TRS-80 Model IV		- Tom Brady
;
;
; ==============
;
NO	EQU	0
YES	EQU	0FFH
;
;  Modem/UART equates
;
MSPORT 	EQU	0E8H		; Modem status port
USPORT	EQU	0EAH		; UART status port
DPORT  	EQU	0EBH		; Data holding register I/O
MSNDRDY	EQU	040H		; Modem send ready bit      1=true
MRCVRDY	EQU	080H		; Modem receive ready bit   1=true
CDOK	EQU	020H		; Carrier detect bit        1=true
;
;  General equates
;
; If not specified in BYE, make certain USECON EQU NO in XMODEM.ASM and
; remove the ';' from before 'CONOUT'.  Change at Label JCONOUT from NOUSE
; to CONOUT.
;
;CONOUT	EQU	0EC02H		; Console output routine address - yours
				; may differ - see note above.
BYSPEED	EQU	YES		; YES = use BYE baud rate factor at 03CH
				; NO  = set your own
MSPEED	EQU	03CH		; Modem speed found here from BYE, or
				; 1=300, 5=1200, 6=2400 only if BYSPEED = NO
;
;
; ===========
; Jump Table:
; ===========
;
; Must be in the exact sequence as in MB-KMD.  This starts after JMP BEGIN
; at 103H.
;
	ORG	0103H		; Start after JMP BEGIN
;
JCONOUT:JMP	NOUSE		; CRT out vector (MUST BE '0' IF NOT USED)
JMINIT:	JMP	NOUSE		; Initialization
JUNINIT:JMP	NOUSE		; Undo what MINIT did
JSENDR:	JMP	SENDIT		; Send data byte on stack 
JCARCK:	JMP	MDCARCK		; Carrier check (NZ=no carrier)
JMDINP:	JMP	MDINP		; Read data byte
JGETCHR:JMP	MDINP		; Read data byte - garbage collection
JRCVRDY:JMP	RCVRDY		; Check receive ready
JSNDRDY:JMP	SNDRDY		; Check send ready
JSPEED:	JMP	SPEED		; Get MSPEED value
SPARE1:	JMP	NOUSE	
SPARE2:	JMP	NOUSE
SPARE3:	JMP	NOUSE
;
;
; =============
;
; We won't use these jumps, so return.
;
NOUSE:	RET
;
;
; Read UART for receive status
;
RCVRDY:	IN	USPORT		; Read UART status port
	ANI	MRCVRDY		; Mask receive ready
	CPI	MRCVRDY		; Z = ready
	RET
;
;
; Read UART for send status
;
SNDRDY:	IN	USPORT		; Read UART status port
	ANI	MSNDRDY		; Mask crap
	CPI	MSNDRDY		; Z = ready
	RET
;
;
; Send character along...
;
SENDIT:	POP	PSW		; Get character from stack
	OUT	DPORT		; Sendit
	RET
;
;
; Get character waiting
;
MDINP:	IN	DPORT		; Read the data port
	RET
;
; 
; Get value of MSPEED from BYE or your own setting.  See note above.
; 
SPEED:	 IF	BYSPEED		; If using BYE baud rate factor
	LDA	MSPEED		; Speed byte stored at this location
	RET
	 ENDIF
;
	 IF	NOT BYSPEED	; If using your own
	MVI	A,MSPEED	; notes above
	 ENDIF
;
;
; Check for carrier
;
MDCARCK:IN	MSPORT		; Read modem status port
	ANI	CDOK		; Mask carrier detect
	RET
;
;
	END