;
; =======================================================
;  KMOSCP-1.ASM - MB-KMD patch file for the OSBORNE MODEM
; =======================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the OSBORNE 01 and the
; OSBORNE COMM-PAC modem.  
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMOSCP-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 10/26/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility		- Michael Conley
; 01/16/84 - Adapted from XMEX-1 by Irv Hoff		- John Riehl	
;
;
;
; NOTE: The following options must be set as shown in the MB-KMD assembly
;       file.
;
; LARGEIO:	EQU	YES
; LARSIZE:	EQU	0B0H
;
; USECON:	EQU	NO	; If you are running MB-KMD with BYE3/5
;				; or MBYExx.
;
; ==============
; 
YES:	EQU	0FFH
NO:	EQU	0
;
; Only one of the following can be yes and the others no.  If you have none
; of the below,  you will have to use DDT to find out where the 5th JMP
; instruction in your BIOS jumps to and use it for the JMP at 103H. Set all
; three equates below to NO
;
BIOS13:	 EQU	NO		; Yes = Osborne uses BIOS 1.3
BIOS14:  EQU	YES		; Yes = Osborne uses BIOS 1.4 or 1.41
BIOS144: EQU	NO		; Yes = Osborne uses BIOS 1.44+ 
				;      (Nuevos Electronics 80 column mod.)
;
; ==============
;
MODDATP: EQU	2A01H		; Data in port
MODDATO: EQU	MODDATP		; Data out port
MODCTLP: EQU	MODDATP-1	; Control/status port
MODSNDB: EQU	2		; Bit to test for send
MODSNDR: EQU	2		; Value when ready
MODRCVB: EQU	1		; Bit to test for receive
MODRCVR: EQU	1		; Value when ready
MODDCDB: EQU	4		; Carrier detect bit
MODDCDA: EQU	4		; Value when active
MODPARE: EQU	40H		; Value for parity error
MODOVRE: EQU	10H		; Value for overrun error
MODFRME: EQU	20H		; Value for framing error
;
LSPEED:	 EQU	YES		; Yes, using 'BYE' with speed selection
				; No, using 'SPEED' manual selection
MSPEED:	 EQU	3CH		; Location of baud rate factor (set by
				; 'BYE')  set location in 'BYE' to agree.
				; 3DH and 3EH often used by newer versions
				; of 'ZCPR'.
XSPEED:	 EQU	1		; Speed for file time transfer without
				; auto-set.  Use one of the following:
				; 0=110 1=300 2=450 3=600 4=710 5=1200
BASE:	 EQU	100H		; Start of CP/M normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
; Note the ORG of 103H - This jump table has no jump to 'BEGIN'.
;
	 ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:	  IF	BIOS13
	 JMP	0E915H		; BIOS 1.3 console output routine
	  ENDIF			; BIOS13
;
	  IF	BIOS14
	 JMP	0E738CH		; BIOS 1.4 console output routine
	  ENDIF			; BIOS14
;
	  IF	BIOS144		; BIOS 1.44+ console output routine
	 JMP	0E749H
	  ENDIF			; BIOS144
;
	  IF (NOT BIOS13) AND (NOT BIOS14) AND (NOT BIOS144)
	 JMP	0000H		; Put your BIOS console out jump address here
	  ENDIF
;
PMINIT:	 JMP	MINIT		; Initialization routine (if needed)
PUNINIT: RET ! NOP ! NOP	; Not required
PSENDR:	 JMP	SENDR		; Send character (via pop psw)
PCAROK:	 JMP	CAROK		; Test for carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	GETCHR		; Get character from modem
PRCVRDY: JMP	RCVRDY		; Check receive ready
PSNDRDY: JMP	SNDRDY		; Check send ready
PSPEED:	 JMP	SPEED		; Get speed value for file transfer time
POSTAT:  JMP	OSTAT		; Get I/O status
PEXTRA1: RET ! NOP ! NOP	; Extra for custom routine
PEXTRA2: RET ! NOP ! NOP	; Extra for custom routine
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
;  RET with Z = carrier on
;
CAROK:	CALL	POSTAT		; Get status
	ANI	MODDCDB		; Get carrier detect bit
	PUSH	PSW
	CNZ	MDIN
	POP	PSW
	RET
;
;
; =================================================================
; --> GETCHR - - initialize if not already done, then get character
; --> MDIN - - get a character
; =================================================================
;
GETCHR:	CALL	MINIT
MDIN:	JMP	OSIN		; Get character from data in port
;
;
; ==============
;
; This is the Osborne initialization routine which is required to relocate
; the memory mapped above 4000H.
;
INITFLG:  DB	0		; Initialization flag
;	
MINIT:	  LDA	INITFLG		; Have we been here before?
	  ORA	A
	  RNZ			; If yes, exit
	  INR	A
	  STA	INITFLG
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  LXI	H,OSIN		; Get address of first byte to move
	  LXI	D,0A000H	; Get place to put first byte
	  LXI	B,RCVRDY-OSIN	; Get length of code to move
	  DB	0EDH,0B0H	; Z80 LDIR
;
	  LXI	H,0A000H	; Get new address of OSIN
	  SHLD	MDIN+1		; PATCH CALL FOR "GET CHAR." ROUTINE
	  LXI	H,0A000H+OSOUT-OSIN
	  SHLD	SENDR+2		; PATCH CALL FOR "SEND CHAR." ROUTINE
	  LXI	H,0A000H+OSTAT-OSIN
	  SHLD	POSTAT+1	; PATCH CALL FOR "GET STATUS" ROUTINE
	  POP	H
	  POP	D
	  POP	B
	  RET
;
;
; ==============
;
; Routines that get placed just under 'BYE'
;
OSIN:	DI			; Disable interrupts
	OUT	0		; Switch to alternate page
	LDA	MODDATP		; Get data byte
	OUT	1		; Switch pages back
	EI			; Re-enable interrupts
	RET
;
;
OSOUT:	DI			; Disable interrupts
	OUT	0		; Switch to alternate page
	STA	MODDATO		; Send data byte
	OUT	1		; Switch pages back
	EI			; Re-enable interrupts
	RET
;
;
OSTAT:	DI			; Disable interrupts
	OUT	0		; Switch to alternate page
	LDA	MODCTLP		; Get status byte
	OUT	1		; Switch pages back
	EI			; Re-enable interrupts
	RET
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
;  RET with Z = character available.  Return with error code in A-reg.
;
RCVRDY:	CALL	POSTAT		; Get modem status
	PUSH	B		; Save scratch register
	PUSH	PSW		; Check error status
	ANI	MODFRME+MODOVRE
	MOV	B,A		; Save it for a moment
	POP	PSW
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	MOV	A,B		; Get the error code char. back
	POP	B
	RET
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:	POP	PSW		; Get the character back
	JMP	OSOUT		; Send it to the modem output
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:	CALL	POSTAT		; Get status byte
	ANI	MODSNDB		; Isolate ready bit
	CPI	MODSNDR		; Ready to send?
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
	END
