;
; =========================================================================
;  KMK484-1.ASM - MB-KMD patch file for the KAYPRO 4'84 with INTERNAL MODEM
; =========================================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the KAYPRO 4'84 with
; INTERNAL MODEM
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMK484-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 08/22/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility 	- Michael Conley
; 05/12/85 - Initial version  				- Terry Carroll
;
;
; ==============
;
YES:	  EQU	0FFH
NO:	  EQU	0
;
MODDATP:  EQU	0DH		; Data in port for Kaypro 4'84 Internal Modem
MODCTLP:  EQU	MODDATP+2	; Control/status port
MODSNDB:  EQU	04H		; Bit to test for send
MODSNDR:  EQU	04H		; Value when ready
MODRCVB:  EQU	01H		; Bit to test for receive
MODRCVR:  EQU	01H		; Value when ready
MODDCDB:  EQU	08H		; Carrier detect bit
MODDCDA:  EQU	08H		; Value when active
MODPARE:  EQU	10H		; Value for parity error
MODOVRE:  EQU	20H		; Value for overrun error
MODFRME:  EQU	40H		; Value for framing error
MODRESI:  EQU   10H		; Reset external status/interrupts
MODERES:  EQU   30H		; Error reset
;
LSPEED:	  EQU	YES		; Yes,  using MBYE3x or any BYE3-xx
				; No,  using 'SPEED' manual selection
MSPEED:	  EQU	3CH		; Location of baud rate factor (MBYE3x)
XSPEED:	  EQU	1		; 1 = 300
BASE:	  EQU	100H		; Start of CP/M normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
;
	  ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:   JMP	00000H		; Must be 00000h (leave me alone)
PMINIT:	  JMP	MINIT		; Initialization routine (if needed)
PUNINIT:  JMP	UNINIT		; Undo whatever 'MINIT' did (or return)
PSENDR:	  JMP	SENDR		; Send character (via pop psw)
PCAROK:	  JMP	CAROK		; Test for carrier
PMDIN:	  JMP	MDIN		; Receive data byte
PGETCHR:  JMP	GETCHR		; Get character from modem
PRCVRDY:  JMP	RCVRDY		; Check receive ready
PSNDRDY:  JMP	SNDRDY		; Check send ready
PSPEED:	  JMP	SPEED		; Get speed value for file transfer time
PEXTRA1:  JMP	EXTRA1		; Extra for custom routine
PEXTRA2:  JMP	EXTRA2		; Extra for custom routine
PEXTRA3:  JMP	EXTRA3		; Extra for custom routine
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
;  RET with Z = carrier on
;
CAROK:
	MVI	A,MODRESI	; Reset external status/interrupts
	OUT	MODCTLP
	IN	MODCTLP		; Get status
	ANI	MODDCDB		; Get carrier detect bit
	CPI	MODDCDA		; Test bit
	RET
;
;
; ==============
;
EXTRA1:	RET			; For later use
EXTRA2:	RET			; For later use
EXTRA3:	RET			; For later use
;
;
; ==========================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN - get a character, same as GETCHR
; ==========================================
;
GETCHR:
MDIN:	IN	MODDATP		; Get character from data in port
	RET
;
;
; ==============
;
MINIT:	RET			; No initialization required
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
;  RET with Z = character available.  Return with error code in A-reg.
;
RCVRDY:	IN	MODCTLP		; Get modem status
	PUSH	B		; Save scratch register
	PUSH	PSW
	MVI	A,1+MODRESI	; Select read register 1
	OUT	MODCTLP
	IN	MODCTLP		; Read the error status
	ANI	MODFRME+MODOVRE+MODPARE
	MOV	B,A		; Save it for a moment
	MVI	A,MODERES
	OUT	MODCTLP		; Do an error reset command
	POP	PSW		; Now get modem status back
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	MOV	A,B		; Get the error code char. back
	POP	B
	RET
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:	POP	PSW		; Get the character back
	OUT	MODDATP		; Send it to the modem output
	RET
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:	IN	MODCTLP		; Get status byte
	ANI	MODSNDB		; Isolate ready bit
	CPI	MODSNDR		; Ready to send?
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:	EQU	$
;
	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
; ============== 
;
UNINIT:	RET			; Not initialized, so no 'UN-INITIALIZE'
;
; ==============
;
;
	END
