
;
; ==============================================================
;  KMDG-1.ASM - MB-KMD patch file for the DIGITAL GROUP with IOP
; ==============================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts any version of MB-KMD to run with the DIGITAL GROUP
; computer with an IOP processor card.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
;       MLOAD KMD=MB-KMD,KMDG-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 10/26/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/21/86 - Created to work with MB-KMD		- Bob Kramer
;
;
; ==============
; 
YES:	 EQU	0FFH
NO:	 EQU	0
;
; Values shown are for an 8251A
;
MODCTLP: EQU	049H		; First control/status port
MODDATP: EQU	048H		; Data in port
MODSNDB: EQU	1		; Bit to test for send
MODSNDR: EQU	1		; Value when ready
MODRCVB: EQU	2		; Bit to test for receive
MODRCVR: EQU	2		; Value when ready
MODDCDB: EQU	4		; Carrier detect bit
MODDCDA: EQU	0		; Value when active
;
LSPEED:	 EQU	YES		; Yes,  using 'BYE' with speed selection
				; No,  using 'SPEED' manual selection
MSPEED:	 EQU	3CH		; Location of baud rate factor (set by
				; 'BYE').  set location in 'BYE' to agree.
				; 3DH and 3EH often used by newer versions
	 			; of 'ZCPR'.
XSPEED:	 EQU	5		; Speed for file time transfer without
				; auto-set.  use one of the following:
				; 0=110 1=300 2=450 3=600 4=710 5=1200
BASE:	 EQU	100H		; Start of CP/M normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
;
	 ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:	 JMP	00000H		; Must be 00000h if not used, see below
				; (may be changed to  jmp  crtout, if
				; routine below is used)
PMINIT:	 JMP	MINIT		; Initialization routine (if needed)
PUNINIT: JMP	UNINIT		; Undo whatever 'MINIT' did (or return)
PSENDR:	 JMP	SENDR		; Send character (via pop psw)
PCAROK:	 JMP	CAROK		; Test for carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	GETCHR		; Get character from modem
PRCVRDY: JMP	RCVRDY		; Check receive ready
PSNDRDY: JMP	SNDRDY		; Check send ready
PSPEED:	 JMP	SPEED		; Get speed value for file transfer time
PEXTRA1: JMP	EXTRA1		; Extra for custom routine
PEXTRA2: JMP	EXTRA2		; Extra for custom routine
PEXTRA3: JMP	EXTRA3		; Extra for custom routine
;
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
; RET with Z = carrier on
;
CAROK:	XRA	A
	RET
;
;
; ============================================
; --> CRTOUT - allows direct output to the CRT
; ============================================
;
; Use in place of the CONOUT address.  Do not use with memory mapped
; displays.  Change the above to CONOUT  JMP  CTROUT then change the
; following if your ports are different -- your port may not be the
; same and your 'ready bit' to check may be different.
;
CRTOUT:	RET
;
;
; ==============
;
EXTRA1:	RET			; For later use
EXTRA2:	RET			; For later use
EXTRA3:	RET			; For later use
;
;
; ==========================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN - get a character, same as GETCHR
; ==========================================
;
GETCHR:
MDIN:  	CALL	INRDY	     	; Get character from data port
	IN	MODDATP
	RET
;
; Character ready from modem?
;
INRDY:	IN	MODCTLP
	ANI	MODRCVB
	RNZ
	XRA	A
	RET
;
;
; ==============
;
MINIT:	RET			; No initialization required
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
; RET with Z = character available.  Return with error code in A-reg.
;
RCVRDY:	IN	MODCTLP		; Get modem status
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	RET
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
; (Comes here via a "JZ SENDR" so no problem with the stack because
; of the "POP PSW".
;
SENDR:	POP	PSW		; Get the character back
	CALL	OTDATP		; Send it to the modem output
	RET
;
; Out to modem
;
OTDATP:	PUSH	PSW
;
OTD1:	IN	MODCTLP
	ANI	MODSNDB
	JNZ	OTD2
	JMP	OTD1		; Try it again
;
OTD2:	POP	PSW
	OUT	MODDATP
	RET
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:	IN	MODCTLP		; Get status byte
	ANI	MODSNDB		; Isolate ready bit
	CPI	MODSNDR		; Ready to send?
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
; ==============
;
UNINIT:	RET			; Not initialized, so no 'un-initialize'
;
; ==============
;
;
	END
