;
; ====================================================================
; KMAP-1.ASM - MB-KMD patch file for APPLE II/MOUNTAIN CPS CARD/SMODEM
; ====================================================================
;
;
; =============
; Introduction:
; =============
;
; This file adapts MB-KMD to run with the Apple with a Mountain CPS Card.
;
; To use, first edit any options desired into the mainline source code of
; the transfer program, then assemble with ASM or MAC to produce a HEX file.
;
; Then edit this file as needed (check the CONOUT routine if you want to 
; locally see file transfer time and the record count while programs are 
; being sent).  Then assemble this overlay with ASM or MAC.
;
; Now merge the two .HEX files using MLOAD.COM (available on most RCP/M
; systems using the command:
;
; 	MLOAD KMD=MB-KMD,KMAP-1
;
; Then place the resulting .COM file on your system where it is accessible
; from any drive/user area (usually A0:)
;
;
; ===============
; Update History:
; ===============
;
; 08/21/86 - Edited for inclusion in MBKMDOVL.LBR	- Bob Kramer
; 08/09/86 - Inspected for MB-KMD compatibility		- Michael Conley
; 01/20/84 - Created file, adapted from XMDC-1 by Irv Hoff and M7AP-1
;	     (MDM7XX. overlay) CPS routines by Wally Hubbard.
;							- Norman Beeler
;
;
; ==============
; 
YES:	 EQU	0FFH
NO:	 EQU	0
;
SLOT	 EQU	2		; CPS slot number, usually 1 or 2 
MODCR:	 EQU	0E0FEH+SLOT*100H  ; Control port of CPS card
MODDATP: EQU	0E0FAH+SLOT*100H  ; Data port of CPS card
MODCTL1: EQU	0E0FBH+SLOT*100H  ; Status port of CPS card
MODRCVB: EQU	02H		; Bit to test for receive
MODRCVR: EQU	02H		; Value when ready
MODSNDB: EQU	01H		; Bit to test for send
MODSNDR: EQU	01H		; Value when ready
MODDCDB: EQU	01000000B	; Carrier detect bit
MODDCDA: EQU	01000000B	; Value when active
MODPARE: EQU	00001000B	; Parity error
MODOVRE: EQU	00010000B	; Overrun error
MODFRME: EQU	00100000B	; Framing error	
;
LSPEED:	EQU	YES		; Yes,  using 'BYE' with speed selection
				; No,  using 'SPEED' manual selection
MSPEED:	EQU	3CH		; Location of baud rate factor (set by
				; 'BYE')  set location in 'BYE' to agree.
				; 3DH and 3EH often used by newer versions
				; of 'ZCPR'.
XSPEED:	EQU	1		; Speed for file time transfer without
				; Auto-set.  use one of the following:
				; 0=110 1=300 2=450 3=600 4=710 5=1200
BASE:	EQU	100H		; start of cp/m normal program area
;
;
; ===========
; Jump table:
; ===========
;
; The jump table must be in exactly the same sequence as the one in MB-KMD.
;  Note the ORG of 103H - This jump table has no jump to 'BEGIN'.
;
	 ORG	BASE+3		; Start after 'JMP BEGIN'
;
CONOUT:	 JMP	00000H		; Must be 00000h if not used, see below
PMINIT:	 JMP	MINIT		; Initialization routine (if needed)
PUNINIT: JMP	UNINIT		; Undo whatever 'MINIT' did (or return)
PSENDR:	 JMP	SENDR		; Send character (via pop psw)
PCAROK:	 JMP	CAROK		; Test for carrier
PMDIN:	 JMP	MDIN		; Receive data byte
PGETCHR: JMP	GETCHR		; Get character from modem
PRCVRDY: JMP	RCVRDY		; Check receive ready
PSNDRDY: JMP	SNDRDY		; Check send ready
PSPEED:	 JMP	SPEED		; Get speed value for file transfer time
PEXTRA1: JMP	EXTRA1		; Extra for custom routine
PEXTRA2: JMP	EXTRA2		; Extra for custom routine
PEXTRA3: JMP	EXTRA3		; Extra for custom routine
;
;
; ================================================================
; To Display the Record Count on the CRT During Program Transfers:
; ================================================================
;	
;    This one addition requires some work on the part of the user.  When
; "BYE" is added,  CP/M is normally moved lower to accomodate the new
; program above CP/M.  Whenever BYE is called to enable the RCPM capability,
; it steals some of the addresses contained in the BIOS jump vector table.
; In order to display on the CRT during program transfers you need to get
; into the BIOS console output routine directly,  else what is being
; displayed also tries to go out the modem.  This is a big NO-NO at that
; time.  (This cannot be done automatically by MB-KMD,  since BYE has
; already taken the address we need to find,  by the time MB-KMD is auto-
; matically activated by the remote station.)
;
;    So,  with the disk containing BYE, but prior to activating BYE, do
; this:
;	1) Cold reboot to move CP/M (and BIOS) to the new area needed
;            when BYE is activated on the same disk.
;	2) Use DDT and dump the area from 0000H to 0002H.  This gives
;	     the warm reboot address in BIOS.
;	3) Add 9 Bytes to that address to get your console output jump
;	     vector.
;	4) Pick off the address contained in the jump vector and install
;	     that in "CONOUT", below.  Example of one system in use:
;
;  FIRST, COLD REBOOT WITH DISK CONTAINING "BYE"
;
;	  0000  C3 03 E0    (location of warm reboot on disk with BYE
;
;  PRIOR TO ACTIVATING BYE BUT ON SAME DISK
;
;	  E003  C3 E9 E0    (BIOS warm reboot jump vector on this disk)
;	  E006  C3 00 E9    (BIOS get console status routine)
;	  E009  C3 B7 E1    (BIOS console input routine)
;	  E00C  C3 D4 E1    (BIOS console output routine)
;
;		The address we need is thus E1D4.  Put that below, in
;		our example it would be:    CONOUT   JMP   0E1D4H
;
;
;CONOUT:  JMP	00000H		; If you wish to show the record count
;				; during program transfer, fill in this
;				; address at 'CONOUT' above.
;
;						- Irv Hoff
;
; =========================================
; --> CAROK - check for presence of carrier
; =========================================
;
;  RET with RZ = carrier on
;
CAROK:	LDA	MODCTL1		; Read modem status port
	ANI	MODDCDB		; Get carrier detect bit
	CPI	MODDCDA		; Test bit
	RET
;
;
; ==============
;
EXTRA1:	RET			; For later use
EXTRA2:	RET			; For later use
EXTRA3:	RET			; For later use
;
;
; ============================================
; --> GETCHR - get a character, same as MDIN
; --> MDIN --- get a character, same as GETCHR
; ============================================
;
GETCHR:
MDIN:	LDA	MODDATP		; Get character from data in port 
	RET
;
;
; ==============
;
MINIT:	RET			; No initialization required
;
;
; ================================
; --> RCVRDY - check receive ready
; ================================
;
;  RET with JZ = character available.  Return with error code in A-reg.
;
RCVRDY:	LDA	MODCTL1		; Get modem status
	ANI	MODRCVB		; Isolate ready bit
	CPI	MODRCVR		; Test it
	MVI	A,0		; Return with zero in A (so MB-KMD doesn't
	RET			; Think we have an error)
;
;
; ==========================
; --> SENDR - send character
; ==========================
;
SENDR:	POP	PSW		; Get the character back
	STA	MODDATP		; Send it to the modem output
	RET
;
;
; ===================================
; --> SNDRDY - check if ready to send
; ===================================
;
SNDRDY:	LDA	MODCTL1		; Read status port
	ANI	MODSNDB		; Mask off bit to be tested
	CPI	MODSNDR		; Set status flag
	RET
;
;
; ====================================================
; --> SPEED - sets the time shown for program transfer
; ====================================================
;
SPEED:	 IF	LSPEED
	LDA	MSPEED		; Get index for baud rate from 'BYE'
	 ENDIF
;
	 IF 	NOT LSPEED
	MVI	A,XSPEED	; Get index for baud rate from 'XSPEED'
	 ENDIF
;
	RET
;
;
; ==============
;
UNINIT:	RET			; Not initialized, so no 'UN-INITIALIZE'
;
; ==============
;
;
	END
