/************************************************************************/
/*	bds1.46  2.29	17mar87		misc.c				*/
/*									*/
/*	Random functions...						*/
/************************************************************************/

/************************************************************************/
/*				history 				*/
/* 86April KK,BP,MM wc networks ,userlog and...				*/
/* 83Jul13 BAK  Looking for Rcpm bug					*/
/* 83Jun11 BAK  Correcting userlog error - forces write of data.	*/
/* 83Mar12 CrT	from msg.c						*/
/* 83Mar03 CrT & SB   Various bug fixes...				*/
/* 83Feb27 CrT	Save private mail for sender as well as recipient.	*/
/* 83Feb23	Various.  transmitFile() won't drop first char on WC... */
/* 82Dec06 CrT	2.00 release.						*/
/* 82Nov05 CrT	Stream retrieval.  Handles messages longer than MAXTEXT.*/
/* 82Nov04 CrT	Revised disk format implemented.			*/
/* 82Nov03 CrT	Individual history begun.  General cleanup.		*/
/************************************************************************/

#include "229ctdl.h"

/************************************************************************/
/*				contents				*/
/*									*/
/*	download()		menu-level routine for WC-protocol sends*/
/*	patchDebug()		display/patch byte			*/
/*	putFlChar()		readFile() -> disk file interface	*/
/*	putWCChar()		filter[]s, readFile() to putMsgChar()	*/
/*	transmitFile()		send a host file, no formatting 	*/
/*	tutorial()		prints a .hlp file			*/
/*	visible()		convert control chars to letters	*/
/************************************************************************/

/************************************************************************/
/*	download() is the menu-level send-message-via-WC-protocol fn	*/
/************************************************************************/
download(whichMess, revOrder)
char whichMess, revOrder;
{
    outFlag	= OUTOK;
    echo		= NEITHER; 
    usingWCprotocol	= TRUE	 ;	/* all points bulletin		*/
    SFRunning	= TRUE; 		/* init sendWCChar coroutine	*/
    showMessages(whichMess, revOrder);

    setUp(FALSE);
    usingWCprotocol	= FALSE  ;
}

/************************************************************************/
/*	putFlChar() is used to upload files				*/
/*	returns: ERROR on problems else TRUE				*/
/*	Globals: msgBuf.mbtext is used as a buffer, to save space	*/
/*      modified 2/21/87 to return error if putC() works   .bp.		*/
/************************************************************************/
putFlChar(c)
char c;
{
 	return  putC(c, msgBuf.mbtext) /* != ERROR */ ;
}

/************************************************************************/
/*	putWCChar() filter[]s from readFile() to putMsgChar()		*/
/*	Returns: ERROR if problems, else TRUE				*/
/*	Globals: outFlag is set to OUTSKIP when an ascii EOF (^Z) is	*/
/*	    encountered, and no further text is written to disk.	*/
/************************************************************************/
int putWCChar(c)
int c;
{
    if (outFlag)	return TRUE;	/* past ascii EOF.  ignore.	*/

    if (c == ERROR) {
	/* EOF.  Note for overkill:	*/
	outFlag = OUTSKIP;
	return TRUE;
    }

    c	&= 0x7F;	/* cut high stuff off	*/

    if (c == CPMEOF) {
	/* ascii EOF.  Ignore rest of file:	*/
	outFlag = OUTSKIP;
	return TRUE;
    }
    c=filter[c];
 
    if (c!=0) return putMsgChar(c);
}

/************************************************************************/
/*	transmitFile() dumps a host file with no formatting		*/
/************************************************************************/
transmitFile(filename)
char *filename;
{
    char mAbort();
    int  getc(), sendWCChar();
    char fbuf[BUFSIZ], fname[NAMESIZE];
    int  c;

    outFlag	= OUTOK;

    unspace(filename, fname);

    if(fopen(fname, fbuf) == ERROR) {
	mPrintf("\n \n No %s\n ", fname);
        outFlag = OUTSKIP;	/*these 2 lines seem to be ignored */
	fClose(fbuf);
	return(ERROR);
				   }
    if (!usingWCprotocol) doCR(); 
    if (usingWCprotocol)   {
	SFRunning   = TRUE;
	sendWCChar('\0');	/* warm up routine	*/
    }

    while ( ((c=getc(fbuf)) != ERROR)  && ( (whichIO == CONSOLE)
					   ||
					   (interpret(pCarrDetect)) ) )
	 {
	if (!usingWCprotocol) putCh(inVis(c)); /* keep off the screen */
/*	if (whichIO == MODEM) {
*/	    if (!usingWCprotocol)	outMod(c);
	    else			if(sendWCChar(c) == ERROR)break;
/*				}
*/	if (textDownload  &&  c==CPMEOF)   break;
	if (textDownload  &&  mAbort() )   break;
	    }

    if (usingWCprotocol)   while (sendWCChar(ERROR) == FALSE);

    fClose(fbuf);
}

/************************************************************************/
/*	tutorial() prints file <filename> on the modem & console	*/
/*	Returns:	TRUE on success else ERROR			*/
/************************************************************************/
#define MAXWORD 256
tutorial(filename)
char *filename;
{
    char fbuf[BUFSIZ];
    char line[MAXWORD];
    int  toReturn;

    toReturn	= TRUE;

    outFlag	= OUTOK;
    if(fopen(filename, fbuf) == ERROR) {
	mPrintf("\n No %s\n ", filename);
	toReturn	= ERROR;
    } else {
	doCR();
	if (!expert) mPrintf("\n <J>ump <P>ause <S>top\n ");
	doCR();
	while ((fGetS(line, fbuf)) && ((whichIO==CONSOLE)
					||
					(interpret(pCarrDetect)) ))
			  mPrintf("%s", line);
	fClose(fbuf);
 	doCR();
    }
    return   toReturn;
}

/************************************************************************/
/*	visible() converts given char to printable form if nonprinting	*/
/************************************************************************/
char visible(c)
char c;
{
    if (c==0xFF)  c = '|'	;   /* start-of-message in message.buf	*/
    c		    = c & 0x7F	;   /* kill high bit otherwise		*/
    if ( c < ' ') c = c + 'A' -1;   /* make all control chars letters	*/
    if (c== 0x7F) c = 'D'	;   /* catch DELETE too 		*/
    return(c);
}


A' -1;