
; KMD23OVL.ASM	-  KMD CP/M FILE TRANSFER PROGRAM OVERLAY  -  01/11/88
;
;				  by
;			    Irvin M. Hoff
;		copyrighted (c) 1985, 1986, 1987, 1988
;
;
;	This program assembles with ASM, LASM, M80, MAC, RMAC or SLRMAC.
;	If using M80, remove the ";;" at the beginning of the ASEG line.
;
;;	ASEG		; Needed for M80, ignore for other assemblers
;
;=======================================================================
;
;	This is an universal CP/M-80 file transfer program that gets
;	its I/O (and time clock, if used) information from the BYE5
;	program itself - thus no hardware specific or time clock over-
;	lays are needed, and no overlay libraries need to be retained.
;	It uses the XMODEM protocol with either CRC or checksum.  It
;	supports automatic (or manual) 1k protocol.  It has KMD batch
;	mode that is compatible with YMODEM batch other than does not
;	use date in Julian or time in octal.  It is based on a 1979
;	program called XMODEM by Keith Petersen, which was adapted from
;	Ward Christensen's 1978 MODEM2 program.  Many of the routines
;	in the version used had been added by the the authors of this
;	program.
;					- Irv Hoff, W6FFC
;					  (415) 948-2166  (voice)
;					  (415) 948-2513  PRACSA RCPM
;
;=======================================================================
;
; Read the KMD23.UPD file to see what this and past versions have added.
; It provides you with valuable data on understanding and using the many
; support files that are available, such as FOR, NEW, KFOR, KNEW, KMDEL,
; etc.
;
;=======================================================================
;
; TO USE:
; ------
; 1) Edit the KMD23OVL.ASM overlay for desired options.  (The ones most-
;	changed are marked with an asterisk '*' in the comment field).
; 2) Assemble to a .HEX file.
; 3) Use MLOAD.COM to merge KMD23.COM with your new KMD23OVL.HEX file:
;	B>MLOAD KMD.COM=KMD23.COM,KMD23OVL.HEX.
; 4) Finished, ready to use, requires BYE5 (uses its I/O and time clock)
;	or a slightly modified XMODEM overlay if not using BYE5.
;
;
; Selecting options:
; -----------------
; Options that are most often changed are marked with ';*' at the start
; of the comment line for that option.	Simple systems not using time
; clocks, user logs, etc. will keep most of those 'NO'.  RCPM systems
; running the usual bulletin board systems, etc., will change most of
; those to 'YES'.
;
; When finished changing whatever options are desired, use your normal
; assembler to get a .HEX file of this overlay.  Then use MLOAD.COM to
; merge into the KMD.COM file with your new changes:
;
;		A>MLOAD KMD.COM=KMD23.COM,KMD23OVL.HEX
;
; MLOAD.COM is included with this overlay file, but SID.COM or DDT.COM
; may also be used to merge the KMD23OVL.HEX file with KMD23.COM if you
; then save the correct number of memory pages as the new KMDA.COM file.
;
;					- Notes by Irv Hoff W6FFC
;
;======================================================================
;
YES	EQU	0FFH
NO	EQU	0
;
CR	EQU	0DH
LF	EQU	0AH
;
;
	ORG	0100H
;
	DS	3
;
;
;-----------------------------------------------------------------------
;
; Options - change to suit your system, then assemble to get a .HEX file
;
;-----------------------------------------------------------------------
;
MHZ:	DB	4	;*Clock speed, use integer (2,4,5,8, etc.)
MSPEED:	DW	003CH	; Location of BYE5's modem speed indicator
;
;-----------------------------------------------------------------------
;
; Normal disk systems can transfer 16k from computer to disk in 2-3-4
; seconds and less.  Some very slow 5-1/4" floppy systems (such as North
; Star) may take up to 20-30 seconds to transfer 16k.  This would cause
; several timeouts at 10 seconds each.	If you experience any timeouts,
; change the BUFSIZ to somethng smaller, perhaps 8k or even 4k.
;
BUFSIZ:	DB	16	; File transfer buffer size in Kbytes
;
;-----------------------------------------------------------------------
;
DESCRIB:DB	yes	;*Yes, asks for a description of uploaded file
DRIVE:	DB	'A'	; Drive area for description of upload
USER:	DB	14	; User area for description of upload
;
;-----------------------------------------------------------------------
;
DRIVMAX:DW	003DH	; Location of MAXDRIV byte
USRMAX:	DW	003FH	; Location of MAXUSER byte
WHEEL:	DW	003EH	;*Location of ZCMD or ZCPR2 wheel byte.  If
			;   using if ZCPR3, run SHOW.COM to find correct
			;   address for the WHEEL byte.
;-----------------------------------------------------------------------
;
; The following will all be available for the SYSOP's personal use when
; the wheel byte is set in local non-zero (0FFH) mode.	If not using a
; wheel byte, select manually with a YES.
;
NOCOMR:	DB	NO	; NO = change .COM to .OBJ and .PRL to .OBP
NOCOMS:	DB	no	;*Permit sending .COM files?
NOLBS:	DB	NO	; Permit sending .??# files?
NOSYS:	DB	NO	; Permit sending .SYS files?
;
;-----------------------------------------------------------------------
;
ZCPR:	DB	yes	;*Yes, if using ZCMDR or ZCPR with WHEEL byte
			;   implemented.  If Yes, .NDR, .RCP and .SYS
			;   files not received.
;-----------------------------------------------------------------------
;
; Allows drive/user area to be specified for downloading.  If using ZCMD
; or ZCPR, set USEMAX 'YES'.  Then the answers to MAXDRV and MAXUSR are
; ignored.
;
USEMAX:	DB	YES	;*Yes ZCMD or ZCPR for DRIVMAX & USRMAX values
			; No to use MAXDRV and MAXUSR specified next
;
; If USEMAX above is set YES for automatic operation the following two
; are ignored.	If set NO, the following will be used.
;
MAXDRV:	DB	4	; Number of disk drives used
MAXUSR:	DB	12	; Maximum user area allowed
;
;-----------------------------------------------------------------------
;
; Selects the drive/user area for uploading private files for the SYSOP.
; This permits experimental files, replacement files and proprietary
; programs to be sent to the SYSOP.
;
PRDRV:	DB	'B'	; Private drive for SYSOP to receive file
PRUSR:	DB	15	; Private user area for SYSOP to receive file
;
;-----------------------------------------------------------------------
;
; Selects the drive/user area for downloading private files from the
; SYSOP. This permits him to put a special file in this area, then leave
; a private note to that person mentioning the name of the file and to
; use "SP".  Although anybody could download that program, they don't
; know what (if any) files are there.  A high degree of security exists,
; while the SYSOP still has the ability to make special files available.
; Thus any person can be a temporary "privileged user".  (Wildcards and
; batch are not allowed, for what should be obvious reasons.)
;
SPLDRV:	DB	'B'	; Special drive area for downloading SYSOP files
SPLUSR:	DB	15	; Special user area for downloading SYSOP files
;
;-----------------------------------------------------------------------
;
; Allows uploading to be done on a specified driver and user area so all
; viewers (including the SYSOP) can readily find the latest entries.
;
SETAREA:DB	YES	; Yes, if using designated area to receive files
DRV:	DB	'B'	;*Drive to receive file on
USR:	DB	0	; User area to receive file in
;
;-----------------------------------------------------------------------
;
; Allows separate area for another type of file, such as MS-DOS.  NEWLST
; permits putting the descriptions in with the main files, if desired.
; If YES, makes separate listing.  NIBMDR and NIBMUS will then put those
; files wherever you request - prevents overcrowding if somebody fills
; the upload area.
;
MSDOS:	DB	yes	;*Yes if using separate area for MS-DOS files
IBMDRV:	DB	'D'	; Drive to upload MS-DOS, NEW and FOR files
IBMUSR:	DB	0	; User area for IBM files
NEWLST:	DB	YES	; Yes to put MSDOS "NEW" and "FOR" lists on new
			;    new drive, NO to keep them on CP/M lists
NIBMDR:	DB	'A'	; Drive for the IBM KDM.LOG and FOR files
NIBMUS:	DB	13	; User area for the IBM KMD.LOG and FOR files
;
;-----------------------------------------------------------------------
;
MSGFIL:	DB	NO	; Yes if supporting message files, No if not
			; (Not supported by most BBS systems)
;
;-----------------------------------------------------------------------
;
; Set the following equate YES, if your BBS software sets BYE5's LCPTR
; bit-mapped flag register to restrict user's ability to download files.
; This is used on systems that require at least an occassional upload to
; allow the user to continue numerous downloads.  See BYE5.DOC for a de-
; scription of how to implement the LCPTR byte.
;
;	Bit-5  KMD downloads allowed?	  (0 = NO, 1 = YES)
;
RESUSR:	DB	yes	;*YES, if restricting downloads
;
;-----------------------------------------------------------------------
;
XCANCL:	DB	YES	; Cancel file transfer with 3 or more CTL-X's
;
;-----------------------------------------------------------------------
;
; A few spares for possible future additions so this overlay will not be
; obsolete at that time.
;
SPARES1:DB	0,0
;
;-----------------------------------------------------------------------
;		    logging options
;
; File transfer logging options
;
LOGCAL:	DB	yes	;*Yes, logs KMD transfers
LOGDRV:	DB	'A'	; Drive to place 'KMD.LOG' file
LOGUSR:	DB	14	; User area to put 'KMD.LOG' file
LASTDRV:DB	'A'	; Drive 'LASTCALR???'file is on
LASTUSR:DB	14	; User area of 'LASTCALR???' file
LCNAME:	DB	1	; Column # where the caller's name starts in
			;   LASTCALR, normally column one.  Some BBS
			;   systems start in col. 12 if CLOCK is YES.
NAMELEN:DB	2	;*Number of names in LASTCALR for a user, some
			;   BBS systems allow 3 names.	(John H. Smith)
			;   Select 2 or 3, accordingly - you can use a
			;   larger number (like 50) if you want to use
			;   up to the first CR or LF in LASTCALR.
CPM3:	DB	NO	; Yes if using CP/M 3.0 and LOGCAL is Yes
;
;		end of logging options
;-----------------------------------------------------------------------
;		 start of TIMEON area
;
CLOCK:	DB	yes	;*If YES, you must have clock code installed in
			;   BYE5 that sets RTCBUF with time/date and
			;   time-on-system.  Status and MXTIME are also
			;   picked up from BYE5.
DTOS:	DB	yes	;*Yes to display "time on system" messages
EDATE:	DB	NO	; Yes to show dd/mm/yy vice mm/dd/yy in KMD.LOG
TIMEON:	DB	yes	;*Yes to police time-on-system with BYE5
;
; NOTE: If ZCPR = YES and WHEEL byte is set, send time is unlimited.  If
;	TIMEON is YES, unlimited time is allowed if MAXMIN in BYE5 is 0.
;	Set CLOCK and TIMEON the same way in BYE5 and KMD.  Select your
;	preference and set MAXMIN in BYE5.  Suggest using 60 if CLOCK
;	and TIMEON are YES, and 45 if CLOCK is NO.  See examples below.
;
;		 TIME	300 BPS  1200 BPS 1k	2400 BPS 1k
;		------	-------  ------------	------------
;		30 min	 48.7k	  180k	 200k	 320k	380k
;		45 min	 73.1k	  270k	 300k	 480k	570k
;		60 min	 97.5k	  360k	 400k	 640k	760k
;
CREDIT:	DB	yes	;*Yes to credit upload time to BYE5's MXTIME
;
LOGLDS:	DB	yes	;*Count number of up/down loads since login.
			;   Your BBS program can check UPLDS and DNLDS
			;   when user logs out and update either the
			;   user's file or a file for this purpose.
			;   You can either modify your BBS entry program
			;   to check the LASTCALR file before updating
			;   it and then update (risky), or make a sepa-
			;   rate program that BYE calls when logging
			;   off a user (preferred).
;
UPLDS:	DW	0054H	; Clear these values to Zero from your BBS pro-
DNLDS:	DW	0055H	;   gram when somebody logs in.  NOTE:	Clear
			;   ONLY when a user logs in.  Not when he re-
			;   enters the BBS program from CP/M.
;
;		 end of TIMEON area
;-----------------------------------------------------------------------
;
; File descriptors, change as desired if this list is not suitable.
; Move the line with the terminating '$' up, if fewer descriptors are
; desired.  There are 129 extra bytes available.  Be sure to terminate
; before address 0250h.  (Can check with a .PRN file if getting close.)
;
FILDES:	DB	CR,LF,'  0) - ''C'' '	; (Extra space needed for M80)
	DB	CR,LF,'  1) - CP/M'
	DB	CR,LF,'  2) - dBASE'
	DB	CR,LF,'  3) - MS/DOS'
	DB	CR,LF,'  4) - PASCAL'
	DB	CR,LF,'  5) - RCPM/BBS'
	DB	CR,LF,'  6) - ZCPR3'
	DB	CR,LF,'  7) - Other'
	DB	CR,LF,'  8) - (spare)'
	DB	CR,LF,'  9) - (spare)'
	DB	CR,LF,'$'
;
GUIDE:	DS	0		; MUST QUIT PRIOR TO 0250H
;.....
;
	ORG	0250H
;
; This section selects the text used when sending files to different
; portions of the disk.  Not used unless the MSDOS option is set YES.
; There are 175 byes available (including those shown.)  Must terminate
; before address 0300h.  (Can check with a .PRN file if getting close.)
;
SELECT:	DB	CR,LF,'        1 for  8-bit (CP/M, Apple, general)'
	DB	CR,LF,'        2 for 16-bit (IBM, Macintosh, Atari, '
	DB	'Amiga)'
	DB	CR,LF,'$'
;
GUIDE1:	DS	0
;
;			end of overlay
;-----------------------------------------------------------------------
;
	END
