; BYE510 - REMOTE CONSOLE PROGRAM FOR CP/M AND MODEM - 08/01/86
;
;		For use with CP/M 2 or CP/M 3
;
;
;	NOTE:	Read the BYE5.HIS in this .LBR to review
;		update history and to see changes imple-
;		mented by this version.
;
;
; BYE5 replaces all previous BYE2, BYE3, BYE4, BYE+, and MBYE series and
; also supports the latest available technology for RCP/M systems.  BYE5
; will work with KMD04 and XMODEM-116 or later revisions.
;
;=======================================================================
;
; NOTE:  This program is copyrighted (c) 1986 by  Wayne Masters, Irv Hoff,
;	 and George Peace.  All rights reserved.  Users are hereby granted
;	 a limited license to copy this program for personal use only. The
;	 program may be distributed  unmodified to all interested parties.
;	 No fee or other consideration shall be  accepted by any  party or
;	 parties.  In accordance with the copyright law of 1978,  form	TX
;	 has been sent to the U.S. Government Copyright Office.
;
;	 =	 =	 =	 =	 =	 =	 =	 =
;
;	 If you have changes that you would like to see in a forthcoming
;	 general release, please forward them for consideration.  This
;	 seems to be the only way to control the modifications that have
;	 run rampant in previous versions of public domain programs.  It
;	 has taken many hours to correct problems some of these changes
;	 have caused, particularly when used with assemblers that have
;	 characteristics different from the one being currently used or
;	 if other equates are selected.
;
;	 Send/call any suggestions or requests for help to:
;
;	Wayne Masters		Irv Hoff, W6FFC 	George Peace
;   (408) 378-3798 voice     (415) 948-2166 voice    (717) 657-0285 voice
;
;		    Potpourri RCPM		     CP/M-3 George Peace
;		    (408) 378-7474		     (717) 657-8699
;
;	 =	 =	 =	 =	 =	 =	 =	 =
;
;	If using M80, remove the ";" at the beginning of the ASEG line.
;
;	ASEG		; Needed for M80, but RMAC can't handle it
;
; This program allows modem callers to use a CP/M system just as if they
; were seated at the system console.  Special assembly-time options al-
; low limiting the caller's access by password and/or access to only a
; message-service program.  A number of external inserts are available
; to adapt this program to various computers, clocks and  modems.  It
; may be assembled with ASM, LASM, MAC, RMAC, SLRMAC or M80.  If the
; ZCPR3 equate is YES, a  macro assembler such as MAC, M80 or SLRMAC
; will be required.  If the program will not assemble correctly with
; M80, check the insert that was added, it likely is not configured
; properly.
;
; BYE5 will continue supporting what the Sysop's organizations have re-
; quested, not personal preferences.
;					-  Wayne Masters
;
;=======================================================================
;
; The following files are inside this library to assist you in installa-
; tion:
;
; BYE5.DOC	For general installation and extended BDOS functions
; B5-CPM3.DOC	Specific instructions for CP/M 3 installation
; BYE5.HIS	BYE5 update history (read this to see latest features)
; BYE5-INS.INF	Computer-specific inserts currently available (CP/M 2 & 3)
; B5-TIME.INF	Clock inserts currently available (CP/M 2 & 3)
; B5IM-1.DOC	Intelligent (smart) modem configuration information
; BYE5nnC.AQM	Condensed version of BYE5 for small floppy based systems
;
;=======================================================================
;
; If the CPM3 equate is YES, BYE5 uses an RSX loader to attach itself to
; your operating system (see B5-CPM3.DOC).  For CP/M-2 users, (CPM3 NO),
; BYE5 uses a special loader that is built into the program to automati-
; cally move itself below CCP. This does not require any alteration in
; the location of CP/M by using MOVECPM.  All you need to do is: (1)
; choose the desired options, (2) patch in the insert for your computer
; in the special area near the start marked "+++ Install your I/O port
; insert here +++", (3) patch in the insert for your clock at label TIME
; (if CLOCK is YES), (4) then finish editing, assemble, load and use.
;
; Most users of this program will have a modem such as an Anchor, Hayes,
; ProModem, U.S.Robotics, or Racal Vadic Maxwell.   All these types are
; "intelligent" modems.  If using this type of modem, set the IMODEM
; and B5IM equates to 'YES'.  Otherwise leave them set to 'NO' and BYE
; assumes you have a "dumb" auto-answer modem,	(such as a Bell 212A).
; This readily adapts the program to a wide variety of modems and I/O
; serial types.
;
; NOTE:  Two support libraries exist for BYE5...
;	 BYE5-INS.LBR contains all available computer-specific inserts
;	 B5-CLOCK.LBR contains all available clock inserts.
;
; Be sure to check Potpourri for the latest version of these inserts.
; Many have been corrected and/or updated by users of BYE5 and the one(s)
; you have may not be the latest version.
;
; The program does the following:
;
;	If you type BYE E, BYE will load and execute as though it has
;	a valid carrier or caller.  Handy for debug, else it:
;
;	1) Hangs up the phone
;	2) Awaits ring if B5IM is YES, (or carrier detect if B5IM is NO)
;	   allows exit to CP/M if local KEYB types CTL-C
;	3) Answers the phone and outputs carrier
;	4) Awaits incoming carrier.  If none found in 30 seconds goes
;	   back to step 1
;	5) Detects the speed of caller and sets local cpu to that speed
;	6) Asks number of nulls (0-9) (optional)
;	7) Sets the log-in time (if TIMEON is YES)
;	8) Types the "WELCOME" file from disk, (optional) allowing
;	    CTL-C to skip it
;	9) Asks for a password (optional), allowing 3 tries to get
;	    it right.  When entered drops into CP/M
;      10) Caller can leave by hanging up, (any time carrier is
;	    lost, it waits then goes back to step 1) or the caller
;	    may type the program name (BYE).
;					- Notes by Wayne Masters
;
;=======================================================================
;
MAIN	EQU	5
VERS	EQU	10
MONTH	EQU	08
DAY	EQU	01
YEAR	EQU	86
;
;
; System equates
;
NO	EQU	0
YES	EQU	NOT NO		; For conditional assembly
;
;
; You will likely also want to change the password, located below at
; label 'PASSWD' (if you set PWRQD YES).  If you are using a BBS .COM
; file then PWRQD is normally left NO.
;
;***********************************************************************
;
;		  OPTION CONFIGURATION SECTION
;
;***********************************************************************
;
;-----------------------------------------------------------------------
;		       BYE5 configuration
;
;
LOCMD	EQU	61		; BYE's  lowest extended BDOS call
HICMD	EQU	LOCMD+27	; BYE's highest extended BDOS call
CCPL	EQU	8		; Number of sectors for CCP size (norm
				; Is 8.  Apples with Micrsoft CP/M
				; V2.23+ use 9.  Systems w/Trantor WL
				; BIOS, set to 0 and set TRANWL YES.
				; For older versions of Trantor BIOS
				; Start with 24 and work down until it
				; Stops working (typically 24 or 16).
				; An updated Trantor (WL) BIOS is ad-
				; Vised for RCP/M use if running a
				; Large BBS program.  CP/M-3 does not
				; Use this or TRANWL equates.
;
;-----------------------------------------------------------------------
;		   Modem Type
;
IMODEM	EQU	NO		; Yes, for intelligent modem, including
				; Hayes
B5IM	EQU	NO		; Yes, your modem uses AT protocol, like
				; Hayes
;
;
; Set one (and only one) of the following HS equates to YES
;
HS9600	EQU	NO		; Yes, if modem's high speed is 9600 bps
HS4800	EQU	NO		; Yes, if modem's high speed is 4800 bps
HS2400	EQU	NO		; Yes, if modem's high speed is 2400 bps
HS1200	EQU	NO		; Yes, if modem's high speed is 1200 bps
HS300	EQU	NO		; Yes, if modem's high speed is  300 bps
;
;
; The next 7 equates are only used if B5IM is YES
;
DOATZ	EQU	NO		; Yes to do ATZ between calls.	If your
				; Modem reverts to auto-answer after
				; ATZ, set this NO.  It speeds up the
				; Turnaround between calls AND pre-
				; Vents modem from answering while
				; BYE5 is trying to reinitialize for
				; The next call.  Most modems (Hayes
				; And clones) don't need it
ECHO	EQU	NO		; Yes for Hayes, ProModem, Courier, RV-
				; Maxwell, NO for all others (USR,
				; Anchor, etc.)
ANCHOR	EQU	NO		; Yes, if you have a Mark XII
NODTR	EQU	NO		; Yes, modem or computer does not sup-
				; Port DTR such as Anchor Mark XII or
				; Some Osborne-1's.  NOTE OS-1 users..
				; BYE5 can handle your NODTR problem,
				; But will NOT work unless you install
				; The hardware mod to fix the carrier
				; Detect logic.  The same mod also
				; Fixes the DTR problem, so you should
				; Install the whole mother board modi-
				; Fication kit and set this NO
NOATA	EQU	NO		; Yes, if you have an older Password,
				; 212A or S-100 that will not execute
				; The ATA command after ring is de-
				; Tected. Newer firmware works.
OFFHK	EQU	NO		; Yes, if you want BYE to put your phone
				; Off-hook (ATH1) when running locally
				; (E) or exiting to CP/M (instead of
				; Using ATS0=0)
SHORTB	EQU	NO		; Yes, for modems that that can't accept
				; A 30 character CMD string, like the
				; MultiModem.
;
;-----------------------------------------------------------------------
;			 General Equates
;
HARDLOG	EQU	NO		; Yes, echo remote input to printer
PRINTER	EQU	NO		; Yes, if your bbs uses printer for er-
				; Ror msgs. or if you use ^P remotely.
				; QBBS users say YES if QENTER is set
				; To print callers data
				; NOTE, if you use your printer I/O drivers
				; For your modem, then say YES to this
COMFILE	EQU	NO		; Yes, chain to a .COM file on carrier
				; Detect
COMDRV	EQU	'A'		; Drive to look for .COM file on
COMUSR	EQU	0		; User# of .COM file to be called after
				; Answer
DISKLOG	EQU	NO		; Yes, echo remote input to disk file
				; Warning..this code requires appx 1024 bytes
				; Large BBS programs may not work on cp/m 2.2
				; if you use this.
LOGUSR	EQU	14		; User number of SYS.LOG file
LOGDRV	EQU	'A'		; Drive for SYS.LOG file
;
EXFILE	EQU	NO		; Yes, chain to a .COM file when BYE
				; Logs off a caller (even when he
				; Types BYE).  Your exit.COM file must
				; Preserve the stack and do a RETURN
				; (not warmboot) to re-enter BYE cor-
				; Rectly or use the EXRET method below
				; CPM3 or PBBS users must say YES to this
				; QBBS users must say NO, MBBS NO if CP/M 2
				; MBBS YES if using CPM3
EXRET	EQU	NO		; YES, if your exit file can't preserve the
				; Stack and do a normal RETURN.  MBASIC,
				; "C", and some Pascal programs can't do
				; The stack save-return easily.  Simply
				; POKE FCB+1 (5DH) with 'r' (small r) and
				; Do a warmboot (SYSTEM) and BYE5 will
				; Handle your exit file return correctly
BYHANG	EQU	NO		; Yes, for BYE5 to say goodbye and hangup
				; The phone BEFORE calling your EXIT file
				; METAL, & OxGate users must say YES
				; PBBS v2.n YES, PBBS 3.0 or > NO
				; PBBS v2.n must change EXITFCB to BYE.COM
				; Instead of PBYE.COM
EXDRV	EQU	'A'		; Drive to look for exit .COM file on
EXUSR	EQU	14		; User # of .COM file to be called upon
				; Exit
MSGFIL	EQU	NO		; Yes, if your BBS system allows mes-
				; Sages to be uploaded by KMD11 and
				; Later with the RM option.  KMD11
				; Sets a flag that will cause your
				; MSG.COM file to be executed.	The
				; COM file must be on the same D/U
				; As COMFILE.  Your MSG.COM file can
				; Append (then erase) the uploaded
				; Message(s) to your message file.w
				; Your MSG.COM file must preserve the
				; Stack and do a RETURN (not warmboot)
				; To renter BYE.  You can select the
				; Name of MSG.COM at label MSGFCB:
				; (default name is MFMSG.COM)
NO25TH	EQU	NO		; Yes, you wish to display LASTCALR data
				; (^W).  You may also print a header
				; Above the LC data.  Put your custom-
				; Ized header at label LCHEAD:
				; MBBS, PBBS, QBBS users must say YES
NO25BF	EQU	78		; Size (bytes) of lc buffer needed by
				; Your BBS. MBBS, QBBS = 65
				; METAL, PBBS, OXGATE =78
READLC	EQU	NO		; Yes, to have BYE read your LASTCALR
				; File, No if your BBS pokes LASTCALR
				; Into BYE.  MBBS, PBBS, QBBS, METAL,
				; And OxGate users say NO
LCDRV	EQU	'A'		; Drive to find LASTCALR or LASTCALR.DAT
LCUSR	EQU	14		; User # of LASTCALR or LASTCALR.DAT file
;
SKTERM	EQU	NO		; Yes, to skip the code that waits for the
				; Caller to get his modem program into
				; Terminal mode.  Caution...The caller may
				; Miss your opening welcome text if you set
				; This equate yes.  If your BBS program
				; Has code built in to make sure the caller
				; Is ready AND in terminal mode, set to yes
WBDRIV	EQU	'A'-41H		; Drive to log to on first warmboot to cp/m
				; Some add-on hard disk systems want C
;
WELFILE	EQU	NO		; Yes, to send a WELCOME file
WELDRV	EQU	'A'		; Drive to look for WELCOME??? file
WELUSR	EQU	14		; User number of WELCOME??? file
;
CLRSCR	EQU	NO		; Yes, to auto-clear local CRT screen
				; Between calls.  No, will still allow
				; You to use ^Z to manually clear it.
				; You are allowed a 6 byte sequence
				; Below. The example is for an <ESC>:
				; If you use a ctrl-key (example, ^Z),
				; Set CLRCH1 EQU 'Z'-40H.  Set all
				; Unused bytes 0.  Leave this NO until
				; Everything is working
CLRCH1	EQU	1BH		; Set these for your clear screen sequence
CLRCH2	EQU	':'		; 1B is escape and ESC : clears my screen
CLRCH3	EQU	0		; (Byte 3 if you need it).
CLRCH4	EQU	0		; Six bytes allowed for clear screen
CLRCH5	EQU	0		; Sequence and you can also clear your
CLRCH6	EQU	0		; 25th line if desired.
;
PRGRSS	EQU	YES		; Yes, for helpful progress reports on
				; CRT.	Leave this YES until every-
				; Thing is working
PRNTGB	EQU	YES		; Yes, print "Goodbye..." message
PRNTWB	EQU	NO		; Yes, print a string for each warm boot
PWRQD	EQU	NO		; Yes, password needed for CP/M access
RVIDEO	EQU	NO		; Yes, display local messages in reverse
				; Video when caller is online.	(Set your
				; On/off sequence below).  This also works
				; With half intensity instead of reverse v.
RVON1	EQU	1BH		; Set your reverse-on sequence in these 4
RVON2	EQU	'G'		; Bytes.  Set unused bytes to nulls (0).
RVON3	EQU	'4'		; 1BH is escape, ESC G4 is reverse video
RVON4	EQU	0		; ON for the Televideo 925 terminal
;
RVOFF1	EQU	1BH		; Now set the reverse-off sequence as above
RVOFF2	EQU	'G'		; ESC G0 is reverse video OFF for the 925
RVOFF3	EQU	'0'
RVOFF4	EQU	0		; Set unused bytes to 0
;
TOVALUE	EQU	5		; Minutes of no-activity allowed.  255 max.
;
;-----------------------------------------------------------------------
;	      System and Hardware dependent options
;
CPM3	EQU	NO		; Yes, installing with CP/M 3.0, see
				; B5-CPM3.DOC
;
;
; The next six equates are only for CPM3 users
;
CCPPLUS	EQU	NO		; Yes, CCP+ installed.
;
HISTRSX	EQU	NO		; Yes, clear command line HISTory if
				; HIST+ RSX is installed
SDRV1	EQU	1		; Set these 4 equates to the default
SDRV2	EQU	0FFH		; Drive search chain.
SDRV3	EQU	0FFH		; 0 = current, 0FFH = end of chain.
SDRV4	EQU	0FFH		; 1 = A, 2 = B, etc.
;
; End of CPM3 only
;
CLOSS	EQU	1		; If carrier dies, wait 1 second, then
				; Hang up
CTRLC	EQU	'K'-'@'		; Map ^C to this character
DOWNMIN	EQU	2		; Number of min after Sysop types ^O to
				; Logout
LOSER	EQU	NO		; Yes, warm boot overwrites part of the
				; BIOS
MHZ	EQU	4		; Processor clock in MHz
MOTOR	EQU	NO		; Yes power up/down drives between calls
TRANWL	EQU	NO		; Yes if running Trantor WL BIOS system
;
;-----------------------------------------------------------------------
;			 Filtered characters
; BYE5 filters incoming modem noise by ignoring those characters most
; frequently generated by noisy modems or marginal phone connections.
; Also, some incoming characters may cause your local terminal to do
; strange (and sometimes undocumented) things.	The most common char-
; acters generated by noisy modem connections are the left brace ({),
; the delete character (07F) and nulls (00H).  An example of problem
; characters for the TRS-80 is the backward slash (\).	You may select
; any 4 characters below for BYE5 to filter from the incoming modem.
; Set any, or all, to nulls (00H) if you choose not to use the modem
; filter code.
;
FILT1	EQU	7BH		; Left brace
FILT2	EQU	7FH		; Delete character
FILT3	EQU	60H		; Backward slash (TRS-80 problem)
FILT4	EQU	00H		; Null
;
;-----------------------------------------------------------------------
;			 Function Keys
;
LEADIN	EQU	NO		; Yes, to use lead-in character for
				; F-keys instead of single CTL chars.
;
	 IF	LEADIN
LEADKY	EQU	'\'		; Key to use for lead-in.  Choose a sel-
				; Dom used key.
	 ENDIF			; LEADIN
;
;
; If LEADIN is YES, you must type the LEADKY first, then the character
; inside the ' ' below.  If LEADIN is NO, the following characters are
; used as a single control key.  Select only your character preference
; inside the ' ', and leave the -40H alone.  Either option will accept
; upper and lower case.
;
ANSKEY	EQU	'A'-40H		; Key to force modem to answer the phone
BLNKKEY	EQU	'B'-40H		; Key to toggle remote terminal on/off
LOGKEY	EQU	'D'-40H		; Key to flip disk log file save.
BELLKEY	EQU	'G'-40H		; Key to toggle bells on console
LCKEY	EQU	'L'-40H		; Key to force return to local cp/m after
				; Current caller logs off (& alert sysop)
TWITKEY	EQU	'N'-40H		; Keycode to hangup modem manually
SYSDKEY	EQU	'O'-40H		; Key to print "System going down in
				; N min.."
MSGKEY	EQU	'Q'-40H		; Keycode to print "Message from SYSOP:"
TIMEKEY	EQU	'T'-40H		; Key for Sysop to display time (if
				; TIMEON)
ULTKEY	EQU	'U'-40H		; Key to grant current caller unlimited
				; Time.  Also enables all the flag bits
				; In LCPTR
WHOKEY	EQU	'W'-40H		; Key to display LASTCALR if NO25TH is
				; YES
XITKEY	EQU	'X'-40H		; Key to exit from "Message from Sysop"
				; Loop
ZCREEN	EQU	'Z'-40H		; Key to manually clear your screen
;
;-----------------------------------------------------------------------
;			   RBBS Type
;
; Set only one, or none of the following BBS equates to YES.  If COMFILE
; YES and none of the below are selected you will have an undefined label
; COMFCB during assembly.
;
METAL	EQU	NO		; Yes, running METAL BBS system.
;
MBBS	EQU	NO		; Yes, running MBBS4n BBS system
MBSDRV	EQU	'A'		; Drive where you keep MBBS.COM
MBSUSR	EQU	0		; User area for MBBS.COM
				; LOGIN.COM and MFGMSG.COM must both be on
				; COMDRV and COMUSR selected above
;
MINICK	EQU	NO		; Yes, running MINICBBS..you must also create
				; Your COMFCB label
;
OXGATE	EQU	NO		; Yes, running OxGate BBS system
PBBS	EQU	NO		; Yes, running PBBS system
QBBS	EQU	NO		; Yes, running QBBS system
RBBS	EQU	NO		; Yes, running RBBS, sets/resets
				; 'WRTLOC' flag
IOVAL	EQU	0		; Initial value for IOBYTE (if MINICK
				; YES)
LMBELL	EQU	NO		; Yes, your bbs uses a low-memory bell flag
				; MBBS and RBBS users must say YES
KILBEL	EQU	03BH		; Byte for low memory bell toggle flag
;
;
; Some BBS systems require a flag to be reset to allow reentry to the
; BBS from CP/M (older versions of RBBS do).  If you run a BBS that uses
; this technique, then set RTOK to YES, and define the byte to reset at
; RTOKFG.  BYE5 will reset this byte to zero between calls.
;
RTOK	EQU	NO		; Yes, to reset the following byte be-
RTOKFG	EQU	020H		; Tween calls.	PBBS users should say
				; Yes, and set RTOKFG EQU to your REENTR
				; Byte, normally 20H.
;
;-----------------------------------------------------------------------
;		       Clock/Time Equates
;
; NOTE... Be sure to set the CLOCK and TIMEON equates the same way in
; both BYE5 and KMD.
;
CLOCK	EQU	NO		; If YES, add your clock reader code at
				; The start of label TIME: and store
				; Binary values in CCHOUR and CCMIN
				; PBBS and QBBS users must say YES
BCD2BIN	EQU	NO		; Yes, your clock routine calls BCDBIN
BIN2BCD	EQU	NO		; Yes, your clock routine calls BINBCD
TIMEON	EQU	NO		; Yes, if you want BYE5 to keep track of
				; Time-on-system and log off user
				; After MAXMIN.  This works without a
				; Clock if you use KMD
MAXMIN	EQU	60		; Minutes for maximum time allowed on
				; System.  Recommend 60 if CLOCK and
				; TIMEON are YES, and 45 if CLOCK is
				; NO and TIMEON YES.  (255 minutes
				; Maximum).  0= No restrictions.
;
; NOTE, the previous callers timeon is preserved for your exit or login
; program to access in BYE's fixed lookup table at label LCPTR.  You may
; choose to store that data in low memory, or elsewhere by changing the
; LCTON equate to a new address.  LCTON is found just after BYE's fixed
; lookup table.
;
PRNTOS	EQU	NO		; Yes, print Time-left-on-system on warmboots
				; If WHEEL is on or MXTIME=0, this will print
				; Time-on-system rather than Time-left...
RSPEED	EQU	NO		; Yes, restricting primetime to a min.
				; Speed (a clock read routine is re-
				; Quired if YES - see CLOCK)
;
	 IF	RSPEED		; 24 hour clock, 00=midnight, 23=11PM
HOUR1	EQU	19		; Start of prime-time (19=7:00 PM)
HOUR2	EQU	23		; End of prime-time (23=11:00 PM)
SPEED	EQU	5		; Minimum speed accepted (5=1200 baud).
				; Change OFFMSG to match your times,
				; Baud rate and time zone.  OFFMSG is
				; A message at code end.
	 ENDIF			; RSPEED
;
;-----------------------------------------------------------------------
;			  CCP Options
;
ZCPR2	EQU	NO		; Yes, if running ZCPR1/2, ZCMD1/2 or
				; NZCPR1/2
				; Yes, if using CP/M 3 with wheel byte
ZCPR3	EQU	NO		; Yes, if running ZCPR3
;
;
; NOTE: requires MAC.COM to assemble if ZCPR3 set YES
;
	 IF	ZCPR3
	MACLIB	Z3BASE		; Requires MAC to assemble...otherwise
				; Enter constants directly..see label
				; DOZ3 for required EQU's
	 ENDIF			; ZCPR3
;
;
; NZCPR/ZCMD/ZCPR all use bytes (at 3DH/3EH/3FH) to store the maximum
; drive, wheel status, and maximum user area.  Some BBS systems poke
; these low memory bytes to reset these (for Sysop, etc.)  Other BBS
; systems (like OxGate) poke the bytes in BYE that do the same thing.
; The equate USEZCPR allows you to select where you want to poke things.
; For OxGate, set it to NO, for RBBS, you probably want it set to YES.
; If you are NOT using NZCPR/ZCMD/ZCPR then set USEZCPR to NO.
;
USEZCPR	EQU	NO		; Yes, if using ZCPR/NZCPR/ZCMD to set
				; Bytes
CHEKDU	EQU	NO		; Yes, if you want BYE to police MAXDRIV
				; And MAXUSER.	No, if your CCP can do
				; That (saves a lot of code).  In
				; Either case, BYE keeps correct
				; Values in these low memory bytes
MAXDRIV	EQU	003DH		; ZCPR lolcation of MAXDRIV byte
WHEEL	EQU	003EH		; Location of ZCPR's wheel flag
MAXUSER	EQU	003FH		; ZCPR location of MAXUSR byte
MAXDRV	EQU	'B'-'@'		; Highest drive supported
MAXUSR	EQU	9		; Highest user area
SYSDRV	EQU	'O'-'@'		; Highest local drive supported
SYSUSR	EQU	15		; Highest local user area (0-15)
;
;
; If CHGPATH is YES, BYE automagically will change the .COM path to suit
; which mode it is in.	An example of this is: when remote, the path is
; $$:, A0: -- when local, MY path is $$:, A0:, A15: which allows keeping
; PIP and FORMAT and other nasties up in A15: -- See REMPATH and SYSPATH
; DB's at end of program for current paths.  If the Sysop uses the ^B to
; blank the remote console, the Wheel byte is set and SYSPATH is setup
; for the Sysop.  The wheel byte is reset and REMPATH setup when ^B is
; used the second time to turn the remote back on.
;
CHGPATH	EQU	NO		; Yes, if changing ZCPR's external path
EXTPATH	EQU	0040H		; ZCPR external path default location
;
;-----------------------------------------------------------------------
;			 MSPEED values
;
MSPEED	EQU	03CH		; Baud rate pointer
BP110	EQU	0		; 110 baud - baud rate pntrs for MSPEED
BP300	EQU	1		; 300 baud
BP450	EQU	2		; 450 baud
BP600	EQU	3		; 600 baud
BP710	EQU	4		; 710 baud
BP1200	EQU	5		; 1200 baud
BP2400	EQU	6		; 2400 baud
BP4800	EQU	7		; 4800 baud
BP9600	EQU	8		; 9600 baud
BP19200	EQU	9		; 19200 baud
;
;-----------------------------------------------------------------------
;		    Motor controlled drives
;
; These values suit a Compupro/Viasyn Disk1A with YE-DATA 180 20cm
; drives.  Alter to suit your needs if your disk controller supports
; motor control.
;
	 IF	MOTOR
DISK	EQU	0C3H		; Disk control port
DISKON	EQU	080H		; Motors on
DISKOFF	EQU	000H		; Motors off
	 ENDIF			; MOTOR
;
;-----------------------------------------------------------------------
;			 if using LOSER
;
; There are some cases where warm boot overwrites the initial BIOS jump
; table.  This problem was solved for the Superbrain 3.0 bios by find-
; ing a warmboot call to HIGH in the BIOS.  This call is then patched by
; BYE.	The form of the call is:     WBCALL   CALL  WMSTRT
;
	 IF	LOSER
WBCALL	EQU	0E260H		; Check this in your BIOS
;
;
; The following location is called
;
WMSTRT	EQU	0E566H		; Check this in your BIOS
	 ENDIF			; LOSER
;
;-----------------------------------------------------------------------
;
;	     END OF OPTION CONFIGURATION SECTION FOR BYE5
;
;-----------------------------------------------------------------------
;
	 IF	NOT CPM3
	ORG	100H
;
;-------------------- Special Loader Routine ---------------------------
START:	LXI	SP,ISTACK
	MVI	C,32
	MVI	E,241
	CALL	BDOS
	CPI	77
	JNZ	STARTA
	LHLD	BDOS+1
	INX	H
	INX	H
	INX	H
	PCHL
	ENDIF
STARTA:	IF	COMFILE	AND (NOT CPM3)
	LXI	H,COMFCB+1
	LXI	D,ENTMSG
	MVI	B,8
STAR1:	MOV	A,M
	CPI	' '
	JZ	STAR2
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR1
STAR2:	XRA	A
	STAX	D
	ENDIF
	IF	EXFILE AND (NOT	CPM3)
	LXI	H,EXITFCB+1
	LXI	D,EXTMSG
	MVI	B,8
STAR3:	MOV	A,M
	CPI	' '
	JZ	STAR4
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR3
STAR4:	XRA	A
	STAX	D
	ENDIF
	IF	MSGFIL AND (NOT	CPM3)
	LXI	H,MSGFCB+1
	LXI	D,MSGMSG
	MVI	B,8
STAR5:	MOV	A,M
	CPI	' '
	JZ	STAR6
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR5
STAR6:	XRA	A
	STAX	D
	ENDIF
	IF	LMBELL AND (NOT	CPM3)
	LDA	BELLON
	CMA
	STA	KILBEL
	ENDIF
	IF	NOT CPM3
	LHLD	BDOS+1
	LXI	D,-(CCPL*256)-8
	DAD	D
	LXI	D,OBJEND-1
	LXI	B,OBJEND-BEGOBJ
BLOCK:	LDAX	D
	MOV	M,A
	MOV	A,B
	ORA	C
	JZ	UPDATE
	DCX	D
	DCX	H
	DCX	B
	JMP	BLOCK
UPDATE:	XCHG
	CALL	NEGHL
	DAD	D
	SHLD	OFFSET
	XCHG
	LXI	H,ENDOBJ
	DAD	D
	SHLD	ENDRNG
	LXI	H,BEGOBJ
	DAD	D
	DCX	H
MODIFY:	INX	H
	DB	LXID
ENDRNG:	DW	0
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JC	BEGIN
	MVI	B,INST3E-INST3
	LXI	D,INST3
THRBYT:	LDAX	D
	CMP	M
	JZ	CHANGE
	INX	D
	DCR	B
	JNZ	THRBYT
	MVI	B,INST2E-INST2
	LXI	D,INST2
TWOBYT:	LDAX	D
	CMP	M
	JZ	SKIP
	DCR	B
	INX	D
	JNZ	TWOBYT
	JMP	MODIFY
SKIP:	INX	H
	JMP	MODIFY
CHANGE:	LXI	D,OBJEND
	LXI	B,BEGOBJ
	INX	H
	MOV	A,E
	SUB	M
	INX	H
	MOV	A,D
	SBB	M
	JC	MODIFY
	DCX	H
	MOV	A,M
	SUB	C
	INX	H
	MOV	A,M
	SBB	B
	JC	MODIFY
	DCX	H
	DB	LXID
OFFSET:	DW	0
	MOV	A,M
	ADD	E
	MOV	M,A
	INX	H
	MOV	A,M
	ADC	D
	MOV	M,A
	JMP	MODIFY
NEGHL:	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	RET
BEGIN:	LHLD	BDOS+1
	PUSH	H
	LXI	D,BEGOBJ
	LHLD	OFFSET
	DAD	D
	SHLD	BDOS+1
	ENDIF
	IF	TRANWL AND (NOT	CPM3)
	PUSH	H
	CALL	FNDWL
	POP	D
	JC	NOWL
	MOV	M,E
	INX	H
	MOV	M,D
NOWL:	XCHG
	ENDIF
	IF	NOT CPM3
	INX	H
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	INX	H
	PCHL
	ENDIF
	IF	TRANWL AND (NOT	CPM3)
HHSIG	EQU	12
HSSIG	EQU	14
HHSHL	EQU	16
HLSHL	EQU	18
HBSHL	EQU	36
HDRVR	EQU	22
HPCT	EQU	25
PCMGR	EQU	4*2
WWHSIG	EQU	'W'
WWLSIG	EQU	'H'
SIGWBT	EQU	'B'
SIGUB	EQU	'L'
SIGSD	EQU	'S'
FNDWL:	PUSH	D
	LXI	B,0FF06H
ASHELL:	LXI	H,HHSIG
	DAD	B
	MOV	A,M
	CPI	WWHSIG
	JNZ	NSHELL
	INX	H
	MOV	A,M
	CPI	WWLSIG
	JZ	WWLINK
NSHELL:	DCR	B
	LDA	7
	DCR	A
	CMP	B
	JC	ASHELL
	STC
	POP	D
	RET
WWLINK:	LXI	H,HSSIG
	DAD	B
	MOV	A,M
	CPI	SIGWBT
	JZ	WBFND
	LXI	H,HHSHL
	DAD	B
	MOV	C,M
	INX	H
	MOV	B,M
	JMP	WWLINK
WBFND:	LXI	H,HBSHL
	DAD	B
	ORA	A
WLEXIT:	POP	D
	RET
	ENDIF
	IF	NOT CPM3
INST3:	DB	001H,011H,021H,022H,02AH,031H,032H,03AH,0C2H
	DB	0C3H,0C4H,0CAH,0CCH,0CDH,0D2H,0D4H,0DAH,0DCH
	DB	0E2H,0E4H,0EAH,0ECH,0F2H,0F4H,0FAH,0FCH
INST3E	EQU	$
INST2:	DB	006H,00EH,016H,01EH,026H,02EH,036H,03EH,0C6H
	DB	0CEH,0D3H,0D6H,0DBH,0DEH,0E6H,0EEH,0F6H,0FEH
INST2E	EQU	$
	ENDIF
	IF	CPM3
SERIAL:	DB	0,0,0,0,0,0
STARTX:	JMP	FTEST
NEXT:	DB	0C3H
	DW	0
PREV:	DW	0
REMOV:	DB	0FFH
NONBNK:	DB	0
RSXNAM:	DB	'BYE5    '
LOADER:	DB	0
	DB	0,0
INIFLG:	DB	NOTINIT
INIT	EQU	00
NOTINIT	EQU	0FFH
FTEST:	MOV	A,C
	CPI	60
	JNZ	NEXT
	LDAX	D
	ENDIF
	IF	CPM3 AND CCPPLUS
	CPI	4
	JZ	TSTBYE
	ENDIF
	IF	CPM3
	CPI	7
	JZ	GMXUSR
	CPI	11
	JZ	DELRSX
	CPI	101
	JZ	RSXINT
	CPI	102
	JZ	RSXTRM
	JMP	NEXT
RSXINT:	LDA	INIFLG
	CPI	NOTINIT
	JNZ	RSXIN2
	XRA	A
	STA	REMOV
	STA	INIFLG
	ENDIF
	IF	COMFILE	AND CPM3
	LXI	H,COMFCB+1
	LXI	D,ENTMSG
	MVI	B,8
STAR1:	MOV	A,M
	CPI	' '
	JZ	STAR2
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR1
STAR2:	XRA	A
	STAX	D
	ENDIF
	IF	EXFILE AND CPM3
	LXI	H,EXITFCB+1
	LXI	D,EXTMSG
	MVI	B,8
STAR3:	MOV	A,M
	CPI	' '
	JZ	STAR4
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR3
STAR4:	XRA	A
	STAX	D
	ENDIF
	IF	MSGFIL AND CPM3
	LXI	H,MSGFCB+1
	LXI	D,MSGMSG
	MVI	B,8
STAR5:	MOV	A,M
	CPI	' '
	JZ	STAR6
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	STAR5
STAR6:	XRA	A
	STAX	D
	ENDIF
	IF	LMBELL AND CPM3
	LDA	BELLON
	CMA
	STA	KILBEL
	ENDIF
	IF	CPM3
	JMP	BGOBJ2
RSXIN2:
	MVI	A,0FFH
RSXIN9:	RET
RSXTRM:	CALL	MDCARCK
	JNZ	START0
	CALL	UNPATCH
	JMP	BGOBJ2
RSXCLR:	MVI	A,0FFH
	STA	INIFLG
	STA	REMOV
	XRA	A
	RET
	ENDIF
	IF	CPM3 AND CCPPLUS
TSTBYE:
	XRA	A
	RET
	ENDIF
	IF	CPM3
GMXUSR:
	LXI	H,MXUSR
	RET
	ENDIF
DELRSX:	IF	CPM3 AND HISTRSX
	MVI	C,60
	LXI	D,RSXCL
	CALL	NEXT
	ENDIF
	IF	CPM3
	LHLD	PREV
	MVI	L,0EH
	MVI	C,59
	LXI	D,0
DELLP:
	MOV	A,H
	ORA	A
	JZ	NEXT
	MVI	M,0FFH
	DCR	L
	MOV	H,M
	INR	L
	JMP	DELLP
	ENDIF
	DS	40
ISTACK:	DW	0		; Top of stack
;
;
;-----------------------------------------------------------------------
;
;		   THE FOLLOWING CODE GETS MOVED
;		   TO HIGH RAM BY THE LOADER OR RSX
;		   PROGRAM, WHERE IT IS EXECUTED.
;
;-----------------------------------------------------------------------
;
	IF	NOT CPM3
BEGOBJ:	JMP	0		; Filled by BEGIN
	ENDIF			; NOT CPM3
;
BGOBJ2:	JMP	START0		; Hop over fixed vectors
;
MCBOOT:	JMP	MBOOT		; Off to warm boot
	JMP	PRNLOG		; Go print out items of interest
;.....
;
;
; Variables follow in a predefined order that can be manipulated by a
; passworded or other program to give special users different capabili-
; ties.
;
;-----------------------------------------------------------------------
;
; Here is a quickie handy reference table to use so we do not get mixed
; up.  Please do not change the order of it in any future changes.
;
; |mxusr|mxdrv|toval|nulls|ulcsw|lfeeds|wrtloc|hardon|lostflg|covect|
; |1 byt|1 byt|1 byt|1 byt|1 byt|1 byte|1 byte|1 byte|1 byte |2 byes|
;
; |BYE	|bell |stat |lcbuf|mxtme|rtcbuf|
; |3 byt|1 byt|1 byt|2 byt|1 byt|2 byte|
;-----------------------------------------------------------------------
;
MXUSR:	DB	MAXUSR		; Runtime maximum user area available
MXDRV:	DB	MAXDRV		; Runtime maximum drive available
TOVAL:	DB	TOVALUE		; Number of mins. to wait before timeout
NULLS:	DB	0		; Number of nulls after <cr>
ULCSW:	DB	0		; Upper case only switch (32=upper case)
LFEEDS:	DB	0		; Line feed mask (0=don't mask)
WRTLOC:	DB	0		; Location RBBS pokes so BYE won't hang
HARDON:	DB	0FFH		; If 0, hardlog is deactivated
MDMOFF:	DB	0		; If 0FFH, do not output to modem
COVECT:	DW	0		; Console output vector for XMODEM
HDROFF	EQU	$-MCBOOT	; Offset to 'BYE' that follows
	DB	'BYE'		; Tells XMODEM that BYE is being used
BELLON:	DB	0FFH		; If 0FFH ok to send bell (Chat) to con-
				; Sole, 00H=belloff.  This only affects
				; Your initial default choice
LCPTR:	JMP	LCDATA		; First byte is user access restrictions
				; And flags while user is logged on,
				; Used for his total time-on after
				; Logoff.  LCDATA is address of buffer
				; For NO25TH data, NO25BF in length
MXTIME:	JMP	RTCBUF		; First bye holds maximum time allowed
				; Next 2 bytes point to the real time
				; Clock buffer
;
;
;		end of BYE5's fixed lookup table
;-----------------------------------------------------------------------
;
LCTON	EQU	LCPTR		; Byte to store last caller's time-on-
				; System value (in binary).  You may
				; Equate this to a low-memory byte or
				; Use this byte in the BYE fixed var-
				; Iable table...can then be used by
				; Your entry/exit program to determine
				; How long the previous caller was on.
;
;-----------------------------------------------------------------------
;
;	  THIS IS THE OFFICIAL START OF THE BYE PROGRAM
;
;-----------------------------------------------------------------------
;
;	   ++++ Install your user defined subroutines here ++++
;
;	You may install a subroutine here that has the label SRUDEF
;	that can be called from a transient program like your entry/
;	exit .com file.  To access it, MVI C,84  CALL BDOS from your
;	program.  Make sure this subroutine has a RET at the end.
;	The transient program making a BDOS 84 call may pass data to
;	this subroutine in any register(s) except A and C.  This routine
;	can return data to the calling program in any register(s).
;
SRUDEF:	RET			; SubRoutine U DEFine for BDOS call 84
;
;-----------------------------------------------------------------------
;
;	   ++++ Install your I/O port insert here ++++
;	       or select one from the BYE5-INS.LBR
;
;-----------------------------------------------------------------------
;
;      ++++ Install your Modem dependent insert here ++++
;	      (If B5IM is YES you don't need one)
;
;-----------------------------------------------------------------------
;
;	     ++++ Install your TIME routine here ++++
;
; If you have a clock and wish to use TIMEON or RSPEED, please replace
; the following code with your clock read code.  Use as many instruc-
; tions as you need but make sure you store binary, not BCD values in
; CCHOUR and CCMIN.  Use RTCBUF to store BCD clock data, then use BCDBIN
; to convert it to binary for CCHOUR and CCMIN.  See B5C-QXnn.INS as an
; example of handling a BCD clock, or B5C-SDS.INS for a BIOS interrupt-
; driven clock that runs in binary (hex).  All registers are saved before
; TIME is called, so you don't have to save them.
;
; NOTE... Set BCD2BIN to YES if your clock routine calls BCDBIN
;	  Set BIN2BCD to YES if your clock routine calls BINBCD
;
;
; (Replace the following code with your own clock subroutine)
;
	IF	CLOCK OR RSPEED
TIME:	RET			; Install your clock code here
	ENDIF			; CLOCK OR RSPEED
;
;		     end of clock routine
;-----------------------------------------------------------------------
	IF	B5IM
IMRING:	CALL	MDINST
	RZ
	CALL	MDINP
	ANI	7FH
	ENDIF
	IF	B5IM AND PRGRSS
	CALL	RCDISP
	PUSH	PSW
	LXI	H,LFMSG
	CALL	PRINTL
	POP	PSW
	ENDIF
	IF	B5IM
	CPI	CR
	RZ
	CPI	LF
	RZ
	CPI	'2'
	JNZ	REDOIT
	ENDIF
IMRIN1:	IF	B5IM AND (NOT NOATA)
	MVI	B,22
	CALL	DLP1
	CALL	EATALL
IMRIN2:	LXI	H,B5ATA
	CALL	IMSEND
	ENDIF
	IF	B5IM
	LXI	B,30000
MDR1:	CALL	MDINST
	JZ	RCHEK
	CALL	MDINP
	ANI	07FH
	ENDIF
	IF	B5IM AND PRGRSS
	CALL	RCDISP
	ENDIF
	IF	B5IM
	CPI	CR
	JZ	MDR1
	CPI	LF
	JZ	MDR1
	CPI	'2'
	JZ	IMRIN1
	CPI	'3'
	JZ	REDOIT
	CPI	'4'
	JZ	REDOIT
	CPI	'1'
	JNZ	MDR2
	CALL	CHECK1
	ENDIF
	IF	B5IM AND PRGRSS
	CALL	RCDISP
	ENDIF
	IF	B5IM
	CPI	'0'
	JZ	SET24
	JMP	SET3
MDR2:	CPI	'5'
	JZ	SET12
	CPI	'6'
	JZ	SET24
	CPI	'9'
	JZ	SET24
	ENDIF
	IF	B5IM AND ANCHOR
	JMP	SET3
	ENDIF
	IF	B5IM
	JMP	MDR1
RCHEK:	CALL	KDELAY
	DCX	B
	MOV	A,C
	ORA	B
	JNZ	MDR1
REDOIT:	POP	H
	LXI	H,VCNUM
	INR	M
	ENDIF
	IF	B5IM AND DISKLOG
	CALL	OPENLOG
	LXI	H,VOCMSG
	CALL	WRTMSG
	MVI	E,0
	CALL	TSTHRD
	ENDIF
	IF	B5IM
	LXI	H,LFMSG
	CALL	PRINTL
	CALL	MDSTOP
	JMP	HANGUP1
	ENDIF
	IF	B5IM AND PRGRSS
RCDISP:	PUSH	B
	PUSH	H
	PUSH	PSW
	STA	RCSHOW
	LXI	H,RCSHOW
	CALL	PRINTL
	POP	PSW
	PUSH	PSW
	CPI	CR
	JNZ	RCDIS1
	MVI	A,LF
	STA	RCSHOW
	LXI	H,RCSHOW
	CALL	PRINTL
RCDIS1:	POP	PSW
	POP	H
	POP	B
	RET
	ENDIF
	IF	B5IM
CHECK1:	LXI	B,400
CHECK2:	CALL	KDELAY
	DCX	B
	MOV	A,B
	ORA	C
	JZ	CHECK3
	CALL	MDINST
	JZ	CHECK2
	CALL	MDINP
	ANI	07FH
	RET
CHECK3:	MVI	A,0FFH
	RET
SET24:	CALL	DLP
	CALL	SET2400
	MVI	A,BP2400
	STA	MSPEED
	JMP	FINISH
SET3:	CALL	DLP
	CALL	SET300
	MVI	A,BP300
	STA	MSPEED
	JMP	FINISH
SET12:	CALL	DLP
	CALL	SET1200
	MVI	A,BP1200
	STA	MSPEED
FINISH:	CALL	MDCARCK
	JZ	REDOIT
	POP	H
	CALL	PATCH
	MVI	B,6
	CALL	DLP1
	CALL	EATALL
	JMP	ANSW
IMINIT:	CALL	DLP
	CALL	EATALL
	ENDIF
	IF	B5IM AND DOATZ
	LXI	H,B5ATZ
	CALL	IMSEND
	CALL	DLP
	CALL	EATALL
	ENDIF
	IF	B5IM
	LXI	H,B5INIT
	CALL	IMSEND
	ENDIF
	IF	B5IM AND SHORTB
	CALL	DLP
	CALL	EATALL
	LXI	H,B5INT1
	CALL	IMSEND
	ENDIF
	IF	B5IM AND PRGRSS
IMINT1:	CALL	CHECK1
	CPI	0FFH
	JZ	IMINT2
	CPI	'0'
	CZ	RCDISP
	JZ	IMINT3
	CPI	'4'
	CZ	RCDISP
	JNZ	IMINT1
IMINT2:	LXI	H,CMDERR
	CALL	PRINTL
	JMP	IMINIT
	ENDIF
	IF	B5IM
IMINT3:	LXI	H,LFMSG
	CALL	PRINTL
	CALL	DLP
	CALL	EATALL
	RET
DLP:	MVI	B,10
DLP1:	CALL	DELAY
	DCR	B
	JNZ	DLP1
	RET
EATALL:	CALL	CHECK1
	CPI	0FFH
	JNZ	EATALL
	RET
IMQUIT:	LXI	H,LFMSG
	CALL	PRINTL
	ENDIF
	IF	B5IM AND DOATZ
	CALL	DLP
	CALL	EATALL
	LXI	H,B5ATZ
	CALL	IMSEND
	ENDIF
	IF	B5IM
	CALL	DLP
	CALL	EATALL
	ENDIF
	IF	B5IM AND (NOT OFFHK)
	LXI	H,B5USR
	CALL	IMSEND
	CALL	EATALL
	ENDIF
	IF	B5IM AND OFFHK
	LXI	H,B5ATH1
	CALL	IMSEND
	ENDIF
	IF	B5IM
	RET
IMSEND:	PUSH	B
	SHLD	ADDSTR
IMSEN1:	CALL	MDOUTST
	JZ	IMSEN1
	MOV	A,M
	PUSH	PSW
	CALL	MDOUTP
	POP	PSW
	ENDIF
	IF	B5IM AND PRGRSS
	CALL	RCDISP
	ENDIF
	IF	B5IM AND ECHO
	CALL	CHECK1
	CMP	M
	JNZ	NOECHO
	ENDIF
	IF	B5IM
	INX	H
	MOV	A,M
	ORA	A
	JNZ	IMSEN1
	POP	B
	RET
	ENDIF
NOECHO:	IF	B5IM AND ECHO AND PRGRSS
	LXI	H,NOEMSG
	CALL	PRINTL
	ENDIF
	IF	B5IM AND ECHO
	CALL	MDOUTST
	JZ	NOECHO
	MVI	A,CR
	CALL	MDOUTP
	CALL	DLP
	CALL	EATALL
	LHLD	ADDSTR
	JMP	IMSEN1
	ENDIF
	IF	B5IM AND NODTR
IMHANG:	CALL	EATALL
	MVI	B,30
	CALL	DLP1
	LXI	H,B5ESC
	CALL	IMSEND
	CALL	EATALL
	MVI	B,15
	CALL	DLP1
	LXI	H,B5ATH
	CALL	IMSEND
	CALL	DLP
	RET
	ENDIF
IMDONE:	CALL	DELAY
	IF	NOT NODTR
	CALL	MDSTOP
	ENDIF
	CALL	MDCARCK
	RZ
	IF	B5IM AND NODTR
	CALL	IMHANG
	ENDIF
	JMP	IMDONE
START0:	IF	TIMEON
	LDA	TON
	STA	LCTON
	ENDIF
	IF	NOT CPM3
	LHLD	BDOS+1
	SHLD	BDADDR
	ENDIF
	IF	CPM3
	LHLD	STARTX+1
	ENDIF
	IF	NOT CPM3
	LHLD	BEGOBJ+1
	ENDIF
	MOV	A,H
	LXI	D,BYERSX
	CMP	D
	JZ	NORPTC
	SHLD	REALBD+1
	LXI	H,BYERSX
	IF	CPM3
	SHLD	STARTX+1
	ENDIF
	IF	NOT CPM3
	SHLD	BEGOBJ+1
	ENDIF
NORPTC:	XRA	A
	STA	MDMOFF
	STA	ULCSW
	STA	LFEEDS
	STA	WRTLOC
	STA	OPTION
	IF	TIMEON AND CLOCK AND (NOT EXFILE)
	CALL	MDCARCK
	CNZ	RMTOS
	ENDIF
	IF	MINICK
	MVI	A,IOVAL
	STA	IOBYTE
	ENDIF
	IF	MBBS
	LXI	SP,STACK
	CALL	MDCARCK
	JZ	START1
	LDA	LCDATA
	CPI	' '
	JZ	GOODBY
	XRA	A
	STA	0
	MVI	A,0FFH
	STA	WRTLOC
	LDA	FCB+1
	CPI	'C'
	JZ	MBBSC
	ENDIF
	IF	MBBS AND PRNTGB
	LXI	H,GBMSG
	CALL	PRINTB
	ENDIF
	IF	MBBS
MBBS01:	CALL	IMDONE
	JMP	MBBSNC
MBBSC:	STA	OPTION
	LXI	H,MBBS1
	CALL	PRINTB
	CALL	LODCOM
	CALL	MDCARCK
	JZ	MBBSNC
	MVI	A,0CDH
	STA	0
	CALL	100H
MBBSNC:	LXI	H,MBBS2
	CALL	PRINTL
	MVI	A,0FFH
	STA	MDMOFF
	MVI	A,'E'
	STA	OPTION
	CALL	LODCOM
	CALL	100H
	ENDIF
	CALL	MDCARCK
	JNZ	GOODBY
START1:	IF	COMFILE
	LDA	FCB+1
	STA	OPTION
	MVI	A,' '
	STA	FCB+1
	ENDIF
	IF	CPM3
	MVI	C,GTSCB
	LXI	D,SCBPB
	CALL	BDOS
	SHLD	SCBBASE
	MVI	L,SCBCOM
	MOV	A,M
	STA	MEMBASE
	MVI	L,SCBBDOS
	MOV	A,M
	STA	BDOSBASE
	ENDIF
	CALL	PATCH
	CALL	UNPATCH
	LXI	H,VMSG
	CALL	PRINTL
	JMP	HANGUP
GOODBY:	IF	EXFILE
	JMP	LOGOFF
	ENDIF
	IF	PRNTGB AND (NOT	EXFILE)
	LXI	H,GBMSG
	CALL	PRINTB
	ENDIF
	IF	NOT EXFILE
	CALL	IMDONE
	CALL	UNPATCH
	ENDIF
	IF	DISKLOG	AND (NOT EXFILE)
	LXI	H,DSCMSG
	CALL	WRTMSG
	ENDIF
HANGUP:	LXI	SP,STACK
	IF	DISKLOG
	XRA	A
	STA	BDOSFL
	STA	LOGTOG
	MOV	E,A
	CALL	TSTHRD
	ENDIF
	IF	CPM3
	CALL	DELRSX
	LXI	D,DEFPW
	MVI	C,DEFPAS
	CALL	REALBD
	ENDIF
	IF	COMFILE
	LXI	H,ENTMSG
	CALL	PRINTL
	CALL	LODCOM
	ENDIF
HANGUP1:MVI	A,WBDRIV
	STA	0004H
	IF	CPM3
	CALL	SETDRIVE
	XRA	A
	CALL	SETUSER
	ENDIF
	XRA	A
	STA	MDMOFF
	STA	WRTLOC
	STA	TON
	STA	MSFLAG
	IF	RTOK
	STA	RTOKFG
	ENDIF
	IF	CPM3
	LHLD	SCBBASE
	MVI	L,0D4H
	MOV	M,A
	MVI	L,0CAH
	MOV	M,A
	INR	L
	DCR	A
	MOV	M,A
	ENDIF
	IF	CPM3 AND CCPPLUS
	MVI	L,0A4H
	MOV	A,M
	ORI	80H
	MOV	M,A
	ENDIF
	IF	CPM3
	MOV	D,H
	MVI	E,0E8H
	LXI	H,DRVSRC
	MVI	B,4
	CALL	MOVE
	ENDIF
	IF	NO25TH OR MBBS
	LXI	H,LFMSG
	CALL	PRINTL
	LXI	H,LCDATA
	CALL	PRINTL
	ENDIF
	IF	NO25TH OR MBBS
	LXI	H,LCDATA
	MVI	B,NO25BF
	CALL	ZEROM
	LXI	H,LCFILL
	LXI	D,LCDATA
	MVI	B,15
	CALL	MOVE
	ENDIF
	IF	TIMEON
	LXI	H,TONMSG
	CALL	PRINTL
	XRA	A
	LXI	H,TONMSD
	CALL	DEC8
	ENDIF
	IF	TIMEON OR CLOCK
	MVI	A,255
	STA	TCHKFG
	ENDIF
	CALL	CALSUM
	IF	B5IM AND HS9600
	CALL	SET9600
	ENDIF
	IF	B5IM AND HS4800
	CALL	SET4800
	ENDIF
	IF	B5IM AND HS2400
	CALL	SET2400
	ENDIF
	IF	B5IM AND HS1200
	CALL	SET1200
	ENDIF
	IF	B5IM AND HS300
	CALL	SET300
	ENDIF
	CALL	MDINIT
	MVI	A,0C3H
	STA	0
	LDA	LCDFLG
	ORA	A
	JNZ	BEXCPM
	IF	CLRSCR
	CALL	CLEARIT
	ENDIF
	IF	COMFILE
	LDA	OPTION
	CPI	'E'
	JNZ	MOTOFF
	ENDIF
ERUN:	IF	COMFILE	AND B5IM
	CALL	IMQUIT
	ENDIF
	IF	COMFILE	AND (NOT B5IM)
	CALL	MDQUIT
	ENDIF
	IF	COMFILE
	MVI	A,0FFH
	STA	MDMOFF
	STA	WRTLOC
	MVI	A,'L'-30H
	STA	MSPEED
	JMP	ANSW
	ENDIF
MOTOFF:	IF	MOTOR
	CALL	DSKOFF
	ENDIF
RINGWT:	CALL	CONSTAT
	ORA	A
	JZ	RINGW1
	CALL	VCONIN
	ANI	7FH
	CPI	'C'-40H
	CZ	USRCHK
	CALL	CKFUNC
RINGW1:	IF	B5IM
	CALL	IMRING
	JZ	RINGWT
	ENDIF
	IF	NOT B5IM
	CALL	MDCARCK
	JZ	RINGWT
	ENDIF
ANSW:	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	IF	MOTOR
	CALL	DSKON
	ENDIF
	IF	(NOT USEZCPR) AND (ZCPR2 OR ZCPR3)
	MVI	A,MAXUSR
	STA	MXUSR
	INR	A
	STA	MAXUSER
	MVI	A,MAXDRV
	STA	MXDRV
	DCR	A
	STA	MAXDRIV
	ENDIF
	IF	CHGPATH
	CALL	REMPAT
	ENDIF
	XRA	A
	STA	LFEEDS
	STA	CDOFF
	STA	FKFLAG
	IF	ZCPR2 OR ZCPR3
	STA	WHEEL
	ENDIF
	MVI	A,TOVALUE
	STA	TOVAL
	IF	COMFILE
	LDA	OPTION
	CPI	'E'
	JZ	WELCOME
	ENDIF
	LXI	H,CWCAR
	INR	M
	IF	B5IM
	JMP	WELCOME
	ENDIF
	IF	NOT B5IM
ANSWA:	CALL	SET300
	MVI	A,BP300
	STA	MSPEED
	CALL	MDINP
	CALL	MDINP
ANSWB:	CALL	PATCH
	ENDIF
	IF	PRGRSS AND (NOT	B5IM)
	LXI	H,MSG30
	CALL	PRINTL
	ENDIF
	IF	NOT B5IM
	CALL	TSTBAUD
	JZ	WELCOME
	ENDIF
	IF	PRGRSS AND (NOT	B5IM) AND (HS1200 OR HS2400)
	LXI	H,MSG12
	CALL	PRINTL
	ENDIF
	IF	(NOT B5IM) AND (HS1200 OR HS2400)
	CALL	SET1200
	JNZ	ANS0
	MVI	A,BP1200
	STA	MSPEED
	CALL	MDINP
	CALL	TSTBAUD
	JZ	WELCOME
	ENDIF
ANS0:	IF	PRGRSS AND (NOT	B5IM) AND HS2400
	LXI	H,MSG24
	CALL	PRINTL
	ENDIF
	IF	(NOT B5IM) AND HS2400
	CALL	SET2400
	JNZ	BADDO
	MVI	A,BP2400
	STA	MSPEED
	CALL	MDINP
	CALL	TSTBAUD
	JZ	WELCOME
	ENDIF
	IF	NOT B5IM
BADDO:	CALL	UNPATCH
	JMP	ANSWA
	ENDIF
	IF	CPM3
DRVSRC:	DB	SDRV1,SDRV2,SDRV3,SDRV4
DEFPW:	DB	'        '
RSXCL:	DB	56
	ENDIF
	IF	NOT CPM3
BDCHEK:	PUSH	H
	DB	LXIH
BDADDR:	DW	0000H
	SHLD	6
	POP	H
	RET
	ENDIF
CHECK:	IF	MINICK
	LDA	IOBYTE
	ANI	80H
	RNZ
	ENDIF
	IF	RBBS OR	MBBS OR	PBBS OR	QBBS
	LDA	WRTLOC
	ORA	A
	RNZ
	ENDIF
	LDA	MDMOFF
	ORA	A
	RNZ
	CALL	CARCK
	RNC
	LXI	SP,STACK
	LXI	H,CLMSG
	CALL	PRINTL
	IF	DISKLOG
	XRA	A
	STA	BDOSFL
	LXI	H,CARMSG
	CALL	WRTMSG
	JMP	LOGOFF
DROPIT:
	LXI	SP,STACK
	XRA	A
	STA	BDOSFL
	LXI	H,DRPMSG
	CALL	WRTMSG
	ENDIF
LOGOFF:	LXI	SP,STACK
	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	CALL	PATCH
	IF	TIMEON
	LDA	TON
	STA	LCTON
	ENDIF
	CALL	MDCARCK
	JZ	LOGOF1
	IF	NOT BYHANG
	JMP	LOGOF2
	ENDIF
	IF	TIMEON AND CLOCK
	CALL	RMTOS
	ENDIF
	IF	PRNTGB
	LXI	H,GBMSG
	CALL	PRINTB
	ENDIF
LOGOF1:	MVI	A,255
	STA	MDMOFF
	STA	TCHKFG
	CALL	IMDONE
LOGOF2:	IF	MBBS
	XRA	A
	STA	FCB+1
	STA	0
	STA	MXTIME
	LDA	LCDATA
	CPI	' '
	JNZ	MBBS01
	ENDIF
	IF	EXFILE
	LXI	H,EXTMSG
	CALL	PRINTL
	MVI	C,SETUSR
	MVI	E,EXUSR
	CALL	BDOS
	MVI	C,SELDSK
	MVI	E,EXDRV-'A'
	CALL	BDOS
	CALL	LODEX
	CALL	100H
	ENDIF
	IF	EXFILE AND (NOT	BYHANG)
	CALL	MDCARCK
	JZ	PREOFF
	ENDIF
	IF	CLOCK AND TIMEON AND EXFILE AND	(NOT BYHANG)
	CALL	RMTOS
	ENDIF
	IF	PRNTGB AND EXFILE AND (NOT BYHANG)
	LXI	H,GBMSG
	CALL	PRINTB
	ENDIF
	JMP	PREOFF
CKFUNC:	IF	LEADIN
	PUSH	PSW
	CPI	LEADKY
	JNZ	FKEY1
	MVI	A,0FFH
	STA	FKFLAG
	POP	PSW
	MVI	A,07FH
	RET
FKEY1:	LDA	FKFLAG
	ORA	A
	JZ	FKEXIT
	XRA	A
	STA	FKFLAG
	POP	PSW
	ANI	1FH
	ENDIF
	IF	B5IM AND (NOT NOATA)
	MOV	B,A
	PUSH	B
	CALL	MDCARCK
	POP	B
	MOV	A,B
	JNZ	ANSKNO
	CPI	ANSKEY
	CZ	IMRIN2
ANSKNO:	ENDIF
	IF	NO25TH OR MBBS
	CPI	WHOKEY
	JZ	WHOSIT
	ENDIF
	IF	TIMEON
	CPI	TIMEKEY
	JZ	DTIME
	ENDIF
	CPI	ZCREEN
	JZ	CLEARIT
	CPI	BELLKEY
	JZ	BELLTOG
	IF	DISKLOG
	CPI	LOGKEY
	JZ	LOGFLP
	ENDIF
	MOV	B,A
	PUSH	B
	CALL	MDCARCK
	POP	B
	MOV	A,B
	RZ
	CPI	LCKEY
	JZ	LCDOIT
	CPI	ULTKEY
	JZ	ULTIME
	CPI	BLNKKEY
	JZ	BLNKTOG
	CPI	SYSDKEY
	JZ	SYSDOWN
	CPI	TWITKEY
	PUSH	PSW
	CZ	IMDONE
	POP	PSW
	IF	NOT DISKLOG
	JZ	LOGOFF
	ENDIF
	IF	DISKLOG
	JZ	DROPIT
	ENDIF
	CPI	MSGKEY
	RNZ
	LXI	H,MFSMSG
	CALL	PRINTB
SYSML:	CALL	VCONIN
	CPI	XITKEY
	JZ	SYSMX
	MOV	C,A
	PUSH	PSW
	CALL	MOUTPUT
	POP	PSW
	CPI	'H'-'@'
	JZ	SYSMBS
	CPI	CR
	JZ	SYSMCR
	JMP	SYSML
SYSMCR:	MVI	C,LF
	JMP	SYSECH
SYSMBS:	MVI	C,' '
	CALL	MOUTPUT
	MVI	C,'H'-'@'
SYSECH:	CALL	MOUTPUT
	JMP	SYSML
SYSMX:	MVI	C,CR
	CALL	MOUTPUT
	MVI	C,LF
	CALL	MOUTPUT
	CALL	MDINP
	CALL	MDINP
	MVI	A,CR
	RET
SYSDOWN:LXI	H,SGDMSG
	CALL	PRINTB
	IF	TIMEON
	CALL	TCHECK
	LDA	TON
	ADI	DOWNMIN
	STA	MXTIME
	ENDIF
	MVI	A,CR
	RET
LCDOIT:	LXI	H,LCDMSG
	CALL	PRINTL
	MVI	A,07FH
	STA	LCDFLG
	RET
BELLTOG:LDA	BELLON
	ORA	A
	MVI	A,0FFH
	LXI	H,BELMON
	JZ	BELLT1
	XRA	A
	LXI	H,BELMOFF
BELLT1:	STA	BELLON
	IF	LMBELL
	ORA	A
	JZ	BELLT2
	XRA	A
	JMP	BELLT3
BELLT2:	MVI	A,0FFH
BELLT3:	STA	KILBEL
	ENDIF
	CALL	PRINTL
	MVI	A,07FH
	RET
ULTIME:	XRA	A
	STA	MXTIME
	MVI	A,0FFH
	STA	LCPTR
	LXI	H,ULTMSG
	CALL	PRINTL
	MVI	A,CR
	RET
BLNKTOG:LDA	MDMOFF
	ORA	A
	IF	ZCPR2 OR ZCPR3
	JZ	DUSET
	CALL	RETDU
	ENDIF
	IF	(NOT ZCPR2) AND	(NOT ZCPR3)
	MVI	A,0FFH
	LXI	H,SCRMOFF
	JZ	BLNKT1
	XRA	A
	LXI	H,SCRMON
	ENDIF
BLNKT1:	STA	MDMOFF
	IF	ZCPR2 OR ZCPR3
	STA	WHEEL
	ENDIF
	CALL	PRINTL
	MVI	A,CR
	RET
DUSET:	IF	ZCPR2 OR ZCPR3
	MVI	A,SYSUSR+1
	STA	MAXUSER
	MVI	A,SYSDRV-1
	STA	MAXDRIV
	LDA	LCPTR
	STA	CDOFF
	ENDIF
	IF	CHGPATH
	CALL	SYSPAT
	ENDIF
	IF	ZCPR2 OR ZCPR3
	MVI	A,0FFH
	STA	LCPTR
	LXI	H,SCRMOFF
	JMP	BLNKT1
RETDU:	LDA	MXUSR
	INR	A
	STA	MAXUSER
	LDA	MXDRV
	DCR	A
	STA	MAXDRIV
	LDA	CDOFF
	STA	LCPTR
	ENDIF
	IF	CHGPATH
	CALL	REMPAT
	ENDIF
	IF	ZCPR2 OR ZCPR3
	XRA	A
	LXI	H,SCRMON
	RET
	ENDIF
	IF	NO25TH OR MBBS
WHOSIT:	LXI	H,CRMSG
	CALL	PRINTL
	LXI	H,LCHEAD
	CALL	PRINTL
	LXI	H,LCDATA
	CALL	PRINTL
	LXI	H,CRMSG
	CALL	PRINTL
	MVI	A,07FH
	RET
	ENDIF
	IF	TIMEON
DTIME:	CALL	TCHECK
	LXI	H,LFMSG
	CALL	PRINTL
	LDA	MXTIME
	ORA	A
	JZ	DTIME1
	LXI	H,TLNMSG
	ENDIF
	IF	TIMEON AND (ZCPR2 OR ZCPR3)
	LDA	WHEEL
	ORA	A
	JNZ	DTIME1
	ENDIF
	IF	TIMEON
	JMP	DTIME2
DTIME1:	LXI	H,TONMSG
DTIME2:	CALL	PRINTL
	LXI	H,LFMSG
	CALL	PRINTL
	MVI	A,07FH
	RET
	ENDIF
CLEARIT:LXI	H,CLRSEQ
	CALL	PRINTL
	MVI	A,LF
	RET
	IF	LEADIN
FKEXIT:	POP	PSW
	RET
	ENDIF
REALBD:	JMP	0
BYERSX:
	IF	DISKLOG
	MOV	A,C
	CPI	15
	JNZ	NOT15B
	LDA	LOGTOG
	ORA	A
	JZ	NOT15
	PUSH	D
	CALL	LOGFLP
	POP	D
	XRA	A
	STA	LOGTOG
	JMP	NOT15A
NOT15:
	LDA	DSKLOG
	ORA	A
	JZ	NOT15A
	PUSH	D
	CALL	SETLUS
	LXI	D,LOGFCB
	MVI	C,16
	CALL	REALBD
	CALL	CLRLUS
	POP	D
NOT15A:
	MVI	C,15
NOT15B:
	CALL	STBDOS
	LDA	DSKLOG
	ORA	A
	MOV	A,C
	JZ	NOLOGTEST
	ENDIF
	IF	DISKLOG	AND CPM3
	CPI	98
	JNZ	NOT98
	CALL	SETLUS
	LXI	D,LOGFCB
	MVI	C,16
	CALL	REALBD
	CALL	CLRLUS
	MVI	C,98
	JMP	REALBD
NOT98:
	CPI	13
	JNZ	NOT13
	LXI	D,80H
	MVI	C,26
	CALL	REALBD
	MVI	E,0
	MVI	C,14
	CALL	REALBD
	LXI	D,0FFFFH
	MVI	C,37
	MOV	A,C
NOT13:
	CPI	37
	JNZ	NOT37
	MOV	A,E
	ANI	0FEH
	MOV	E,A
	JMP	REALBD
NOT37:
	ENDIF
	IF	DISKLOG	AND (NOT CPM3)
	CPI	13
	JNZ	NOT13
	CALL	SETLUS
	LXI	D,LOGFCB
	MVI	C,16
	CALL	REALBD
	CALL	CLRLUS
	MVI	C,13
	JMP	REALBD
NOT13:
	ENDIF
	IF	DISKLOG
	CPI	1
	JNZ	NOT1
	CALL	REALBD
	JMP	HARDWR
NOT1:
	CPI	6
	JNZ	NOT6
	MOV	A,E
	INR	A
	JNZ	REALBD
	CALL	REALBD
	ORA	A
	RZ
HARDWR:
	CALL	STKNEW
	PUSH	PSW
	ANI	7FH
	CALL	WRBYTE
	CPI	CR
	JNZ	HARRET
	MVI	A,LF
	CALL	WRBYTE
HARRET:
	POP	PSW
	RET
NOT6:
	CPI	10
	JNZ	NOLOGTEST
	PUSH	D
	CALL	REALBD
	POP	H
	INX	H
	MOV	A,M
	ORA	A
	RZ
	CALL	STKNEW
	PUSH	H
	CALL	WRTTIM
	POP	H
	MOV	B,M
	INX	H
B10LOP:
	MOV	A,M
	CALL	WRBYTE
	INX	H
	DCR	B
	JNZ	B10LOP
	JMP	WRCRLF
NOLOGTEST:
	ENDIF
	IF	DISKLOG	AND (NOT CPM3)
	CPI	26
	JNZ	NOTDMA
	XCHG
	SHLD	OLDDMA
	XCHG
	JMP	REALBD
NOTDMA:
	ENDIF
	MOV	A,C
	CPI	32
	JZ	TSTUSR
	CPI	LOCMD
	JC	REALBD
	CPI	HICMD+1
	JNC	REALBD
	SUI	LOCMD
	PUSH	D
	MOV	E,A
	ADD	A
	ADD	E
	MOV	E,A
	MVI	D,0
	LXI	H,RSXTBL
	DAD	D
	POP	D
	MOV	A,E
	PCHL
RSXTBL:	JMP	MDINST
	JMP	MDOUTST
	JMP	MDOUTP
	JMP	MDINP
	JMP	MDCARCK
	JMP	CONSTAT
	JMP	CONIN
	JMP	RCONOT
	JMP	RMXDRV
	JMP	RMXUSR
	JMP	RMTOUT
	JMP	RMNULL
	JMP	RMULC
	JMP	RMLFM
	JMP	RMWRT
	JMP	RMHDR
	JMP	RMOFF
	JMP	RMBELL
	JMP	RMRTC
	JMP	RMLCBF
	JMP	RMMXT
	JMP	RMLTIM
	JMP	RMTOS
	JMP	SRUDEF
	JMP	RMXLCP
	JMP	LOGSTAT
	JMP	LOGPUT
	JMP	IMDONE
TSTUSR:	MOV	A,E
	CPI	241
	JNZ	REALBD
	MVI	A,77
	RET
RCONOT:	MOV	C,E
	JMP	VCONOUT
RMXDRV:	LXI	H,MXDRV
	JMP	SETGET1
RMXUSR:	LXI	H,MXUSR
	JMP	SETGET1
RMNULL:	LXI	H,NULLS
	JMP	SETGET1
RMTOUT:	LXI	H,TOVAL
	JMP	SETGET1
RMULC:	LXI	H,ULCSW
	JMP	SETGET1
RMLFM:	LXI	H,LFEEDS
	JMP	SETGET2
RMHDR:	LXI	H,HARDON
	JMP	SETGET2
RMWRT:	LXI	H,WRTLOC
	JMP	SETGET2
RMOFF:	LXI	H,MDMOFF
	JMP	SETGET2
RMBELL:	LXI	H,BELLON
	JMP	SETGET2
RMRTC:	IF	TIMEON
	CALL	TCHECK
	ENDIF
	IF	CLOCK AND (NOT TIMEON)
	CALL	TIME
	ENDIF
	LDA	TON
	LXI	H,RTCBUF
	RET
RMXLCP:	LXI	H,LCPTR
	INR	A
	JZ	SGET1
	MOV	M,D
	RET
RMLCBF:	LXI	H,LCDATA
	RET
RMMXT:	LXI	H,MXTIME
	JMP	SETGET1
RMLTIM:	STA	LMIN
	MOV	A,D
	STA	LHOUR
	RET
RMTOS:	IF	TIMEON
	CALL	TCHECK
	LDA	MXTIME
	ORA	A
	JZ	RMTOS1
	LXI	H,TLNMSG
	ENDIF
	IF	TIMEON AND (ZCPR2 OR ZCPR3)
	LDA	WHEEL
	ORA	A
	JNZ	RMTOS1
	ENDIF
	IF	TIMEON
	JMP	RMTOS2
RMTOS1:	LXI	H,TONMSG
RMTOS2:	CALL	PRINTB
	ENDIF
	RET
SETGET1:INR	A
	JZ	SGET1
	DCR	A
	MOV	M,A
	RET
SGET1:	MOV	A,M
	RET
SETGET2:INR	A
	JZ	SGET1
	DCR	A
	JZ	SGET2W
	MVI	A,255
SGET2W:	MOV	M,A
	RET
CONIN:	PUSH	B
	PUSH	D
	PUSH	H
	CALL	VCONIN
	CALL	CKFUNC
	POP	H
	POP	D
	POP	B
	RET
CONOUT:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	A,C
	ANI	07FH
	CNZ	VCONOUT
	POP	H
	POP	D
	POP	B
	RET
CONSTAT:PUSH	B
	PUSH	D
	PUSH	H
	CALL	VCONSTAT
	POP	H
	POP	D
	POP	B
	RET
DELAY:	PUSH	B
	LXI	B,4167*MHZ
DELAY1:	DCX	B
	MOV	A,B
	ORA	C
	JNZ	DELAY1
	POP	B
	RET
KDELAY:	PUSH	B
	LXI	B,42*MHZ
	JMP	DELAY1
BEXCPM:	LXI	H,BELMSG
	CALL	PRINTL
EXCPM:	IF	B5IM
	CALL	IMQUIT
	ENDIF
	IF	NOT B5IM
	CALL	MDQUIT
	ENDIF
	IF	MOTOR
	CALL	DSKON
	ENDIF
	IF	DISKLOG
	MVI	E,0
	CALL	TSTHRD
	ENDIF
	LHLD	REALBD+1
	IF	CPM3
	SHLD	STARTX+1
	ENDIF
	IF	NOT CPM3
	SHLD	BDOS+1
	ENDIF
	IF	ZCPR2 OR ZCPR3
	MVI	A,0FFH
	STA	WHEEL
	MVI	A,SYSUSR+1
	STA	MAXUSER
	MVI	A,SYSDRV-1
	STA	MAXDRIV
	ENDIF
	IF	CHGPATH
	CALL	SYSPAT
	ENDIF
	IF	ZCPR3
	CALL	DOZ3
	ENDIF
	IF	CPM3
	CALL	RSXCLR
	ENDIF
	CALL	UNPATCH
	MVI	A,0C3H
	STA	000H
	JMP	0000H
	IF	ZCPR3
DOZ3:	LHLD	Z3CL
	MVI	M,0
	LXI	H,SHSTK
	CALL	ZERO128
	LXI	H,Z3ENV+128
	CALL	ZERO128
	LXI	H,Z3MSG
	MVI	B,80
	CALL	ZEROM
	RET
ZERO128:MVI	B,128
	ENDIF
ZEROM:	MVI	M,0
	INX	H
	DCR	B
	JNZ	ZEROM
	RET
CARCK:	IF	LMBELL
	LDA	KILBEL
	CMA
	STA	BELLON
	ENDIF
	LDA	MDMOFF
	ORA	A
	JNZ	CARCK2
	CALL	MDCARCK
	JNZ	CARCK2
	PUSH	B
	MVI	B,CLOSS*10
CARLP:	CALL	DELAY
	CALL	MDCARCK
	MOV	A,B
	POP	B
	JNZ	CARCK2
	DCR	A
	STC
	RZ
	PUSH	B
	MOV	B,A
	JMP	CARLP
CARCK2:	IF	USEZCPR	AND (ZCPR2 OR ZCPR3)
	LDA	MAXDRIV
	INR	A
	STA	MXDRV
	LDA	MAXUSER
	DCR	A
	STA	MXUSR
	ENDIF
	IF	(NOT USEZCPR) AND (ZCPR2 OR ZCPR3)
	LDA	MXDRV
	DCR	A
	STA	MAXDRIV
	LDA	MXUSR
	INR	A
	STA	MAXUSER
	ENDIF
	IF	CHEKDU
	LDA	0004H
	ANI	0FH
	PUSH	H
	LXI	H,MXDRV
	CMP	M
	JC	CARCK3
	LDA	0004H
	ANI	0F0H
	ORI	WBDRIV
	STA	0004H
	ENDIF
	IF	CPM3 AND CHEKDU
	MVI	A,WBDRIV
	CALL	SETDRIVE
	ENDIF
	IF	CHEKDU
	LXI	H,IDMSG
	CALL	PRINTB
	JMP	0000H
CARCK3:	LDA	0004H
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC
	LXI	H,MXUSR
	CMP	M
	JC	CARCK4
	JZ	CARCK4
	LDA	0004H
	ANI	0FH
	STA	0004H
	ENDIF
	IF	CPM3 AND CHEKDU
	XRA	A
	CALL	SETUSER
	ENDIF
	IF	CHEKDU
	LXI	H,IUMSG
	CALL	PRINTB
	JMP	0000H
CARCK4:	POP	H
	ENDIF
	ORA	A
	RET
PRINTB:	PUSH	B
	PUSH	PSW
PRBL:	MOV	C,M
	CALL	MOUTPUT
	INX	H
	MOV	A,M
	ORA	A
	JNZ	PRBL
	POP	PSW
	POP	B
	RET
PRINTL:	PUSH	B
	PUSH	PSW
	IF	RVIDEO
	CALL	MDCARCK
	JZ	PRLL
	PUSH	H
	LXI	H,RVIDON
	CALL	PRTREV
	POP	H
	ENDIF
PRLL:	MOV	C,M
	CALL	CONOUT
	INX	H
	MOV	A,M
	ORA	A
	JNZ	PRLL
	IF	RVIDEO
	CALL	MDCARCK
	LXI	H,RVIDOFF
	CNZ	PRTREV
	ENDIF
	POP	PSW
	POP	B
	RET
	IF	RVIDEO
PRTREV:	MOV	C,M
	CALL	CONOUT
	INX	H
	MOV	A,M
	ORA	A
	RZ
	JMP	PRTREV
	ENDIF
LISTOUT:PUSH	B
	PUSH	D
	PUSH	H
	PUSH	PSW
	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	MOV	C,A
	CALL	VLISTOUT
	POP	PSW
	POP	H
	POP	D
	POP	B
	RET
	IF	DISKLOG
LOGFLP:	LDA	BDOSFL
	ORA	A
	JZ	LOGFLP1
	STA	LOGTOG
	MVI	A,07FH
	RET
LOGFLP1:
	CALL	STKNEW
	LXI	H,DSKLOG
	MOV	A,M
	ORA	A
	JZ	OPENLOG
	XRA	A
	JP	CLSHRD
OPENLOG:
	LXI	H,DSKLOG
OPNHRD:
	INR	M
	DCR	M
	MVI	A,07FH
	RNZ
	ORI	0FFH
	MOV	M,A
	CALL	OPNLOG
	LXI	H,OPNMSG
	CALL	PRINTL
	MVI	A,07FH
	RET
TSTHRD:
	MOV	A,E
	LXI	H,DSKLOG
	ORA	M
	RZ
	CALL	STKNEW
	MOV	A,E
	ORA	A
	JNZ	OPNHRD
CLSHRD:
	MOV	M,A
	CALL	WRCRLF
	CALL	CLSLOG
	LXI	H,CLSMSG
	CALL	PRINTL
	MVI	A,07FH
	RET
CLSLOG:
	MVI	A,26
	CALL	WRBY
	CALL	WRITE
	CALL	SETLUS
	LXI	D,LOGFCB
	MVI	C,16
	CALL	REALBD
	JMP	CLRLUS
OPNLOG:
	CALL	SETLUS
	XRA	A
	STA	WOFFSET
	LXI	H,LOGFCB+12
	LXI	D,LOGFCB+13
	MVI	M,0
	MVI	B,23
	CALL	MOVE
	LXI	D,LOGFCB
	MVI	C,15
	CALL	REALBD
	INR	A
	JNZ	NOLOGMAKE
	LXI	D,LOGFCB
	MVI	C,22
	CALL	REALBD
NOLOGMAKE:
	LXI	D,LOGFCB
	MVI	C,35
	CALL	REALBD
	LHLD	LOGFCB+33
	MOV	A,H
	ORA	L
	JZ	CLRLUS
	DCX	H
	SHLD	LOGFCB+33
	LXI	D,LOGFCB
	MVI	C,33
	CALL	REALBD
	LXI	B,128
	MVI	A,26
	LXI	H,RECORD
FINDEOF:
	CMP	M
	JZ	FOUNDEOF
	INX	H
	INR	B
	DCR	C
	JNZ	FINDEOF
	DCR	B
FOUNDEOF:
	LXI	H,WOFFSET
	MOV	M,B
	JMP	CLRLUS
	ENDIF
	IF	DISKLOG	AND CPM3
SETLUS:
	LHLD	SCBBASE
	MVI	L,0E0H
	MOV	A,M
	LXI	D,OLDLUS
	STAX	D
	MVI	M,LOGUSR
	MVI	L,0E6H
	INX	D
	MOV	A,M
	MVI	M,1
	STAX	D
	MVI	L,0D8H
	INX	D
	MOV	A,M
	STAX	D
	INR	L
	INX	D
	MOV	A,M
	STAX	D
	LXI	D,RECORD
	MVI	C,26
	JMP	REALBD
CLRLUS:
	LHLD	SCBBASE
	MVI	L,0E0H
	LXI	D,OLDLUS
	LDAX	D
	MOV	M,A
	MVI	L,0E6H
	INX	D
	LDAX	D
	MOV	M,A
	INX	D
	XCHG
	MOV	E,M
	INX	H
	MOV	D,M
	MVI	C,26
	JMP	REALBD
	ENDIF
	IF	DISKLOG	AND (NOT CPM3)
SETLUS:
	MVI	E,255
	MVI	C,32
	CALL	REALBD
	STA	OLDLUS
	MVI	E,LOGUSR
	MVI	C,32
	CALL	REALBD
	LXI	D,RECORD
	MVI	C,26
	JMP	REALBD
CLRLUS:
	LDA	OLDLUS
	MOV	E,A
	MVI	C,32
	CALL	REALBD
	LHLD	OLDDMA
	XCHG
	MVI	C,26
	JMP	REALBD
	ENDIF
	IF	DISKLOG
ADDHLA:
	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
WRBYTE:
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	CPI	' '
	JNC	WROK
	CPI	CR
	JZ	WROK
	CPI	LF
	JZ	WROK
	CPI	8
	JZ	WROK
	MVI	A,'^'
	CALL	WRBY
	POP	PSW
	PUSH	PSW
	ADI	40H
WROK:
	CALL	WRBY
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
WRBY:
	PUSH	PSW
	LDA	WOFFSET
	LXI	H,RECORD
	CALL	ADDHLA
	POP	PSW
	MOV	M,A
	LXI	H,WOFFSET
	MOV	A,M
	INR	A
	CM	WRITE
	MOV	M,A
	RET
WRITE:
	LDA	WOFFSET
	ORA	A
	RZ
	PUSH	H
	CALL	SETLUS
	LXI	D,LOGFCB
	MVI	C,21
	CALL	REALBD
	CALL	CLRLUS
	XRA	A
	POP	H
	RET
WRCRLF:
	MVI	A,CR
	CALL	WRBYTE
	MVI	A,LF
	JMP	WRBYTE
WRTMSG:
	LDA	DSKLOG
	ORA	A
	RZ
	PUSH	H
	CALL	WRTTIM
	POP	H
WRTMS1:
	MOV	A,M
	ORA	A
	JZ	WRCRLF
	CALL	WRBYTE
	INX	H
	JMP	WRTMS1
WRTTIM:
	ENDIF
	IF	DISKLOG	AND CLOCK
	CALL	TIME
	ENDIF
	IF	DISKLOG
	LXI	H,RTCBUF
	CALL	WRTA
	MVI	A,':'
	CALL	WRBYTE
	INX	H
	CALL	WRTA
	MVI	A,' '
	JMP	WRBYTE
WRTA:
	MOV	A,M
	RAR
	RAR
	RAR
	RAR
	CALL	WRTHEX
	MOV	A,M
WRTHEX:
	ANI	0FH
	ADI	'0'
	JMP	WRBYTE
STBDOS:
	MVI	A,0FFH
	STA	BDOSFL
	POP	H
	SHLD	CALLIN+1
CALLIN:
	CALL	0
	PUSH	PSW
	XRA	A
	STA	BDOSFL
	POP	PSW
	RET
STKNEW:
	SHLD	HLSAVE
	POP	H
	SHLD	USRCAL+1
	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,NEWSTK
	LHLD	HLSAVE
USRCAL:
	CALL	0
	LXI	SP,0
OLDSP	EQU	$-2
	RET
LOGSTAT:
	MOV	A,E
	INR	A
	JNZ	TSTHRD
	LDA	DSKLOG
	ORA	A
	RZ
	ORI	0FFH
	RET
LOGPUT:
	CALL	STKNEW
	XCHG
	JMP	WRTMSG
	ENDIF
	IF	NOT DISKLOG
LOGSTAT:
LOGPUT:
	MVI	A,77
	RET
	ENDIF
	IF	DISKLOG
PUTSL:
	MVI	A,'/'
	STAX	D
	INX	D
	RET
DATEMSG:
	MOV	A,M
	RAR
	RAR
	RAR
	RAR
	CALL	PUTDATE
	MOV	A,M
	INX	H
PUTDATE:
	ANI	0FH
	ADI	'0'
	STAX	D
	INX	D
	RET
	ENDIF
LODCOM:	IF	COMFILE
	MVI	C,SELDSK
	MVI	E,COMDRV-'A'
	CALL	BDOS
	MVI	C,SETUSR
	MVI	E,COMUSR
	CALL	BDOS
	ENDIF
	IF	MSGFIL
	LDA	000H
	CPI	0C2H
	JNZ	NOMSGF
	XRA	A
	STA	MSGFCB
	LXI	H,MSGFCB
	SHLD	CURRFCB
	LXI	H,MSGFCB+12
	MVI	B,21
	CALL	ZEROM
	LXI	D,MSGFCB
	JMP	LODCM2
NOMSGF:	ENDIF
	IF	MBBS
	LDA	OPTION
	CPI	'C'
	JNZ	LODCM1
	MVI	C,SELDSK
	MVI	E,MBSDRV-'A'
	CALL	BDOS
	MVI	C,SETUSR
	MVI	E,MBSUSR
	CALL	BDOS
	XRA	A
	STA	OPTION
	STA	FCB+1
	STA	CM2FCB
	LXI	H,CM2FCB
	SHLD	CURRFCB
	LXI	H,CM2FCB+12
	MVI	B,21
	CALL	ZEROM
	LXI	D,CM2FCB
	JMP	LODCM2
	ENDIF
	IF	COMFILE
LODCM1:	LXI	H,COMFCB
	SHLD	CURRFCB
	XRA	A
	STA	COMFCB
	LXI	H,COMFCB+12
	MVI	B,21
	CALL	ZEROM
	LXI	D,COMFCB
LODCM2:	CALL	OPENFIL
	JZ	ABORT
	JMP	LOADFIL
	ENDIF
LODEX:	IF	EXFILE
	LXI	H,EXITFCB
	SHLD	CURRFCB
	LXI	H,EXITFCB+12
	MVI	B,21
	CALL	ZEROM
	LXI	D,EXITFCB
	CALL	OPENFIL
	JZ	ABORT
	ENDIF
	IF	COMFILE	OR EXFILE
LOADFIL:LHLD	6
	LXI	D,-80H
	DAD	D
	PUSH	H
	LXI	D,80H
	LXI	B,0
	PUSH	B
	PUSH	D
GLOOP:	POP	D
	LXI	H,80H
	DAD	D
	POP	B
	POP	D
	PUSH	D
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	JNC	SIZEOK
	LXI	H,PTSMSG
	JMP	ERRXIT
SIZEOK:	INX	B
	PUSH	B
	PUSH	H
	XCHG
	MVI	C,STDMA
	CALL	BDOS
	LHLD	CURRFCB
	XCHG
	MVI	C,READ
	CALL	BDOS
	ORA	A
	JZ	GLOOP
	POP	B
	POP	B
	POP	H
	MOV	A,B
	ORA	C
	JZ	ABORT
	LXI	D,80H
	MVI	C,STDMA
	CALL	BDOS
	LXI	H,CFLMSG
	CALL	PRINTL
	RET
ABORT:	LXI	H,CNFMSG
ERRXIT:	CALL	PRINTL
	MVI	A,0CDH
	STA	000H
	JMP	000H
	ENDIF
OPENFIL:IF	CPM3
	PUSH	D
	LXI	D,0080H
	MVI	C,STDMA
	CALL	BDOS
	POP	D
	PUSH	D
	MVI	C,SEARCH
	CALL	BDOS
	INR	A
	POP	D
	RZ
	PUSH	D
	DCR	A
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	MOV	E,A
	MVI	D,0
	LXI	H,0080H
	DAD	D
	POP	D
	PUSH	D
	INX	H
	INX	D
	MVI	B,11
	CALL	MOVE
	POP	D
	ENDIF
	MVI	C,OPEN
	CALL	BDOS
	INR	A
	RET
MBOOT:	LDA	OPTION
	CPI	0FFH
	JZ	VWARMBT
	LXI	SP,STACK
	IF	EXRET
	LDA	FCB+1
	CPI	'r'
	JZ	PREOFF
	ENDIF
	IF	MSGFIL
	LDA	0
	CPI	0C2H
	JNZ	MBOOT1
	LXI	H,MSGMSG
	CALL	PRINTL
	CALL	LODCOM
	MVI	A,0C3H
	STA	000H
	CALL	0100H
	LXI	SP,STACK
MBOOT1:	ENDIF
	IF	CPM3
	MVI	B,0B3H
	CALL	GETSCB
	ANI	080H
	JNZ	VWARMBT
	ENDIF
	IF	(COMFILE OR EXFILE) AND	(NOT PBBS)
	LDA	OPTION
	CPI	'E'
	JNZ	MBOOT2
	MVI	A,' '
	STA	FCB+1
	STA	OPTION
	CALL	UNPATCH
	ENDIF
	IF	EXFILE AND (NOT	MBBS) AND (NOT PBBS)
	JMP	LOGOFF
	ENDIF
	IF	COMFILE	AND (NOT PBBS)
	JMP	START0
	ENDIF
MBOOT2:	LDA	0
	CPI	0C3H
	IF	MBBS
	JNZ	NORPTC
	ENDIF
	IF	NOT MBBS
	JNZ	LOGOFF
	ENDIF
	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	IF	(NO25TH	OR MBBS) AND READLC
	LDA	LCDATA
	CPI	' '
	JNZ	NO25EX
	XRA	A
	STA	FCBRNO
	LXI	H,LCNAME
	LXI	D,FCB
	MVI	B,13
	CALL	MOVE
	MVI	C,0DH
	CALL	BDOS
	MVI	C,SELDSK
	MVI	E,LCDRV-'A'
	CALL	BDOS
	MVI	C,SETUSR
	MVI	E,LCUSR
	CALL	BDOS
	LXI	D,FCB
	CALL	OPENFIL
	LXI	H,LCMSG1
	CZ	PRINTL
	JZ	NO25EX
	LXI	D,FCB
	MVI	C,READ
	CALL	BDOS
	LXI	H,LCMSG1
	ORA	A
	CNZ	PRINTL
	LXI	H,80H
	LXI	D,LCDATA
	MVI	B,NO25BF
	CALL	MOVE
	MVI	B,NO25BF
	LXI	H,LCDATA
NO25RD:	MOV	A,M
	CPI	'Z'-'@'
	JZ	NO25ZD
	CPI	','
	CZ	NO25SP
	CPI	';'
	CZ	NO25SP
	CPI	CR
	CZ	NO25SP
	CPI	LF
	CZ	NO25SP
	DCR	B
	JZ	NO25ZD
	INX	H
	JMP	NO25RD
NO25ZD:	XRA	A
	MOV	M,A
	STA	04H
	ENDIF
	IF	NO25TH OR MBBS
NO25EX:	CALL	WHOSIT
	ENDIF
	IF	PRNTWB
	LXI	H,WBMSG
	CALL	PRINTB
	ENDIF
	IF	TIMEON AND CLOCK AND PRNTOS
	CALL	RMTOS
	ENDIF
	JMP	VWARMBT
	IF	(NO25TH	OR MBBS) AND READLC
NO25SP:	MVI	A,' '
	MOV	M,A
	RET
	ENDIF
MINPUT:	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	XRA	A
	STA	MSFLAG
MINP2:	CALL	CONSTAT
	ORA	A
	JNZ	CONIN
	CALL	MSTAT
	ORA	A
	JZ	MINP2
MINP3:	CALL	MDINP
	ANI	7FH
	CPI	FILT4
	JZ	MINP2
	CPI	FILT1
	JZ	MINP2
	CPI	FILT2
	JZ	MINP2
	CPI	FILT3
	JZ	MINP2
	IF	ZCPR2 OR ZCPR3
	MOV	B,A
	LDA	WHEEL
	ORA	A
	MOV	A,B
	JNZ	MINP4
	ENDIF
	CPI	'P'-'@'
	JZ	MINP2
MINP4:	IF	HARDLOG
	PUSH	B
	MOV	B,A
	LDA	HARDON
	ORA	A
	MOV	A,B
	POP	B
	JZ	NOLOG
	CPI	20H
	JNC	MINP5
	CPI	CR
	JNZ	NOLOG
MINP5:	CALL	LISTOUT
	CPI	CR
	JNZ	NOLOG
	MVI	A,LF
	CALL	LISTOUT
	MVI	A,CR
	ENDIF
NOLOG:
	IF	DISKLOG
	MOV	C,A
	LDA	DSKLOG
	ORA	A
	JZ	NOHARD
	LDA	BDOSFL
	ORA	A
	JNZ	NOHARD
	CALL	STKNEW
	PUSH	H
	PUSH	B
	LDA	TIMSFL
	ORA	A
	CNZ	WRTTIM
	POP	B
	POP	H
	MOV	A,C
	CALL	WRBYTE
	CPI	CR
	MVI	A,LF
	CZ	WRBYTE
	MVI	A,0
	JNZ	HRDL1
	DCR	A
HRDL1:
	STA	TIMSFL
NOHARD:
	MOV	A,C
	ENDIF
	CPI	'C'-'@'
	RNZ
	LDA	0
	CPI	0C3H
	MVI	A,3
	RZ
	MVI	A,CTRLC
	RET
MOUTPUT:IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	XRA	A
	STA	MSFLAG
	IF	COMFILE	AND TIMEON AND CLOCK
	LDA	OPTION
	CPI	'E'
	JNZ	MONOTE
	MOV	A,C
	CPI	LF
	CZ	TCHECK
MONOTE:	ENDIF
	LDA	MDMOFF
	ORA	A
	PUSH	PSW
	CNZ	CONOUT
	POP	PSW
	RNZ
MOUTA:	CALL	CHECK
	CALL	MDOUTST
	JZ	MOUTA
	MOV	A,C
	ANI	7FH
	RZ
	CPI	60H
	JC	MOUTP2
	CPI	7FH
	JZ	MOUTP2
	PUSH	H
	LXI	H,ULCSW
	SUB	M
	POP	H
	MOV	C,A
MOUTP2:	CPI	LF
	JNZ	MOUTP3
	IF	TIMEON
	CALL	TCHECK
	ENDIF
	LDA	LFEEDS
	ORA	A
	MVI	A,0
	JNZ	MOUTP3
	MVI	A,LF
MOUTP3:	CALL	MDOUTP
	PUSH	PSW
	CPI	'G'-'@'
	JNZ	NOTBEL
	LDA	BELLON
	ORA	A
	JZ	ISBELL
NOTBEL:	CALL	CONOUT
ISBELL:	POP	PSW
	CPI	LF
	RNZ
	LDA	NULLS
	ORA	A
	RZ
	PUSH	B
	MOV	B,A
NULLP:	CALL	MDOUTST
	JZ	NULLP
	XRA	A
	CALL	MDOUTP
	DCR	B
	JNZ	NULLP
	POP	B
	RET
MOVE:	MOV	A,M
	STAX	D
	INX	D
	INX	H
	DCR	B
	JNZ	MOVE
	RET
MSTAT:	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	LDA	MDMOFF
	ORA	A
	MVI	A,0
	RNZ
	CALL	CHECK
	CALL	MDINST
	ORA	A
	JZ	MSTAT1
	PUSH	PSW
	XRA	A
	STA	MSFLAG
	POP	PSW
	RET
MSTAT1:	LDA	MSFLAG
	ORA	A
	MVI	A,0FFH
	STA	MSFLAG
	JNZ	MSTAT3
	LDA	TOVAL
MSTAT2:	STA	TOCNTM
	PUSH	H
	LXI	H,42000
	SHLD	TOCNT
	POP	H
MSTAT3:	CALL	KDELAY
	PUSH	H
	LHLD	TOCNT
	DCX	H
	SHLD	TOCNT
	MOV	A,H
	ORA	L
	POP	H
	JZ	MSTAT4
	XRA	A
	RET
MSTAT4:	MVI	A,'G'-'@'
	CALL	MDOUTP
	LDA	TOCNTM
	DCR	A
	JNZ	MSTAT2
TMOUT:	LXI	H,ITOMSG
	LXI	SP,STACK
	CALL	PRINTB
	CALL	PATCH
	IF	DISKLOG
	XRA	A
	STA	BDOSFL
	LXI	H,TMOMSG
	CALL	WRTMSG
	ENDIF
	IF	MBBS
	JMP	NORPTC
	ENDIF
	IF	NOT MBBS
	JMP	LOGOFF
	ENDIF
NEWJTBL:JMP	MCBOOT
	JMP	MBOOT
	JMP	MSTAT
	JMP	MINPUT
	JMP	MOUTPUT
	IF	(NOT HARDLOG) AND (NOT PRINTER)
	RET
	NOP
	NOP
	RET
	NOP
	NOP
	RET
	NOP
	NOP
	ENDIF
	IF	MOTOR
DSKON:	PUSH	PSW
	MVI	A,DISKON
	OUT	DISK
	PUSH	H
	LXI	H,0000
DSKLP:	XTHL
	XTHL
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	DSKLP
	POP	H
	POP	PSW
	RET
DSKOFF:	PUSH	PSW
	MVI	A,DISKOFF
	OUT	DISK
	POP	PSW
	RET
	ENDIF
NWBCALL:IF	LOSER
	CALL	WMSTRT
	CALL	PATCH
	ENDIF
	IF	NOT CPM3
	CALL	BDCHEK
	ENDIF
	RET
PATCH:	LDA	PTFLAG
	ORA	A
	JNZ	SKPTH
	CALL	TBLADDR
	LXI	D,VCOLDBT
	MVI	B,24
	CALL	MOVE
	LHLD	VCONOUT+1
	SHLD	COVECT
SKPTH:	CALL	TBLADDR
	XCHG
	LXI	H,NEWJTBL
	CALL	MOVE
	MVI	A,0FFH
	STA	PTFLAG
	IF	LOSER
	LXI	H,NWBCALL
	SHLD	WBCALL+1
	ENDIF
	RET
PRNLOG:	LXI	H,VMSG
	CALL	PRINTL
	CALL	CALSUM
	RET
CALSUM:	LDA	CWCAR
	LXI	H,ATMSN
	CALL	DEC8
	LXI	H,ATMSG
	CALL	PRINTL
	IF	B5IM
	LDA	VCNUM
	LXI	H,VCMSN
	CALL	DEC8
	LXI	H,VCMSG
	CALL	PRINTL
	ENDIF
	IF	PWRQD
	LDA	NWPWD
	LXI	H,NWMSD
	CALL	DEC8
	LXI	H,NWMSG
	CALL	PRINTL
	ENDIF
	LXI	H,LFMSG
	CALL	PRINTL
	RET
	IF	WELFILE
RDBYTE:	MOV	A,H
	ORA	A
	JZ	NORD
	LXI	D,FCB
	MVI	C,READ
	CALL	BDOS
	ORA	A
	MVI	A,1AH
	RNZ
	LXI	H,80H
NORD:	MOV	A,M
	INX	H
	RET
	ENDIF
TBLADDR:LHLD	1
	DCX	H
	DCX	H
	DCX	H
	IF	HARDLOG	OR PRINTER
	MVI	B,15
	ENDIF
	IF	(NOT HARDLOG) AND (NOT PRINTER)
	MVI	B,24
	ENDIF
	RET
	IF	NOT B5IM
TSTBAUD:CALL	MDCARCK
	JZ	PREOFF
	LDA	CDOFF
	INR	A
	STA	CDOFF
	CPI	60
	JZ	PREOFF
	MVI	D,20
TSTB1:	MVI	B,1
	PUSH	D
	CALL	DELAY
	CALL	MDINST
	ORA	A
	JZ	TSTB2
	CALL	MDINP
	ANI	7FH
	POP	D
	JMP	TSTB3
TSTB2:	POP	D
	DCR	D
	MOV	A,D
	ORA	A
	JNZ	TSTB1
	MVI	A,0FFH
TSTB3:	CPI	CR
	RZ
	CPI	LF
	RZ
	CPI	'C'-40H
	RET
	ENDIF
UNPATCH:CALL	TBLADDR
	XCHG
	LXI	H,VCOLDBT
	CALL	MOVE
	IF	LOSER
	LXI	H,WMSTRT
	SHLD	WBCALL+1
	ENDIF
	RET
USRCHK:	CALL	PRNLOG
	LXI	H,RS1MSG
	CALL	PRINTL
PRNREL:	CALL	CONSTAT
	ORA	A
	JZ	PRNREL
	CALL	VCONIN
	CPI	60H
	JC	$+5
	SBI	20H
	CPI	'E'
	JZ	USRUN
	CPI	'J'
	JZ	JMPCPM
	CPI	'R'
	JZ	PRNRES
	LXI	H,CRMSG
	CALL	PRINTL
	JNZ	EXCPM
PRNRES:	LXI	H,RS2MSG
	CALL	PRINTL
	IF	CLRSCR
	CALL	CLEARIT
	ENDIF
	RET
USRUN:	MVI	A,'E'
	STA	OPTION
	JMP	ERUN
JMPCPM:	IF	B5IM
	CALL	IMQUIT
	ENDIF
	IF	NOT B5IM
	CALL	MDQUIT
	ENDIF
	CALL	PATCH
	MVI	A,0C3H
	STA	000H
	MVI	A,0FFH
	STA	MDMOFF
	STA	OPTION
	STA	WRTLOC
	IF	ZCPR2 OR ZCPR3
	STA	WHEEL
	ENDIF
	JMP	000H
WELCOME:IF	CLOCK
	CALL	TIME
	LDA	CCHOUR
	STA	LHOUR
	LDA	CCMIN
	STA	LMIN
	ENDIF
	IF	DISKLOG
	CALL	OPENLOG
	LXI	H,RTCBUF+5
	LXI	D,CDAY
	CALL	DATEMSG
	CALL	PUTSL
	CALL	DATEMSG
	CALL	PUTSL
	LXI	H,RTCBUF+4
	CALL	DATEMSG
	LDA	MSPEED
	ADI	'0'
	STA	CONMS1
	LXI	H,CONMSG
	CALL	WRTMSG
	ENDIF
	IF	TIMEON OR CLOCK
	MVI	A,MAXMIN
	STA	MXTIME
	XRA	A
	STA	TCHKFG
	ENDIF
	IF	COMFILE
	LDA	OPTION
	CPI	'E'
	MVI	A,0
	STA	NULLS
	JZ	WELC1
	ENDIF
	LDA	MSPEED
	ADI	3
	STA	NULLS
	LXI	H,TERMSG
	CALL	PRINTB
	CALL	MDINP
	CALL	MDINP
	IF	NOT SKTERM
	CALL	MINPUT
	ENDIF
WELC1:	LXI	H,CRMSG
	CALL	PRINTB
	IF	RSPEED
	LDA	OPTION
	CPI	'E'
	JZ	SPDOK
	XRA	A
	LDA	MSPEED
	SUI	SPEED
	JNC	SPDOK
	CALL	TIME
	MVI	A,HOUR1
SPD01:	LXI	H,CCHOUR
	CMP	M
	JZ	SPDOFF
	INR	A
	CPI	HOUR2
	JZ	SPDOK
	CPI	24
	JNZ	SPD01
	XRA	A
	JMP	SPD01
SPDOFF:	LXI	H,OFFMSG
	CALL	PRINTB
	JMP	PREOFF
	ENDIF
SPDOK:	IF	WELFILE
	LXI	H,WELFILN
	LXI	D,FCB
	MVI	B,13
	CALL	MOVE
	LXI	D,80H
	MVI	C,STDMA
	CALL	BDOS
	MVI	C,SETUSR
	MVI	E,WELUSR
	CALL	BDOS
	MVI	C,SELDSK
	MVI	E,WELDRV-'A'
	CALL	BDOS
	LXI	D,FCB
	CALL	OPENFIL
	JZ	PASSINT
	XRA	A
	STA	FCBRNO
	LXI	H,100H
WELTYPE:CALL	RDBYTE
	CPI	'Z'-'@'
	JZ	PASSINT
	MOV	C,A
	CALL	MOUTPUT
	CALL	MSTAT
	ORA	A
	JZ	WELTYPE
	CALL	MINPUT
	CPI	'C'-'@'
	JZ	PASSINT
	CPI	'K'-'@'
	JZ	PASSINT
	CPI	'K'
	JZ	PASSINT
	CPI	'k'
	JZ	PASSINT
	CPI	'S'-'@'
	JNZ	WELTYPE
WAIT:	CALL	MSTAT
	ORA	A
	JZ	WAIT
	CALL	MINPUT
	CPI	'C'-'@'
	JZ	PASSINT
	CPI	'K'-'@'
	JZ	PASSINT
	CPI	'K'
	JZ	PASSINT
	CPI	'k'
	JNZ	WELTYPE
	ENDIF
PASSINT:IF	PWRQD
	MVI	D,3
PASSINP:LXI	H,PWMSG
	CALL	PRINTB
	LXI	H,PASSWD
	MVI	E,0
PWMLP:	CALL	MINPUT
	CPI	60H
	JC	NOTLC
	ANI	5FH
NOTLC:	PUSH	PSW
	CPI	20H
	JNC	PWDIS
	MVI	C,'^'
	CALL	CONOUT
	POP	PSW
	PUSH	PSW
	ADI	40H
PWDIS:	MOV	C,A
	CALL	CONOUT
	POP	PSW
	CPI	'U'-40H
	JZ	PASSINP
	CMP	M
	JZ	PWMAT
	MVI	E,1
	CPI	CR
	JNZ	PWMLP
PWNMAT:	LXI	H,WRGMSG
	CALL	PRINTB
	DCR	D
	JNZ	PASSINP
	JMP	PREOFF
PWMAT:	INX	H
	CPI	CR
	JNZ	PWMLP
	MOV	A,E
	ORA	A
	JNZ	PWNMAT
	LXI	H,NWPWD
	INR	M
	ENDIF
	IF	COMFILE
	MVI	C,SETUSR
	MVI	E,COMUSR
	CALL	BDOS
	MVI	C,SELDSK
	MVI	E,COMDRV-'A'
	CALL	BDOS
	MVI	A,' '
	STA	FCB+1
	ENDIF
	IF	ZCPR3 AND COMFILE
	CALL	DOZ3
	ENDIF
	IF	COMFILE
	CALL	PATCH
	CALL	100H
	ENDIF
	JMP	0000H
PREOFF:
	LXI	SP,STACK
	CALL	IMDONE
	CALL	UNPATCH
	XRA	A
	STA	OPTION
	IF	DISKLOG
	LXI	H,DSCMSG
	CALL	WRTMSG
	ENDIF
	JMP	HANGUP
	IF	TIMEON OR CLOCK
TCHECK:	LDA	TCHKFG
	INR	A
	RZ
	PUSH	B
	PUSH	D
	PUSH	H
	ENDIF
	IF	TIMEON AND (NOT	CLOCK)
	LDA	TON
	JMP	TCNCLK
	ENDIF
	IF	TIMEON AND CLOCK
	CALL	TIME
	LDA	LHOUR
	CALL	TCX60
	LDA	LMIN
	LXI	D,0
	MOV	E,A
	DAD	D
	PUSH	H
	LDA	CCHOUR
	LXI	H,LHOUR
	SUB	M
	JNC	TCOK
	LDA	CCHOUR
	ADI	24
	STA	CCHOUR
TCOK:	LDA	CCHOUR
	CALL	TCX60
	LDA	CCMIN
	LXI	D,0
	MOV	E,A
	DAD	D
	POP	D
	CALL	TCDIF
	MOV	A,L
	STA	TON
	ENDIF
	IF	TIMEON
TCNCLK:	LXI	H,TONMSD
	CALL	DEC8
	LDA	TON
	MOV	B,A
	LDA	MXTIME
	SUB	B
	LXI	H,TLNMSD
	CALL	DEC8
	POP	H
	POP	D
	POP	B
	ENDIF
	IF	TIMEON AND (ZCPR2 OR ZCPR3)
	LDA	WHEEL
	ORA	A
	RNZ
	ENDIF
	IF	TIMEON
	LDA	MXTIME
	ORA	A
	RZ
	PUSH	B
	MOV	B,A
	LDA	TON
	SUB	B
	POP	B
	RC
	LXI	SP,STACK
	MVI	A,255
	STA	TCHKFG
	XRA	A
	LXI	H,TLNMSD
	CALL	DEC8
	LXI	H,TIMEUP
	CALL	PRINTB
	CALL	PATCH
	ENDIF
	IF	DISKLOG	AND TIMEON
	XRA	A
	STA	BDOSFL
	LXI	H,TLMMSG
	CALL	WRTMSG
	ENDIF
	IF	MBBS AND TIMEON
	XRA	A
	STA	MXTIME
	JMP	NORPTC
	ENDIF
	IF	TIMEON AND (NOT	MBBS)
	JMP	LOGOFF
	ENDIF
	IF	CLOCK
TCX60:	LXI	H,0
	ORA	A
	RZ
	LXI	D,60
TCX61:	DAD	D
	DCR	A
	JNZ	TCX61
	RET
TCDIF:	MOV	A,L
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
	ENDIF
	IF	BCD2BIN
BCDBIN:	PUSH	D
	MOV	E,A
	ANI	15
	MOV	D,A
	MOV	A,E
	ANI	240
	RRC
	MOV	E,A
	RRC
	RRC
	ADD	E
	ADD	D
	POP	D
	RET
	ENDIF
	IF	BIN2BCD
BINBCD:	PUSH	D
	MVI	E,255
BLP:	INR	E
	SUI	10
	JNC	BLP
	ADI	10
	MOV	D,A
	MOV	A,E
	RLC
	RLC
	RLC
	RLC
	ADD	D
	POP	D
	RET
	ENDIF
DEC8:	PUSH	PSW
	PUSH	H
	MVI	A,' '
	MOV	M,A
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
	POP	H
	POP	PSW
	PUSH	B
	PUSH	D
	MVI	E,0
	MVI	D,100
DEC81:	MVI	C,'0'-1
DEC82:	INR	C
	SUB	D
	JNC	DEC82
	ADD	D
	MOV	B,A
	MOV	A,C
	CPI	'1'
	JNC	DEC84
	MOV	A,E
	ORA	A
	MOV	A,C
	JZ	DEC85
DEC84:	MOV	M,A
	INX	H
	MVI	E,0FFH
DEC85:	MOV	A,D
	SUI	90
	MOV	D,A
	MOV	A,B
	JNC	DEC81
	ADI	'0'
	MOV	M,A
	POP	D
	POP	B
	RET
	IF	CHGPATH
REMPAT:	LXI	H,REMPATH
	LXI	D,EXTPATH
	MVI	B,LREMP
	CALL	MOVE
	RET
SYSPAT:	LXI	H,SYSPATH
	LXI	D,EXTPATH
	MVI	B,LSYSP
	CALL	MOVE
	RET
	ENDIF
	IF	CPM3
SETSCB:	LHLD	SCBBASE
	MOV	L,B
	MOV	M,A
	RET
GETSCB:	LHLD	SCBBASE
	MOV	L,B
	MOV	A,M
	RET
SETUSER:MVI	B,0B0H
	CALL	SETSCB
	MVI	B,0E0H
	JMP	SETSCB
SETDRIVE:
	MVI	B,0AFH
	CALL	SETSCB
	MVI	B,0DAH
	JMP	SETSCB
	ENDIF
	IF	NOT CPM3
ENDOBJ	EQU	$
	ENDIF
	IF	B5IM AND DOATZ
B5ATZ:	DB	'ATZ',CR,0
	ENDIF
	IF	B5IM AND NODTR
B5ESC:	DB	'+++',0
B5ATH:	DB	'ATH',CR,0
	ENDIF
	IF	B5IM AND OFFHK
B5ATH1:	DB	'ATH1'
	ENDIF
	IF	B5IM AND OFFHK AND (NOT	ANCHOR)
	DB	'M0'
	ENDIF
	IF	B5IM AND OFFHK
	DB	CR,0
	ENDIF
	IF	B5IM
B5ATA:	DB	'ATA',CR,0
ADDSTR:	DW	0
VCMSG:	DB	CR,LF,'Voice calls: '
VCMSN:	DB	'   ',0
VCNUM:	DB	0
	ENDIF
	IF	B5IM AND PRGRSS
RCSHOW:	DB	'_',0
NOEMSG:	DB	CR,LF,'Echo error',CR,LF,0
CMDERR:	DB	'Modem error',CR,LF,0
	ENDIF
	IF	B5IM
B5INIT:	DB	'AT'
	ENDIF
	IF	B5IM AND ECHO
	DB	'E1'
	ENDIF
	IF	B5IM AND (NOT ECHO)
	DB	'E0'
	ENDIF
	IF	B5IM
	DB	'Q0'
	DB	'V0'
	ENDIF
	IF	B5IM AND (NOT NOATA)
	DB	'S0=0'
	ENDIF
	IF	B5IM AND NOATA
	DB	'S0=1'
	ENDIF
	IF	B5IM AND SHORTB
	DB	CR,0
B5INT1:	DB	'AT'
	ENDIF
	IF	B5IM AND (NOT ANCHOR)
	DB	'M0'
	DB	'S10=25'
	ENDIF
	IF	B5IM AND (NOT HS300) AND (NOT ANCHOR)
	DB	'X1'
	ENDIF
	IF	B5IM
	DB	'H0'
	DB	CR,0
	ENDIF
	IF	B5IM AND (NOT OFFHK)
B5USR:	DB	'ATS0=0',CR,0
	ENDIF
	IF	PRGRSS AND (NOT	B5IM)
MSG30:	DB	'300 baud test',CR,LF,0
MSG12:	DB	'1200 baud test',CR,LF,0
MSG24:	DB	'2400 baud test',CR,LF,0
	ENDIF
VMSG:	DB	CR,LF,'BYE',MAIN+'0'
	DB	VERS/10+'0',VERS MOD 10+'0',' - '
	DB	MONTH/10+'0',MONTH MOD 10+'0','/'
	DB	DAY/10+'0',DAY MOD 10+'0','/'
	DB	YEAR/10+'0',YEAR MOD 10+'0',CR,LF,LF,0
CLRSEQ:	DB	CLRCH1,CLRCH2,CLRCH3,CLRCH4,CLRCH5,CLRCH6,0
	IF	RVIDEO
RVIDON:	DB	RVON1,RVON2,RVON3,RVON4,0
RVIDOFF:DB	RVOFF1,RVOFF2,RVOFF3,RVOFF4,0
	ENDIF
BELMSG:	DB	7,7,0
CDOFF:	DB	0
OPTION:	DB	0
	IF	RSPEED
OFFMSG:	DB	CR,LF,'Sorry!   1200 or 2400 baud only allowed 7PM-11PM'
	DB	CR,LF,CR,LF,' Call back before/after 7-11PM Pacific'
	DB	CR,LF,0
	ENDIF
	IF	TIMEON
TIMEUP:	DB	7,7,CR,LF,CR,LF
	DB	' Your time is up - wait 24 hours to call back',CR,LF,0
TONMSG:	DB	CR,LF,'Minutes on system: '
TONMSD:	DB	'0   ',CR,LF,0
TLNMSG:	DB	CR,LF,'Minutes left: '
TLNMSD:	DB	'0   ',CR,LF,0
	ENDIF
RTCBUF:
	DB	99H,99H,99H
	DB	19H,85H,02H,18H
TON:	DB	0,0
CCHOUR:	DB	0
CCMIN:	DB	0
LHOUR:	DB	0
LMIN:	DB	0
TCHKFG:	DB	0
CRMSG:	DB	CR,LF,CR,LF,0
TERMSG:	DB	CR,LF,'BYE5', VERS/10+'0',VERS MOD 10+'0',' (c)'
	IF	NOT SKTERM
	DB	' - any key to continue: '
	ENDIF
	DB	0
FKFLAG:	DB	0
PTFLAG:	DB	0
	IF	PRNTGB
GBMSG:	DB	CR,LF,'  Goodbye, call again...',CR,LF,'      '
	DB	CR,LF,0
	ENDIF
RS1MSG:	IF	COMFILE
	DB	CR,LF,'<E>xecute .COM file,'
	ENDIF
	DB	CR,LF,'<R>esume BYE,'
	DB	CR,LF,'<J>ump to CP/M with BYE5 attached,'
	DB	CR,LF,'<RET> for  normal unpatched  CP/M: ',0
RS2MSG:	DB	'  Resuming...',CR,LF,0
ATMSG:	DB	CR,LF,'Modem calls: '
ATMSN:	DB	'   ',0
CWCAR:	DB	0
	IF	PWRQD
PASSWD:	DB	'DDT'
	DB	CR
	DB	0,0,0,0,0,0,0
PWMSG:	DB	CR,LF,'Enter Password: ',0
WRGMSG:	DB	'Incorrect password',CR,LF,0
NWMSG:	DB	CR,LF,'Passwords: '
NWMSD:	DB	'   ',0
NWPWD:	DB	0
	ENDIF
	IF	CHEKDU
IDMSG:	DB	'> [Invalid drive]',0
IUMSG:	DB	'> [Invalid user#]',0
	ENDIF
CLMSG:	DB	CR,LF,LF,'[Carrier lost]',CR,LF,0
ITOMSG:	DB	CR,LF,LF,'[Input timed out]',7,CR,LF,0
LCDMSG:	DB	CR,LF,LF,'[Last call]',CR,LF,0
ULTMSG:	DB	CR,LF,'[Unlimited Time]',CR,LF,0
SCRMON:	DB	CR,LF,'[Remote on]',CR,LF,0
SCRMOFF:DB	CR,LF,'[Remote off]',CR,LF,0
BELMON:	DB	CR,LF,'[Bell on]',CR,LF,LF,0
BELMOFF:DB	CR,LF,'[Bell off]',CR,LF,LF,0
MFSMSG:	DB	CR,LF,'Message from Sysop: ',CR,LF,0
SGDMSG:	DB	CR,LF,'Going down in ',DOWNMIN+'0'
	DB	' min.',CR,LF,0
LFMSG:	DB	CR,LF,0
LCDFLG:	DB	0
	IF	PRNTWB
WBMSG:	DB	CR,LF,'Booting CP/M...',CR,LF
	DB	0
	ENDIF
	IF	CPM3
SCBPB:	DB	03AH,0
	ENDIF
	IF	COMFILE	OR EXFILE
PTSMSG:	DB	'++ TPA too small ++',0
CNFMSG:	DB	'.COM ++ Not found-abort ++',CR,LF,0
ENTMSG:	DB	'Entry   ',0
CFLMSG:	DB	'.COM loaded',CR,LF,LF,0
	ENDIF
	IF	EXFILE
EXTMSG:	DB	'Exit    ',0
	ENDIF
	IF	MSGFIL
MSGFCB:	DB	0,'MFMSG   COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
MSGMSG:	DB	'MSGNAME ',0
	ENDIF
	IF	WELFILE
WELFILN:DB	0,'WELCOME ???'
	DB	0
	ENDIF
CM2FCB:	IF	MBBS
	DB	0,'MBBS    COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND RBBS
COMFCB:	DB	0,'RBBS    COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND OXGATE
COMFCB:	DB	0,'OXENTR  COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND METAL
COMFCB:	DB	0,'MENTR   COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND MBBS
COMFCB:	DB	0,'LOGIN   COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND PBBS
COMFCB:	DB	0,'PBBS    COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	COMFILE	AND QBBS
COMFCB:	DB	0,'QENTER  COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
EXITFCB:IF	EXFILE AND QBBS
	DB	0,'QEXIT   COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	EXFILE AND OXGATE
	DB	0,'OXEXIT  COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	EXFILE AND METAL
	DB	0,'MEXIT   COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
	IF	EXFILE AND PBBS
	DB	0,'PBYE    COM'
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0
	ENDIF
LCNAME:	IF	NO25TH OR MBBS
	DB	0,'LASTCALR???'
	DB	0
	ENDIF
LCDATA:	IF	NO25TH OR MBBS
	DB	' ',0
	DS	NO25BF-2
LCFILL:	DB	'  L/C data N/A',0
LCHEAD:	DB	CR,0
	ENDIF
	IF	(NO25TH	OR MBBS) AND READLC
LCMSG1:	DB	'No L/C file',CR,LF,0
	ENDIF
	IF	MBBS
MBBS1:	DB	CR,LF,'Loading for COMMENT before exiting...',CR,LF,LF,0
MBBS2:	DB	CR,LF,'[ Updating ]',CR,LF,0
	ENDIF
	IF	DISKLOG
DSKLOG:	DB	0
OPNMSG:	DB	CR,LF,'[Log on]',CR,LF,0
CLSMSG:	DB	CR,LF,'[Log off]',CR,LF,0
DSCMSG:	DB	'**DISCONNECT**',0
CONMSG:	DB	'**CONNECT '
CONMS1:	DB	'  on '
CDAY:	DS	8
	DB	'**',0
	ENDIF
	IF	DISKLOG	AND TIMEON
TLMMSG:	DB	'**TIME LIMIT**',0
	ENDIF
	IF	DISKLOG
CARMSG:	DB	'**CARRIER LOST**',0
TMOMSG:	DB	'**INPUT TIMEOUT**',0
DRPMSG:	DB	'**DROPPED**',0
VOCMSG:	DB	'**VOICE CALL**',0
LOGFCB:	DB	LOGDRV-40H,'SYS     LOG'
	DS	24
WOFFSET:DB	0
OLDDMA:	DW	80H
BDOSFL:	DB	0
TIMSFL:	DB	0
LOGTOG:	DB	0
OLDLUS:	DS	4
RECORD:	DS	128
HLSAVE:	DS	2
	DS	40
NEWSTK:	DS	0
	ENDIF
	IF	CHGPATH
SYSPATH:DB	1,0
	DB	1,15
	DB	0
LSYSP	EQU	$-SYSPATH
REMPATH:DB	1,0
	DB	0
LREMP	EQU	$-REMPATH
	ENDIF
	IF	NOT CPM3
PEND	EQU	$
	ENDIF
	IF	COMFILE	OR EXFILE
CURRFCB:DS	2
	ENDIF
TOCNTM:	DS	1
TOCNT:	DS	2
MSFLAG:	DS	1
VCOLDBT:DS	3
VWARMBT:DS	3
VCONSTAT: DS	3
VCONIN:	DS	3
VCONOUT:DS	3
VLISTOUT: DS	3
VPUNCH:	DS	3
VREADER:DS	3
	IF	CPM3
SCBBASE:DW	0
MEMBASE:DB	0
BDOSBASE: DB	0
	ENDIF
CR	EQU	0DH
LF	EQU	0AH
LXID	EQU	11H
LXIH	EQU	21H
IOBYTE	EQU	0003H
FCB	EQU	005CH
FCBRNO	EQU	FCB+32
	IF	CPM3
SCBDAT	EQU	00F4H
SCBTIM	EQU	00F6H
SCBCOM	EQU	00FAH
SCBBDOS	EQU	0099H
	ENDIF
	IF	CPM3
BDOS	EQU	NEXT
	ENDIF
	IF	NOT CPM3
BDOS	EQU	0005H
	ENDIF
CI	EQU	1
WRCON	EQU	2
DRECTIO	EQU	6
PRINTF	EQU	9
CSTS	EQU	11
SELDSK	EQU	14
OPEN	EQU	15
SEARCH	EQU	17
READ	EQU	20
STDMA	EQU	26
SETUSR	EQU	32
CHAINP	EQU	47
GTSCB	EQU	49
DEFPAS	EQU	106
	DS	40
STACK	EQU	$
	IF	NOT CPM3
OBJEND	EQU	$
	ENDIF
	END
