*********************************************************
*							*
*		CP/M BDOS ACCESS			*
*							*
*	A LINKABLE MODULE IN THE MICROSOFT		*
*	RELOCATION FORMAT				*
*							*
*		  Software Tools RCPM			*
*		  P.O. Box 357				*
*		  Kenmoe				*
*		  QLD, 4069				*
*		  AUSTRALIA				*
*							*
*	Phone +61-7-378-9530  1200/2400 bps		*
*							*		
*	Written by:	Bill Bolton			*
*							*
*	Date:		06/Aug/1985			*
*							*
*	Version:	1.0	(Initial Release)	*
*							*
*	-------------------------------------------	*
*							*
*	PURPOSE:					*
*							*
*	Allows access to the CP/M BDOS from Microsoft	*
*	High Level Language compilers such as FORTRAN	*
*	COBOL, BASCOM etc.				*
*							*
*	INPUT PARAMETERS:				*
*							*
*	1st. passed in HL = Address of variable for	*
*			    returned value		*
*							*
*	2nd. passed in DE = Address of variable		*
*			    for the optional data	*
*			    argument for BDOS		*
*							*
*	3rd. passed in BC = Address of variable for	*
*			    8 bit returned value	*
*							*
*	RETURNED VALUE:					*
*							*
*	1st.	Any 8 bit value returned by the	BDOS	*
*		in A is placed in the address of the	*
*		variable passed as the 3rd input	*
*		parameter.				*
*							*
*	2nd.	Any 16 bit value returned by the BDOS	*
*		in HL is placed in the address of the	*
*		variable passed as the 2nd input	*
*		parameter.				*
*							*
*	ERROR CONDITIONS:				*
*							*
*			    No error conditions are	*
*			    explicitly reported by	*
*			    this module, BDOS may	*
*			    report an error if the	*
*			    argument is invalid		*
*			    or out of bounds.		*
*							*
*	------------------------------------------	*
*							*
*	Assembler:	RMAC.ASM (Digital Research)	*
*							*
*********************************************************	    

CPMBDOS	EQU	5

PUBLIC	BDOS			;GLOBAL LABLE

	CSEG			;RELOCATABLE MODEULE

BDOS:
;
	SHLD	FUNCTION	;Save pointer to function number
	XCHG
	SHLD	VALUE16		;Save pointer to data argument
	MOV	H,B
	MOV	L,C		;HL <--- BC
	SHLD	VALUE8		;Save pointer to return variable
;
	LXI	H,0		;Set up a stack for this module
	DAD	SP
	SHLD	OLDSTAK
	LXI	SP,STACK
;
	LHLD	FUNCTION
	MOV	C,M		;C <---- BDOS function number
	LHLD	VALUE16
	MOV	E,M
	INX	H
	MOV	D,M		;DE <--- BDOS data argument	
	CALL	CPMBDOS
;
	XCHG			;DE <---- Returned 16 bit value (if any)
	LHLD	VALUE8		;Get pointer to 8 bit return value argument
	MOV	M,A		;Stuff it with 8 bit returned value
	INX	H
	MVI	M,0
	LHLD	VALUE16		;Get pointer to data argument
	MOV	M,E
	INX	H
	MOV	M,D		;Stuff it with 16 bit returned value
;
	LHLD	OLDSTAK		;Restore the caller's stack
	SPHL
	RET
	
;
;	DATA STORAGE
;
	DSEG
;
FUNCTION:
	DW	0		;Address of variable for function
VALUE16:
	DW	0		;Address of variable for data argumeny
VALUE8:
	DW	0		;Address of variable for returned value
;
OLDSTAK:
	DS	2		;CALLER'S STACK POINTER
SPACE:
	DS	14		;STACK
STACK:
	DS	2		;STACK TOP
;
	END
