; B5-DRIV3.ASM	for BYE501 and above		by George F Peace

; This is a CP/M Plus program
;
;	Updated 07/11/86
;		- Added SCB jump vector init code so that bank 1 will
;		  always be in context during BIOS console I/O and
;		  warm boot calls.  Important:  B5-DRIV3 must not
;		  be run within a submit file because submit's GET
;		  RSX restores these vectors on completion.
;				- Jim Lopushinsky -
;		- Deleted RSX loaded checks as they generated unnecessary
;		  overhead.  If a second bye RSX is loaded by calling this
;		  program directly (unlikely), the caller will see double
;		  while he is logged off, then the second bye RSX will clear.
;				- gfp -
;
;	Released 8/17/85 by gfp

; function:	loads or unloads the BYE5 RSX and initializes or resets the
;		remote console environment.

; usage:	Operates just as CP/M 2.2 BYE5 does.  It is called by
;		BYE.COM using the CP/M Plus Chain to program function.

CR	EQU	0DH
LF	EQU	0AH
BDOS	EQU	5
WBOOT	EQU	0
PSTRING	EQU	9
CALLRSX	EQU	60

RSX$INIT EQU	101
RSX$TERM EQU	102

	ORG	100H

; Get System Control Block address and check for non-banked version
;
	LXI	D,SCBPB		;			*JEL*
	MVI	C,49		;			*JEL*
	CALL	BDOS		; Get SCB address	*JEL*
	MVI	L,0F9H		; Point to com mem base	*JEL*
	MOV	A,M		; Get low byte		*JEL*
	INR	L		; Point to high byte	*JEL*
	ORA	M		; Is it zero?		*JEL*
	JZ	NONBANK		; Skip next if non-bank	*JEL*
;
;.....
;
; Modify the BIOS jump vectors in the SCB so that the TPA bank will
;   always be in context during a BIOS console I/O or warm boot call
;
	MVI	L,68H		; Point to WB JMP in SCB *JEL*
	LXI	D,6		; Vectors are 6 apart	*JEL*
	MVI	B,5		; 5 vectors to mod	*JEL*
	MVI	A,21H		; LXI H, op code	*JEL*
MODLOOP:			;			*JEL*
	MOV	M,A		; Change JMP to LXI H,	*JEL*
	DAD	D		; Point to next vector	*JEL*
	DCR	B		; Loop control		*JEL*
	JNZ	MODLOOP		;			*JEL*
NONBANK:			;			*JEL*
;
	MVI	A,RSX$INIT	; Get initialization function

LOADRSX:STA	RSXPB		; Store subfunction in parameter block
	MVI	C,CALLRSX	; Get RSX command index
	LXI	D,RSXPB		; Get RSX parameter block address
	CALL	BDOS

	LDA	STAT		; Get the status byte
	CPI	00		; Was all ok?
	JNZ	ERROR1		; Nope - tell the caller

EXIT:	MVI	C,WBOOT		; Terminate the program but not the RSX
	JMP	BDOS

TERMRSX:MVI	A,RSX$TERM	; Get RSX termination function
	JMP	LOADRSX		; Now go set up the RSX

ERROR1:	MVI	C,PSTRING	; Get print string function
	LXI	D,ERR1MSG	; Get error message address
	CALL	BDOS		; Display the error message
	JMP	EXIT		; Go away

SCBPB:	DB	3AH		; Get addr of SCB	*JEL
	DB	0		; Get op		*JEL

ERR1MSG:DB	'An unexpected error has occurred.  The BYE5 RSX is returning'
	DB	CR,LF
	DB	'a bad status.  Reset the system and try again.'
	DB	CR,LF,'$'
RSXPB:	DB	RSX$INIT	; RSX initialization function
	DB	2		; 2 parameter words follows
	DW	RSXNAME		; Parameter 1 address
	DW	ARGS		; Parameter 2 address
RSXNAME:DB	'BYE5    '	; Name of RSX we're calling
ARGS:	DB	0
STAT:
STAT1:	DB	0
STAT2:	DB	0
	DB	0,0,0

	END
