; B5-CPM3.ASM	for BYE509 and above		by George F Peace
; Rename assembled/linked file to BYE.COM for RCP/M+ operation
;
;	Updated 7/11/86 by JEL...
;		- All initialize code moved to BYE HANGUP routine
;		  It is quite possible (and has happened) that while
;		  the sysop is using the system, carrier is lost,
;		  causing this module to not be run between calls,
;		  giving the next caller unwanted privaleges.
;
;	Updated 4/17/86 by GFP...
;		- Reinstalled password and drive path initialization code
;		  to be executed only on initial execution.  RSX delete
;		  code remains in BYE5nn.ASM
;
;	Updated 4/13/86 by GFP...
;		- Uses BYE5 extended BDOS calls to check BYE existance
;		- Only schedules B5-DRIV3.COM if the BYE5 RSX cannot be found
;		- .LBR delete code, drive/password initialization code
;		  removed (BYE5nn.ASM does that now)
;
;	Updated 1/12/86 by GFP to set search path to default drive,
;				then drive A:
;
; 	Updated 12/85 by Larry J. Moore to turn off the wheel byte and
;					set the default password to null
;
;		This is a CP/M Plus program that is scheduled when:
;
;		- The SYSOP or a caller invokes it manually to reset
;		  the RCP/M+ environment.
;		- The BYE5 configuration tag EXFILE is set to YES, no RBBS
;		  system is defined, and the carrier is lost during a
;		  session.  This requires that EXITFCB in the data portion
;		  of the BYE5nn.ASM program be updated or this program be
;		  renamed to match EXITFCB.
;
; The program performs cleanup operations prior to allowing the BYE5
; RSX to reset the environment.  The "standard" operation is to
; schedule the real (hidden) B5-DRIV3.COM or any other program or
; command as defined at label XQTSTR.
;
;
; ASSEMBLE AND LINK THIS PROGRAM USING MAC/HEXCOM OR RMAC/LINK.
; THE RESULTING .COM FILE SHOULD BE NAMED  BYE.COM  AND BE PLACED SO IT IS
; ACCESSIBLE BY CALLERS AND SYSOP.  IT IS THE FRONT-END TO BYE5 ACCESS
; FOR CP/M PLUS (CPM3 SET TO YES IN BYE5nn.ASM).
;
;
BDOS	EQU	5
CHAINP	EQU	47
GTSCB	EQU	49
CALLRSX	EQU	60
DEFPASS	EQU	106		; Set default password
RSX$TM	EQU	102		; Log caller out

	ORG	100H

; First, see if the BYE5 RSX is loaded.
; If not, run the RSX loader program to initialize the system.
;
	MVI	C,32		; Get user get/set function
	MVI	E,241		; And special entry flag
	CALL	BDOS		; Check for BYE5 existance
	CPI	77		; Test for special return
	JNZ	LODRSX		; Not in memory - exit

	MVI	C,CALLRSX	; Get call RSX function
	LXI	D,RSXPB		; Load RSX parameter block address
	JMP	BDOS		; Jump to active RSX; should not return

LODRSX:
;
; Copy the caller's command tail to the one we're about to issue
;
	LDA	80H		; Get command tail length
	CPI	0		; Was anything typed by the caller?
	JZ	DONE		; Nope, all done

	LXI	H,80H		; Initialize pointer to command tail buffer
	LXI	D,TAIL-1	; Init to destination

CLOOP:
	INX	H		; Point to next byte
	INX	D		; Do it for destination, too
	MOV	A,M		; Get the byte
	STAX	D		; Put it in the destination tail
	CPI	0		; Was that all?
	JNZ	CLOOP		; Nope - get another character
;
DONE:
	LXI	H,XQTSTR	; Source=string
	LXI	D,80H		; Dest=default DMA
	MVI	B,LXQTSTR	; Length of STRING
	CALL	MOVE
	MVI	C,CHAINP	; Chain program
	MVI	E,0		; Don't bother forcing temporary DU:
	JMP	BDOS		; And don't come back

; Move (HL) to (DE), length in (B)
;
MOVE:	MOV	A,M		; Get a byte
	STAX	D		; Put at new home
	INX	D		; Bump pointers
	INX	H
	DCR	B		; Decrement byte count
	JNZ	MOVE		; If more, do it
	RET			; If not, return
;
XQTSTR:	DB	'A:B5-DRIV3.COM '	; Do this
TAIL:	DS	64			; Allow 64 bytes for the command tail
	DB	0			; Required terminator
LXQTSTR	EQU	$-XQTSTR		; Length of string

RSXPB:	DB	RSX$TM		; BYE function
	DB	2		; 2 parameter words follows
	DW	RSXNAME		; Parameter 1 address
	DW	ARGS		; Parameter 2 address

RSXNAME:DB	'BYE5    '	; RSX Name in BYE5nn.ASM (must be 8 bytes)

ARGS:	DB	0
STAT:	DB	0

	END
