{---------------------------------------------------------------------------}
{                                                                           }
{  This program will (when running under Bye337 or newer), hang up the      }
{  phone, and dial a specified number.  This is useful if the Sysop wants   }
{  to access his/her computer from a remote place without running up a long }
{  phone bill.  This program was somewhat inspired by Dave Hardy's          }
{  PMMISTAT program which did the same sort of thing.                       }
{  This is a good demonstration of the features of Bye337.                  }
{                                                                           }
{  This is for the Courrier 2400 or Hayes compatible modems only.           }
{                                                                           }
{---------------------------------------------------------------------------}
{ Copyright (c) 1985 by Paul Traina - all commercial rights reserved        }
{ This program may be distributed under the following circumstances:        }
{    1) This software is to be distributed with the Bye3 series of programs }
{       and no "spinoffs."                                                  }
{    2) This software is not sold or marketed for commercial gain.          }
{    3) The author's copyright notice is not disturbed.                     }
{---------------------------------------------------------------------------}
{                                                                           }
{  Note: A small change will have to be made to Bye337 to have this program }
{        work properly:  You must change part of the modem initialization   }
{        string.  Change "S2=128" to "S2=1  " .. this changes the attention }
{        character to ^A which is virtually impossible to get the system to }
{        echo so you should be safe from crashes.                           }
{                                                                           }
{---------------------------------------------------------------------------}

program Call_Me(input,output);

const
  password = 'CHICKEN';     { Password needed }

  outsta   = 62;            { modem output status }
  outchr   = 63;            { modem output char }
  carsta   = 65;            { modem carrier status }
  wrtloc   = 76;            { write-lock }
  mdmoff   = 77;            { modem-ignore }
  gettime  = 79;            { get rtc buffer }
  getcalr  = 80;            { get caller buffer }

type
  string20            = string[20];
  string80            = string[80];

var
  num                 : string20;
  pass                : string20;
  wait                : integer;
  dummy               : integer;

{ return true if we have carrier }

function carrier:boolean;
begin
  carrier := Bdos(carsta)>0
end;

{ Hangup the phone the universal way }

procedure disconnect;
begin
  while carrier do
    begin
      delay(1500);              { pad 50% over minimum }
      write(usr,^A,^A,^A);
      delay(1500);
      write(usr,^M,'ATH',^M);
      delay(300);               { wait a bit for modem to hangup }
    end;
end;

{ Send a character to the modem }

procedure putchar(ch:char);
var dummy : byte;
begin
  repeat until Bdos(outsta)>0;
  dummy := Bdos(outchr,ord(ch));
  delay(100)    { 100ms mini-delay }
end;

begin
  UsrOutPtr := addr(putchar);             { tie in our output routine }

  if Bdos(32,241) <> 77 then
  begin
    writeln('Bye337 or newer not running.');
    halt
  end;

  writeln('Call me back...');
  write('Phone number? ');
  readln(num);
  write('Password? ');
  readln(pass);

  mem[0] := $CD;                      { from now on, bump him if bad }

  if pass<>password then
  begin
    writeln('Invalid password.');
    halt
  end;

  writeln;
  writeln('Calling you back... bye bye');
  writeln;

  dummy := Bdos(mdmoff,255);      { turn on modem-ignore flag }
  dummy := Bdos(wrtloc,255);      { turn on write-loc if we have it }

  disconnect;
  delay(1000);

  write(usr,^M,'ATDTR',num,^M);   { tell modem to dial number (answer mode )}

  wait := 0;                      { wait for carrier or timeout }
  repeat
    delay(1000);                  { wait one second }
    wait := wait + 1;
  until carrier or (wait > 60);

  if wait > 60 then
  begin
    disconnect;                   { we have an error, try to recover }
    delay(1000);                  { turn on all bye's error checking }
    dummy := Bdos(mdmoff,0);
    dummy := Bdos(wrtloc,0);
    halt;
  end;

  { we have connect }

  delay(1000);
  dummy := Bdos(mdmoff,0);              { re-enable bye's checking }
  dummy := Bdos(wrtloc,0);

  writeln;
  write('Enter sync string---> ');
  readln(pass);
  write('Enter password?');
  readln(pass);

  if password<>pass then
  begin
    writeln('Invalid password.');
    halt
  end;

  { All done...whew... return to CP/M }

  mem[0] := $C3;                       { let us go to cp/m without death }
end.
