/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                   BinkleyTerm WaZOO/EMSI Session Logic                   */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*  This module is based largely on a similar module in OPUS-CBCS V1.03b.   */
/*  The original work is (C) Copyright 1987, Wynn Wagner III. The original  */
/*  author has graciously allowed us to use his code in this work.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef HAVE_HYDRA
#include "hydra.h"
#endif

#define rb_plus "r+b"

int WaZOO_callback (char *);
int WaZOO_time (long);

static void LOCALFUNC InitExtAgent (void);
static void LOCALFUNC DeinitExtAgent (void);
int EXTMAIL_callback (char *);

static int fsent;

#define NUM_FLAGS 4

/*--------------------------------------------------------------------------*/
/* SEND WaZOO (send another WaZOO or EMSI-capable system its mail)          */
/*   returns TRUE (1) for good xfer, FALSE (0) for bad                      */
/*--------------------------------------------------------------------------*/
int 
send_WaZOO ()
{
	char fname[80];
	char s[80];
	char *HoldName;
	int c;
	int check_again;
	struct stat buf;
	ADDRP addrp = &called_addr;
	ADDR saved_addr;
	int i;
	int akas;

	fsent = 0;

	switch (remote_pickup)
	{
	case -2:					/* External Mail session */
		InitExtAgent ();

	/* ExtMail is handled like WaZOO. Fall through to that case. */

	case -1:					/* WaZOO Session */
		akas = 1;
		remote_akas[0] = called_addr;
		break;

	case 1:
		akas = 1;
		break;

	case 2:
		akas = num_rakas;
		break;

	default:
		akas = 0;
		break;
	}

	saved_addr = called_addr;

	for (i = 0; i < akas; i++)
	{
		addrp = &remote_akas[i];
		HoldName = HoldAreaNameMunge (addrp);
		status_line (MSG_TXT (M_EMSI_PROC_NODE), Full_Addr_Str (addrp), HoldName);
		check_again = 0;

just_make_sure:
		/*--------------------------------------------------------------------*/
		/* Send all waiting ?UT files (mail packets)                          */
		/*--------------------------------------------------------------------*/
		*ext_flags = 'O';
		for (c = 0; c < NUM_FLAGS; c++)
		{
#ifndef JACK_DECKER
			if (caller && (ext_flags[c] == 'H'))
				continue;
#endif

			(void) sprintf (fname,
				"%s%s.%cUT",
				HoldName, Hex_Addr_Str (addrp), ext_flags[c]);

			if (!stat (fname, &buf))
			{

				/*--- Build a dummy PKT file name */
				invent_pkt_name (s);

				/*--- Tell ZModem to handle this as a SEND AS then DELETE */
				status_line (MSG_TXT (M_PACKET_MSG));

				/* Do this using the external mail agent if need be */
				if (remote_pickup == -2)
				{
					if (!EXTMAIL_callback (fname))
					{
						net_problems = 1;
						return FALSE;
					}
				}
				else
#ifdef HAVE_HYDRA
				if (remote_capabilities & DOES_HYDRA)
				{
					fsent++;
					if (hydra (fname, s) == XFER_ABORT)
					{
						net_problems = 1;
						return FALSE;
					}
				}
				else
#endif /* HAVE_HYDRA */
				{
					if (!Send_Zmodem (fname, s, fsent++, DO_WAZOO))
					{
						net_problems = 1;
						return FALSE;
					}
				}
				CLEAR_IOERR ();
				(void) unlink (fname);
			}
		}						/* for */

		/*--------------------------------------------------------------------*/
		/* Send files listed in ?LO files (attached files)                    */
		/*--------------------------------------------------------------------*/
		*ext_flags = 'F';
		called_addr = *addrp;
		if (!do_FLOfile (ext_flags, WaZOO_callback))
		{
			called_addr = saved_addr;
			return FALSE;
		}

		called_addr = saved_addr;
		if (fsent && !check_again)
		{
			check_again = 1;
			goto just_make_sure;
		}

		/*--------------------------------------------------------------------*/
		/* Send our File requests to other system                             */
		/*--------------------------------------------------------------------*/
		if (requests_ok && !no_pickup)
		{
			(void) sprintf (fname, "%s%s.REQ", HoldName, Hex_Addr_Str (addrp));
			if (!stat (fname, &buf))
			{
				if (!(((unsigned) remote_capabilities) & WZ_FREQ))
					status_line (MSG_TXT (M_FREQ_DECLINED));
				else
				{
					status_line (MSG_TXT (M_OUT_REQUESTS));
					++made_request;
#ifdef HAVE_HYDRA
					if (remote_capabilities & DOES_HYDRA)
					{
						fsent++;
						if (hydra (fname, NULL) == XFER_OK)
							(void) unlink (fname);
					}
					else
#endif /* HAVE_HYDRA */
					{
						if (Send_Zmodem (fname, NULL, fsent++, DO_WAZOO))
							(void) unlink (fname);
					}
				}
			}
		}
	}							/* end of send loop */

	/* This is as far as we go for external mail */

	if (remote_pickup == -2)
	{
		DeinitExtAgent ();
		goto success;
	}

#ifdef HAVE_HYDRA
	if (remote_capabilities & DOES_HYDRA)
		(void) hydra (NULL, NULL);	/* End of first batch */
#endif	/* HAVE_HYDRA */

	fsent = respond_to_file_requests (fsent, WaZOO_callback, WaZOO_time);

	if (!fsent)
		status_line (MSG_TXT (M_NOTHING_TO_SEND), Full_Addr_Str (addrp));

#ifdef HAVE_HYDRA
	if (remote_capabilities & DOES_HYDRA)
		(void) hydra (NULL, NULL);
	else
#endif	/* HAVE_HYDRA */
		(void) Send_Zmodem (NULL, NULL, ((fsent) ? END_BATCH : NOTHING_TO_DO), DO_WAZOO);

success:

	sent_mail = 1;
	return TRUE;

}								/* WaZOO */

/*
 * WaZOO_callback () -- send requested file using WaZOO/EMSI method.
 *
 *
 */
int 
WaZOO_callback (char *reqs)
{
	if (remote_pickup == -2)
		return EXTMAIL_callback (reqs);

#ifdef HAVE_HYDRA
	if (remote_capabilities & DOES_HYDRA)
	{
		fsent++;
		switch (hydra (reqs, NULL))
		{
		case XFER_ABORT:
			return (FALSE);

		case XFER_SKIP:
			return (SPEC_COND);

		case XFER_OK:
		default:
			return (TRUE);
		}
	}
	else
#endif	/* HAVE_HYDRA */
		return (Send_Zmodem (reqs, NULL, fsent++, DO_WAZOO));
}

int 
WaZOO_time (long filesize)
{
	long ltemp;

	ltemp = filesize * 10L / cur_baud.rate_value * 100L / 95L;
	return (ltemp < 20L) ? 20 : (int) ltemp;
}

static void LOCALFUNC
InitExtAgent ()
{
	status_line (MSG_TXT (M_START_EXTMAIL), Full_Addr_Str (&remote_addr));
	mdm_init (modem_busy);
	exit_DTR ();
	close_up ();
	vfossil_cursor (1);
}

int
EXTMAIL_callback (char *reqs)
{
	char *p = Txbuf;
	char *q = Txbuf + 2048;
	struct stat f;
	long ltime;

	ltime = (long) time (NULL);

	sprintf (q, "%s.%03x", ExtMailAgent, TaskNumber);
	(void) unlink (q);

	(void) stat (reqs, &f);

	sprintf (p, "%s %s %03x %s",
		ExtMailAgent,
		Full_Addr_Str (&remote_addr),
		TaskNumber,
		reqs);
	b_spawn (p);

	if (!dexists (q))
	{
		net_problems = 1;
		DeinitExtAgent ();
		return FALSE;
	}

	hist.files_out++;
	hist.size_out += f.st_size;
	hist.time_out += (long) time (NULL) - ltime;

	return TRUE;
}

static void LOCALFUNC
DeinitExtAgent ()
{
	come_back ();
	RAISE_DTR ();
	mdm_init (modem_init);
	status_line (MSG_TXT (M_END_EXTMAIL), Full_Addr_Str (&remote_addr));
}



