/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*    This module has significant work from Vince Perriello, Bob Hartman,   */
/*             Holger Schurig, Michael Buenter and Doug Boone               */
/*                  BinkleyTerm Outbound Area Manipulation                  */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern char *mail_status_chars (unsigned int);

/* local prototypes */

static int mail_change (BINK_SAVEP, int);
static int mail_delreq (BINK_SAVEP, int);
static int mail_stop (BINK_SAVEP, int);
static int mail_addr (BINK_SAVEP, int);

static void LOCALFUNC zoom_window (REGIONP, MAILP, MAILP);
static void LOCALFUNC append_pkt (REGIONP, unsigned int, char *, char *);
static int LOCALFUNC mail_addsend (ADDRP, char *, char *);
static int LOCALFUNC mail_addrequest (ADDRP, char *, char *, char *);
static int LOCALFUNC kill_node (char *);
static void LOCALFUNC call_tries (ADDRP baddr, int *calls, int *badcalls);

/* local variables */

static int curl;
static MAILP cur, oldp, oldcur;

#define ZHELPSIZE 9

int 
Do_Zoom (BINK_SAVEP rp, int x)
{
	REGIONP zoomwin;
	MAILP p;
	long t_idle;
	int i, c;
	int changed = 0;
	short z;

	x = 1;

	/* is there a window */

	if (rp == NULL)
		return (0);

	zoomwin = rp->region;

	/* draw a box */

	sb_fill (zoomwin, ' ', colors.hold);
	sb_box (zoomwin, boxtype, colors.hold);

	/* give it a title */

	sb_move (zoomwin, 0, 1);
	sb_puts (zoomwin, MSG_TXT (M_ZOOM_TITLE));

	/* clear the inside of zoomed outbound */

	zoomwin->sr0++;
	zoomwin->sr1--;
	zoomwin->sc0++;
	zoomwin->sc1--;
	sb_fillc (zoomwin, ' ');
	zoomwin->sr0--;
	zoomwin->sr1++;
	zoomwin->sc0--;
	zoomwin->sc1++;

	/* Put the help text at the bottom of the window */

	c = (int) (zoomwin->sr1 - 1);
	i = M_ZOOM_HELP;

	for (z = zoomwin->sr1 - ZHELPSIZE + 1; z < (short) c; i++, z++)
	{
		sb_move (zoomwin, z, 1);
		sb_puts (zoomwin, MSG_TXT (i));
	}

	/* is there a rescan flag? */
	if (forcerescancheck ())
	{
		sb_move (zoomwin, 1, 2);
		sb_puts (zoomwin, MSG_TXT (M_ZOOM_WAIT));
		sb_show ();
		xmit_reset (0);
	}

	/* is there something in the outbound? */

	if (mail_top == NULL)
	{
		sb_move (zoomwin, 10, 10);
		sb_puts (zoomwin, MSG_TXT (M_NOTHING_IN_OUTBOUND));
		sb_show ();
		wait_for_key (120);
		return (x);
	}

	p = cur = mail_top;
	oldp = oldcur = NULL;
	curl = 2;
	zoom_window (zoomwin, p, cur);

	t_idle = timerset (6000);
	while (!timeup (t_idle) && (PEEKBYTE () == (short) 0xffff))
	{
		if (KEYPRESS ())
		{
			t_idle = timerset (3000);

			c = (int) KbRemap (FOSSIL_CHAR ());

			switch ((unsigned) c)
			{
			case F_PEND_PGUP:
				for (i = 2; i < (zoomwin->sr1 - ZHELPSIZE); i++)
				{
					if (p->prev != NULL)
						p = p->prev;
					if (cur->prev != NULL)
						cur = cur->prev;
				}
				break;

			case F_PEND_PGDN:
				for (i = 2; i < (zoomwin->sr1 - ZHELPSIZE); i++)
				{
					if (p->next != NULL)
						p = p->next;
					if (cur->next != NULL)
						cur = cur->next;
				}
				break;

			case F_PEND_UPAR:
				if (curl > 2)
				{
					cur = cur->prev;
				}
				else
				{
					if (p->prev != NULL)
						p = cur = p->prev;
				}
				break;

			case F_PEND_DNAR:
				if (curl < (zoomwin->sr1 - 1 - ZHELPSIZE))
				{
					if (cur->next != NULL)
						cur = cur->next;
				}
				else
				{
					if (p->next != NULL)
						p = p->next;
					if (cur->next != NULL)
						cur = cur->next;
				}
				break;

			case F_PEND_HOME:
				p = cur = mail_top;
				break;

			case F_PEND_END:
				while (p->next != NULL)
				{
					p = p->next;
				}
				cur = p;
				for (i = 2; i < (zoomwin->sr1 - 1 - ZHELPSIZE); i++)
				{
					if (p->prev != NULL)
						p = p->prev;
				}
				break;

			case F_ZOOM_ADDRESS:	/* readdress */
				changed = sb_popup (10, 5, 4, 70, mail_addr, 0);
				break;

			case F_UN_CALLRIGHTNOW:
			case F_ZOOM_CRASH:	/* crash */
				changed = sb_popup (10, 5, 4, 70, mail_change, (int) 'C');
				break;

			case F_ZOOM_DIRECT:/* direct */
				changed = sb_popup (10, 5, 4, 70, mail_change, (int) 'D');
				break;

			case F_UN_GETFILE:
				changed = sb_popup (10, 5, 7, 70, Do_Get, 0);
				break;

			case F_ZOOM_GET:	/* get files */
				changed = sb_popup (10, 5, 7, 70, Do_Get, 1);
				break;

			case F_ZOOM_HOLD:	/* hold */
				changed = sb_popup (10, 5, 4, 70, mail_change, (int) 'H');
				break;

			case F_ZOOM_KILLTRIES:	/* reset dial tries */
				changed = sb_popup (10, 5, 4, 70, mail_stop, 0);
				break;

			case F_ZOOM_NORMAL:/* normal */
				changed = sb_popup (10, 5, 4, 70, mail_change, (int) 'N');
				break;

			case F_UN_POLLPKT:
				changed = sb_popup (10, 5, 4, 70, Do_Poll_Packet, 0);
				break;

			case F_ZOOM_POLL:	/* poll */
				changed = sb_popup (10, 5, 5, 70, Do_Poll_Packet, 1);
				break;

			case F_ZOOM_KILLREQ:	/* delete request */
				changed = sb_popup (10, 5, 4, 70, mail_delreq, 0);
				break;

			case F_UN_SENDFILE:
				changed = sb_popup (10, 5, 6, 70, Do_Send, 0);
				break;

			case F_ZOOM_SEND:	/* send files */
				changed = sb_popup (10, 5, 6, 70, Do_Send, 1);
				break;

			case F_ZOOM_STOPMAIL:	/* stop mail */
				changed = sb_popup (10, 5, 4, 70, mail_stop, 1);
				break;

			case F_ZOOM_KILLNODE:
			case F_UN_KILLNODESMAIL:
				changed = !sb_popup (10, 5, 4, 70, Do_Kill, 1);
				break;

			default:			/* Space, ESCape or Return terminates */
				c &= 0x00ff;
				if ((c == 0x20) || (c == 0x1b) || (c == 0x0d))
					return (x);
				break;
			}

			if (changed != 0)
			{
				sb_move (zoomwin, (short) curl, 1);
				sb_wa (zoomwin, colors.hold, 78);
				sb_move (zoomwin, 1, 2);
				sb_puts (zoomwin, MSG_TXT (M_ZOOM_WAIT));
				sb_show ();
				xmit_reset (0);
				t_idle = timerset (6000);
				x = 1;
				/* is there something in the outbound ? */
				if (mail_top == NULL)
				{
					sb_move (zoomwin, 10, 10);
					sb_puts (zoomwin, MSG_TXT (M_NOTHING_IN_OUTBOUND));
					sb_show ();
					wait_for_key (120);
					return (x);
				}
				else
				{
					oldp = oldcur = NULL;
					p = cur = mail_top;
					curl = 2;
					changed = 0;
				}
			}

			if ((oldp != p) || (oldcur != cur))
				zoom_window (zoomwin, p, cur);

		}
		time_release ();
	}
	return (x);
}

static void LOCALFUNC 
zoom_window (REGIONP zoomwin, MAILP p, MAILP cur)
{
	int i;
	int calls, badcalls;
	int zsize = (zoomwin->sr1) - ZHELPSIZE;

	char out_str[50];

	if (oldp == p)
	{
		oldcur = cur;
		sb_move (zoomwin, (short) curl, 1);
		sb_wa (zoomwin, colors.hold, 78);
		i = 2;
		while ((i < zsize) && (p != cur))
		{
			i++;
			p = p->next;
		}
		sb_move (zoomwin, (short) i, 1);
		sb_wa (zoomwin, colors.calling, 78);
		curl = i;
		sb_show ();
		return;
	}

	/* save old status */

	oldp = p;
	oldcur = cur;

	/* give it a header */

	sb_move (zoomwin, 1, 1);
	sb_puts (zoomwin, MSG_TXT (M_ZOOM_HEADER));

	sb_move (zoomwin, (short) curl, 1);
	sb_wa (zoomwin, colors.hold, 78);

	for (i = 2; i < zsize; i++)
	{
		long age;

		if (p == NULL)
			break;

		sb_move (zoomwin, (short) i, 1);

		if (p == cur)
		{
			sb_wa (zoomwin, colors.calling, 78);
			curl = i;
		}

		sprintf (out_str, " %-35s", Full_Addr_Str (&(p->mail_addr)));
		sb_puts (zoomwin, out_str);

		sb_move (zoomwin, (short) i, 36);

		call_tries (&(p->mail_addr), &calls, &badcalls);

		age = (time (NULL) - p->oldest) / 86400L;

		sprintf (out_str, "%3u %9lu %3lu %5d %5d %6s ",
			p->numfiles, p->mailsize, age, calls, badcalls,
			mail_status_chars (p->mailtypes));

		sb_puts (zoomwin, out_str);
		p = p->next;
	}

	/* clear the rest of the zoomed outbound */
	if (i <= zsize)
	{
		zoomwin->sr0 += i;
		zoomwin->sr1 -= ZHELPSIZE;
		zoomwin->sc0++;
		zoomwin->sc1--;
		sb_fillc (zoomwin, ' ');
		zoomwin->sr0 -= i;
		zoomwin->sr1 += ZHELPSIZE;
		zoomwin->sc0--;
		zoomwin->sc1++;
	}

	sb_show ();
}

static int 
mail_change (BINK_SAVEP p, int x)
{
	REGIONP r;
	char iname[80], oname[80], tname[80];	/* junk[80] */
	char *HoldName, *result, *temp_buffer;
	struct FILEINFO fileinfo;
	int ihandle, ohandle;
	int check;
	int written = 1;
	int buff_size;
	int change = 0;

	if (p == NULL)
		return (change);

	r = p->region;

	sb_fill (r, ' ', colors.popup);
	sb_box (r, boxtype, colors.popup);

	switch ((char) x)
	{
	case 'C':
		{
			strcpy (oname, "Crash");
			break;
		}
	case 'D':
		{
			strcpy (oname, "Direct");
			break;
		}
	case 'H':
		{
			strcpy (oname, "Hold");
			break;
		}
	case 'N':
		{
			strcpy (oname, "Normal");
			x = (int) 'F';
			break;
		}
	}

	sprintf (junk, MSG_TXT (M_ZOOM_CHANGE),
		Full_Addr_Str (&(cur->mail_addr)), oname);

	sb_move (r, 0, 1);
	sb_puts (r, junk);

	sb_move (r, 1, 2);
	sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
	(void) sb_input_chars (r, 1, 22, junk, 1);

	/* If user says 'no', get out */

	if (junk[0] != (char) toupper (MSG_TXT (M_YES)[0]))
		return (change);

	if (flag_file (TEST_AND_SET, &(cur->mail_addr), 0))
	{
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_NODE_BUSY));
		wait_for_key (60);
		return (0);
	}

	/* first append/rename ?LO */

	HoldName = HoldAreaNameMunge (&(cur->mail_addr));
	(void) sprintf (tname, "%s%s.?LO", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)));
	(void) sprintf (oname, "%s%s.%cLO", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)), (char) x);

	if (!dfind (&fileinfo, tname, 0))
	{
		do
		{
			buff_size = (int) fileinfo.size;
			strcpy (iname, fileinfo.name);
			result = strchr (iname, '.');
			result++;
			if (*result != (char) x)
			{
				if (cur->mail_addr.Point != 0)
				{
					(void) sprintf (iname, "%s%04x%04x.PNT\\%s",
						HoldName, cur->mail_addr.Net,
						cur->mail_addr.Node, fileinfo.name);
				}
				else
				{
					(void) sprintf (iname, "%s%s", HoldName, fileinfo.name);
				}
				if (rename (iname, oname) != 0)
				{
					temp_buffer = (char *) malloc (buff_size + 1);
					ihandle = open (iname, O_RDONLY | O_BINARY);
					ohandle = open (oname, O_APPEND | O_BINARY | O_WRONLY);
					sb_move (r, 2, 2);
					sprintf (junk, MSG_TXT (M_ZOOM_APPEND), MSG_TXT (M_ZOOM_MAIL_ATT));
					sb_puts (r, junk);
					do
					{
						check = read (ihandle, temp_buffer, buff_size);
						if (check)
							written = write (ohandle, temp_buffer, check);
					}
					while (check > 0);
					close (ihandle);
					close (ohandle);
					if (written > 0)
						unlink (iname);
					free (temp_buffer);
				}
				else
				{
					sb_move (r, 2, 2);
					sprintf (junk, MSG_TXT (M_ZOOM_RENAME), MSG_TXT (M_ZOOM_MAIL_ATT));
					sb_puts (r, junk);
				}
				change = 1;
			}
		}
		while (!dfind (&fileinfo, NULL, 1));
		(void) (dfind (&fileinfo, NULL, 2));
	}

	/* now rename ?UT */

	if ((char) x == 'F')
		x = (int) 'O';
	(void) sprintf (tname, "%s%s.?UT", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)));
	(void) sprintf (oname, "%s%s.%cUT", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)), (char) x);
	if (!dfind (&fileinfo, tname, 0))
	{
		do
		{
			buff_size = (int) fileinfo.size;
			strcpy (iname, fileinfo.name);
			result = strchr (iname, '.');
			result++;
			if (*result != (char) x)
			{
				if (cur->mail_addr.Point != 0)
				{
					(void) sprintf (iname, "%s%04x%04x.PNT\\%s",
						HoldName, cur->mail_addr.Net,
						cur->mail_addr.Node, fileinfo.name);
				}
				else
				{
					(void) sprintf (iname, "%s%s", HoldName, fileinfo.name);
				}
				if ((rename (iname, oname)) != 0)
				{
					if (buff_size > 60)
						append_pkt (r, buff_size, iname, oname);
				}				/* do append if rename failed */
				else
				{
					sb_move (r, 2, 2);
					sprintf (junk, MSG_TXT (M_ZOOM_RENAME), MSG_TXT (M_ZOOM_MAIL_PKT));
					sb_puts (r, junk);
				}
				change = 1;
			}
		}
		while (!dfind (&fileinfo, NULL, 1));
		(void) (dfind (&fileinfo, NULL, 2));
	}							/* end of ?UT handling */

	(void) flag_file (CLEAR_FLAG, &(cur->mail_addr), 0);
	wait_for_key (60);
	return (change);
}

static void LOCALFUNC 
append_pkt (REGIONP r, unsigned int size, char *iname, char *oname)
{
	int ihandle, ohandle;
	struct tm *dt;
	time_t now;
	struct _pkthdr *header;
	char *copy;
	unsigned int buff_size, go;

	sb_move (r, 2, 2);
	sprintf (junk, MSG_TXT (M_ZOOM_APPEND), MSG_TXT (M_ZOOM_MAIL_PKT));
	sb_puts (r, junk);

	header = (struct _pkthdr *) malloc (sizeof (struct _pkthdr) + 1);

	ohandle = open (oname, O_BINARY | O_RDWR);
	ihandle = open (iname, O_BINARY | O_RDONLY);

	go = read (ohandle, header, sizeof (struct _pkthdr));

	lseek (ohandle, 0L, SEEK_SET);

	/* Update the packet header to reflect that its been messed with */

	time (&now);
	dt = localtime (&now);

	header->year = dt->tm_year + 1900;
	header->month = dt->tm_mon + 1;
	header->day = dt->tm_mday;
	header->hour = dt->tm_hour;
	header->minute = dt->tm_min;
	header->second = dt->tm_sec;
	header->product = PRDCT_CODE;

	go = write (ohandle, header, sizeof (struct _pkthdr));

	free (header);

	lseek (ohandle, -2L, SEEK_END);
	lseek (ihandle, ((long) sizeof (struct _pkthdr)), SEEK_SET);
	size -= sizeof (struct _pkthdr);

	buff_size = size;
	if ((copy = (char *) malloc (buff_size)) == NULL)
	{
		do
		{
			buff_size = (buff_size / 10) * 9;
			copy = (char *) malloc (buff_size);
		}
		while (copy == NULL);
	}
	do
	{
		go = read (ihandle, copy, buff_size);
		go = write (ohandle, copy, go);
		size -= buff_size;
		if (buff_size > size)
			buff_size = size;
	}
	while (size > 0);
	free (copy);
	close (ihandle);
	close (ohandle);
	if (go > 0)
		unlink (iname);
	else
	{
		sb_move (r, 2, 2);
		sprintf (junk, MSG_TXT (M_ZOOM_ERRAPP), MSG_TXT (M_ZOOM_MAIL_PKT));
		sb_puts (r, junk);
	}
	return;
}

static int 
mail_stop (BINK_SAVEP p, int x)
{
	REGIONP r;
	int change = 0;
	char stop[80];
	char *HoldName;
	char sure[2];
	FILE *fp;
	struct FILEINFO fileinfo;

	if (p == NULL)
		return (change);

	r = p->region;

	sb_fill (r, ' ', colors.popup);
	sb_box (r, boxtype, colors.popup);

	if (x)
		sprintf (stop, MSG_TXT (M_ZOOM_STOP),
			Full_Addr_Str (&(cur->mail_addr)));
	else
		sprintf (stop, MSG_TXT (M_ZOOM_DELETE),
			Full_Addr_Str (&(cur->mail_addr)));

	sb_move (r, 0, 1);
	sb_puts (r, stop);

	sb_move (r, 1, 2);
	sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
	(void) sb_input_chars (r, 1, 22, sure, 1);

	/* If user says 'no', get out */

	if (sure[0] != (char) toupper (MSG_TXT (M_YES)[0]))
		return (change);

	if (flag_file (TEST_AND_SET, &(cur->mail_addr), 0))
	{
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_NODE_BUSY));
		wait_for_key (60);
		return (0);
	}

	HoldName = HoldAreaNameMunge (&(cur->mail_addr));
	(void) sprintf (stop, "%s%s.$$?", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)));

	if (!dfind (&fileinfo, stop, 0))
	{
		do
		{
			if (cur->mail_addr.Point != 0)
			{
				(void) sprintf (stop, "%s%04x%04x.PNT\\%s",
					HoldName, cur->mail_addr.Net,
					cur->mail_addr.Node, fileinfo.name);
			}
			else
			{
				(void) sprintf (stop, "%s%s", HoldName, fileinfo.name);
			}

			unlink (stop);
		}
		while (!dfind (&fileinfo, NULL, 1));
		(void) (dfind (&fileinfo, NULL, 2));
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_ZOOM_DELCOUNT));
		change = 1;
	}

	if (x)
	{
		(void) sprintf (stop, "%s%s.$$9", HoldName,
			Hex_Addr_Str (&(cur->mail_addr)));
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_ZOOM_NOSEND));
		fp = share_fopen (stop, append_ascii, DENY_WRITE);
		if (fp == (FILE *) NULL)
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_ZOOM_ERRNOSEND));
		}
		else
			change = 1;
		fclose (fp);
	}
	(void) flag_file (CLEAR_FLAG, &(cur->mail_addr), 0);
	wait_for_key (60);
	return (change);
}

static int 
mail_delreq (BINK_SAVEP p, int x)
{
	REGIONP r;
	int rhandle;
	char req[80];
	char sure[2];
	char *HoldName;

	if (p == NULL)
		return (0);

	r = p->region;
	x = 0;

	sb_fill (r, ' ', colors.popup);
	sb_box (r, boxtype, colors.popup);

	sprintf (junk, MSG_TXT (M_ZOOM_DELREQ),
		Full_Addr_Str (&(cur->mail_addr)));

	sb_move (r, 0, 1);
	sb_puts (r, junk);

	sb_move (r, 1, 2);
	sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
	(void) sb_input_chars (r, 1, 22, sure, 1);

	/* If user says 'no', get out */

	if (sure[0] != (char) toupper (MSG_TXT (M_YES)[0]))
		return (x);

	if (flag_file (TEST_AND_SET, &(cur->mail_addr), 0))
	{
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_NODE_BUSY));
		wait_for_key (60);
		return (0);
	}

	HoldName = HoldAreaNameMunge (&(cur->mail_addr));
	(void) sprintf (req, "%s%s.REQ", HoldName,
		Hex_Addr_Str (&(cur->mail_addr)));

	if (dexists (req))
	{
		rhandle = open (req, O_RDONLY | O_BINARY);
		close (rhandle);
		if (rhandle == 0)
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_ZOOM_ERRREQ));
		}
		else
		{
			unlink (req);
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_ZOOM_DEL_REQ));
			x = 1;
		}
		wait_for_key (60);
	}
	(void) flag_file (CLEAR_FLAG, &(cur->mail_addr), 0);
	return (x);
}

static void LOCALFUNC 
append_fil (REGIONP r, unsigned int size, char *iname, char *oname,
	char *desc)
{
	char *temp_buffer;
	char temp[50];
	int ihandle, ohandle;
	int check;
	int written = 1;

	temp_buffer = (char *) malloc (size + 1);
	ihandle = open (iname, O_RDONLY | O_BINARY);
	ohandle = open (oname, O_APPEND | O_BINARY | O_WRONLY);
	(void) sprintf (temp, MSG_TXT (M_ZOOM_APPEND), desc);
	sb_move (r, 2, 2);
	sb_puts (r, temp);
	do
	{
		check = read (ihandle, temp_buffer, size);
		if (check)
			written = write (ohandle, temp_buffer, check);
	}
	while (check > 0);
	close (ihandle);
	close (ohandle);
	if (written > 0)
		unlink (iname);
	free (temp_buffer);
}

static int LOCALFUNC 
appren_mail (REGIONP r, ADDRP fromaddr, ADDRP toaddr,
	char *ftype, char *desc)
{
	char iname[80], oname[80], tname[80];
	char *HoldName;
	struct FILEINFO fileinfo;
	int buff_size;
	int change = 0;

	HoldName = HoldAreaNameMunge (fromaddr);
	(void) sprintf (tname, "%s%s.%s", HoldName, Hex_Addr_Str (fromaddr), ftype);
	if (!dfind (&fileinfo, tname, 0))
	{
		do
		{
			buff_size = (int) fileinfo.size;
			HoldName = HoldAreaNameMunge (toaddr);
			(void) sprintf (oname, "%s%s.%s", HoldName, Hex_Addr_Str (toaddr),
				&(fileinfo.name[9]));
			HoldName = HoldAreaNameMunge (fromaddr);
			if (cur->mail_addr.Point != 0)
			{
				(void) sprintf (iname, "%s%04x%04x.PNT\\%s", HoldName,
					fromaddr->Net, fromaddr->Node, fileinfo.name);
			}
			else
			{
				(void) sprintf (iname, "%s%s", HoldName, fileinfo.name);
			}
			if (rename (iname, oname) != 0)
			{
				if (!strcmp (desc, "?UT"))	/* mail packet */
				{
					if (buff_size > 60)
						append_pkt (r, buff_size, iname, oname);
				}
				else
					/* other file */
				{
					append_fil (r, buff_size, iname, oname, desc);
				}
			}
			else
			{
				sprintf (iname, MSG_TXT (M_ZOOM_RENAME), desc);
				sb_move (r, 2, 2);
				sb_puts (r, iname);
			}
			change = 1;
		}
		while (!dfind (&fileinfo, NULL, 1));
		(void) (dfind (&fileinfo, NULL, 2));
	}
	return (change);
}

static int 
mail_addr (BINK_SAVEP p, int x)
{
	REGIONP r;
	char iname[80], sure[2];
	ADDR addr;

	x = 0;

	if (p == NULL)
		return (0);

	r = p->region;

	sb_fill (r, ' ', colors.popup);
	sb_box (r, boxtype, colors.popup);

	sb_move (r, 0, 1);
	sb_puts (r, MSG_TXT (M_ZOOM_DESTINATION));

	sb_move (r, 1, 2);
	sb_puts (r, MSG_TXT (M_ZOOM_NEWADDR));
	if (!sb_input_chars (r, 1, 18, iname, 36))
	{
		if (!find_address (iname, &addr))
		{
			return (0);
		}
		if (nodefind (&addr, 0))
		{
			sb_move (r, 1, 2);
			sprintf (iname, "Node: %-18.18s - %-20.20s",
				Full_Addr_Str (&addr), newnodedes.SystemName);
			sb_puts (r, iname);
		}
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
		(void) sb_input_chars (r, 2, 22, sure, 1);

		/* If user says 'no', get out */

		if (sure[0] != (char) toupper (MSG_TXT (M_YES)[0]))
			return (x);

		if (flag_file (TEST_AND_SET, &(cur->mail_addr), 0))
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			return (0);
		}
		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			(void) flag_file (CLEAR_FLAG, &(cur->mail_addr), 0);
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			return (0);
		}

		/* first append/rename ?LO */

		appren_mail (r, &(cur->mail_addr), &addr, "?LO", "mail attaches");

		/* append/rename REQ */

		appren_mail (r, &(cur->mail_addr), &addr, "REQ", "request files");

		/* now rename ?UT */

		appren_mail (r, &(cur->mail_addr), &addr, "?UT", "mail packets ");

		(void) flag_file (CLEAR_FLAG, &addr, 0);
		(void) flag_file (CLEAR_FLAG, &(cur->mail_addr), 0);
		wait_for_key (60);
		x = 1;
	}							/* end of address input */
	return (x);
}

int 
Do_Get (BINK_SAVEP p, int x)
{
	REGIONP r;
	char node[51];
	char file[51];
	char password[9];
	char flavor[2];
	char more[2];
	int busy = 0;
	int did_it = 0;
	short i;
	ADDR addr;

	if (p == NULL)
		return (0);

	r = p->region;

	if (x)
	{
		addr = cur->mail_addr;

		/* Busy the node if we can. */

		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			return (-1);
		}
		busy = 1;
	}

	/* First fill it all with blanks */

	sb_fill (r, ' ', colors.popup);

	/* Now draw the box */

	sb_box (r, boxtype, colors.popup);
	sb_move (r, 0, 1);
	sb_puts (r, MSG_TXT (M_GET_FILE));

	/* Now do the fields */

	for (;;)
	{
		sb_move (r, 1, 2);
		sb_puts (r, MSG_TXT (M_ADDRESS_TO_GET_FROM));

		/* Display address if zoomed, ask for it if not. */

		if (x)
		{
			strncpy (node, Full_Addr_Str (&addr), 35);
			node[35] = '\0';
			sb_move (r, 1, 23);
			sb_puts (r, node);
		}
		else
		{
			if (sb_input_chars (r, 1, 23, node, 36))
				break;
			if (!find_address (node, &addr))
			{
				if (!did_it)
					did_it = -1;
				break;
			}

			/* Busy the node if we can. */

			if (flag_file (TEST_AND_SET, &addr, 0))
			{
				sb_move (r, 2, 2);
				sb_puts (r, MSG_TXT (M_NODE_BUSY));
				wait_for_key (60);
				if (!did_it)
					did_it = -1;
				break;
			}
			busy = 1;
		}

		/* Ask for the filename */

		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_FILE_TO_RECEIVE));
		if (sb_input_chars (r, 2, 23, file, 12))
			break;

		/* Get the password if any */

		sb_move (r, 3, 2);
		sb_puts (r, MSG_TXT (M_PASSWORD_TO_USE));
		(void) sb_input_chars (r, 3, 23, password, 8);

		/* Get the flavor or quit */

		sb_move (r, 4, 2);
		sb_puts (r, MSG_TXT (M_GET_FLAVOR));
		(void) sb_input_chars (r, 4, 41, flavor, 1);

		/* Get the file if we can */

		if (flavor[0] != 'Q')
		{
			if (mail_addrequest (&addr, file, password, flavor) == 0)
				did_it = 1;
			else if (!did_it)
				did_it = -1;
		}

		/* Unbusy the node */

		if (!x)
		{
			(void) flag_file (CLEAR_FLAG, &addr, 0);
			busy = 0;
		}

		/* Anything more to do? */

		sb_move (r, 5, 2);
		sb_puts (r, MSG_TXT (M_GET_MORE));
		(void) sb_input_chars (r, 5, 23, more, 1);
		if (more[0] != (char) toupper (MSG_TXT (M_YES)[0]))
			break;

		/* Yes, clear the box. */

		for (i = 1; i <= 5; i++)
		{
			sb_move (r, i, 2);
			sb_puts (r, "                                                 ");
		}
	}

	/* If we busied something, get rid of it. */

	if (busy)
		(void) flag_file (CLEAR_FLAG, &addr, 0);
	return (did_it);
}

static int LOCALFUNC 
mail_addrequest (ADDRP pAddr, char *file, char *password, char *flavor)
{
	char *HoldName;
	char fname[100];
	FILE *f;

	if (flavor[0] == '\0')
		flavor[0] = 'N';
	if ((flavor[0] != 'C') && (flavor[0] != 'H') && (flavor[0] != 'N') &&
		(flavor[0] != 'D'))
		return (-3);
	if (flavor[0] == 'N')
		flavor[0] = 'F';
	flavor[1] = '\0';

	HoldName = HoldAreaNameMunge (pAddr);

	/* Now see if we should send anything back to him */

	(void) sprintf (fname, "%s%s.REQ", HoldName, Hex_Addr_Str (pAddr));
	if ((f = fopen (fname, append_binary)) == NULL)
		return (-2);

	(void) fprintf (f, "%s", file);
	if (password[0] != '\0')
	{
		(void) fprintf (f, " !%s", password);
	}
	(void) fprintf (f, "\r\n");
	(void) fclose (f);

	(void) mail_addsend (pAddr, "", flavor);
	return (0);
}

int 
Do_Poll_Packet (BINK_SAVEP p, int x)
{
	REGIONP r;
	char node[51];
	char more[2];
	int busy = 0;
	int did_it = 0;
	ADDR addr;

	if (p == NULL)
		return (0);

	r = p->region;

	if (x)
	{
		addr = cur->mail_addr;

		/* Busy the node if we can. */

		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			return (-1);
		}
		busy = 1;
	}

	/* First fill it all with blanks */

	sb_fill (r, ' ', colors.popup);

	/* Now draw the box */

	sb_box (r, boxtype, colors.popup);
	sb_move (r, 0, 1);
	sb_puts (r, MSG_TXT (M_ZOOM_POLL));

	/* Now do the fields */

	sb_move (r, 1, 2);
	sb_puts (r, MSG_TXT (M_POLL_WHOM));

	/* Display address if zoomed, ask for it if not. */

	if (x)
	{
		strncpy (node, Full_Addr_Str (&addr), 39);
		node[39] = '\0';
		sb_move (r, 1, 14);
		sb_puts (r, node);
	}
	else
	{
		if (sb_input_chars (r, 1, 14, node, 40))
			goto Done;
		if (!find_address (node, &addr))
		{
			if (!did_it)
				did_it = -1;
			goto Done;
		}

		/* Busy the node if we can. */

		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			if (!did_it)
				did_it = -1;
			goto Done;
		}
		busy = 1;
	}

	if (x)
	{
		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
		if (sb_input_chars (r, 2, 22, more, 1))
			goto Done;
		if (more[0] != (char) toupper (MSG_TXT (M_YES)[0]))
			goto Done;
	}

	if (mail_addsend (&addr, "", "C") == 0)
		did_it = 1;
	else if (!did_it)
		did_it = -1;
Done:

	/* If we busied something, get rid of it. */

	if (busy)
		(void) flag_file (CLEAR_FLAG, &addr, 0);
	return (did_it);
}

int 
Do_Send (BINK_SAVEP p, int x)
{
	REGIONP r;
	char node[51];
	char file[51];
	char flavor[2];
	char more[2];
	int busy = 0;
	int did_it = 0;
	short i;
	ADDR addr;

	if (p == NULL)
		return (0);

	r = p->region;

	if (x)
	{
		addr = cur->mail_addr;

		/* Busy the node if we can. */

		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			sb_move (r, 2, 2);
			sb_puts (r, MSG_TXT (M_NODE_BUSY));
			wait_for_key (60);
			return (-1);
		}
		busy = 1;
	}

	/* First fill it all with blanks */

	sb_fill (r, ' ', colors.popup);

	/* Now draw the box */
	sb_box (r, boxtype, colors.popup);
	sb_move (r, 0, 1);
	sb_puts (r, MSG_TXT (M_SEND_FILE));

	/* Now do the fields */

	for (;;)
	{
		sb_move (r, 1, 2);
		sb_puts (r, MSG_TXT (M_ADDRESS_TO_SEND_TO));

		/* Display address if zoomed, ask for it if not. */

		if (x)
		{
			strncpy (node, Full_Addr_Str (&addr), 46);
			node[46] = '\0';
			sb_move (r, 1, 22);
			sb_puts (r, node);
		}
		else
		{
			if (sb_input_chars (r, 1, 22, node, 47))
				break;
			if (!find_address (node, &addr))
			{
				if (!did_it)
					did_it = -1;
				break;
			}

			/* Busy the node if we can. */

			if (flag_file (TEST_AND_SET, &addr, 0))
			{
				sb_move (r, 2, 2);
				sb_puts (r, MSG_TXT (M_NODE_BUSY));
				wait_for_key (60);
				if (!did_it)
					did_it = -1;
				break;
			}
			busy = 1;
		}

		/* Ask for the filename */

		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_FILE_TO_SEND));
		if (sb_input_chars (r, 2, 22, file, 47))
			break;

		/* Get the flavor or quit */

		sb_move (r, 3, 2);
		sb_puts (r, MSG_TXT (M_SEND_FLAVOR));
		(void) sb_input_chars (r, 3, 49, flavor, 1);

		/* Send the file if we can */

		if (flavor[0] != 'Q')
		{
			if (mail_addsend (&addr, file, flavor) == 0)
				did_it = 1;
			else if (!did_it)
				did_it = -1;
		}

		/* Unbusy the node */

		if (!x)
		{
			(void) flag_file (CLEAR_FLAG, &addr, 0);
			busy = 0;
		}

		/* Anything more to do? */

		sb_move (r, 4, 2);
		sb_puts (r, MSG_TXT (M_SEND_MORE));
		(void) sb_input_chars (r, 4, 20, more, 1);
		if (more[0] != (char) toupper (MSG_TXT (M_YES)[0]))
			break;

		/* Yes, clear the box. */

		for (i = 1; i <= 4; i++)
		{
			sb_move (r, i, 2);
			sb_puts (r, "                                                 ");
		}
	}

	/* If we busied something, get rid of it. */

	if (busy)
		(void) flag_file (CLEAR_FLAG, &addr, 0);
	return (did_it);
}

static int LOCALFUNC 
mail_addsend (ADDRP pAddr, char *file, char *flavor)
{
	char *HoldName;
	char fname[100];
	FILE *f;

	if (flavor[0] == '\0')
		flavor[0] = 'N';
	if ((flavor[0] != 'C') && (flavor[0] != 'H') && (flavor[0] != 'N') &&
		(flavor[0] != 'D'))
		return (-3);
	if (flavor[0] == 'N')
		flavor[0] = 'F';
	flavor[1] = '\0';
	HoldName = HoldAreaNameMunge (pAddr);
	(void) sprintf (fname, "%s%s.%sLO", HoldName,
		Hex_Addr_Str (pAddr), flavor);
	if ((f = fopen (fname, append_binary)) == NULL)
	{
		return (-2);
	}
	else
	{
		if (file[0] != '\0')
			(void) fprintf (f, "%s\r\n", file);
		(void) fclose (f);
	}
	return (0);
}

int 
Do_Kill (BINK_SAVEP p, int x)
{
	REGIONP r;
	char node[51];
	char sure[2];

	if (p != NULL)
	{
		r = p->region;

		/* First fill it all with blanks */
		sb_fill (r, ' ', colors.popup);

		/* Now draw the box */
		sb_box (r, boxtype, colors.popup);

		sb_move (r, 0, 1);
		sb_puts (r, MSG_TXT (M_KILL_MAIL));

		/* Now do the fields */
		sb_move (r, 1, 2);
		sb_puts (r, MSG_TXT (M_ADDRESS_TO_KILL));

		if (x)
		{
			strncpy (node, Full_Addr_Str (&cur->mail_addr), 50);
			node[50] = '\0';
			sb_move (r, 1, 19);
			sb_puts (r, node);
		}
		else if (sb_input_chars (r, 1, 19, node, 50))
			return 0;

		sb_move (r, 2, 2);
		sb_puts (r, MSG_TXT (M_KILL_ALL_MAIL));
		sb_puts (r, MSG_TXT (M_ARE_YOU_SURE));
		(void) sb_input_chars (r, 2, 38, sure, 1);
		if (sure[0] == (char) toupper (MSG_TXT (M_YES)[0]))
			x = kill_node (node);
		else x = 0;
	}
	else x = 0;

	/* Return value is never checked, just use x so lint and -W3 don't get mad */

	return (x);
}

int 
Do_Poll (BINK_SAVEP p, int x)
{
	char node[51];
	REGIONP r;

	happy_compiler = x;			/* Makes the compiler happy! */
	if (p != NULL)
	{
		r = p->region;

		/* First fill it all with blanks */

		sb_fill (r, ' ', colors.popup);

		/* Now draw the box */

		sb_box (r, boxtype, colors.popup);
		sb_move (r, 0, 1);
		sb_puts (r, MSG_TXT (M_NODE_TO_POLL));

		/* Now do the fields */

		sb_move (r, 1, 2);
		sb_puts (r, MSG_TXT (M_POLL_WHOM));
		if (!sb_input_chars (r, 1, 14, node, 40))
		{
			return (find_address (node, &next_addr));
		}
	}
	return (FALSE);
}

static int LOCALFUNC 
kill_node (char *node)
{
	ADDR addr;
	char *HoldName;
	char *p;
	char fname[160];
	struct FILEINFO fileinfo = {0};
	int j;

	if (find_address (node, &addr))
	{
		if (flag_file (TEST_AND_SET, &addr, 0))
		{
			return (-1);
		}

		HoldName = HoldAreaNameMunge (&addr);

		(void) sprintf (fname, "%s%s.*", HoldName, Hex_Addr_Str (&addr));
		j = 0;
		while (!dfind (&fileinfo, fname, j))
		{
			j = 1;

			/* Don't delete the .bsy flags yet */

			if ((p = strchr (fileinfo.name, '.')) != NULL)
			{
				if (strcmp (p, ".BSY") == 0)
					continue;
			}

			if (addr.Point != 0)
			{
				(void) sprintf (fname, "%s%04hx%04hx.PNT\\%s",
					HoldName, addr.Net, addr.Node, fileinfo.name);
			}
			else
				(void) sprintf (fname, "%s%s", HoldName, fileinfo.name);

			(void) unlink (fname);
		}
		if (j)
			(void) dfind (&fileinfo, NULL, 2);

		(void) flag_file (CLEAR_FLAG, &addr, 0);
		return (0);
	}
	/* else */
	return (-1);
}

static void LOCALFUNC 
call_tries (ADDRP baddr, int *calls, int *badcalls)
{
	int res;
	int i, j;
	struct FILEINFO bad_dta = {0};
	char *HoldName;

	char fname[128];

	HoldName = HoldAreaNameMunge (baddr);
	(void) sprintf (fname, "%s%s.$$?", HoldName, Hex_Addr_Str (baddr));
	j = (int) strlen (fname) - 1;			/* Point at ?          */
	res = -1;								/* Initialize to fail  */

	i = 0;									/* This says findfirst */
	while (!dfind (&bad_dta, fname, i))		/* as long as we match */
	{
		if (isdigit (bad_dta.name[11]))		/* is there a digit?   */
		{
			fname[j] = bad_dta.name[11];	/* Yes, copy to fname  */
			res = fname[j] - '0';			/* Save it for testing */
			break;							/* Get out of while    */
		}
		else
			i = 1;							/* Else use findnext   */
	}
	if (i)
		(void) dfind (&bad_dta, NULL, 2);

	/* Initialize the return values */

	*calls = *badcalls = 0;

	/* Is it automatically ok (no .$$ file there) ? */

	if (res == -1)
		return;

	/* We now have the number of bad calls (calls with carrier) */

	*badcalls = res;

	/* Open the file and find out how many total calls were made */

	i = open (fname, O_RDONLY | O_BINARY);
	if (i != -1)
	{
		res = 0;
		(void) read (i, (char *) &res, sizeof (int));
		(void) close (i);
	}

	*calls = res;
	return;
}
	
#if 0
static char LOCALFUNC xlat_flavor (char flavor);
static char LOCALFUNC 
xlat_flavor (char flavor)
{
	char *real_flavor = "CHDN";
	char *user_flavor;

	user_flavor = MSG_TXT (M_CHDN_FLAGS);
	for (;;)
	{
		if (!*real_flavor)
			break;
		if (*user_flavor == flavor)
		{
			return *real_flavor;
		}
		user_flavor++;
		real_flavor++;
	}
	return (0);
}

#endif
