#define __STDC__ 1

#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/*box drawing characters*/
#define DTLC '\xC9'
#define DTRC '\xBB'
#define DBLC '\xC8'
#define DBRC '\xBC'
#define DHOR '\xCD'
#define DVER '\xBA'
#define SHOR '\xC4'
#define SVER '\xB3'
#define DTUP '\xCF'
#define DTLT '\xB6'
#define DTRT '\xC7'
#define DTDN '\xD1'
#define SCRS '\xC5'
#define STLT '\xB4'
#define STRT '\xC3'
#define STUP '\xC1'
#define STDN '\xC2'

/*Okay, so the PC speaker is cheesy-sounding.  Welcome to reality.*/
typedef enum  /*Enumeration of notes and frequencies*/
{
	CZ=33,DZ=37,EZ=42,FZ=44,GZ=49,AZ=55,BZ=62,CY=66,DY=74,EY=83,FY=88,
	GY=98,AY=110,BY=124,CX=131,DX=148,EX=165,FX=175,GX=196,AX=220,BX=247,
	C0=262,D0=296,E0=330,F0=349,G0=392,A0=440,B0=494,C1=523,D1=587,E1=659,
	F1=698,G1=784,A1=880,B1=988,C2=1024,D2=1174,E2=1318,F2=1396,G2=1568,
	A2=1760,B2=1976,C3=2048,D3=2348,E3=2636,F3=2792,G3=3136,A3=3520,B3=3952,
	C4=4096,D4=4696,E4=5272,F4=5584,G4=6272,A4=7040,B4=7904,THIRTYSECOND=1,
	SIXTEENTH=3,EIGHTH=6,QUARTER=12,HALF=25,WHOLE=50,END=0,REST=-1
} TUNE;

/*Axel F (C) by Harold Faltermeyer from the "Beverly Hills Cop" soundtrack*/
/*      This particular TUNE array sounds even worse than the others!     */
TUNE home[] =
{
	E0,EIGHTH,REST,THIRTYSECOND,G0,EIGHTH,REST,THIRTYSECOND,E0,SIXTEENTH,
	REST,THIRTYSECOND+1,E0,SIXTEENTH,A0,SIXTEENTH,REST,THIRTYSECOND,
	E0,SIXTEENTH,REST,THIRTYSECOND,D0,SIXTEENTH+1,E0,EIGHTH,
	REST,THIRTYSECOND,B0,EIGHTH,E0,SIXTEENTH,REST,THIRTYSECOND*2,
	E0,SIXTEENTH,C1,SIXTEENTH,REST,THIRTYSECOND,B0,SIXTEENTH,
	REST,THIRTYSECOND,G0,SIXTEENTH,REST,THIRTYSECOND,E0,SIXTEENTH,
	REST,THIRTYSECOND,B0,SIXTEENTH,REST,THIRTYSECOND,E1,SIXTEENTH,
	REST,THIRTYSECOND*2,G0,SIXTEENTH-1,E0,THIRTYSECOND*2,REST,THIRTYSECOND,
	D0,SIXTEENTH,C0,THIRTYSECOND*2,REST,THIRTYSECOND,F0+21,SIXTEENTH+1,
	REST,THIRTYSECOND*2,E0,QUARTER,END
};

/*Battery (C) by Metallica from "Master of Puppets"*/
TUNE restaurant[] =
{
	C0,QUARTER/2,E0,EIGHTH/2,F0,EIGHTH/2,D0,QUARTER/2,REST,THIRTYSECOND,
	C0,QUARTER/2,E0,(QUARTER+EIGHTH)/2,F0,EIGHTH/2,D0,QUARTER/2,
	REST,THIRTYSECOND,C0,QUARTER/2,E0,EIGHTH/2,F0,EIGHTH/2,D0,QUARTER/2,
	REST,THIRTYSECOND,C0-6,(QUARTER+EIGHTH+SIXTEENTH)/2,F0,QUARTER/2+1,
	E0,(QUARTER+EIGHTH)/2,REST,QUARTER/2,END
};

/*Harvester of Sorrow (C) by Metallica from "...And Justice for All"*/
TUNE start[] =
{
    BZ,THIRTYSECOND*2,REST,SIXTEENTH+THIRTYSECOND,EY,THIRTYSECOND*2,
    REST,SIXTEENTH,CX,EIGHTH,BY,EIGHTH,REST,THIRTYSECOND,BZ,THIRTYSECOND*2,
    REST,THIRTYSECOND,EY,THIRTYSECOND*2,REST,THIRTYSECOND,DX,EIGHTH,
    CX,EIGHTH,BY,EIGHTH,BZ,THIRTYSECOND*2,REST,SIXTEENTH,EY,THIRTYSECOND*2,
    REST,SIXTEENTH,CX,EIGHTH,BY,EIGHTH,REST,THIRTYSECOND,BZ,THIRTYSECOND*2,
    REST,THIRTYSECOND,EY,THIRTYSECOND*2,REST,THIRTYSECOND,BY,EIGHTH,
    REST,THIRTYSECOND,BZ,THIRTYSECOND*2,REST,SIXTEENTH+1,BY,EIGHTH,
    END
};

/*Harvester of Sorrow (C) by Metallica from "...And Justice for All"*/
TUNE deal[] =
{
    BZ,THIRTYSECOND*2,REST,SIXTEENTH+THIRTYSECOND,EY,THIRTYSECOND*2,
    REST,SIXTEENTH,CX,EIGHTH,BY,EIGHTH,REST,THIRTYSECOND,BZ,THIRTYSECOND*2,
    REST,THIRTYSECOND,EY,THIRTYSECOND*2,REST,THIRTYSECOND,DX,EIGHTH,
    CX,EIGHTH,BY,EIGHTH,END
};

/*Back in Black (C) by AC/DC from "Back in Black"*/
TUNE victory[] =
{
	AX,EIGHTH,REST,QUARTER,GX,SIXTEENTH-1,REST,THIRTYSECOND,
	GX,SIXTEENTH-1,REST,THIRTYSECOND,GX,EIGHTH,REST,QUARTER,
	EX,SIXTEENTH-1,REST,THIRTYSECOND,EX,SIXTEENTH-1,REST,THIRTYSECOND,
	EX,EIGHTH,REST,HALF-2,F1,SIXTEENTH,E1,SIXTEENTH,D1,SIXTEENTH,
	C1,SIXTEENTH,D1,SIXTEENTH,C1,SIXTEENTH,B0,SIXTEENTH,
	A0,EIGHTH,END
};

TUNE shot[] =
{
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,THIRTYSECOND,
	BZ,THIRTYSECOND,REST,QUARTER,END
};

TUNE siren[] =
{
    A0,QUARTER,AX,QUARTER,A0,QUARTER,AX,QUARTER,END
};

TUNE bad_news[] =
{
	AX,SIXTEENTH,GX,SIXTEENTH,REST,SIXTEENTH,FX,SIXTEENTH,REST,SIXTEENTH,
	EX,EIGHTH,REST,SIXTEENTH,GX,SIXTEENTH,FX,SIXTEENTH,REST,SIXTEENTH,
	EX,SIXTEENTH,REST,SIXTEENTH,DX,EIGHTH,REST,SIXTEENTH,EX,SIXTEENTH,
	REST,EIGHTH,CX,SIXTEENTH,REST,EIGHTH,DX,QUARTER,REST,SIXTEENTH,
	REST,QUARTER,END
};

TUNE dead[] =
{
    DY,QUARTER+EIGHTH,REST,THIRTYSECOND,DY,QUARTER+SIXTEENTH,
    REST,THIRTYSECOND,DY,EIGHTH,REST,THIRTYSECOND,DY,QUARTER+THIRTYSECOND,
    REST,SIXTEENTH,FY,QUARTER+SIXTEENTH,EY,EIGHTH,REST,THIRTYSECOND,
    EY,QUARTER,DY,EIGHTH,REST,THIRTYSECOND,DY,QUARTER,REST,THIRTYSECOND,
    CY,EIGHTH,DY,HALF,END
};

TUNE good_news[] =
{
	DX,SIXTEENTH,REST,THIRTYSECOND,DX,SIXTEENTH,REST,SIXTEENTH,DX,SIXTEENTH,
	REST,SIXTEENTH,DX,SIXTEENTH,REST,SIXTEENTH,DX,SIXTEENTH,REST,SIXTEENTH,
	DX,SIXTEENTH,REST,SIXTEENTH,DX,THIRTYSECOND,FX,EIGHTH,REST,THIRTYSECOND,
	GX,EIGHTH,REST,THIRTYSECOND,DX,SIXTEENTH,REST,THIRTYSECOND,DX,SIXTEENTH,
	REST,SIXTEENTH,DX,SIXTEENTH,REST,SIXTEENTH,DX,SIXTEENTH,REST,SIXTEENTH,
	DX,QUARTER-SIXTEENTH+1,END
};

TUNE move[] =
{
    DZ,EIGHTH,DZ,EIGHTH,EZ,EIGHTH,DZ,EIGHTH,
    FZ,EIGHTH,DZ,EIGHTH,GZ,EIGHTH,FZ,EIGHTH,
    DZ,EIGHTH,DZ,EIGHTH,EZ,EIGHTH,DZ,EIGHTH,
    FZ,EIGHTH,DZ,EIGHTH,GZ,EIGHTH,FZ,EIGHTH,
    DZ,EIGHTH,DZ,EIGHTH,EZ,EIGHTH,DZ,EIGHTH,
    FZ,EIGHTH,DZ,EIGHTH,GZ,EIGHTH,FZ,EIGHTH,
    DZ,EIGHTH,REST,QUARTER,END
};

/*Money (C) by Pink Floyd from "Dark Side of the Moon"*/
TUNE money[] =
{
    DY,QUARTER,AY,EIGHTH,FY,SIXTEENTH,DY,THIRTYSECOND*2,REST,EIGHTH,
    FZ,SIXTEENTH*3,BZ,SIXTEENTH*3,DY,SIXTEENTH*3,FY,SIXTEENTH*3,
    DY,SIXTEENTH*3,AY,EIGHTH,FY,SIXTEENTH,DY,THIRTYSECOND*2,REST,EIGHTH,
    FZ,SIXTEENTH*3,BZ,SIXTEENTH*3,DY,SIXTEENTH*3,FY,SIXTEENTH*3,
    DY,QUARTER,REST,EIGHTH,C0,THIRTYSECOND,C1,THIRTYSECOND,
    C2,THIRTYSECOND,C3,EIGHTH,REST,QUARTER,END
};

/*Structure for game data*/
struct data
	{/*lots of space allocated for a good long game*/
	unsigned long  cost[6],      /*dope prices*/
				cash,         /*cash on hand*/
				bank,         /*cash in bank*/
				debt,         /*debt to vinnie*/
				last_cost;    /*last amount of money exchanged*/
	unsigned int   stash[6],     /*dope in your stash*/
				coat[6],      /*dope in your pockets*/
				guns,         /*how many guns you have*/
				danger,       /*how dangerous the cops think you are*/
				health,       /*percentage of intact flesh on your body*/
				city,         /*what city you're in*/
				last_city,    /*the city you were in last turn*/
				days_used,    /*days you've been in business*/
				days_left,    /*days you have to pay your debt*/
				last_volume,  /*last amount of dope that changed hands*/
				total;        /*total of all dope in your pockets*/
	int            pockets;      /*pockets in your trenchcoat*/
	};

/*Global variables*/
/*Labels used for drugs, cities, and guns--easily changed later*/
char drug_name[6][6]=    {/*names of drugs*/
					"Coke","Smack","Dust","Acid","Herb","Rocks"
					},

	city_name[6][11]=   {/*names of cities*/
					"Rockville","Northwest","Southeast",
					"Arlington","The Mall","Alexandria"
					},

	gun_name[6][14]=    {/*names of guns*/
					"n AK-47"," 9mm pistol","n Uzi SMG",
					" 45 automatic"," Beretta"," 12 gauge pump"
					},

	homey[6][9]=        {/*names of friends who give you a lift*/
					"Leroy","Peanut","Bubba","Tyrone","Clarence","Ren"
					},

	def_file[13]="DOPEWARS.SAV";
	int noise=1;
    float version_number=1.5;


/*Function declarations*/

int  str2dec         (char * string);        /*string to decimal integer*/

unsigned int
	str2uns         (char * string);        /*string to unsigned int*/

unsigned long
	str2unl         (char * string);        /*string to unsigned long*/


void retired         (void);                 /*retirement routine*/
void cleanup         (void);                 /*final housekeeping*/
void reset		 (void);				/*exit routine*/
void online_help (void);                /*help routine*/

int  dice            (int num,               /*dice rolling function--*/
				  int sides,             /*very useful in most games,*/
				  int bonus);            /*this one is all-purpose*/

void getit           (char * string);        /*string handling routine*/
void str2fil         (char * string);        /*convert string to filename*/

void beep            (const TUNE * tune);    /*music playing routine*/

void randomize_price (struct data * market); /*redetermine prices for dope*/

void encounter       (struct data * modify); /*events around you*/
void modify_game     (struct data * modify); /*cheat function*/

void play            (struct data * player); /*play a turn*/
void killed          (struct data * player );/*routine if you die*/
void the_cops        (struct data * player); /*routine for cop fights*/
void initialize_game (struct data * player); /*set beginning values*/

void buy             (struct data * check);  /*routine to buy dope*/
void jet             (struct data * check);  /*routine to move around*/
void sell            (struct data * check);  /*routine to sell dope*/
void bank            (struct data * check);  /*routine to access the bank*/
void build           (struct data * check);  /*build the screen*/
void update          (struct data * check);  /*update the screen*/
void vinnie          (struct data * check);  /*routine to see loan shark*/
void end_game        (struct data * check);  /*routine if your time is up*/
void transfer        (struct data * check);  /*routine to access your stash*/
void game_functions  (struct data * check);  /*save,restore,new,quit*/

void save_game       (struct data * game);   /*save your game*/
void restore_game    (struct data * game);   /*restore a saved game*/

void main(void)
{         /*main logic driver*/
	struct time tik;                               /*random number seed*/
	struct data info;                              /*character info*/

	atexit(reset);							  /*clean up at exit*/
	textmode(C80);                                 /*set video mode*/
	gettime(&tik);                                 /*get the time*/
	srand(tik.ti_hund);                            /*seed dice roller*/
	initialize_game(&info);                        /*set up player data*/
	randomize_price(&info);                        /*determine prices*/
	info.last_city=info.city=0;                    /*set city and last
										    city to Rockville*/
	build(&info);                                  /*build the screen*/
	if(noise) beep(start);                         /*play a little tune*/
	encounter(&info);                              /*do first encounters*/
	while(info.days_left) play(&info);             /*play till time is up*/
	end_game(&info);                               /*do end game screen*/
	cleanup();                                     /*clean up*/
}

void initialize_game (struct data * player)
{
	int counter;                                   /*counter for loops*/

	player->stash[0]=player->stash[1]=player->stash[2]=
	player->stash[3]=player->stash[4]=player->stash[5]=0;
	player->total=0;                               /*zero out the stash*/
	counter=6;
	while (counter--)                              /*zero out the coat*/
		player->coat[counter]=player->stash[counter];
	player->cash=2000;                             /*starting cash*/
	player->debt=5000;                             /*starting debt*/
	player->bank=player->last_cost=0;              /*last amount of
										    money exchanged*/
	player->guns=player->last_volume=0;            /*last amount of
										    dope exchanged*/
	player->pockets=100;                           /*100 pockets*/
	player->health=100;                            /*and 100 health*/
	player->days_used=1;                           /*it is day 1*/
	player->days_left=30;                          /*and you have 30 days
										    to pay the debt*/
	player->danger=500;                            /*you aren't very
										    dangerous yet*/
}

void randomize_price (struct data * market)
{/*Randomize the dope prices*/
/*coke:15001 to 30000*/
	market->cost[0]=(unsigned long)(dice(1,15000,15000));
/*smack:5001 to 15000*/
	market->cost[1]=(unsigned long)(dice(1,10000,5000));
/*dust:5001 to 10000*/
	market->cost[2]=(unsigned long)(dice(1,5000,5000));
/*acid:1001 to 5000*/
	market->cost[3]=(unsigned long)(dice(1,4000,1000));
/*herb:101 to 250*/
	market->cost[4]=(unsigned long)(dice(1,150,100));
/*rock:26 to 75*/
	market->cost[5]=(unsigned long)(dice(1,50,25));
}


void play (struct data * player)
{ /*actual game play routine*/
	char action='\0';

	while (player->city==player->last_city) /*if the player hasn't moved*/
	{
		update(player);                    /*update the screen*/
		the_cops(player);                  /*see if the cops show up*/
		cprintf("\n\rSo what next, G?  "); /*ask what to do*/
		while((action!='B')&&(action!='S')&&(action!='J')
			&&(action!='G')&&(action!='V')&&(action!='T'))
		{   /*keep getting a response till it's valid*/
			action=(toupper(getch()));    /*if X call function menu*/
			if (action=='X') game_functions(player);
		}
		switch(action)                     /*take the valid response*/
		{                                  /*and act on it*/
			case 'B':
				textcolor(MAGENTA);      /*buy process*/
				cprintf("Buy\n\rYou looks over de merchandise:");
				buy(player);
				action='\0';
				break;
			case 'S':
				textcolor(RED);          /*sell process*/
				cprintf("Sell\n\rYou checks fo cops and\n\r"
						"pulls out yo shit:");
				sell(player);
				action='\0';
				break;
			case 'J':
				textcolor(CYAN);         /*jet process*/
				cprintf("Jet\n\rYou gets de fuck outa Dodge!");
				jet(player);
				action='\0';
				break;
			case 'G':
				textcolor(GREEN);        /*bank process*/
				cprintf("Go to bank\n\rYou goes to de bank:");
				bank(player);
				action='\0';
				break;
			case 'V':
				textcolor(MAGENTA);      /*vinnie process*/
				if(player->city)         /*you have to be in Rockville*/
				{
					cprintf("See Vinnie\n\rVinnie be in %s!!!"
							"\n\r",city_name[0]);
					if(noise) beep(bad_news);
				}
				else vinnie(player);     /*to go see vinnie*/
				update(player);
				if((!player->debt)&&(noise)) beep(good_news);
				action='\0';
				break;
			case 'T':
				textcolor(MAGENTA);     /*transfer process*/
				if(player->city)         /*you have to be in Rockville*/
				{
					cprintf("Transfer dope\n\rYo stash be in "
							"%s!!!\n\r",city_name[0]);
					if(noise) beep(bad_news);
				}
				else transfer(player);   /*to go to your stash*/
				action='\0';
		}
	}                                       /*when the player jets to*/
	player->last_city=player->city;         /*another city, note it*/
	(player->days_used)++;                  /*one day passes*/
	if(player->debt) player->days_left--;   /*one less day to pay the debt*/
	player->debt+=(player->debt/10);        /*add interest to debt*/
	player->bank+=(player->bank/10);        /*and to bank account*/
	if(player->health<100) player->health++;/*heal one health point*/
	if(!((player->days_used)%30))           /*if it's time to pay bills*/
	{
		textcolor(GREEN);
		cprintf("\n\rTime to pay de bills!");/*print it*/
		if(player->bank >= 3000)           /*pay it*/
		{
			player->bank-=3000;           /*from the bank*/
			cprintf("\n\rYou writes a check.");
		}                                  /*or from bank and cash*/
		else if (player->cash >= (3000-(player->bank)))
		{
			if(player->bank) cprintf("\n\rYou writes a check\n\r"
								"and gets a money order.");
									/*or from cash only*/
			else cprintf("\n\rYou pays dem out yo pockets.");
			player->cash-=(3000-(player->bank));
			player->bank=0;
		}
		else                               /*if he can't afford it*/
		{
			if(!(player->debt)) player->days_left=30;
			player->cash+=player->bank;   /*borrow from vinnie*/
			player->debt+=(5000-(player->cash));
			player->bank=0;
			player->cash=2000;
			cprintf("\n\rYou has to borrow mo\n\rmoney from Vinnie!");
			if(noise) beep(bad_news);
		}
	}
	if(!(player->days_used%365))            /*if it's been a full year*/
	{                                       /*or more than one year*/
		textcolor(CYAN + BLINK);           /*print the number of years*/
		cprintf("\n\rHappy Anniversamary!");
		if((player->days_used/365)>1)      /*he's been selling dope*/
			cprintf("\n\rYou has been selling\n\rdope fo %d years!",
					(int)(player->days_used/365));
		else cprintf("\n\rYou has been selling\n\rdope fo a year!");
		if((player->days_used/365)>19)     /*if he's been selling dope*/
			retired();                    /*twenty years, he retires*/
		else
		{
			cprintf("\n\rYo friends gives you some\n\r%s fo luck!",
						drug_name[player->danger/100]);
			player->coat[player->danger/100]+=player->days_used/73;
			player->total+=player->days_used/73;
			player->pockets-=player->days_used/73;
		}
	}
	randomize_price(player);                /*redetermine dope prices*/
	update(player);                         /*update the screen*/
	encounter(player);                      /*check for encounters*/
}

void encounter(struct data * modify)
{ /*encounter routine*/
	int event,number;
	unsigned long price;
	char util=0;

	event=dice(1,20,0);                /*10% chance of being mugged*/
	number=(5-dice(1,6,-1));
	if((event>18)&&(modify->cash>5000))/*only if he has over $5000*/
	{
		textcolor(GREEN);
		cprintf("\n\rYou was mugged in de streets!!!");
		modify->cash/=2;              /*take half his money*/
		update(modify);               /*update the screen*/
		if(noise) beep(bad_news);
	}
	event=dice(1,20,0);                /*10% chance of high price*/
	number=(5-dice(1,6,-1));
	if((event>18)||(modify->cost[number]==1))/*if low cost, default here*/
	{
		textcolor(RED);
		switch(number)
		{
			  case 0:
				   cprintf("\n\rCops raided the mayor's office!"
						   "\n\rCoke is primo now!");
				   break;
			  case 1:
				   cprintf("\n\rAddicts are paying outrageous"
						   "\n\rprices for heroin!");
				   break;
			  case 2:
				   cprintf("\n\rLabs was raided all over town!"
						   "\n\rDust is scarce!");
				   break;
			  case 3:
				   cprintf("\n\rThe mob is squeezing LSD labs!");
				   break;
			  case 4:
				   cprintf("\n\rWeed supplies are drying up!");
				   break;
			  case 5:
				   cprintf("\n\rCrackheads is paying through"
						   "\n\rthe nose for smoke!");
		}
		modify->cost[number]*=(dice(1,20,0));/*multiply by 1 to 20*/
		update(modify);
		if((noise)&&((modify->coat[number])||
			((modify->stash[number])&&(!modify->city)))) beep(good_news);
		else if(noise) beep(bad_news);
	}                                /*10% chance of low price*/
	else                             /*if high cost default here*/
	if((event>16)||(modify->cost[number]>3000000000L))
	{
		number=5-number;            /*reverse order of numbers*/
		textcolor(RED);
		switch(number)
		{
			  case 0:
				   cprintf("\n\rJamaican posse raided the DEA!"
						   "\n\rCoke is everywhere!");
				   break;
			  case 1:
				   cprintf("\n\rPigs are selling cheap heroin"
						   "\n\rfrom a raid!");
				   break;
			  case 2:
				   cprintf("\n\rThe lab made too much dust!"
						   "\n\rThey is selling it cheap!");
				   break;
			  case 3:
				   cprintf("\n\rThe Grateful Dead are playing"
						   "\n\rat RFK!");
				   break;
			  case 4:
				   cprintf("\n\rColumbian freighter dusted"
						   "\n\rthe Coast Guard!  Weed prices"
						   "\n\rhave bottomed out!");
				   break;
			  case 5:
				   cprintf("\n\rRival dope dealers is"
						   "\n\rundercutting the rock market!");
        }
		modify->cost[number]/=(dice(1,20,0));/*divide by 1 to 20*/
		while (modify->cost[number]<1) modify->cost[number]++;/*no zeros*/
		update(modify);                      /*update the screen*/
		if((noise)&&((modify->pockets)&&
			((modify->cash+modify->bank)>modify->cost[number])))
					beep(good_news);
		else if(noise) beep(bad_news);
	}
	event=dice(1,20,0);
	number=dice(1,6,-1);
	if(event>18)                              /*straight ten percent*/
	{                                         /*chance of gun offer*/
		util=0;
		price=dice(1,250,250);
		textcolor(CYAN);
		if (modify->cash>=price)
		{
			cprintf("\n\rWould you like to buy"
					"\n\ra%s fo $%lu?",gun_name[number-1],price);
			while ((util != 'Y')&&(util != 'N')) util=(toupper(getch()));
			if (util=='Y')                        /*if you can afford it*/
			{                                     /*and you want it*/
				modify->guns++;
				modify->pockets-=5;
				modify->cash-=price;
				cprintf(" Word up!");
				if(noise) beep(good_news);
			}
			else cprintf(" Fuck you!");           /*if you don't want it*/
			if(noise) beep(victory);
			update(modify);                       /*update the screen*/
		}
	}
	event=dice(1,20,0);                               /*straight 10% chance*/
	if(event>18)                                      /*of a pocket sale*/
	{
		util=0;
		price=dice(1,150,100);
		textcolor(MAGENTA);
		if(modify->cash>=price)
		{
			cprintf("\n\rGeorgetown Leather Design"      /*same idea as guns*/
				"\n\rhas a sale! Mo pockets\n\rfo $%lu?",price);
			while ((util != 'Y')&&(util != 'N')) util=(toupper(getch()));
			if (util=='Y')
			{
				modify->pockets+=10;
				modify->cash-=price;
				cprintf(" Word up!");
				if(noise) beep(good_news);
			}
			else cprintf(" Fuck you!");
			if(noise) beep(victory);
			update(modify);
		}
	}
	event=dice(1,20,0);                               /*5% chance of dope*/
	number=(dice(1,6,-1));                            /*on a dead dude*/
	if(event>19)
	{
		util=dice(1,10,0);
		textcolor(GREEN);
		if(modify->coat[number]) cprintf("\n\rYou cut yo stash of %s!"
										 "\n\rYou gots %d more!",
										 drug_name[number],(int)util);
		else cprintf("\n\rYou find %d %s on"
					 "\n\ra dead dude in de alley!",
					 (int)util,drug_name[number]);
		modify->coat[number]+=util;
		modify->total+=util;
		modify->pockets-=util;
		update(modify);                             /*update the screen*/
		if(noise) beep(good_news);
	}
	event=dice(1,20,0);      /*5% chance if you have > 100 dope in your*/
	number=(5-dice(1,6,-1)); /*stash that some dork will raid it*/
	if((event>19)&&((modify->stash[0]+modify->stash[1]+modify->stash[2]
				 +modify->stash[3]+modify->stash[4]+modify->stash[5])
				 > 100)&&(modify->city))
	{
		textcolor(MAGENTA);
		cprintf("\n\rYo stash has got raided!");
		util=6;
		while(util--)
		{
			modify->stash[util]/=2;/*cut all the dope in half*/
		}
		update(modify);               /*update the screen*/
		if(noise) beep(bad_news);
	}
	event=dice(1,20,0);                /*5% chance if you have*/
	if((event>19)&&(modify->guns))     /*guns that somebody will steal one*/
	{
		textcolor(RED);
		cprintf("\n\rOne of yo guns has got stolen!");
		modify->guns--;
		modify->pockets+=5;
		update(modify);
		if(noise) beep(bad_news);
	}
	event=dice(1,100,0);/*if you have a lot of money, 1% chance of robbery*/
	if(((event>99)&&((modify->cash>1000000L)||(modify->bank>1000000L)))
		||(modify->bank>4000000000L))/*automatic if approaching overflow*/
	{
		textcolor(GREEN);
		cprintf("\n\rDe bank been robbed!");
		modify->bank/=2;              /*cut it in half*/
		update(modify);
		if(noise) beep(bad_news);
	}
	event=dice(1,20,0);               /*10% chance of being chased*/
	number=(dice(1,6,-1));            /*by police dogs, 17% chance*/
	if(event>18)                      /*of dropping any dope you may have*/
	{
		textcolor(YELLOW);
		cprintf("\n\rPolice dogs chase you\n\rfo %d blocks!",dice(1,10,0));
		if (modify->coat[number]) cprintf("\n\rYou dropped some dope!");
		modify->pockets+=modify->coat[number];
		modify->total-=modify->coat[number];
		modify->coat[number]=0;
		update(modify);
		if(noise) beep(bad_news);
	}
	event=dice(1,100,0);
	number=dice(1,10,0);
	if((modify->debt)&&((event>99)||(modify->debt>4000000000L)))
	{
		textcolor(MAGENTA);
		cprintf("\n\rVinnie's bookkeeper fucked up!");
		modify->debt/=number;
		update(modify);
		if(noise) beep(good_news);
	}
	event=dice(1,20,0);
	if(event>19)
	{
		textcolor(LIGHTBLUE);
		cprintf("\n\rYou ripped yo coat!");
		modify->pockets-=10;
		update(modify);
		if(noise) beep(bad_news);
	}
}

void buy (struct data * check)
{  /*buy routine*/
	char action='\0',string[11]="xxxxxxxxxx";
	unsigned long how_much;
	int drug;

	if(noise) beep(deal);
	textcolor(LIGHTMAGENTA);
	cprintf("\n\r1");
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('C');
	textcolor(MAGENTA);
	cprintf("oke ");
	textcolor(LIGHTMAGENTA);
	putch('2');
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('S');
	textcolor(MAGENTA);
	cprintf("mack ");
	textcolor(LIGHTMAGENTA);
	putch('3');
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('D');
	textcolor(MAGENTA);
	cprintf("ust\n\r");
	textcolor(LIGHTMAGENTA);
	putch('4');
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('A');
	textcolor(MAGENTA);
	cprintf("cid ");
	textcolor(LIGHTMAGENTA);
	putch('5');
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('H');
	textcolor(MAGENTA);
	cprintf("erb  ");
	textcolor(LIGHTMAGENTA);
	putch('6');
	textcolor(MAGENTA);
	putch('-');
	textcolor(LIGHTMAGENTA);
	putch('R');
	textcolor(MAGENTA);
	cprintf("ock");
	cprintf("\n\rYo, man, what you need? ");/*print the menu*/
	while ((action<'1')||(action>'6'))
	{ /*get a response*/
		action=getch();
		if(toupper(action)=='C') action='1'; /*convert a letter*/
		if(toupper(action)=='S') action='2'; /*to the appropriate number*/
		if(toupper(action)=='D') action='3';
		if(toupper(action)=='A') action='4';
		if(toupper(action)=='H') action='5';
		if(toupper(action)=='R') action='6';
	}
	drug=(action-'1');                        /*convert character to digit*/
	cprintf("  %s",drug_name[drug]);          /*print your choice*/
	if (check->cash < check->cost[drug])
	{                                         /*see if you can afford it*/
		cprintf("\n\rYou can't afford no %s!",drug_name[drug]);
		if(noise) beep(bad_news);
	}
	else
	{
		cprintf("\n\rYou can afford %u \n\r" /*how much you can afford*/
				"and you can carry %u.",   /*how much you can hold*/
			(unsigned)((check->cash)/(check->cost[drug])),check->pockets);
		cprintf("\n\rHow much you want, homey:");
		getit(string);                       /*how much you want*/
		if(!(strcmp(string,".")))
		{
			if((check->cash/check->cost[drug])<= check->pockets)
			{
			how_much=((check->cash)/(check->cost[drug]));
			}
			else how_much=check->pockets;
			cprintf("\bAll(%u)",how_much);
		}
		else how_much=str2uns(string);            /*convert a string*/
		if (check->pockets < how_much)
		{                                    /*validate*/
			cprintf("\n\rYou can't carry all that!");
		}
		else
		{
			if (check->cash < check->cost[drug]*how_much)
			{
				cprintf("\n\rWhat you take me fo?\n\r"
						"You can't afford that!");
				if(noise) beep(bad_news);
			}
			else
			{                              /*add it in*/
				check->last_cost=(check->cost[drug]*how_much);
				check->cash-=check->last_cost;
				check->last_volume=(unsigned)how_much;
				check->coat[drug]+=check->last_volume;
				check->pockets-=(unsigned)how_much;
				check->total+=(unsigned)how_much;
			}
		}
	}
}

void sell (struct data * check)
{ /*sell routine--a lot like the buy routine*/
	char action='\0',string[11]="xxxxxxxxxx";
	unsigned int how_much;
	int drug;

	if(noise) beep(deal);
	textcolor(LIGHTRED);
	cprintf("\n\r1");
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('C');
	textcolor(RED);
	cprintf("oke ");
	textcolor(LIGHTRED);
	putch('2');
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('S');
	textcolor(RED);
	cprintf("mack ");
	textcolor(LIGHTRED);
	putch('3');
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('D');
	textcolor(RED);
	cprintf("ust\n\r");
	textcolor(LIGHTRED);
	putch('4');
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('A');
	textcolor(RED);
	cprintf("cid ");
	textcolor(LIGHTRED);
	putch('5');
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('H');
	textcolor(RED);
	cprintf("erb  ");
	textcolor(LIGHTRED);
	putch('6');
	textcolor(RED);
	putch('-');
	textcolor(LIGHTRED);
	putch('R');
	textcolor(RED);
	cprintf("ock");
	cprintf("\n\rYo, man, what you got? ");
	while ((action<'1')||(action>'6'))
	{
		action=getch();
		if(toupper(action)=='C') action='1';
		if(toupper(action)=='S') action='2';
		if(toupper(action)=='D') action='3';
		if(toupper(action)=='A') action='4';
		if(toupper(action)=='H') action='5';
		if(toupper(action)=='R') action='6';
	}
	drug=(action-'1');
	cprintf("  %s",drug_name[drug]); /*check how much you have*/
	if (check->coat[drug] == 0)      /*instead of how much you want*/
	{
		cprintf("\n\rYou ain't got no %s!",drug_name[drug]);
		if(noise) beep(bad_news);
	}
	else
	{                                /*print it for reference*/
		cprintf("\n\rYou gots %u %s.",check->coat[drug],drug_name[drug]);
		cprintf("\n\rHow much you selling, homey:");
		getit(string);              /*get an amount*/
		if (!(strcmp(string,".")))
		{
			cprintf("\bAll");
			how_much=check->coat[drug];
		}
		else how_much=str2uns(string);   /*convert it*/
		if (check->coat[drug] < how_much)
		{                           /*and validate*/
			cprintf("\n\rYo, man, you takin' me fo a fool?");
			if(noise) beep(bad_news);
		}
		else
		{                           /*update the info*/
			check->cash+=(check->cost[drug]*how_much);
			check->last_cost=(check->cost[drug]*how_much);
			check->coat[drug]-=check->last_volume=how_much;
			check->pockets+=how_much;
			check->total-=how_much;

		}
	}
}

void jet (struct data * check)
{/*jet routine*/
	char action='\0';
	int x,y;

	check->last_city=check->city;/*move this city to last city*/
	textcolor(LIGHTCYAN);
	cprintf("\n\r1");
	textcolor(CYAN);
	putch('-');
	textcolor(LIGHTCYAN);
	putch('R');
	textcolor(CYAN);
	cprintf("ockville ");
	textcolor(LIGHTCYAN);
	putch('2');
	textcolor(CYAN);
	putch('-');
	textcolor(LIGHTCYAN);
	putch('N');
	textcolor(CYAN);
	cprintf("orthwest\n\r");
	textcolor(LIGHTCYAN);
	putch('3');
	textcolor(CYAN);
	putch('-');
	textcolor(LIGHTCYAN);
	putch('S');
	textcolor(CYAN);
	cprintf("outheast ");
	textcolor(LIGHTCYAN);
	putch('4');
	textcolor(CYAN);
	putch('-');
	textcolor(LIGHTCYAN);
	putch('A');
	textcolor(CYAN);
	cprintf("rlington\n\r");
	textcolor(LIGHTCYAN);
	putch('5');
	textcolor(CYAN);
	cprintf("-The ");
	textcolor(LIGHTCYAN);
	putch('M');
	textcolor(CYAN);
	cprintf("all  ");
	textcolor(LIGHTCYAN);
	putch('6');
	textcolor(CYAN);
	cprintf("-A");
	textcolor(LIGHTCYAN);
	putch('l');
	textcolor(CYAN);
	cprintf("exandria");
	cprintf("\n\rWhere you be going?  ");
	while ((action<'1')||(action>'6'))                 /*get destination*/
	{
		action=getch();
		if(toupper(action)=='R') action='1';
		if(toupper(action)=='N') action='2';
		if(toupper(action)=='S') action='3';
		if(toupper(action)=='A') action='4';
		if(toupper(action)=='M') action='5';
		if(toupper(action)=='L') action='6';
	}
	cprintf("%s",city_name[action-'1']);              /*validate it*/
	if(check->city==(action-'1')) cprintf("\n\rYou is already there!!!");
	else
	{
		x=wherex();
		y=wherey();
		window(1,1,80,25);
		gotoxy(18,7);
		textcolor(LIGHTCYAN+BLINK);
		if(check->cash>=3) cprintf("%-11s","   METRO   ");
		else cprintf("%-11s","HITCHHIKING");
		window(42,12,75,21);
		gotoxy(x,y);
		textcolor(CYAN);
		if(check->cash>=3)
		{
			cprintf("\n\rYou hops on de metro.");
			check->cash-=3;
		}
		else
		{
			cprintf("\n\rI bet you wish you coulds afford"
				   "\n\rde metro rail!!!");
			do
			{
				sleep(1);
				if((x=dice(1,10,0))==10)
				{
					cprintf("\n\n\rHere come somebody!"
						   "\n\rHey! It be %s!",homey[dice(1,6,-1)]);
					if(dice(1,6,0)>5)
						cprintf("\n\rHe gives you a ride!");
					else
					{
						cprintf("\n\rDe cocksucker don't stop!");
						x=0;
					}
				}
			}
			while (x<10);
			cprintf("\n\rYou gets in de car!!!");
			sleep(2);
			x=wherex();
			y=wherey();
			window(1,1,80,25);
			gotoxy(18,7);
			textcolor(LIGHTCYAN+BLINK);
			cprintf("%-11s"," IN DE CAR ");
			window(42,12,75,21);
			gotoxy(x,y);
			textcolor(CYAN);
		}
		if(noise) beep(move);                        /*play a tune*/
		check->city=(action-'1');                    /*update it*/
	}
}



void transfer (struct data * check)
{ /*transfer routine for stash*/
	unsigned amount;
	int counter;
	char action='\0',string[11]="xxxxxxxxxx";
	int drug;
	    /*put all the dope in the stash*/
	cprintf("Transfer dope\n\rYou puts yo dope in de stash.");
	for(counter=0;counter<6;++counter)
	{
		check->stash[counter]+=check->coat[counter];
		check->coat[counter]=0;
	}
	check->pockets+=check->total;
	check->total=0;
	if(noise)
	{
		beep(home);
		textcolor(LIGHTBLUE);
		cprintf("\n\rYo, man, you gots to get"
			   "\n\ra new stereo!  That thing"
			   "\n\rsounds like shit!!!");
	}
	do
	{
		action='X';
		update(check);
		strcpy(string,"xxxxxxxxxx");
		textcolor(LIGHTMAGENTA);
		cprintf("\n\r1");
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('C');
		textcolor(MAGENTA);
		cprintf("oke ");
		textcolor(LIGHTMAGENTA);
		putch('2');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('S');
		textcolor(MAGENTA);
		cprintf("mack ");
		textcolor(LIGHTMAGENTA);
		putch('3');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('D');
		textcolor(MAGENTA);
		cprintf("ust\n\r");
		textcolor(LIGHTMAGENTA);
		putch('4');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('A');
		textcolor(MAGENTA);
		cprintf("cid ");
		textcolor(LIGHTMAGENTA);
		putch('5');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('H');
		textcolor(MAGENTA);
		cprintf("erb  ");
		textcolor(LIGHTMAGENTA);
		putch('6');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('R');
		textcolor(MAGENTA);
		cprintf("ock ");
		textcolor(LIGHTMAGENTA);
		putch('Q');
		textcolor(MAGENTA);
		putch('-');
		textcolor(LIGHTMAGENTA);
		putch('L');
		textcolor(MAGENTA);
		cprintf("eave");
		cprintf("\n\rWhat you gettin' out?:");
		while (((action<'1')||(action>'6'))&&(toupper(action)!='Q'))
		{
			action=getch();                   /*get a response*/
			if(toupper(action)=='C') action='1';
			if(toupper(action)=='S') action='2'; /*convert it*/
			if(toupper(action)=='D') action='3';
			if(toupper(action)=='A') action='4';
			if(toupper(action)=='H') action='5';
			if(toupper(action)=='R') action='6';
			if(toupper(action)=='L') action='Q';
			if((action<='6')&&(action>='1'))
			{
				drug=(action-'1');
				cprintf("  %s",drug_name[drug]);
				if (check->stash[drug] == 0) /*validate it*/
				{
					cprintf("\n\rYou ain't gots no %s!!!"
						,drug_name[drug]);
					if(noise) beep(bad_news);
				}
				else
				{
					cprintf("\n\rYou gots %u %s.",check->stash[drug],
							drug_name[drug]);
					cprintf("\n\rHow much %s is you taking:",
							drug_name[drug]);
					getit(string);                 /*get amount*/
					if(!(strcmp(string,".")))
					{
						cprintf("\bAll");
						amount=check->stash[drug];
					}
					else amount=str2uns(string);  /*convert amount*/
					if(amount>check->stash[drug])  /*validate*/
					{
						cprintf("\n\rYou ain't gots that much %s!",
								drug_name[drug]);
						if(noise) beep(bad_news);
					}
					else
					{                             /*update info*/
						check->coat[drug]+=amount;
						check->total+=amount;
						check->stash[drug]-=amount;
						check->pockets-=amount;
					}
				}
			}
		}
	}
	while(toupper(action)!='Q');
	cprintf("  Nothing");
}

void bank (struct data * check)
{ /*bank routine*/
	char string[11]="xxxxxxxxxx";
	unsigned long deposit;

	if(noise) beep(money);
	cprintf("\n\rHow much to deposit:");
	getit(string); /*get a string*/
	if (!(strcmp(string,".")))
	{
		cprintf("\bAll");
		deposit=check->cash;
	}
	else deposit=str2unl(string);   /*convert it*/
	strcpy(string,"xxxxxxxxxx");
	if (check->cash >= deposit)
	{                      /*validate it*/
		check->cash-=deposit;
		check->bank+=deposit;
	}
	else
	{
		cprintf("Let us know when you have it.");
		if(noise) beep(bad_news);
	}
	update(check);
	textcolor(GREEN);
	cprintf("\n\rHow much to withdraw:");
	getit(string);        /*get another string*/
	if (!(strcmp(string,".")))
	{
		cprintf("\bAll");
		deposit=check->bank;
	}
	else deposit=str2unl(string); /*convert it*/
	if(check->bank >= deposit)/*validate it*/
	{
		check->cash+=deposit;
		check->bank-=deposit;
		cprintf("\n\rNice doing business with you!");
	}
	else
	{
		cprintf("I'm sorry, but that would"
			   "\n\rbe a substantial overdraft.");
		if(noise) beep(bad_news);
	}
}

void vinnie (struct data * check)
{ /*a one-way bank*/
	char string[11]="xxxxxxxxxx";
	unsigned long payment;

	if (check->debt)
	{
		cprintf("See Vinnie\n\rYou goes to de Eye-talian"
				"\n\rrestamaraunt.");
		cprintf("\n\rVinnie be sittin' here giving you de evil eye.");
		if(noise) beep(restaurant);
		cprintf("\n\rHow much you pays him:");
		getit(string);           /*get*/
		if(!(strcmp(string,".")))
		{
			cprintf("\bAll");
			if(check->cash<check->debt) payment=check->cash;
			else payment=check->debt; /*check*/
		}
		else payment=str2unl(string); /*convert*/
		if(check->cash < payment)/*validate*/
		{
			cprintf("\n\rYou ain't gots the money!\n\rHe smacks you!");
			check->health-=5;
			if(noise) beep(bad_news);
		}
		else
		{
			if (check->debt < payment)
			{
				cprintf("\n\rVinnie smiles and accepts yo"
					"\n\rgracious bonus.");
				check->debt=payment;
				if(noise) beep(bad_news);
			}
			check->debt-=payment;
			check->cash-=payment;
		}
	}
	else
	{
		cprintf("See Vinnie\n\rYou goes to de Eye-talian"
					"\n\rrestamaraunt.");
		cprintf("\n\rVinnie be sittin' here giving you de big grin.");
		if(noise) beep(restaurant);
		cprintf("\n\rHow much you borrows:");
		getit(string);
		if(!(strcmp(string,".")))
		{
			cprintf("\bNothing");
			payment=0;
		}
		else payment=str2unl(string); /*get*/
		check->debt+=payment;    /*convert*/
		check->cash+=payment;    /*validate*/
		check->days_left=30;     /*set days to pay debt*/
	}
}

void game_functions (struct data * check)
{
	char action='\0';

	textcolor(YELLOW);
	cprintf("FunXions");
	textcolor(WHITE);
	cprintf("\n\rS");
	textcolor(YELLOW);
	cprintf("ave game  ");
	textcolor(WHITE);
	putch('R');
	textcolor(YELLOW);
	cprintf("estore game\n\r");
	textcolor(WHITE);
	putch('N');
	textcolor(YELLOW);
	cprintf("ew game   ");
	textcolor(WHITE);
	putch('Q');
	textcolor(YELLOW);
	cprintf("uit game\n\r");
	textcolor(WHITE);
	putch('M');
	textcolor(YELLOW);
	cprintf("usic ");
	if(noise) cprintf("off  ");
	else cprintf("on   ");
	textcolor(WHITE);
	putch('D');
	textcolor(YELLOW);
	cprintf("OS shell\n\r");
	textcolor(WHITE);
	putch('C');
	textcolor(YELLOW);
    cprintf("heat      ");
    textcolor(WHITE);
    putch('H');
    textcolor(YELLOW);
    cprintf("elp");
	cprintf("\n\rYour choice:");
	while((action!='S')&&(action!='R')&&(action!='N')&&(action!='C')
            &&(action!='Q')&&(action!='M')&&(action!='D')&&(action!='H'))
		action=(toupper(getch()));
	switch(action)
	{
		case 'S':
			textcolor(GREEN);
			cprintf("Save");
            textcolor(LIGHTRED + BLINK);
            cprintf("\n\rNot on de sysop disk\n\ryou doesn't!!!");
			update(check);
			break;
		case 'R':
			textcolor(RED);
			cprintf("Restore");
            textcolor(LIGHTRED + BLINK);
            cprintf("\n\rNot de sysop's game\n\r you doesn't!!!");
			update(check);
			break;
		case 'M':
			textcolor(LIGHTCYAN);
			cprintf("Music ");
			if(noise)
			{
				cprintf("off");
				noise=0;
			}
			else
			{
				cprintf("on");
				noise=1;
			}
			break;
		case 'N':
			textcolor(MAGENTA);
			cprintf("New game");
			initialize_game(check);
			check->city=0;
			check->days_used=1;
			check->days_left=30;
			check->debt=5000;
			check->last_city=0;
			randomize_price(check);
			update(check);
			encounter(check);
			break;
		case 'D':
            textcolor(LIGHTRED + BLINK);
            cprintf("\n\rNot on de sysop computer\n\ryou doesn't!!!");
            break;
        case 'C':
            textcolor(LIGHTRED + BLINK);
            cprintf("\n\rIf you wants to cheat download de\n\rgot-damn game yoself!!!");
            break;
        case 'H':
            online_help();
            break;
        case 'Q':
			textcolor(LIGHTRED);
			cprintf("Quit");
			textcolor(LIGHTRED + BLINK);
			cprintf("\n\rPress any key...");
			textcolor(RED);
            bioskey(0);
			cprintf("Later!");
			window(1,1,80,25);
			clrscr();
			cleanup();
			exit(1);
	}
	textcolor(CYAN);
	cprintf("\n\rSo what next, G?  ");
}

void save_game (struct data * game)
{
	char string[13]="111111111111";
	FILE *saved_game;

	cprintf("\n\rFile name:");
	getit(string);
	if(string[0]==NULL) strcpy(string,def_file);
	else str2fil(string);
	cprintf("\n\rUsing %s",string);
	if ((saved_game=fopen(string,"wb"))!=NULL)
	{
		fwrite(game,sizeof(*game),1,saved_game);
		fclose(saved_game);
		cprintf("\n\rGame saved.");
	}
	else cprintf("\n\rError opening %s.",string);
}

void restore_game (struct data * game)
{
	char string[13]="111111111111" ;
	FILE *saved_game;

	cprintf("\n\rFile name:");
	getit(string);
	if(string[0]==NULL) strcpy(string,def_file);
	else str2fil(string);
	clrscr();
	cprintf("Restoring %s",string);
	if ((saved_game=fopen(string,"rb"))!=NULL)
	{
		fread(game,sizeof(*game),1,saved_game);
		fclose(saved_game);
		cprintf("\n\rGame restored.");
	}
	else cprintf("\n\rError opening %s.",string);
}

void the_cops (struct data * player)
{/*cop routine*/
	int cops,random;
	char util=0;

	if((player->last_cost >= 1000000L)/*if you bought or sold $1,000,000*/
		||(player->last_volume >= 100)/*if you bought or sold over 100*/
		||(player->cash >= 10000000L)/*if you have $10,000,000 on you*/
		||(player->total >= 1000))   /*or if you have over 1000 on you*/
	{                                /*you meet the cops*/
		textcolor(RED);
		cprintf("\n\rDe cops! Oh shit!");/*# of cops depends on PE number*/
		if(noise) beep(siren);
		cops=(dice(1,(((501-(int)player->danger)/10)+1),1));
		while((cops)&&(player->health)&&(player->health<=100))
		{
			update(player);             /*update screen*/
			textcolor(RED);        /*print how many*/
			cprintf("\n\rThey is %d of 'em!",cops);
			cprintf("\n\rDoes you fight?");
			do                    /*ask if you fight and get a response*/
			{
				util=(toupper(getch()));
			}
			while((util!='Y')&&(util!='N'));
			if((util=='N')&&(player->guns))/*if you say no*/
			{        /*if you have guns, they shoot*/
				cprintf(" No");
				cprintf("\n\rThey sees yo guns!");
				cprintf("\n\rThey shoots at you!");
				if(noise) beep(shot);
				if((random=(dice(1,cops+player->guns,0))) > player->guns)
				{
					cprintf("\n\rThey hits you!");
					player->health-=cops;
					update(player);
					textcolor(RED);
				}
				else cprintf("\n\rThey missed you!");
				random=dice(1,6,0);
				if(random<6)
				{                        /*see if you get away*/
					cprintf("\n\rYou tries to run but you"
							"\n\rcan't lose them!!!");
					if((random=dice(1,6,0))>5)
					{
						cops=0;
						cprintf("\n\rYou has been caught!"
							   "\n\rYou goes to jail fo");
						random=dice(1,10,0);
						cprintf("\n\r%d years!!!",random);
						player->days_used+=(random*365);
						player->guns=0;
						player->bank=0;
						player->danger+=random;
						if(player->danger>500) player->danger=500;
						player->pockets+=player->total;
						player->total=0;
						for(random=0;random<6;random++)
							player->coat[random]=0;
						if(player->debt)
							cprintf("\n\rVinnie be nice and"
								   "\n\rdon't charge you no"
								   "\n\rinterest while you is"
								   "\n\rlocked up.");
						if(noise) beep(bad_news);
						if(player->days_used/365>=20)
						{
							window(1,1,80,25);
							clrscr();
							textcolor(LIGHTBLUE);
							cprintf("\n\rBy de time you gets out "
								   "you is far too old to be"
								   " doing this shit.\n\r"
								   "You decides to retire "
								   "and be legal fo de rest of "
								   "yo life.");
							if(noise) beep(start);
							cleanup();
							exit(1);
						}
					}
					util='X';
				}
				else
				{                        /*1 in 6 chance*/
					cprintf("\n\rYou gots away!");
					cops=0;
				}
			}                            /*if no guns, they don't shoot*/
			if((util=='N')&&((random=dice(1,6,0))<6)&&(!player->guns))
			{                            /*see if you escape*/
				cprintf(" No");
				cprintf("\n\rYou tries to run but you"
						"\n\rcan't lose them!!!");
				if((random=dice(1,6,0))>5)
				{
					cops=0;
					cprintf("\n\rYou has been caught!"
						   "\n\rYou goes to jail fo");
					random=dice(1,10,0);
					cprintf("\n\r%d years!!!",random);
					player->days_used+=(random*365);
					player->guns=0;
					player->pockets+=player->total;
					player->total=0;
					player->bank=0;
					player->danger+=random;
					if(player->danger>500) player->danger=500;
					for(random=0;random<6;random++)
						player->coat[random]=0;
					if(player->debt)
						cprintf("\n\rVinnie be nice and"
							   "\n\rdon't charge you no"
							   "\n\rinterest while you is"
							   "\n\rlocked up.");
					if(noise) beep(bad_news);
				}
				util='X';
			}
			else if((util=='N')&&(!player->guns))
			{
				cprintf(" No");
				cprintf("\n\rYou gots away!");
				cops=0;
			}
			else if((util=='Y')&&(player->guns==0))
			{         /*if you have no guns, you can't shoot them*/
				cprintf(" Yes");
				cprintf("\n\rYou gots no guns!");  /*but they can*/
				if(noise) beep(bad_news);
				cprintf("\n\rThey shoots at you!");/*shoot at you*/
				if(noise) beep(shot);
				if((random=(dice(1,cops+player->guns,0))) > player->guns)
				{
					cprintf("\n\rThey hits you!");
					player->health-=cops;
					update(player);
					textcolor(RED);
				}
				else cprintf("\n\rThey missed you!");
			}
			else if(util=='Y')
			{/*of course you can kill someone on full autofire*/
				cprintf(" Yes");
				cprintf("\n\rYou shoots at them!");
				if(noise) beep(shot);
				if((random=(dice(1,player->guns+cops,0)))
					> cops)
				{
					cprintf("\n\rYou kills one!");
					cops--;
					player->danger--;
					if(!player->danger) player->danger=1;
				}  /*if you can hit them*/
				else cprintf("\n\rYou missed!");
				if(cops)
				{
					cprintf("\n\rThey shoots at you!");
					if(noise) beep(shot);
					if((random=(dice(1,cops+player->guns,0)))
								> player->guns)
					{
						cprintf("\n\rThey hits you!");
						player->health-=cops+1;
						update(player);
						textcolor(RED);
					}
					else cprintf("\n\rThey missed you!");
				}
				else
				{    /*if you kill them all*/
					cprintf("\n\rYou waxed them, homey!");
					textcolor(LIGHTRED + BLINK);
					cprintf("\n\rYou is public enemy number %u!"
							,player->danger);
					if(noise) beep(victory);
				}
			}
		} /*if you died, call the killed routine*/
		if((!player->health)||(player->health>100)) killed(player);
		player->last_cost=player->last_volume=0;/*reset counters*/
		update(player);                       /*update screen*/
	}
}

int dice (int num, int sides, int bonus)
{/*dice roller based on the "(num)D(sides)+(bonus)" standard of RPG's*/
	float roll;              /*random number*/
	int total=0;             /*total of all rolls*/

	while (num>0)            /*while there are dice*/
	{                        /*roll one*/
		roll=((float)rand()/RAND_MAX+1.0)*sides/2.0+1.0;
		total+=((int)roll); /*add it to the total*/
		num--;              /*set that die aside*/
	}                        /*when you run out of dice,*/
	total+=bonus;            /*add the bonus(which could be negative)*/
	return total;            /*and return the result*/
}

void build (struct data * check)
{/*build screen routine*/
	unsigned x;
	int line=4;

	textmode(C80);
	clrscr();
/*Line 1*/
	gotoxy(5,line++);
	textcolor(GREEN);
	putch(DTLC);
	for(x=0;x<35;x++) putch(DHOR);
	putch(DTDN);
	for(x=0;x<34;x++) putch(DHOR);
	putch(DTRC);
/*Line 2*/
	gotoxy(5,line++);
	putch(DVER);
	textcolor(CYAN);
	cprintf("  Day %-5u You gots %2u days left  ",
			check->days_used,check->days_left);
	textcolor(GREEN);
	putch(SVER);
	textcolor(RED);
	cprintf("Coke:$%-10lu Smack:$%-10lu",check->cost[0],check->cost[1]);
	textcolor(GREEN);
	putch(DVER);
/*Line 3*/
	gotoxy(5,line++);
	putch(DTRT);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STDN);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STDN);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STLT);
	textcolor(RED);
	cprintf("Dust:$%-10lu  Acid:$%-10lu",check->cost[2],check->cost[3]);
	textcolor(GREEN);
	putch(DVER);
/*Line 4*/
	gotoxy(5,line++);
	putch(DVER);
	textcolor(MAGENTA);
	cputs("  Yo Stash ");
	textcolor(GREEN);
	putch(SVER);
	textcolor(LIGHTGREEN);
	cprintf("%-11s",city_name[check->city]);
	textcolor(GREEN);
	putch(SVER);
	textcolor(CYAN);
	cputs("  Yo Coat  ");
	textcolor(GREEN);
	putch(SVER);
	textcolor(RED);
	cprintf("Herb:$%-10lu  Rock:$%-10lu",check->cost[4],check->cost[5]);
	textcolor(GREEN);
	putch(DVER);
/*Line 5*/
	gotoxy(5,line++);
	putch(DTRT);
	for(x=0;x<11;x++) putch(SHOR);
	putch(SCRS);
	for(x=0;x<11;x++) putch(SHOR);
	putch(SCRS);
	for(x=0;x<11;x++) putch(SHOR);
	putch(SCRS);
	for(x=0;x<34;x++) putch(SHOR);
	putch(DTLT);
/*Line 6*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(SVER);
	cprintf("Cash:      ");
	putch(SVER);
	gotoxy(41,line++);
	putch(SVER);
	textcolor(LIGHTCYAN);
	putch(' ');
	putch('B');
	textcolor(CYAN);
	cprintf("uy,");
	textcolor(LIGHTCYAN);
	putch('S');
	textcolor(CYAN);
	cprintf("ell,");
	textcolor(LIGHTCYAN);
	putch('J');
	textcolor(CYAN);
	cprintf("et,");
	textcolor(LIGHTCYAN);
	putch('G');
	textcolor(CYAN);
	cprintf("o to bank,Fun");
	textcolor(LIGHTCYAN);
	putch('X');
	textcolor(CYAN);
	cprintf("ions ");
	textcolor(GREEN);
	putch(DVER);
/*Line 7*/
	gotoxy(5,line++);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Coke: %-5u",check->stash[0]);
	textcolor(GREEN);
	putch(SVER);
	cprintf("$%-10lu",check->cash);
	putch(SVER);
	textcolor(CYAN);
	cprintf("Coke: %-5u",check->coat[0]);
	textcolor(GREEN);
	putch(SVER);
	textcolor(LIGHTCYAN);
	cprintf("     T");
	textcolor(CYAN);
	cprintf("ransfer dope,See ");
	textcolor(LIGHTCYAN);
	putch('V');
	textcolor(CYAN);
	cprintf("innie     ");
	textcolor(GREEN);
	putch(DVER);
/*Line 8*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(STRT);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STLT);
	gotoxy(41,line++);
	putch(STRT);
	for(x=0;x<34;x++) putch(SHOR);
	putch(DTLT);
/*Line 9*/
	gotoxy(5,line);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Smack:%-5u",check->stash[1]);
	textcolor(GREEN);
	putch(SVER);
	cprintf("Bank:      ");
	putch(SVER);
	textcolor(CYAN);
	cprintf("Smack:%-5u",check->coat[1]);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 10*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(SVER);
	cprintf("$%-10lu",check->bank);
	putch(SVER);
	gotoxy(41,line);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 11*/
	gotoxy(5,line);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Dust: %-5u",check->stash[2]);
	textcolor(GREEN);
	putch(STRT);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STLT);
	textcolor(CYAN);
	cprintf("Dust: %-5u",check->coat[2]);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 12*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(SVER);
	cprintf("Debt:      ");
	putch(SVER);
	gotoxy(41,line);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 13*/
	gotoxy(5,line);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Acid: %-5u",check->stash[3]);
	textcolor(GREEN);
	putch(SVER);
	cprintf("$%-10lu",check->debt);
	putch(SVER);
	textcolor(CYAN);
	cprintf("Acid: %-5u",check->coat[3]);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 14*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(STRT);
	for(x=0;x<11;x++) putch(SHOR);
	putch(STLT);
	gotoxy(41,line);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 15*/
	gotoxy(5,line);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Herb: %-5u",check->stash[4]);
	textcolor(GREEN);
	putch(SVER);
	textcolor(RED);
	cprintf("GUNS:%-5u ",check->guns);
	textcolor(GREEN);
	putch(SVER);
	textcolor(CYAN);
	cprintf("Herb: %-5u",check->coat[4]);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 16*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(SVER);
	textcolor(RED);
	cprintf("HEALTH:%-4u",check->health);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(41,line);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 17*/
	gotoxy(5,line);
	putch(DVER);
	textcolor(MAGENTA);
	cprintf("Rock: %-5u",check->stash[5]);
	textcolor(GREEN);
	putch(SVER);
	textcolor(RED);
	cprintf("HOLD:%-5d ",check->pockets);
	textcolor(GREEN);
	putch(SVER);
	textcolor(CYAN);
	cprintf("Rock: %-5u",check->coat[5]);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 18*/
	gotoxy(5,line);
	putch(DVER);
	gotoxy(17,line);
	putch(SVER);
	textcolor(RED);
	cprintf("P.E. #%-5u",check->danger);
	textcolor(GREEN);
	putch(SVER);
	gotoxy(41,line);
	putch(SVER);
	gotoxy(76,line++);
	putch(DVER);
/*Line 19*/
	gotoxy(5,line);
	putch(DBLC);
	for(x=0;x<11;x++) putch(DHOR);
	putch(DTUP);
	for(x=0;x<11;x++) putch(DHOR);
	putch(DTUP);
	for(x=0;x<11;x++) putch(DHOR);
	putch(DTUP);
	for(x=0;x<34;x++) putch(DHOR);
	putch(DBRC);
/*Set the window*/
	window(42,12,75,21);
	textcolor(CYAN);
}

void update (struct data * check)
{ /*update screen routine*/
	int x,y;

	x=wherex();
	y=wherey();
	window(1,1,80,25);
	textcolor(MAGENTA);
	gotoxy(12,10);
	cprintf("%-5u",check->stash[0]);
	gotoxy(12,12);
	cprintf("%-5u",check->stash[1]);
	gotoxy(12,14);
	cprintf("%-5u",check->stash[2]);
	gotoxy(12,16);
	cprintf("%-5u",check->stash[3]);
	gotoxy(12,18);
	cprintf("%-5u",check->stash[4]);
	gotoxy(12,20);
	cprintf("%-5u",check->stash[5]);
	textcolor(GREEN);
	gotoxy(18,10);
	cprintf("$%-10lu",check->cash);
	gotoxy(18,13);
	cprintf("$%-10lu",check->bank);
	gotoxy(18,16);
	cprintf("$%-10lu",check->debt);
	textcolor(LIGHTGREEN);
	gotoxy(18,7);
	cprintf("%-11s",city_name[check->city]);
	textcolor(RED);
	gotoxy(47,5);
	cprintf("$%-10lu",check->cost[0]);
	gotoxy(65,5);
	cprintf("$%-10lu",check->cost[1]);
	gotoxy(47,6);
	cprintf("$%-10lu",check->cost[2]);
	gotoxy(65,6);
	cprintf("$%-10lu",check->cost[3]);
	gotoxy(47,7);
	cprintf("$%-10lu",check->cost[4]);
	gotoxy(65,7);
	cprintf("$%-10lu",check->cost[5]);
	gotoxy(23,18);
	cprintf("%-5u",check->guns);
	gotoxy(25,19);
	cprintf("%-4u",check->health);
	gotoxy(23,20);
	cprintf("%-5d",check->pockets);
	gotoxy(24,21);
	cprintf("%-5u",check->danger);
	textcolor(CYAN);
	gotoxy(27,5);
	if(check->debt) cprintf("%-2u days left",check->days_left);
	else cprintf("no debts!   ");
	gotoxy(36,10);
	cprintf("%-5u",check->coat[0]);
	gotoxy(36,12);
	cprintf("%-5u",check->coat[1]);
	gotoxy(36,14);
	cprintf("%-5u",check->coat[2]);
	gotoxy(36,16);
	cprintf("%-5u",check->coat[3]);
	gotoxy(36,18);
	cprintf("%-5u",check->coat[4]);
	gotoxy(36,20);
	cprintf("%-5u",check->coat[5]);
	gotoxy(12,5);
	cprintf("%-5u",check->days_used);
	window(42,12,75,21);
	gotoxy(x,y);
}

void str2fil (char * string)
{ /*convert string to filename*/
	int x=0;
	char *start,filename[13]="............";

	start=string;
	while(!(isalpha(*string))&&(*string!=NULL)) string++;
	while(*string!=NULL)
	{
		filename[x]=toupper(*string);
		string++;
		x++;
	}
	for(x=0;x<8;x++)
	{
		if (filename[x]=='.')
		{
			if(!(x))
			{
				strcpy(filename,def_file);
				--x;
			}
			if(!(isalnum(filename[x+1])))
			{
				filename[x+1]='S';
				filename[x+2]='A';
				filename[x+3]='V';
				filename[x+4]=NULL;
			}
			if(!(isalnum(filename[x+2]))) filename[x+2]=NULL;
			if(!(isalnum(filename[x+3]))) filename[x+3]=NULL;
			break;
		}
	}
	if((filename[x]!=NULL)&&(filename[x]!='.'))
	{
		filename[x+4]=NULL;
		filename[x+3]=filename[x+2];
		filename[x+2]=filename[x+1];
		filename[x+1]=filename[x];
		filename[x]='.';
	}
	while (filename[x++]!=NULL)
	{
		if(!(isalnum(filename[x]))) filename[x]=NULL;
		if((x==9)&&(filename[x-1]=='.'))
		{
			filename[x]='S';
			filename[x+1]='A';
			filename[x+2]='V';
			filename[x+3]=NULL;
		}
	}
	strcpy(start,filename);
	strcpy(def_file,filename);
	return;
}

unsigned long str2unl (char * string)
{
	unsigned long decimal=0;

	while((*string)!=NULL)
	{
		if((*string<'0')||(*string>'9')) string++;
		else
		{
			decimal=((decimal*10)+(*string-'0'));
			string++;
		}
	}
	return decimal;
}

int str2dec (char * string)
{
	int decimal=0;

	while(((*string)!=NULL)&&((*string)!='.'))
	{
		if((*string<'0')||(*string>'9')) string++;
		else
		{
			decimal=((decimal*10)+(*string-'0'));
			string++;
		}
	}
	return decimal;
}

unsigned int str2uns (char * string)
{
	unsigned int decimal=0;

	while(((*string)!=NULL)&&((*string)!='.'))
	{
		if((*string<'0')||(*string>'9')) string++;
		else
		{
			decimal=((decimal*10)+(*string-'0'));
			string++;
		}
	}
	return decimal;
}

void getit (char * string)
{
	int x=0;
	do
	{
		*string=getch();
		if(*string=='\r')
		{
			*string='\0';
			if(!(x)) cputs("None");
		}
		else
		{
			if(*string=='\b')
			{
				putch('\b');
				putch(' ');
				putch('\b');
				string-=2;
			}
			else putch(*string);
		}
		x=1;
	}
	while(*(string++)!='\0');
	return;
}

void beep(const TUNE * tune)
{
    int control,frequency,duration;
    clock_t goal;

    while(*tune)
    {
	    frequency=*(tune++);
	    duration=*(tune++);
	    if(frequency>0)
	    {
		outport(0x43,0xb6);
		frequency = (unsigned)(1193180L/frequency);
		outport(0x42,(char)frequency );
		outport(0x42,(char)(frequency >> 8) );
		control=inp(0x61);
		outport(0x61,control | 0x3);
	    }
	    goal=duration+clock();
	    while(goal>clock())/*do nothing*/;
	    if(frequency>0) outport(0x61,control);
	}
	outport(0x61,control);
}

void end_game(struct data * check)
{
	window(1,1,80,25);
	clrscr();
	textcolor(CYAN);
	cprintf("Yo time is up!  After 30 days of buyin' and sellin' dope "
						"you hasn't even gots\n\r");
	cprintf("de money to pay Vinnie back!  And as we all knows, de "
						"Eye-talians doesn't\n\r");
	cprintf("puts up wid no shit from peoples dat owes 'em money.  "
						"Especially folks\n\r");
	cprintf("what owes 'em %lu dollars!!! Damn, G, you is in some "
						"serious hurt now. And\n\r",check->debt);
	cprintf("don't even thinks about getting no extensions.  They "
						"is gonna come over\n\r");
	cprintf("here any time now to be bustin' you up, and I ain't "
						"stickin' around to see.\n\r");
	if(noise) beep(bad_news);
	cprintf("\n\n\rLater, G.  If you makes it.\r");
}

void killed(struct data * player)
{
	window(1,1,80,25);
	clrscr();
	textcolor(LIGHTRED);
	cprintf("You has been killed in de process of selling dope to yo "
					"fellow man.\n\r");
	cprintf("De cops takes all yo money and dope and throws it in de "
					"evidence locker.\n\r");
	cprintf("But don't be worrying yo dead self about all de dope and "
					"cash; some pigs\n\r");
	cprintf("will haves it on de street befo de weekend!  You has managed "
					"to sell dope\n\r");
	cprintf("fo %u days, which is mo than most people could manage to "
					"think about it!\n\r",player->days_used);
	if(noise) beep(dead);
	cleanup();
	exit(1);
}

void retired(void)
{
	window(1,1,80,25);
	clrscr();
	textcolor(LIGHTMAGENTA);
	cprintf("After selling dope fo twenty years, you begins to gets old"
			" and slow.\n\r");
	cprintf("Wisely deciding to leaves the bidness, you takes all yo dope"
			" and sells it\n\r");
	cprintf("to yo best friends in de world of dope dealing.  You retires"
			" to a cozy little\n\r");
	cprintf("place of yo own where you can relaxes fo de rest of yo days.");
	cprintf("\n\n\rYou is truly one of de all time great dopemen.\r");
	if(noise) beep(good_news);
	cleanup();
	exit(1);
}


void modify_game(struct data * modify)
{
	int index,new_short_number;
	unsigned long new_long_number;
	unsigned int new_number;
	char string[15];


	cprintf("Drug prices:");
	for (index=0;index<6;index++)
	{
		cprintf("\n\r%s is $%lu; new price: $",
			drug_name[index],modify->cost[index]);
		getit(string);
		new_long_number=str2unl(string);
		if(new_long_number) modify->cost[index]=new_long_number;
	}
	cprintf("\n\rYou have $%lu; new cash balance: $",modify->cash);
	getit(string);
	new_long_number=str2unl(string);
	if(new_long_number) modify->cash=new_long_number;
	cprintf("\n\rYou have $%lu in the bank; new balance: $",modify->bank);
	getit(string);
	new_long_number=str2unl(string);
	if(new_long_number) modify->bank=new_long_number;
	cprintf("\n\rYou owe Vinnie $%lu; new balance: $",modify->debt);
	getit(string);
	new_long_number=str2unl(string);
	if(new_long_number) modify->debt=new_long_number;
	cprintf("\n\rYour last deal was for $%lu; "
			"new record: $",modify->last_cost);
	getit(string);
	new_long_number=str2unl(string);
	if(new_long_number) modify->last_cost=new_long_number;
	clrscr();
	cprintf("\n\rYour stash:");
	for (index=0;index<6;index++)
	{
		cprintf("\n\rYou have %u %s; new amount:",
			modify->stash[index],drug_name[index]);
		getit(string);
		new_number=str2uns(string);
		if(new_number) modify->stash[index]=new_number;
	}
	cprintf("\n\rYour coat:");
	for (index=0,modify->total=0;index<6;index++)
	{
		cprintf("\n\rYou have %u %s; new amount:",
			modify->coat[index],drug_name[index]);
		getit(string);
		new_number=str2uns(string);
		if(new_number) modify->coat[index]=new_number;
		modify->total+=modify->coat[index];
	}
	clrscr();
	cprintf("\n\rYou have %u guns. New number:",modify->guns);
	getit(string);
	new_number=str2uns(string);
	if(new_number) modify->guns=new_number;
	cprintf("\n\rYou are Public Enemy number %u.  New P.E. #:",
				modify->danger);
	getit(string);
	new_number=str2uns(string);
	if(new_number) modify->danger=new_number;
	cprintf("\n\rYou are at %u%% health.  New health:",modify->health);
	getit(string);
	new_number=str2uns(string);
	if(new_number) modify->health=new_number;
	cprintf("\n\rYou have been selling for %u days.  New number of days:",
				modify->days_used);
	getit(string);
	new_number=str2uns(string);
	if(new_number) modify->days_used=new_number;
	if(modify->debt)
	{
		cprintf("\n\rYou have %u days to pay your debt.  New term:",
					modify->days_left);
		getit(string);
		new_number=str2uns(string);
		if(new_number) modify->days_left=new_number;
	}
	else modify->days_left=30;
	cprintf("\n\rYour last sale was %u bags of dope.  New record:",
			   modify->last_volume);
	getit(string);
	new_number=str2uns(string);
	if(new_number) modify->last_volume=new_number;
	cprintf("\n\rYou have %d pockets empty.  New number:",
					modify->pockets);
	getit(string);
	new_short_number=str2dec(string);
	if(new_short_number) modify->pockets=new_short_number;
	*string=0;
}

void cleanup(void)
{
	textcolor(LIGHTGREEN);
	cprintf("\n\rThank you for playing DOPEWARS.");
	normvideo();
	printf("\n\n");
}

void reset(void)
{
	textcolor(RED);
	cprintf("DOPEWARS %0.1f by Caliban Tiresias Darklock the Hellespontine\n\r",
			 version_number);
	textcolor(GREEN);
	cprintf("     Copyright (C) 1993 Trinity Logical Cybersystems\n\r");
	textcolor(CYAN);
	cprintf("                  All rights reserved.\n\r\n\n");
}

void online_help(void)
{
    cprintf("\n\rThe object of DOPEWARS is to");
    cprintf("\n\rbecome a rich dope dealer.");
    cprintf("\n\rYou must buy low and sell high");
    cprintf("\n\rto achieve this goal.  If you");
    cprintf("\n\rdeal heavily in dope, you will");
    cprintf("\n\rrun into the cops; the cops");
    cprintf("\n\rwill only shoot you if you have");
    cprintf("\n\rguns (threat) or if you fight");
    cprintf("\n\r(resisting arrest).  If the");
    cprintf("\n\rcops catch you, you will go");
    bioskey(0);
    cprintf("\n\rto jail.  You start the game");
    cprintf("\n\rwith a 5000 dollar debt to");
    cprintf("\n\rVinnie the loan shark, which");
    cprintf("\n\ryou must pay in thirty days.");
    cprintf("\n\rOnce you pay Vinnie off, he");
    cprintf("\n\rwill loan you more money if you");
    cprintf("\n\rwant.  Every thirty days, you");
    cprintf("\n\rmust pay 3000 dollars in cost");
    cprintf("\n\rof living expenses; if you");
    cprintf("\n\rcannot afford it, you will");
    bioskey(0);
    cprintf("\n\rautomatically borrow more");
    cprintf("\n\rmoney from Vinnie.  If you");
    cprintf("\n\rhave a lot of dope, you can");
    cprintf("\n\rTransfer dope and put it in");
    cprintf("\n\ryour stash; if you have a lot");
    cprintf("\n\rof money, you can Go to bank");
    cprintf("\n\rand put it in savings.  You");
    cprintf("\n\rmust use cash in all your deals");
    cprintf("\n\rexcept the bills; dope dealers");
    cprintf("\n\rand loan sharks don't take");
    bioskey(0);
    cprintf("\n\rchecks.  Every year, your");
    cprintf("\n\rfriends will wish you a");
    cprintf("\n\rhappy anniversary and give");
    cprintf("\n\ryou some dope.  The screen");
    cprintf("\n\ris relatively easy to read;");
    cprintf("\n\ryour stash is on the left,");
    cprintf("\n\ryour coat pockets on the right,");
    cprintf("\n\rand separating them is a little");
    cprintf("\n\rfinancial statement of your");
    cprintf("\n\rcash, bank balance, and debt.");
    bioskey(0);
    cprintf("\n\rUnder the financial statement");
    cprintf("\n\ris a list of your abilities;");
    cprintf("\n\rhow many guns you have, how");
    cprintf("\n\rmuch health you have (if you");
    cprintf("\n\rget shot, you will lose some;");
    cprintf("\n\revery day you get one point of");
    cprintf("\n\rhealth back), how much dope you");
    cprintf("\n\rcan carry (your pockets), and");
    cprintf("\n\rwhere you are on the most wanted");
    cprintf("\n\rlist (#500 when you start).");
    bioskey(0);
    cprintf("\n\rIt is worth noting that it costs");
    cprintf("\n\r3 dollars to ride the metro, so");
    cprintf("\n\ralways keep a little bit of cash.");
    cprintf("\n\rIf you have no money, you will");
    cprintf("\n\rhave to hitchhike.");
    textcolor(LIGHTGREEN);
    cprintf("\n\rDOPEWARS ");
    textcolor(LIGHTRED);
    cprintf("by Caliban Tiresias");
    cprintf("\n\rDarklock, ");
    textcolor(YELLOW);
    cprintf("(C) 1993, ");
    textcolor(LIGHTCYAN);
    cprintf("product of");
    cprintf("\n\rTrinity Logical Cybersystems,");
    cprintf("\n\rAll Rights Reserved.");
    textcolor(YELLOW);
    cprintf("\n\rPress any key...");
    bioskey(0);
}
